/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.Constants;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CallTemplate;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Choose;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Copy;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.CopyOf;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirCommentConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ForEach;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.If;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Number;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.OperatorExpr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Otherwise;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Param;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Template;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Text;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.ValueOf;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableBase;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.VariableRef;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.When;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.WithParam;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeConstants;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.XSLTCHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;

public class TranslatorHelper
implements Constants {
    public static boolean isTopLevelRTFNode(Expr expr) {
        Expr expr2 = (Expr)expr.jjtGetParent();
        if (expr2 == null) {
            return false;
        }
        int n2 = expr2.getId();
        return n2 == 217 || n2 == 34 || n2 == 29;
    }

    private static boolean isSimpleRTF(Expr expr) {
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(expr2, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAdaptiveRTF(Expr expr) {
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (TranslatorHelper.isTextElement(expr2, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTextElement(Expr expr, boolean bl) {
        if (expr instanceof ValueOf || expr instanceof Number || expr instanceof Text) {
            return true;
        }
        if (expr instanceof If) {
            return bl ? TranslatorHelper.isAdaptiveRTF(expr) : TranslatorHelper.isSimpleRTF(expr);
        }
        if (expr instanceof Choose) {
            int n2 = expr.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                Expr expr2 = (Expr)expr.jjtGetChild(i);
                if (expr2 instanceof Text || (expr2 instanceof When || expr2 instanceof Otherwise) && (bl && TranslatorHelper.isAdaptiveRTF(expr2) || !bl && TranslatorHelper.isSimpleRTF(expr2))) continue;
                return false;
            }
            return true;
        }
        return bl && (expr instanceof CallTemplate || expr instanceof ApplyTemplates);
    }

    public static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            Class<?> clazz2 = clazz;
            while (clazz2.isArray()) {
                stringBuffer.append("[");
                clazz2 = clazz2.getComponentType();
            }
            stringBuffer.append(TranslatorHelper.getSignature(clazz2));
            return stringBuffer.toString();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            String string2 = clazz.toString();
            ErrorMsg errorMsg = new ErrorMsg("UNKNOWN_SIG_TYPE_ERR", string2);
            throw new Error(errorMsg.toString());
        }
        return "L" + clazz.getName().replace('.', '/') + ';';
    }

    public static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TranslatorHelper.getSignature(classArray[i]));
        }
        return stringBuffer.append(')').append(TranslatorHelper.getSignature(method.getReturnType())).toString();
    }

    public static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(TranslatorHelper.getSignature(classArray[i]));
        }
        return stringBuffer.append(")V").toString();
    }

    public static boolean canLoadAsArrayOffsetLength(Text text2) {
        return text2.getSimpleStringValue().length() <= 21845;
    }

    public static Template getCalleeTemplate(CallTemplate callTemplate) {
        XTQProgram xTQProgram = callTemplate.getXTQProgram();
        xTQProgram = xTQProgram.getTopLevelXTQProgram();
        List list = xTQProgram.getAllValidTemplates();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Template template = (Template)list.get(i);
            if (template.getQName() != callTemplate.getQName() || !template.isSimpleNamedTemplate()) continue;
            return template;
        }
        return null;
    }

    protected static boolean buildParameterList(CallTemplate callTemplate, Object[] objectArray) {
        Object object2;
        Expr expr;
        int n2;
        int n3 = callTemplate.jjtGetNumChildren();
        int n4 = objectArray.length;
        block0: for (n2 = 0; n2 < n3; n2 += 1) {
            Node node2 = callTemplate.jjtGetChild(n2);
            if (!(node2 instanceof WithParam) || ((WithParam)(expr = (WithParam)node2)).isTunnel()) continue;
            object2 = ((WithParam)expr).getQName();
            for (int i = 0; i < n4; ++i) {
                Object object3 = objectArray[i];
                if (object3 instanceof Param && ((Param)object3).getQName() == object2) {
                    objectArray[i] = expr;
                    continue block0;
                }
                if (!(object3 instanceof WithParam) || ((WithParam)object3).getQName() != object2) continue;
                objectArray[i] = expr;
                continue block0;
            }
        }
        n2 = 0;
        for (int i = 0; i < n4; ++i) {
            if (!(objectArray[i] instanceof Param)) continue;
            expr = (Param)objectArray[i];
            object2 = ((VariableBase)expr).getExpression();
            if (expr.jjtGetNumChildren() <= 0 && (object2 == null || !XSLTCHelper.hasVariableReferences((Expr)object2))) continue;
            n2 = 1;
            break;
        }
        return n2 != 0;
    }

    protected static boolean checkAttributesUnique(DirElemConstructor dirElemConstructor) {
        boolean bl = TranslatorHelper.canProduceAttributeNodes(dirElemConstructor, true);
        if (bl) {
            return false;
        }
        List list = dirElemConstructor.getAttributeElements();
        if (list != null) {
            int n2 = list.size();
            Hashtable<Object, com.ibm.xltxe.rnm1.xtq.ast.nodes.Constructor> hashtable = null;
            for (int i = 0; i < n2; ++i) {
                CompAttrConstructor compAttrConstructor;
                com.ibm.xltxe.rnm1.xtq.ast.nodes.Constructor constructor;
                Expr expr;
                Expr expr2 = (Expr)list.get(i);
                if (expr2 instanceof UseAttributeSets) {
                    return false;
                }
                if (!(expr2 instanceof CompAttrConstructor)) continue;
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, com.ibm.xltxe.rnm1.xtq.ast.nodes.Constructor>();
                    for (int j = 0; j < i; ++j) {
                        expr = (Expr)list.get(j);
                        if (!(expr instanceof DirAttributeConstructor)) continue;
                        constructor = (DirAttributeConstructor)expr;
                        hashtable.put(((DirAttributeConstructor)constructor).getQName(), constructor);
                    }
                }
                if ((expr = (compAttrConstructor = (CompAttrConstructor)expr2).getNameExpr()) instanceof Text) {
                    constructor = (Text)expr;
                    String string2 = constructor.toString();
                    if (string2 != null && hashtable.get(string2) != null) {
                        return false;
                    }
                    if (string2 == null) continue;
                    hashtable.put(string2, compAttrConstructor);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean canProduceAttributeNodes(Expr expr, boolean bl) {
        int n2 = expr.jjtGetNumChildren();
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (expr2 instanceof Text) {
                Text text2 = (Text)expr2;
                if (text2.isIgnore()) continue;
                return false;
            }
            if (expr2 instanceof DirElemConstructor || expr2 instanceof ValueOf || expr2 instanceof CompElemConstructor || expr2 instanceof DirCommentConstructor || expr2 instanceof Number || expr2 instanceof DirPIConstructor) {
                return false;
            }
            if (expr2 instanceof CompAttrConstructor) {
                if (bl) continue;
                return true;
            }
            if (expr2 instanceof CallTemplate || expr2 instanceof ApplyTemplates || expr2 instanceof Copy || expr2 instanceof CopyOf) {
                return true;
            }
            if ((expr2 instanceof If || expr2 instanceof ForEach) && TranslatorHelper.canProduceAttributeNodes(expr2, false)) {
                return true;
            }
            if (!(expr2 instanceof Choose)) continue;
            int n3 = expr2.jjtGetNumChildren();
            for (int j = 0; j < n3; ++j) {
                Expr expr3 = (Expr)expr2.jjtGetChild(j);
                if (!(expr3 instanceof When) && !(expr3 instanceof Otherwise) || !TranslatorHelper.canProduceAttributeNodes(expr3, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasBadChars(String string2) {
        for (char c : string2.toCharArray()) {
            if (c >= ' ' && '~' >= c && c != '<' && c != '>' && c != '&' && c != '\"') continue;
            return true;
        }
        return false;
    }

    public static Type getRealType(Expr expr) {
        Type type2 = ASTDecorator2.getExpressionCastType(expr);
        if (type2 != null) {
            return type2;
        }
        return ASTDecorator2.getType(expr);
    }

    public static boolean isNodeValueTest(Expr expr) {
        if (!ASTDecorator.getCanOptimize(expr)) {
            return false;
        }
        return XSLTCHelper.getStepForPredicate(expr) != null && TranslatorHelper.getCompareValue(expr) != null;
    }

    public static Expr getCompareValue(Expr expr) {
        Expr expr2 = ASTDecorator.getCompareValue(expr);
        if (expr2 != null) {
            return expr2;
        }
        if (expr == null) {
            return null;
        }
        if (expr.getId() == 59) {
            OperatorExpr operatorExpr = (OperatorExpr)expr;
            if (operatorExpr.getOperatorType() != 13 && operatorExpr.getOperatorType() != 14) {
                return null;
            }
            Expr expr3 = operatorExpr.getOperand(0);
            Expr expr4 = operatorExpr.getOperand(1);
            Type type2 = TranslatorHelper.getRealType(expr3);
            Type type3 = TranslatorHelper.getRealType(expr4);
            if (type2 == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(expr3)) {
                expr2 = expr3;
            } else if (expr3 instanceof VariableRef) {
                expr2 = expr3;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
            if (type3 == TypeConstants.STRING && !XSLTCHelper.isSimpleStep(expr4)) {
                expr2 = expr4;
            } else if (expr4 instanceof VariableRef) {
                expr2 = expr4;
            }
            if (expr2 != null) {
                ASTDecorator.setCompareValue(expr, expr2);
                return expr2;
            }
        }
        return null;
    }
}

