/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.translator;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.nodes.Node;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.Counter;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceHelper {
    private static final Type s_javaObjectType = new JavaObjectType("java.lang.Object");
    private static final Type s_hashtableType = new JavaObjectType("java.util.Hashtable");
    private static final String s_getStaticNamespaceTablesFunction = "get-static-namespace-tables";
    private static final String s_namespace_id_key = "com.ibm.xltxe.rnm1.xtq.xslt.translator.namespacehelper.namespaceid";
    public static final String s_getNSPrefixCounterFunction = "get-ns-prefix-counter";
    private List m_namespaceNodes = new ArrayList();

    public Instruction getNamespaceId(Expr expr) {
        int n2;
        Expr expr2 = this.lastNamespaceNode(expr);
        Integer n3 = (Integer)expr2.getProperty(s_namespace_id_key);
        if (n3 == null) {
            n2 = this.m_namespaceNodes.size();
            expr2.addProperty(s_namespace_id_key, new Integer(n2));
            this.m_namespaceNodes.add(expr2);
        } else {
            n2 = n3;
        }
        return LiteralInstruction.integerLiteral(n2);
    }

    public Function generateGetStaticNamespaceTablesFunction() {
        Object object2;
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction[] instructionArray = new Instruction[this.m_namespaceNodes.size()];
        ArrayList<StreamInstruction> arrayList = new ArrayList<StreamInstruction>();
        for (int i = 0; i < this.m_namespaceNodes.size(); ++i) {
            object2 = (Expr)this.m_namespaceNodes.get(i);
            Instruction instruction2 = letChainBuilder.bind(new OnceInstruction(new NewJavaObjectInstruction(new Instruction[0], s_hashtableType)));
            this.fillInHashtable(instruction2, (Expr)object2, arrayList, letChainBuilder);
            instructionArray[i] = instruction2;
        }
        arrayList.add(new StreamInstruction(s_hashtableType, instructionArray));
        Instruction instruction3 = letChainBuilder.packageUp(new BeginInstruction(arrayList));
        object2 = new Function(s_getStaticNamespaceTablesFunction, new Binding[0], instruction3);
        ((Function)object2).setMemoizeResult(true);
        return object2;
    }

    public final Instruction callGetStaticNamespaceTablesFunction() {
        return new FunctionCallInstruction(s_getStaticNamespaceTablesFunction, new Instruction[0]);
    }

    public final Instruction getNamespaceTable(Expr expr) {
        Instruction instruction2 = this.callGetStaticNamespaceTablesFunction();
        Instruction instruction3 = this.getNamespaceId(expr);
        StreamElementInstruction streamElementInstruction = new StreamElementInstruction(instruction2, instruction3);
        return streamElementInstruction;
    }

    private Expr lastNamespaceNode(Expr expr) {
        Node node2;
        HashMap<String, String> hashMap;
        Expr expr2 = expr;
        while (expr2 != null && ((hashMap = expr2.getPrefixMapping()) == null || hashMap.size() <= 0) && (node2 = expr2.jjtGetParent()) instanceof Expr) {
            expr2 = (Expr)node2;
        }
        return expr2;
    }

    private void fillInHashtable(Instruction instruction2, Expr expr, List list, LetChainBuilder letChainBuilder) {
        HashMap<String, String> hashMap;
        Node node2 = expr.jjtGetParent();
        if (node2 != null && node2 instanceof Expr) {
            this.fillInHashtable(instruction2, (Expr)node2, list, letChainBuilder);
        }
        if ((hashMap = expr.getPrefixMapping()) != null) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                Instruction instruction3 = letChainBuilder.bind(StreamInstruction.charStreamLiteral(entry.getKey()));
                Instruction instruction4 = letChainBuilder.bind(StreamInstruction.charStreamLiteral(entry.getValue()));
                Instruction[] instructionArray = new Instruction[]{letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction3)), letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction4))};
                list.add(new JavaMethodInvocationInstruction("put", instruction2.cloneWithoutTypeInformation(), instructionArray, s_javaObjectType));
            }
        }
    }

    public Function generateGetNSPrefixCountFunction(int n2) {
        NewJavaObjectInstruction newJavaObjectInstruction = new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.integerLiteral(n2)}, (Type)new JavaObjectType(Counter.class.getName()));
        Function function2 = new Function(s_getNSPrefixCounterFunction, new Binding[0], newJavaObjectInstruction);
        function2.setMemoizeResult(true);
        return function2;
    }

    public Instruction callGetNSPrefixCountFunction() {
        return new FunctionCallInstruction(s_getNSPrefixCounterFunction, new Instruction[0]);
    }
}

