/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.ObjectFactory;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMsg;

public class XSLTObject {
    private static final int NUMBER_TYPE = 0;
    private static final int BOOLEAN_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int NODESET_TYPE = 3;
    private static final int RTF_TYPE = 4;
    private static final int EXTERNAL_TYPE = 5;
    private static final String[] TYPE_NAME = new String[]{"number", "boolean", "string", "node-set", "result tree fragment", "object"};
    private GenericJavaObject m_javaObj;
    private Object m_xsltObj;
    private int m_type;

    private XSLTObject(int n2, Object object2, GenericJavaObject genericJavaObject) {
        this.m_type = n2;
        this.m_xsltObj = object2;
        this.m_javaObj = genericJavaObject;
    }

    public static XSLTObject createXSLTObject(double d) {
        Double d2 = new Double(d);
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)d2, 0);
        return new XSLTObject(0, d2, genericJavaObject);
    }

    public static XSLTObject createXSLTObject(float f2) {
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)new Float(f2), 1);
        return new XSLTObject(0, new Double(f2), genericJavaObject);
    }

    public static XSLTObject createXSLTObject(long l) {
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)new Long(l), 2);
        return new XSLTObject(0, new Double(l), genericJavaObject);
    }

    public static XSLTObject createXSLTObject(int n2) {
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)new Integer(n2), 3);
        return new XSLTObject(0, new Double(n2), genericJavaObject);
    }

    public static XSLTObject createXSLTObject(short s) {
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)new Short(s), 4);
        return new XSLTObject(0, new Double(s), genericJavaObject);
    }

    public static XSLTObject createXSLTObject(byte by2) {
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)new Byte(by2), 5);
        return new XSLTObject(0, new Double(by2), genericJavaObject);
    }

    public static XSLTObject createXSLTObject(char c) {
        Character c2 = new Character(c);
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)c2, 6);
        return new XSLTObject(5, null, genericJavaObject);
    }

    public static XSLTObject createXSLTObject(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)bl2, 7);
        return new XSLTObject(1, bl2, genericJavaObject);
    }

    public static XSLTObject createXSLTObject() {
        String string2 = "";
        GenericJavaObject genericJavaObject = new GenericJavaObject((Object)string2, String.class.getName());
        return new XSLTObject(2, string2, genericJavaObject);
    }

    public boolean isNumber() {
        return this.m_type == 0;
    }

    public boolean isBoolean() {
        return this.m_type == 1;
    }

    public boolean isString() {
        return this.m_type == 2;
    }

    public boolean isNodeset() {
        return this.m_type == 3;
    }

    public boolean isRTF() {
        return this.m_type == 4;
    }

    public boolean isExternal() {
        return this.m_type == 5;
    }

    public double getJavaDouble() {
        try {
            return this.m_javaObj.getDouble();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "double");
            return 0.0;
        }
    }

    public float getJavaFloat() {
        try {
            return this.m_javaObj.getFloat();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return (float)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "float");
            return 0.0f;
        }
    }

    public long getJavaLong() {
        try {
            return this.m_javaObj.getLong();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return (long)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "long");
            return 0L;
        }
    }

    public int getJavaInt() {
        try {
            return (int)this.m_javaObj.getLong();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return (int)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "int");
            return 0;
        }
    }

    public short getJavaShort() {
        try {
            return (short)this.m_javaObj.getLong();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return (short)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "short");
            return 0;
        }
    }

    public byte getJavaByte() {
        try {
            return (byte)this.m_javaObj.getLong();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return (byte)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "byte");
            return 0;
        }
    }

    public char getJavaChar() {
        try {
            return this.m_javaObj.getChar();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                if (this.isString()) {
                    String string2 = (String)this.m_xsltObj;
                    if (string2.length() > 0) {
                        return ((String)this.m_xsltObj).charAt(0);
                    }
                    return '\u0000';
                }
                return (char)BasisLibrary.numberF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "char");
            return '\u0000';
        }
    }

    public boolean getJavaBoolean() {
        try {
            return this.m_javaObj.getBoolean();
        }
        catch (ConversionException conversionException) {
            if (this.m_xsltObj != null) {
                return BasisLibrary.booleanF(this.m_xsltObj);
            }
            this.throwConversionException(this.getTypeName(), "boolean");
            return false;
        }
    }

    public Double getJavaDoubleObject() {
        if (this.m_xsltObj != null) {
            return new Double(BasisLibrary.numberF(this.m_xsltObj));
        }
        try {
            return (Double)this.m_javaObj.getObject(Double.class);
        }
        catch (ConversionException conversionException) {
            this.throwConversionException(this.getTypeName(), Double.class.getName());
            return null;
        }
    }

    public Boolean getJavaBooleanObject() {
        if (this.m_xsltObj != null) {
            return new Boolean(BasisLibrary.booleanF(this.m_xsltObj));
        }
        try {
            return (Boolean)this.m_javaObj.getObject(Boolean.class);
        }
        catch (ConversionException conversionException) {
            this.throwConversionException(this.getTypeName(), Boolean.class.getName());
            return null;
        }
    }

    public String getJavaString() {
        if (this.m_xsltObj != null) {
            return BasisLibrary.stringF(this.m_xsltObj);
        }
        try {
            return (String)this.m_javaObj.getObject(String.class);
        }
        catch (ConversionException conversionException) {
            this.throwConversionException(this.getTypeName(), String.class.getName());
            return null;
        }
    }

    public Object getJavaObject(Class clazz) {
        try {
            return this.m_javaObj.getObject(clazz);
        }
        catch (ConversionException conversionException) {
            this.throwConversionException(this.getTypeName(), Object.class.getName());
            return null;
        }
    }

    public Object getValueObject() {
        return this.m_javaObj.m_object;
    }

    public Class getValueClass() {
        return this.m_javaObj.getTypeClass();
    }

    public String getValueTypeName() {
        if (this.isExternal()) {
            Object object2 = this.getValueObject();
            if (object2 == null) {
                return "null";
            }
            return object2.getClass().getName();
        }
        return TYPE_NAME[this.m_type];
    }

    public double getNumber() {
        if (this.m_xsltObj != null) {
            return BasisLibrary.numberF(this.m_xsltObj);
        }
        return 0.0;
    }

    public boolean getBoolean() {
        if (this.m_xsltObj != null) {
            return BasisLibrary.booleanF(this.m_xsltObj);
        }
        return false;
    }

    public String getString() {
        if (this.m_xsltObj != null) {
            return BasisLibrary.stringF(this.m_xsltObj);
        }
        try {
            Object object2 = this.m_javaObj.getObject();
            if (object2 != null) {
                if (object2 instanceof char[]) {
                    String string2 = new String((char[])object2);
                    return string2;
                }
                return object2.toString();
            }
            return "";
        }
        catch (ConversionException conversionException) {
            return "";
        }
    }

    protected String getTypeName() {
        if (this.isExternal()) {
            return "(" + this.m_javaObj.getTypeName() + ")";
        }
        return TYPE_NAME[this.m_type];
    }

    protected void throwConversionException(String string2, String string3) {
        throw new RuntimeException(new RuntimeMsg("CONVERSION_FAILED", (Object)string2, (Object)string3).getFormattedMessage());
    }

    protected static class GenericJavaObject {
        private static final int DOUBLE_TYPE = 0;
        private static final int FLOAT_TYPE = 1;
        private static final int LONG_TYPE = 2;
        private static final int INT_TYPE = 3;
        private static final int SHORT_TYPE = 4;
        private static final int BYTE_TYPE = 5;
        private static final int CHAR_TYPE = 6;
        private static final int BOOLEAN_TYPE = 7;
        private static final int OBJECT_TYPE = 8;
        private static final String[] TYPE_NAMES = new String[]{"double", "float", "long", "int", "short", "byte", "char", "boolean", "object"};
        private static final Class[] TYPE_CLASSES = new Class[]{Double.TYPE, Float.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Byte.TYPE, Character.TYPE, Boolean.TYPE, Object.class};
        private int m_type;
        private Object m_object;
        private String m_className;
        private Class m_class;

        protected GenericJavaObject(Object object2, int n2) {
            this.m_type = n2;
            this.m_object = object2;
            this.m_className = this.getTypeName();
        }

        protected GenericJavaObject(Object object2, String string2) {
            this.m_type = 8;
            this.m_object = object2;
            this.m_className = string2;
        }

        protected boolean isPrimitive() {
            return this.m_type != 8;
        }

        protected boolean isBoolean() {
            return this.m_type == 7;
        }

        protected boolean isNumber() {
            switch (this.m_type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }

        protected String getTypeName() {
            switch (this.m_type) {
                case 8: {
                    return this.m_className;
                }
            }
            return TYPE_NAMES[this.m_type];
        }

        protected Class getTypeClass() {
            if (this.isPrimitive()) {
                return TYPE_CLASSES[this.m_type];
            }
            return this.getObjectClass();
        }

        protected double getDouble() throws ConversionException {
            if (this.isNumber()) {
                return ((Number)this.m_object).doubleValue();
            }
            if (this.m_type == 6) {
                return ((Character)this.m_object).charValue();
            }
            throw new ConversionException();
        }

        protected float getFloat() throws ConversionException {
            if (this.isNumber()) {
                return ((Number)this.m_object).floatValue();
            }
            if (this.m_type == 6) {
                return ((Character)this.m_object).charValue();
            }
            throw new ConversionException();
        }

        protected long getLong() throws ConversionException {
            if (this.isNumber()) {
                return ((Number)this.m_object).longValue();
            }
            if (this.m_type == 6) {
                return ((Character)this.m_object).charValue();
            }
            throw new ConversionException();
        }

        protected char getChar() throws ConversionException {
            if (this.isNumber()) {
                return (char)((Number)this.m_object).intValue();
            }
            if (this.m_type == 6) {
                return ((Character)this.m_object).charValue();
            }
            throw new ConversionException();
        }

        protected boolean getBoolean() throws ConversionException {
            if (this.m_type == 7) {
                return (Boolean)this.m_object;
            }
            throw new ConversionException();
        }

        protected Object getObject() throws ConversionException {
            if (this.m_type == 8) {
                return this.m_object;
            }
            throw new ConversionException();
        }

        protected Object getObject(Class clazz) throws ConversionException {
            Class clazz2;
            if (this.m_type == 8 && (clazz2 = this.getObjectClass()) != null && clazz.isAssignableFrom(clazz2)) {
                return this.m_object;
            }
            throw new ConversionException();
        }

        private Class getObjectClass() {
            String string2 = this.m_className;
            while (this.m_class == null) {
                try {
                    this.m_class = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    int n2 = this.m_className.lastIndexOf(46);
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2) + "$" + string2.substring(n2 + 1, string2.length());
                        continue;
                    }
                    throw new RuntimeException(new RuntimeMsg("ERR_CLASS_NOT_FIND", this.m_className).getFormattedMessage());
                }
            }
            return this.m_class;
        }
    }

    protected static class ConversionException
    extends Exception {
        private static final long serialVersionUID = 4113263809836890815L;

        protected ConversionException() {
        }
    }
}

