/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.extensions.ExsltBase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ExsltDatetime
extends ExsltBase {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "--MM-dd";
    static final String gm = "--MM--";
    static final String gd = "---dd";
    static final String t = "HH:mm:ss";
    static final String EMPTY_STR = "";
    private static final Double nan = new Double(Double.NaN);

    public static String dateTime() {
        Calendar calendar = Calendar.getInstance();
        Date date2 = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dt);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date2));
        int n2 = calendar.get(15) + calendar.get(16);
        if (n2 == 0) {
            stringBuffer.append("Z");
        } else {
            int n3 = n2 / 3600000;
            int n4 = n2 % 3600000;
            char c = n3 < 0 ? (char)'-' : '+';
            stringBuffer.append(c + ExsltDatetime.formatDigits(n3) + ':' + ExsltDatetime.formatDigits(n4));
        }
        return stringBuffer.toString();
    }

    private static String formatDigits(int n2) {
        String string2 = String.valueOf(Math.abs(n2));
        return string2.length() == 1 ? '0' + string2 : string2;
    }

    public static String date(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (string4 == null || string5 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d};
            String string6 = d;
            Date date2 = ExsltDatetime.testFormats(string4, stringArray2);
            if (date2 == null) {
                return EMPTY_STR;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string6);
            simpleDateFormat.setLenient(false);
            String string7 = simpleDateFormat.format(date2);
            if (string7.length() == 0) {
                return EMPTY_STR;
            }
            return string3 + string7 + string5;
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String date() {
        String string2 = ExsltDatetime.dateTime().toString();
        String string3 = string2.substring(0, string2.indexOf("T"));
        String string4 = string2.substring(ExsltDatetime.getZoneStart(string2));
        return string3 + string4;
    }

    public static String time(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            if (string3 == null || string4 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d, t};
            String string5 = t;
            Date date2 = ExsltDatetime.testFormats(string3, stringArray2);
            if (date2 == null) {
                return EMPTY_STR;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
            String string6 = simpleDateFormat.format(date2);
            return string6 + string4;
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String time() {
        String string2 = ExsltDatetime.dateTime().toString();
        String string3 = string2.substring(string2.indexOf("T") + 1);
        return string3;
    }

    public static double year(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            boolean bl = stringArray[0].length() == 0;
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d, gym, gy};
            double d = ExsltDatetime.getNumber(string3, stringArray2, 1);
            if (bl || Double.isNaN(d)) {
                return d;
            }
            return -d;
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double year() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static double monthInYear(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d, gym, gm, gmd};
            return ExsltDatetime.getNumber(string3, stringArray2, 2) + 1.0;
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double monthInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static double weekInYear(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d};
            return ExsltDatetime.getNumber(string3, stringArray2, 3);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double weekInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(3);
    }

    public static double dayInYear(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d};
            return ExsltDatetime.getNumber(string3, stringArray2, 6);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double dayInYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(6);
    }

    public static double dayInMonth(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            String[] stringArray2 = new String[]{dt, d, gmd, gd};
            double d = ExsltDatetime.getNumber(string3, stringArray2, 5);
            return d;
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double dayInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static double dayOfWeekInMonth(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d};
            return ExsltDatetime.getNumber(string3, stringArray2, 8);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double dayOfWeekInMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(8);
    }

    public static double dayInWeek(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, d};
            return ExsltDatetime.getNumber(string3, stringArray2, 7);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double dayInWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7);
    }

    public static double hourInDay(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, t};
            return ExsltDatetime.getNumber(string3, stringArray2, 11);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double hourInDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static double minuteInHour(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, t};
            return ExsltDatetime.getNumber(string3, stringArray2, 12);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double minuteInHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }

    public static double secondInMinute(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return Double.NaN;
            }
            String[] stringArray2 = new String[]{dt, t};
            return ExsltDatetime.getNumber(string3, stringArray2, 13);
        }
        catch (ParseException parseException) {
            return Double.NaN;
        }
    }

    public static double secondInMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(13);
    }

    public static Object leapYear(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return nan;
            }
            String[] stringArray2 = new String[]{dt, d, gym, gy};
            double d = ExsltDatetime.getNumber(string3, stringArray2, 1);
            if (Double.isNaN(d)) {
                return nan;
            }
            int n2 = (int)d;
            if (n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (ParseException parseException) {
            return nan;
        }
    }

    public static boolean leapYear() {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        return n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0;
    }

    public static String monthName(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d, gym, gm};
            String string4 = "MMMM";
            return ExsltDatetime.getNameOrAbbrev(string2, stringArray2, string4);
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String monthName() {
        String string2 = "MMMM";
        return ExsltDatetime.getNameOrAbbrev(string2);
    }

    public static String monthAbbreviation(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d, gym, gm};
            String string4 = "MMM";
            return ExsltDatetime.getNameOrAbbrev(string2, stringArray2, string4);
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String monthAbbreviation() {
        String string2 = "MMM";
        return ExsltDatetime.getNameOrAbbrev(string2);
    }

    public static String dayName(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d};
            String string4 = "EEEE";
            return ExsltDatetime.getNameOrAbbrev(string2, stringArray2, string4);
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String dayName() {
        String string2 = "EEEE";
        return ExsltDatetime.getNameOrAbbrev(string2);
    }

    public static String dayAbbreviation(String string2) {
        try {
            String[] stringArray = ExsltDatetime.getEraDatetimeZone(string2);
            String string3 = stringArray[1];
            if (string3 == null) {
                return EMPTY_STR;
            }
            String[] stringArray2 = new String[]{dt, d};
            String string4 = "EEE";
            return ExsltDatetime.getNameOrAbbrev(string2, stringArray2, string4);
        }
        catch (ParseException parseException) {
            return EMPTY_STR;
        }
    }

    public static String dayAbbreviation() {
        String string2 = "EEE";
        return ExsltDatetime.getNameOrAbbrev(string2);
    }

    private static String[] getEraDatetimeZone(String string2) {
        int n2;
        String string3 = EMPTY_STR;
        String string4 = string2;
        String string5 = EMPTY_STR;
        if (string2.charAt(0) == '-' && !string2.startsWith("--")) {
            string3 = "-";
            string4 = string2.substring(1);
        }
        if ((n2 = ExsltDatetime.getZoneStart(string4)) > 0) {
            string5 = string4.substring(n2);
            string4 = string4.substring(0, n2);
        } else if (n2 == -2) {
            string5 = null;
        }
        return new String[]{string3, string4, string5};
    }

    private static int getZoneStart(String string2) {
        if (string2.indexOf("Z") == string2.length() - 1) {
            return string2.length() - 1;
        }
        if (string2.length() >= 6 && string2.charAt(string2.length() - 3) == ':' && (string2.charAt(string2.length() - 6) == '+' || string2.charAt(string2.length() - 6) == '-')) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                simpleDateFormat.setLenient(false);
                Date date2 = simpleDateFormat.parse(string2.substring(string2.length() - 5));
                return string2.length() - 6;
            }
            catch (ParseException parseException) {
                System.out.println("ParseException " + parseException.getErrorOffset());
                return -2;
            }
        }
        return -1;
    }

    private static Date testFormats(String string2, String[] stringArray) throws ParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
                simpleDateFormat.setLenient(false);
                return simpleDateFormat.parse(string2);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    private static double getNumber(String string2, String[] stringArray, int n2) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        Date date2 = ExsltDatetime.testFormats(string2, stringArray);
        if (date2 == null) {
            return Double.NaN;
        }
        calendar.setTime(date2);
        return calendar.get(n2);
    }

    private static String getNameOrAbbrev(String string2, String[] stringArray, String string3) throws ParseException {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i], Locale.ENGLISH);
                simpleDateFormat.setLenient(false);
                Date date2 = simpleDateFormat.parse(string2);
                simpleDateFormat.applyPattern(string3);
                return simpleDateFormat.format(date2);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return EMPTY_STR;
    }

    private static String getNameOrAbbrev(String string2) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String formatDate(String string2, String string3) {
        String[] stringArray;
        String string4;
        TimeZone timeZone;
        if (string2.endsWith("Z") || string2.endsWith("z")) {
            timeZone = TimeZone.getTimeZone("GMT");
            string2 = string2.substring(0, string2.length() - 1) + "GMT";
            string4 = "z";
        } else if (string2.length() >= 6 && string2.charAt(string2.length() - 3) == ':' && (string2.charAt(string2.length() - 6) == '+' || string2.charAt(string2.length() - 6) == '-')) {
            stringArray = string2.substring(string2.length() - 6);
            timeZone = "+00:00".equals(stringArray) || "-00:00".equals(stringArray) ? TimeZone.getTimeZone("GMT") : TimeZone.getTimeZone("GMT" + (String)stringArray);
            string4 = "z";
            string2 = string2.substring(0, string2.length() - 6) + "GMT" + (String)stringArray;
        } else {
            timeZone = TimeZone.getDefault();
            string4 = EMPTY_STR;
        }
        stringArray = new String[]{dt + string4, d, gym, gy};
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(t + string4);
            simpleDateFormat.setLenient(false);
            Date date2 = simpleDateFormat.parse(string2);
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(ExsltDatetime.strip("GyMdDEFwW", string3));
            simpleDateFormat2.setTimeZone(timeZone);
            return simpleDateFormat2.format(date2);
        }
        catch (ParseException parseException) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i]);
                    simpleDateFormat.setLenient(false);
                    Date date3 = simpleDateFormat.parse(string2);
                    SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat(string3);
                    simpleDateFormat3.setTimeZone(timeZone);
                    return simpleDateFormat3.format(date3);
                }
                catch (ParseException parseException2) {
                    continue;
                }
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gmd);
                simpleDateFormat.setLenient(false);
                Date date4 = simpleDateFormat.parse(string2);
                SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat(ExsltDatetime.strip("Gy", string3));
                simpleDateFormat4.setTimeZone(timeZone);
                return simpleDateFormat4.format(date4);
            }
            catch (ParseException parseException3) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gm);
                    simpleDateFormat.setLenient(false);
                    Date date5 = simpleDateFormat.parse(string2);
                    SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat(ExsltDatetime.strip("Gy", string3));
                    simpleDateFormat5.setTimeZone(timeZone);
                    return simpleDateFormat5.format(date5);
                }
                catch (ParseException parseException4) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(gd);
                        simpleDateFormat.setLenient(false);
                        Date date6 = simpleDateFormat.parse(string2);
                        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat(ExsltDatetime.strip("GyM", string3));
                        simpleDateFormat6.setTimeZone(timeZone);
                        return simpleDateFormat6.format(date6);
                    }
                    catch (ParseException parseException5) {
                        return EMPTY_STR;
                    }
                }
            }
        }
    }

    private static String strip(String string2, String string3) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        while (n2 < string3.length()) {
            char c = string3.charAt(n2);
            if (c == '\'') {
                int n3 = string3.indexOf(39, n2 + 1);
                if (n3 == -1) {
                    n3 = string3.length();
                }
                stringBuffer.append(string3.substring(n2, n3));
                n2 = n3++;
                continue;
            }
            if (string2.indexOf(c) > -1) {
                ++n2;
                continue;
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

