/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.DateTimeBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;

public class XTime
extends XItemBase {
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone = null;

    protected XTime(DateTimeBase dateTimeBase) {
        this.m_hour = dateTimeBase.getHours();
        this.m_minute = dateTimeBase.getMinutes();
        this.m_second = (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction();
    }

    public XTime(int n2, int n3, double d) {
        this(n2, n3, d, null);
    }

    public XTime(int n2, int n3, double d, int n4, int n5) {
        this(n2, n3, d, new XDayTimeDuration(0, n4, n5, 0.0));
    }

    public XTime(int n2, int n3, double d, XDayTimeDuration xDayTimeDuration) {
        this.m_hour = n2;
        this.m_minute = n3;
        this.m_second = d;
        this.m_timezone = xDayTimeDuration;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XTime add(XDayTimeDuration xDayTimeDuration) {
        double d = this.m_second + xDayTimeDuration.getSeconds();
        int n2 = XDataTypeUtils.fQuotient(d, 60.0);
        double d2 = XDataTypeUtils.modulo(d, 60.0, n2);
        int n3 = this.m_minute + xDayTimeDuration.getMinutes() + n2;
        n2 = XDataTypeUtils.fQuotient(n3, 60.0);
        int n4 = (int)XDataTypeUtils.modulo((double)n3, 60.0, n2);
        n3 = this.m_hour + xDayTimeDuration.getHours() + n2;
        n2 = XDataTypeUtils.fQuotient(n3, 24.0);
        int n5 = (int)XDataTypeUtils.modulo((double)n3, 24.0, n2);
        return new XTime(n5, n4, d2, this.m_timezone);
    }

    public XDayTimeDuration subtract(XTime xTime) {
        XDateTime xDateTime = new XDateTime(1970, 6, 20, this.getHour(), this.getMinute(), this.getSecond(), this.getTimeZoneHour(), this.getTimeZoneMinute()).normalize();
        XDateTime xDateTime2 = new XDateTime(1970, 6, 20, xTime.getHour(), xTime.getMinute(), xTime.getSecond(), xTime.getTimeZoneHour(), xTime.getTimeZoneMinute()).normalize();
        return xDateTime.subtract(xDateTime2);
    }

    public XTime subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }
}

