/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDate;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import java.math.BigDecimal;

public class XDayTimeDuration
extends XDuration {
    public XDayTimeDuration(int n2, int n3, int n4, double d) {
        this.calculateValue(n2, n3, n4, d);
    }

    public XDayTimeDuration(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public final void calculateValue(int n2, int n3, int n4, double d) {
        this.m_CValue = XDataTypeUtils.dayTimeDurationToSeconds(n2, n3, n4, d);
        if (this.m_CValue.doubleValue() == 0.0) {
            return;
        }
        this.m_days = this.m_CValue.divide(new BigDecimal(86400), 1).intValue();
        BigDecimal bigDecimal = this.m_CValue.subtract(new BigDecimal(86400.0 * (double)this.m_days));
        this.m_hours = (int)bigDecimal.doubleValue() / 3600;
        bigDecimal = bigDecimal.subtract(new BigDecimal(this.m_hours * 3600));
        this.m_minutes = (int)bigDecimal.doubleValue() / 60;
        this.m_seconds = bigDecimal.subtract(new BigDecimal(this.m_minutes * 60)).doubleValue();
    }

    public final void setValue(BigDecimal bigDecimal) {
        this.m_CValue = bigDecimal;
        if (bigDecimal.doubleValue() == 0.0) {
            return;
        }
        this.m_days = (int)bigDecimal.divide(new BigDecimal(86400), 1).longValue();
        BigDecimal bigDecimal2 = bigDecimal.subtract(new BigDecimal(this.m_days).multiply(new BigDecimal(86400)));
        this.m_hours = (int)bigDecimal2.doubleValue() / 3600;
        bigDecimal2 = bigDecimal2.subtract(new BigDecimal(this.m_hours * 3600));
        this.m_minutes = (int)bigDecimal2.doubleValue() / 60;
        this.m_seconds = bigDecimal2.subtract(new BigDecimal(this.m_minutes * 60)).doubleValue();
    }

    @Override
    public BigDecimal getCValue() {
        return this.m_CValue;
    }

    public XDayTimeDuration add(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(this.m_days + xDayTimeDuration.getDays(), this.m_hours + xDayTimeDuration.getHours(), this.m_minutes + xDayTimeDuration.getMinutes(), this.m_seconds + xDayTimeDuration.getSeconds());
    }

    public XDate add(XDate xDate) {
        return xDate.add(this);
    }

    public XTime add(XTime xTime) {
        return xTime.add(this);
    }

    public XDateTime add(XDateTime xDateTime) {
        return xDateTime.add(this);
    }

    public XDayTimeDuration subtract(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(this.m_CValue.add(xDayTimeDuration.getCValue().negate()));
    }

    public XDayTimeDuration multiply(double d) {
        this.checkDoubleValue(d, false);
        return new XDayTimeDuration(this.m_CValue.multiply(new BigDecimal(d)));
    }

    public XDayTimeDuration divide(double d) {
        this.checkDoubleValue(d, true);
        if (Double.isInfinite(d)) {
            return new XDayTimeDuration(new BigDecimal(0));
        }
        return new XDayTimeDuration(this.m_CValue.divide(new BigDecimal(d), 18, 4));
    }

    public BigDecimal divide(XDayTimeDuration xDayTimeDuration) {
        return this.m_CValue.divide(xDayTimeDuration.getCValue(), 18, 4);
    }
}

