/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.DateTimeBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;
import java.math.BigDecimal;

public class XDateTime
extends XItemBase {
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private int m_hour;
    private int m_minute;
    private double m_second;
    private XDayTimeDuration m_timezone;

    protected XDateTime(DateTimeBase dateTimeBase) {
        this.m_year = dateTimeBase.getYear();
        this.m_month = dateTimeBase.getMonth();
        this.m_day = dateTimeBase.getDay();
        this.m_hour = dateTimeBase.getHours();
        this.m_minute = dateTimeBase.getMinutes();
        this.m_second = (double)dateTimeBase.getSeconds() + dateTimeBase.getFraction();
    }

    public XDateTime(int n2, int n3, int n4, int n5, int n6, double d) {
        this(n2, n3, n4, n5, n6, d, null);
    }

    public XDateTime(int n2, int n3, int n4, int n5, int n6, double d, int n7, int n8) {
        this(n2, n3, n4, n5, n6, d, new XDayTimeDuration(0, n7, n8, 0.0));
    }

    public XDateTime(int n2, int n3, int n4, int n5, int n6, double d, XDayTimeDuration xDayTimeDuration) {
        this.m_year = n2;
        this.m_month = n3;
        this.m_day = n4;
        this.m_hour = n5;
        this.m_minute = n6;
        this.m_second = d;
        this.m_timezone = xDayTimeDuration;
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime xDateTime = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), 0, 0);
            return xDateTime.subtract(this.m_timezone);
        }
        return this;
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public double getSecond() {
        return this.m_second;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XDateTime add(XYearMonthDuration xYearMonthDuration) {
        int n2 = this.m_month + xYearMonthDuration.getMonths();
        int n3 = (int)XDataTypeUtils.modulo((double)n2, 1, 13);
        int n4 = XDataTypeUtils.fQuotient(n2, 1, 13);
        int n5 = this.m_year + xYearMonthDuration.getYears() + n4;
        int n6 = XDataTypeUtils.normalizeDay(this.m_day, n3, n5);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n6, n3, n5);
        return new XDateTime(nArray[2], nArray[1], nArray[0], this.m_hour, this.m_minute, this.m_second, this.m_timezone);
    }

    public XDateTime add(XDayTimeDuration xDayTimeDuration) {
        double d = this.m_second + xDayTimeDuration.getSeconds();
        int n2 = XDataTypeUtils.fQuotient(d, 60.0);
        double d2 = XDataTypeUtils.modulo(d, 60.0, n2);
        int n3 = this.m_minute + xDayTimeDuration.getMinutes() + n2;
        n2 = XDataTypeUtils.fQuotient(n3, 60.0);
        int n4 = (int)XDataTypeUtils.modulo((double)n3, 60.0, n2);
        n3 = this.m_hour + xDayTimeDuration.getHours() + n2;
        n2 = XDataTypeUtils.fQuotient(n3, 24.0);
        int n5 = (int)XDataTypeUtils.modulo((double)n3, 24.0, n2);
        int n6 = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n6 += xDayTimeDuration.getDays() + n2, this.m_month, this.m_year);
        return new XDateTime(nArray[2], nArray[1], nArray[0], n5, n4, d2, this.m_timezone);
    }

    public XDateTime subtract(XYearMonthDuration xYearMonthDuration) {
        return this.add(XDataTypeUtils.negate(xYearMonthDuration));
    }

    public XDateTime subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }

    public XDayTimeDuration subtract(XDateTime xDateTime) {
        XDateTime xDateTime2 = this.normalize();
        XDateTime xDateTime3 = xDateTime.normalize();
        int n2 = XDataTypeUtils.numberOfDays(xDateTime2.getDay(), xDateTime2.getMonth(), xDateTime2.getYear()) - XDataTypeUtils.numberOfDays(xDateTime3.getDay(), xDateTime3.getMonth(), xDateTime3.getYear());
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n2, 0, 0, 0.0);
        double d = XDataTypeUtils.timeToSeconds(new XTime(xDateTime2.getHour(), xDateTime2.getMinute(), xDateTime2.getSecond())) - XDataTypeUtils.timeToSeconds(new XTime(xDateTime3.getHour(), xDateTime3.getMinute(), xDateTime3.getSecond()));
        if (n2 > 0 && d < 0.0) {
            return xDayTimeDuration.subtract(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(d * -1.0)));
        }
        return xDayTimeDuration.add(XDataTypeUtils.secondsTodayTimeDuration(new BigDecimal(d)));
    }
}

