/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDataTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDateTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XItemBase;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;

public class XDate
extends XItemBase {
    private final XDayTimeDuration ZERO_DTD = new XDayTimeDuration(0, 0, 0, 0.0);
    private int m_year;
    private int m_month;
    private int m_day;
    private XDayTimeDuration m_timezone;

    public XDate(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public XDate(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, new XDayTimeDuration(0, n5, n6, 0.0));
    }

    public XDate(int n2, int n3, int n4, XDayTimeDuration xDayTimeDuration) {
        this.m_year = n2;
        this.m_month = n3;
        this.m_day = n4;
        this.m_timezone = xDayTimeDuration;
    }

    public XDateTime normalize() {
        if (this.m_timezone != null && !this.m_timezone.equals(this.ZERO_DTD)) {
            XDateTime xDateTime = new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0, 0, 0);
            return xDateTime.subtract(this.m_timezone);
        }
        return new XDateTime(this.getYear(), this.getMonth(), this.getDay(), 0, 0, 0.0);
    }

    public int getYear() {
        return this.m_year;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getDay() {
        return this.m_day;
    }

    public XDayTimeDuration getTimeZone() {
        return this.m_timezone;
    }

    public int getTimeZoneHour() {
        return this.m_timezone != null ? this.m_timezone.getHours() : Integer.MAX_VALUE;
    }

    public int getTimeZoneMinute() {
        return this.m_timezone != null ? this.m_timezone.getMinutes() : Integer.MAX_VALUE;
    }

    public XDate add(XYearMonthDuration xYearMonthDuration) {
        int n2 = this.m_month + xYearMonthDuration.getMonths();
        int n3 = (int)XDataTypeUtils.modulo((double)n2, 1, 13);
        int n4 = XDataTypeUtils.fQuotient(n2, 1, 13);
        int n5 = this.m_year + xYearMonthDuration.getYears() + n4;
        int n6 = this.m_day;
        n6 = XDataTypeUtils.normalizeDay(n6, n3, n5);
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n6, n3, n5);
        return new XDate(nArray[2], nArray[1], nArray[0], this.m_timezone);
    }

    public XDate add(XDayTimeDuration xDayTimeDuration) {
        int n2 = XDataTypeUtils.normalizeDay(this.m_day, this.m_month, this.m_year);
        n2 += xDayTimeDuration.getDays();
        if (xDayTimeDuration.getHours() < 0 || xDayTimeDuration.getMinutes() < 0 || xDayTimeDuration.getSeconds() < 0.0) {
            --n2;
        }
        int[] nArray = new int[3];
        nArray = XDataTypeUtils.normalizeDate(n2, this.m_month, this.m_year);
        return new XDate(nArray[2], nArray[1], nArray[0], this.m_timezone);
    }

    public XDayTimeDuration subtract(XDate xDate) {
        XDateTime xDateTime = this.normalize();
        XDateTime xDateTime2 = xDate.normalize();
        return xDateTime.subtract(xDateTime2);
    }

    public XDate subtract(XYearMonthDuration xYearMonthDuration) {
        return this.add(XDataTypeUtils.negate(xYearMonthDuration));
    }

    public XDate subtract(XDayTimeDuration xDayTimeDuration) {
        return this.add(XDataTypeUtils.negate(xDayTimeDuration));
    }
}

