/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XDayTimeDuration;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XTime;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.XYearMonthDuration;
import java.math.BigDecimal;

public class XDataTypeUtils {
    public static final BigDecimal dayTimeDurationToSeconds(XDayTimeDuration xDayTimeDuration) {
        return XDataTypeUtils.dayTimeDurationToSeconds(xDayTimeDuration.getDays(), xDayTimeDuration.getHours(), xDayTimeDuration.getMinutes(), xDayTimeDuration.getSeconds());
    }

    public static final BigDecimal dayTimeDurationToSeconds(int n2, int n3, int n4, double d) {
        return new BigDecimal(n2).multiply(new BigDecimal(86400)).add(new BigDecimal(n3).multiply(new BigDecimal(3600))).add(new BigDecimal(n4).multiply(new BigDecimal(60))).add(new BigDecimal(d)).setScale(3, 4);
    }

    public static final double timeToSeconds(XTime xTime) {
        return (double)(xTime.getHour() * 3600 + xTime.getMinute() * 60) + xTime.getSecond();
    }

    public static final XDayTimeDuration secondsTodayTimeDuration(BigDecimal bigDecimal) {
        return new XDayTimeDuration(bigDecimal);
    }

    public static final XYearMonthDuration negate(XYearMonthDuration xYearMonthDuration) {
        return new XYearMonthDuration(xYearMonthDuration.getCValue().negate());
    }

    public static final XDayTimeDuration negate(XDayTimeDuration xDayTimeDuration) {
        return new XDayTimeDuration(xDayTimeDuration.getCValue().negate());
    }

    public static final int fQuotient(double d, double d2) {
        return (int)Math.floor(d / d2);
    }

    public static final int fQuotient(double d, int n2, int n3) {
        return XDataTypeUtils.fQuotient(d - (double)n2, n3 - n2);
    }

    public static final double modulo(double d, double d2, int n2) {
        return d - (double)n2 * d2;
    }

    public static final double modulo(double d, int n2, int n3) {
        double d2 = d - (double)n2;
        double d3 = n3 - n2;
        return XDataTypeUtils.modulo(d2, d3, XDataTypeUtils.fQuotient(d2, d3)) + (double)n2;
    }

    public static int maxDayInMonthFor(int n2, int n3) {
        if (n3 == 2) {
            return XDataTypeUtils.isLeapYear(n2) ? 29 : 28;
        }
        if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
            return 30;
        }
        return 31;
    }

    private static boolean isLeapYear(int n2) {
        return n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0;
    }

    public static final int[] normalizeDate(int n2, int n3, int n4) {
        int[] nArray = new int[3];
        while (true) {
            int n5;
            int n6 = XDataTypeUtils.maxDayInMonthFor(n4, n3);
            if (n2 < 1) {
                n2 += XDataTypeUtils.maxDayInMonthFor(n4, n3 - 1);
                n5 = -1;
            } else {
                if (n2 <= n6) break;
                n2 -= n6;
                n5 = 1;
            }
            n6 = n3 + n5;
            n3 = (int)XDataTypeUtils.modulo((double)n6, 1, 13);
            n4 += XDataTypeUtils.fQuotient(n6, 1, 13);
        }
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
        return nArray;
    }

    public static final int normalizeDay(int n2, int n3, int n4) {
        int n5 = XDataTypeUtils.maxDayInMonthFor(n4, n3);
        if (n2 < 1) {
            n5 = 1;
        } else if (n2 < n5 && n2 >= 1) {
            n5 = n2;
        }
        return n5;
    }

    private static int leaps(int n2) {
        return (n2 - 1) / 4 - (n2 - 1) / 100 + (n2 - 1) / 400;
    }

    public static final int numberOfDays(int n2, int n3, int n4) {
        int[] nArray = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        int n5 = (n4 - 1) * 365 + XDataTypeUtils.leaps(n4);
        n5 += nArray[n3 - 1] + n2;
        return XDataTypeUtils.isLeapYear(n4) && n3 > 2 ? ++n5 : n5;
    }
}

