/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.xml.types.TypeError;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.output.ResultTreeSequenceWriterStream;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.SchemaNamedXType;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XType;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.dp.values.chars.CharBufferChars;
import com.ibm.xml.xci.dp.values.chars.Chars;
import com.ibm.xml.xci.errors.XCIDynamicErrorException;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.AttributePSVI;
import com.ibm.xml.xml4j.api.s1.xs.ElementPSVI;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIAttrNSImpl;
import com.ibm.xml.xml4j.internal.s1.dom.PSVIElementNSImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.traversal.NodeIterator;

public class RuntimeLibrary {
    public static final String VERSION = "Gustav-Mon-Jan-22-06:03:25-EST-2007";
    public static final char[] s_emptyCharStream = new char[0];
    private static final DecimalFormat DEC_NOTATION;
    private static final DecimalFormat DOUBLE_FORMATER;
    public static final int[] EMPTY_NAMESPACE_TABLE;
    public static final int EMPTY_ID = 13;
    static final short DERMETH = 3;
    private static final HashMap m_prefixes;

    public static String verboseVersionWithCopyright() {
        return "Xylem RuntimeLibrary version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\" (C) Copyright IBM Corp. 2004, 2005, 2006";
    }

    public static String verboseVersion() {
        return "Xylem runtime version \"Gustav-Mon-Jan-22-06:03:25-EST-2007\"";
    }

    public static void checkVersion(String string2) {
        if (!string2.equals(VERSION)) {
            throw new Error("version '" + string2 + "' does not match RuntimeLibrary version '" + VERSION + "'");
        }
    }

    public static final int codePointCount(char[] cArray) {
        String string2 = new String(cArray);
        return string2.codePointCount(0, string2.length());
    }

    public static final boolean contains(char[] cArray, char[] cArray2) {
        if (cArray2.length == 0) {
            return true;
        }
        if (cArray2.length > cArray.length) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[n2]) {
                if (++n2 != cArray2.length) continue;
                return true;
            }
            while (n2 != 0) {
                --n2;
                --i;
            }
        }
        return false;
    }

    public static char[] doubleToCharArray10(double d) {
        return RuntimeLibrary.doubleToString10(d).toCharArray();
    }

    public static String doubleToString10(double d) {
        return BasisLibrary.realToString(d);
    }

    public static char[] floatToCharArray10(float f2) {
        return RuntimeLibrary.floatToString10(f2).toCharArray();
    }

    public static String floatToString10(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        if (f2 == 0.0f) {
            return "0";
        }
        if ((double)StrictMath.abs(f2) < 1.0E-6 || StrictMath.abs(f2) >= 1000000.0f) {
            return DOUBLE_FORMATER.format(f2);
        }
        return RuntimeLibrary.removeTrailingZeros(Float.toString(f2));
    }

    public static char[] doubleToCharArray(double d) {
        return RuntimeLibrary.doubleToString(d).toCharArray();
    }

    public static String doubleToString(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        Double d2 = new Double(d);
        if (d == 0.0) {
            String string2 = d2.toString();
            return string2.substring(0, string2.indexOf("."));
        }
        if (StrictMath.abs(d) >= 1.0E-6 && StrictMath.abs(d) < 1000000.0) {
            return DEC_NOTATION.format(d);
        }
        if (StrictMath.abs(d) > 0.0 && StrictMath.abs(d) < 1.0E7) {
            return DOUBLE_FORMATER.format(d);
        }
        return Double.toString(d);
    }

    public static char[] floatToCharArray(float f2) {
        return RuntimeLibrary.floatToString(f2).toCharArray();
    }

    public static String floatToString(float f2) {
        if (f2 == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        if (f2 == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (Float.isNaN(f2)) {
            return "NaN";
        }
        Float f3 = new Float(f2);
        if (f2 == 0.0f) {
            String string2 = f3.toString();
            return string2.substring(0, string2.indexOf("."));
        }
        if ((double)StrictMath.abs(f2) >= 1.0E-6 && StrictMath.abs(f2) < 1000000.0f) {
            Double d = new Double(f3.toString());
            return DEC_NOTATION.format(d);
        }
        if (StrictMath.abs(f2) > 0.0f && StrictMath.abs(f2) < 1.0E7f) {
            Double d = new Double(f3.toString());
            return DOUBLE_FORMATER.format(d);
        }
        return f3.toString();
    }

    public static String removeTrailingZeros(String string2) {
        int n2 = string2.length();
        if (string2.charAt(n2 - 1) != '0') {
            return string2;
        }
        if (string2.indexOf(46) >= 0) {
            while (string2.charAt(n2 - 1) == '0') {
                --n2;
            }
            if (string2.charAt(n2 - 1) == '.') {
                --n2;
            }
            return string2.substring(0, n2);
        }
        return string2;
    }

    public static char[] decimalToCharArray(BigDecimal bigDecimal) {
        return RuntimeLibrary.decimalToString(bigDecimal).toCharArray();
    }

    public static String decimalToString(BigDecimal bigDecimal) {
        return RuntimeLibrary.removeTrailingZeros(bigDecimal.stripTrailingZeros().toPlainString());
    }

    public static char[] normalizeSpace(char[] cArray) {
        char[] cArray2;
        int n2;
        int n3 = cArray.length;
        char[] cArray3 = new char[cArray.length];
        int n4 = 0;
        for (n2 = 0; n2 < n3 && RuntimeLibrary.isWhiteSpace(cArray[n2]); ++n2) {
        }
        while (true) {
            if (n2 < n3 && !RuntimeLibrary.isWhiteSpace(cArray[n2])) {
                if (n4 == cArray3.length) {
                    cArray2 = new char[cArray3.length * 2];
                    System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                    cArray3 = cArray2;
                }
                cArray3[n4++] = cArray[n2++];
                continue;
            }
            if (n2 == n3) break;
            while (n2 < n3 && RuntimeLibrary.isWhiteSpace(cArray[n2])) {
                ++n2;
            }
            if (n2 >= n3) continue;
            if (n4 == cArray3.length) {
                cArray2 = new char[cArray3.length * 2];
                System.arraycopy(cArray3, 0, cArray2, 0, cArray3.length);
                cArray3 = cArray2;
            }
            cArray3[n4++] = 32;
        }
        if (n4 == cArray3.length) {
            return cArray3;
        }
        cArray2 = new char[n4];
        System.arraycopy(cArray3, 0, cArray2, 0, n4);
        return cArray2;
    }

    private static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static final boolean startsWith(char[] cArray, char[] cArray2) {
        if (cArray2.length == 0) {
            return true;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) {
                if (i != cArray2.length - 1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void addToElement(Object object2, Node node2, boolean bl) {
        RuntimeLibrary.addToElement((Cursor)object2, node2, node2.getOwnerDocument(), bl);
    }

    public static void addToElement(Cursor cursor2, Node node2, boolean bl) {
        RuntimeLibrary.addToElement(cursor2, node2, node2.getOwnerDocument(), bl);
    }

    private static String render_xci_qname(QName qName) {
        return BasisLibrary2.qNameToString(qName);
    }

    public static void addToElement(Cursor cursor2, Node node2, Document document2, boolean bl) {
        if (cursor2.isWrapped()) {
            cursor2 = cursor2.unwrap();
        }
        if (Node.class == cursor2.exportAsClass("expdom2")) {
            Node node3 = (Node)cursor2.exportAs(Node.class.getName(), false);
            short s = cursor2.itemKind();
            if (s == 2) {
                String string2 = cursor2.itemName().getQName(1, null).getNamespaceURI();
                if (string2.equals("")) {
                    string2 = null;
                }
                String string3 = RuntimeLibrary.render_xci_qname(cursor2.itemName().getQName(1, null));
                ((Element)node2).setAttributeNS(string2, string3, cursor2.itemTypedValue().getString(1));
                if (bl) {
                    Attr attr2 = ((Element)node2).getAttributeNodeNS(string2, string3);
                    Attr attr3 = (Attr)node3;
                    if (attr3 instanceof AttributePSVI) {
                        ((PSVIAttrNSImpl)attr2).setPSVI((AttributePSVI)((Object)attr3));
                    }
                }
            } else if (s == 4) {
                String string4 = node3.getNamespaceURI();
                String string5 = node3.getNodeName();
                ((Element)node2).setAttributeNS(string4, string5, cursor2.itemTypedValue().getString(1));
            } else {
                Node node4 = node2.appendChild(document2.importNode(node3, !bl));
                if (bl) {
                    RuntimeLibrary.copySubtreeWithTypeAnnotations(node3, node4, document2);
                }
            }
            return;
        }
        short s = cursor2.itemKind();
        switch (s) {
            case 3: {
                node2.appendChild(document2.createTextNode(cursor2.itemTypedValue().getString(1)));
                break;
            }
            case 2: {
                QName qName = cursor2.itemName().getQName(1, null);
                String string6 = qName.getNamespaceURI();
                ((Element)node2).setAttributeNS(string6.length() == 0 ? null : string6, RuntimeLibrary.render_xci_qname(qName), cursor2.itemTypedValue().getString(1));
                break;
            }
            case 1: 
            case 9: {
                Object object2;
                String string7;
                Node node5 = s == 1 ? document2.createElementNS((string7 = ((QName)(object2 = cursor2.itemName().getQName(1, null))).getNamespaceURI()).length() == 0 ? null : string7, RuntimeLibrary.render_xci_qname((QName)object2)) : document2.createDocumentFragment();
                object2 = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
                boolean bl2 = object2.toChildren(null);
                if (bl2) {
                    do {
                        RuntimeLibrary.addToElement((Cursor)object2, node5, document2, bl);
                    } while (object2.toNext());
                }
                node2.appendChild(node5);
                break;
            }
            case 4: {
                VolatileCData volatileCData = cursor2.itemName();
                String string8 = volatileCData == null || volatileCData.isEmptySequence() ? "xmlns" : "xmlns:" + volatileCData.getQNameLocalPart(1);
                ((Element)node2).setAttributeNS("http://www.w3.org/2000/xmlns/", string8, cursor2.itemTypedValue().getString(1));
                break;
            }
            case 8: {
                node2.appendChild(document2.createComment(cursor2.itemStringValue().getString(1)));
                break;
            }
            case 7: {
                node2.appendChild(document2.createProcessingInstruction(cursor2.itemName().getQName(1, null).getLocalPart(), cursor2.itemStringValue().getString(1)));
            }
        }
    }

    private static void copySubtreeWithTypeAnnotations(Node node2, Node node3, Document document2) {
        Node node4;
        Object object2;
        if (node3 instanceof Element) {
            if (node2 instanceof ElementPSVI && node3 instanceof PSVIElementNSImpl) {
                ((PSVIElementNSImpl)node3).setPSVI((ElementPSVI)((Object)node2));
            }
            object2 = node2.getAttributes();
            Element element2 = (Element)node3;
            for (int i = 0; i < object2.getLength(); ++i) {
                node4 = (Attr)object2.item(i);
                Attr attr2 = (Attr)document2.importNode(node4, false);
                element2.setAttributeNodeNS(attr2);
                if (!(node4 instanceof AttributePSVI) || !(attr2 instanceof PSVIAttrNSImpl)) continue;
                ((PSVIAttrNSImpl)attr2).setPSVI((AttributePSVI)((Object)node4));
            }
        }
        object2 = node2.getChildNodes();
        for (int i = 0; i < object2.getLength(); ++i) {
            Node node5 = object2.item(i);
            node4 = document2.importNode(node5, false);
            node3.appendChild(node4);
            RuntimeLibrary.copySubtreeWithTypeAnnotations(node5, node4, document2);
        }
    }

    public static int compare(double d, double d2) {
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return 0;
        }
        if (Double.isNaN(d2) || d > d2) {
            return 1;
        }
        if (Double.isNaN(d) || d < d2) {
            return -1;
        }
        return 0;
    }

    public static int compare(String string2, String string3) {
        int n2 = string2.compareToIgnoreCase(string3);
        if (n2 > 0) {
            return 1;
        }
        if (n2 < 0) {
            return -1;
        }
        return 0;
    }

    private static String cursorToString(Cursor cursor2) {
        if (cursor2 == null) {
            return "";
        }
        Chars chars = cursor2.itemStringValueAsChars();
        return chars.isEmpty() ? "" : ((Object)chars).toString();
    }

    public static char[] cursorToCharArray(Cursor cursor2) {
        if (cursor2 == null) {
            return s_emptyCharStream;
        }
        Chars chars = cursor2.itemStringValueAsChars();
        return chars.isEmpty() ? s_emptyCharStream : chars.toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor cursor2, Cursor cursor3) {
        if (cursor2 == null) {
            return s_emptyCharStream;
        }
        CharSequence charSequence = cursor2.sequenceConstructSimpleContent(cursor3.itemStringValueAsChars(), true, false);
        if (charSequence instanceof Chars) {
            return ((Chars)charSequence).toCharArray();
        }
        return ((Object)charSequence).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor cursor2, String string2) {
        if (cursor2 == null) {
            return s_emptyCharStream;
        }
        CharSequence charSequence = cursor2.sequenceConstructSimpleContent(string2, true, false);
        if (charSequence instanceof Chars) {
            return ((Chars)charSequence).toCharArray();
        }
        return ((Object)charSequence).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor cursor2, char[] cArray) {
        if (cursor2 == null) {
            return s_emptyCharStream;
        }
        CharSequence charSequence = cursor2.sequenceConstructSimpleContent(CharBufferChars.make(cArray), true, false);
        if (charSequence instanceof Chars) {
            return ((Chars)charSequence).toCharArray();
        }
        return ((Object)charSequence).toString().toCharArray();
    }

    public static char[] cursorItemAtomize(Cursor cursor2) {
        if (cursor2 == null) {
            return s_emptyCharStream;
        }
        CharSequence charSequence = cursor2.sequenceConstructSimpleContent(" ", true, false);
        if (charSequence instanceof Chars) {
            return ((Chars)charSequence).toCharArray();
        }
        return ((Object)charSequence).toString().toCharArray();
    }

    public static String cursorItemAtomizeToString(Cursor cursor2, char[] cArray) {
        if (cursor2 == null) {
            return "";
        }
        return ((Object)cursor2.sequenceConstructSimpleContent(CharBufferChars.make(cArray), true, false)).toString();
    }

    public static String cursorItemAtomizeToString(Cursor cursor2, String string2) {
        if (cursor2 == null) {
            return "";
        }
        return ((Object)cursor2.sequenceConstructSimpleContent(string2, true, false)).toString();
    }

    public static void cursorItemAtomize(Cursor cursor2, String string2, ResultTreeSequenceWriterStream resultTreeSequenceWriterStream) {
        if (cursor2 != null) {
            CharSequence charSequence = cursor2.sequenceConstructSimpleContent(string2, true, false);
            if (charSequence instanceof Chars) {
                resultTreeSequenceWriterStream.addText((Chars)charSequence);
            } else {
                resultTreeSequenceWriterStream.addText(((Object)charSequence).toString());
            }
        }
    }

    public static double cursorToDouble(Cursor cursor2) {
        if (cursor2 == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(RuntimeLibrary.cursorToString(cursor2));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static float cursorToFloat(Cursor cursor2) {
        if (cursor2 == null) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(RuntimeLibrary.cursorToString(cursor2));
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static BigDecimal cursorToDecimal(Cursor cursor2) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(RuntimeLibrary.cursorToString(cursor2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException();
        }
        return bigDecimal;
    }

    public static int cursorToInt(Cursor cursor2) {
        if (cursor2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(RuntimeLibrary.cursorToString(cursor2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static double stringToDouble(char[] cArray) {
        try {
            return Double.parseDouble(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static float stringToFloat(char[] cArray) {
        try {
            return Float.parseFloat(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return Float.NaN;
        }
    }

    public static int stringToInt(char[] cArray) {
        try {
            return Integer.parseInt(new String(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static BigDecimal stringToDecimal(char[] cArray) {
        BigDecimal bigDecimal;
        try {
            bigDecimal = new BigDecimal(String.valueOf(cArray));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException();
        }
        return bigDecimal;
    }

    public static final Object convertJavaObject(CursorFactory cursorFactory, Object object2) {
        if (object2 instanceof Double) {
            return object2;
        }
        if (object2 instanceof Number) {
            return new Double(((Number)object2).doubleValue());
        }
        return object2;
    }

    public static XCollator getCollator(String string2, String string3) {
        CollatorDeclaration collatorDeclaration = CollatorFactory.getCollatorDeclaration(null, string2, null, null, null, string3, null);
        XCollator xCollator = CollatorFactory.createCollatorFromDeclaration(collatorDeclaration);
        return xCollator;
    }

    public static Collator getCollator(String string2) {
        if (string2 == null || string2.length() == 0) {
            return Collator.getInstance();
        }
        Locale locale = new Locale(string2.toLowerCase(), Locale.getDefault().getCountry());
        return Collator.getInstance(locale);
    }

    public static final int[] getNamespaceTable(Object object2) {
        if (object2 instanceof Cursor) {
            return new int[0];
        }
        return null;
    }

    public static final float getCurrentItemAsFloat(Cursor cursor2) {
        return cursor2.itemTypedValue().getFloat(1);
    }

    public static final double getCurrentItemAsDouble(Cursor cursor2) {
        return cursor2.itemTypedValue().getDouble(1);
    }

    public static final BigDecimal getCurrentItemAsDecimal(Cursor cursor2) {
        return cursor2.itemTypedValue().getBigDecimal(1);
    }

    public static final long getCurrentItemAsLong(Cursor cursor2) {
        try {
            return cursor2.itemTypedValue().getLong(1);
        }
        catch (XCIDynamicErrorException xCIDynamicErrorException) {
            BasisLibrary2.runTimeError("ERR_INTEGER_TOO_LARGE");
            return 0L;
        }
    }

    public static final BigInteger getCurrentItemAsBigInteger(Cursor cursor2) {
        return cursor2.itemTypedValue().getBigInteger(1);
    }

    public static final int[] getCurrentItemAsDuration(Cursor cursor2) {
        int[] nArray = new int[7];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            nArray[0] = duration2.getYears();
            nArray[1] = duration2.getMonths();
            nArray[2] = duration2.getDays();
            nArray[3] = duration2.getHours();
            nArray[4] = duration2.getMinutes();
            BigDecimal bigDecimal = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
            if (bigDecimal == null) {
                nArray[5] = 0;
                nArray[6] = 0;
            } else {
                nArray[5] = bigDecimal.intValue();
                nArray[6] = bigDecimal.remainder(BigDecimal.ONE).movePointRight(3).intValue();
            }
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsYearMonthDuration(Cursor cursor2) {
        int[] nArray = new int[2];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            nArray[0] = duration2.getYears();
            nArray[1] = duration2.getMonths();
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsDayTimeDuration(Cursor cursor2) {
        int[] nArray = new int[5];
        try {
            Duration duration2 = cursor2.itemTypedValue().getDuration(1);
            nArray[0] = duration2.getDays();
            nArray[1] = duration2.getHours();
            nArray[2] = duration2.getMinutes();
            BigDecimal bigDecimal = (BigDecimal)duration2.getField(DatatypeConstants.SECONDS);
            if (bigDecimal == null) {
                nArray[3] = 0;
                nArray[4] = 0;
            } else {
                nArray[3] = bigDecimal.intValue();
                nArray[4] = bigDecimal.remainder(BigDecimal.ONE).movePointRight(3).intValue();
            }
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsDateTime(Cursor cursor2) {
        int[] nArray = new int[10];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getYear();
            nArray[1] = xMLGregorianCalendar.getMonth();
            nArray[2] = xMLGregorianCalendar.getDay();
            nArray[3] = xMLGregorianCalendar.getHour();
            nArray[4] = xMLGregorianCalendar.getMinute();
            nArray[5] = xMLGregorianCalendar.getSecond();
            int n2 = xMLGregorianCalendar.getMillisecond();
            nArray[6] = n2 == Integer.MIN_VALUE ? 0 : n2;
            nArray[7] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[8] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[9] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsTime(Cursor cursor2) {
        int[] nArray = new int[7];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getHour();
            nArray[1] = xMLGregorianCalendar.getMinute();
            nArray[2] = xMLGregorianCalendar.getSecond();
            int n2 = xMLGregorianCalendar.getMillisecond();
            nArray[3] = n2 == Integer.MIN_VALUE ? 0 : n2;
            nArray[4] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[5] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[6] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsDate(Cursor cursor2) {
        int[] nArray = new int[6];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getYear();
            nArray[1] = xMLGregorianCalendar.getMonth();
            nArray[2] = xMLGregorianCalendar.getDay();
            nArray[3] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[4] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[5] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsYearMonth(Cursor cursor2) {
        int[] nArray = new int[5];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getYear();
            nArray[1] = xMLGregorianCalendar.getMonth();
            nArray[2] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[3] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[4] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsYear(Cursor cursor2) {
        int[] nArray = new int[4];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getYear();
            nArray[1] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[2] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[3] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsMonthDay(Cursor cursor2) {
        int[] nArray = new int[5];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getMonth();
            nArray[1] = xMLGregorianCalendar.getDay();
            nArray[2] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[3] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[4] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsDay(Cursor cursor2) {
        int[] nArray = new int[4];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getDay();
            nArray[1] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[2] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[3] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final int[] getCurrentItemAsMonth(Cursor cursor2) {
        int[] nArray = new int[4];
        try {
            XMLGregorianCalendar xMLGregorianCalendar = cursor2.itemTypedValue().getXMLGregorianCalendar(1);
            nArray[0] = xMLGregorianCalendar.getMonth();
            nArray[1] = xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE ? 0 : 1;
            nArray[2] = xMLGregorianCalendar.getTimezone() / 60;
            nArray[3] = xMLGregorianCalendar.getTimezone() % 60;
        }
        catch (ParseException parseException) {
            throw new TypeError();
        }
        return nArray;
    }

    public static final boolean getCurrentItemAsBoolean(Cursor cursor2) {
        return cursor2.itemTypedValue().getBoolean(1);
    }

    public static final byte[] getCurrentItemAsBase64Binary(Cursor cursor2) {
        Bytes bytes2 = cursor2.itemTypedValue().getBase64Binary(1);
        int n2 = (int)bytes2.byteLength();
        byte[] byArray = new byte[n2];
        bytes2.writeBytesTo(0, byArray, 0, true);
        return byArray;
    }

    public static final byte[] getCurrentItemAsHexBinary(Cursor cursor2) {
        Bytes bytes2 = cursor2.itemTypedValue().getHexBinary(1);
        int n2 = (int)bytes2.byteLength();
        byte[] byArray = new byte[n2];
        bytes2.writeBytesTo(0, byArray, 0, true);
        return byArray;
    }

    public static final QName getCurrentItemAsQName(Cursor cursor2) {
        return cursor2.itemTypedValue().getQName(1, cursor2.itemNamespaceContext());
    }

    public static final QName getCurrentItemAsNotation(Cursor cursor2) {
        return cursor2.itemTypedValue().getQName(1, cursor2.itemNamespaceContext());
    }

    public static final int getTypeConstant(Cursor cursor2) {
        XSTypeDefinition xSTypeDefinition = cursor2.itemXSType();
        if (xSTypeDefinition != null && 16 == xSTypeDefinition.getTypeCategory()) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
            switch (xSSimpleTypeDefinition.getVariety()) {
                case 3: {
                    return 60;
                }
                case 2: {
                    return 61;
                }
            }
            return RuntimeLibrary.convertType(xSTypeDefinition);
        }
        return 45;
    }

    private static int convertType(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "boolean", (short)3)) {
            return 17;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "double", (short)3)) {
            return 3;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "float", (short)3)) {
            return 2;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "integer", (short)3)) {
            return 5;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "decimal", (short)3)) {
            return 4;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "dayTimeDuration", (short)3)) {
            return 8;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "yearMonthDuration", (short)3)) {
            return 7;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "duration", (short)3)) {
            return 6;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "dateTime", (short)3)) {
            return 9;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "time", (short)3)) {
            return 10;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "date", (short)3)) {
            return 11;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYearMonth", (short)3)) {
            return 12;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYear", (short)3)) {
            return 13;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonthDay", (short)3)) {
            return 14;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gDay", (short)3)) {
            return 15;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonth", (short)3)) {
            return 16;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "hexBinary", (short)3)) {
            return 19;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", (short)3)) {
            return 18;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "anyURI", (short)3)) {
            return 20;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "QName", (short)3)) {
            return 21;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "NOTATION", (short)3)) {
            return 22;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "string", (short)3)) {
            return 1;
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "untypedAtomic", (short)3)) {
            return 0;
        }
        return 46;
    }

    public static Cursor getCurrentItemAsListOrUnion(Cursor cursor2) {
        CData cData = cursor2.itemTypedValue().constant(false);
        Cursor cursor3 = cursor2.factory().sequence(cData, cursor2.profile());
        return cursor3;
    }

    public static Cursor getVariableValue(DynamicContext dynamicContext, QName qName) {
        Cursor cursor2 = dynamicContext.getVariableValue(qName);
        if (cursor2 != null) {
            cursor2 = cursor2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
        }
        return cursor2;
    }

    public static boolean isVariableDefined(DynamicContext dynamicContext, QName qName) {
        return dynamicContext.isVariableBound(qName);
    }

    public static Cursor getCursor(Node node2) {
        if (node2 == null) {
            return null;
        }
        if (node2 instanceof Cursor) {
            Cursor cursor2 = ((Cursor)((Object)node2)).fork(true);
            cursor2.toSelf();
            return cursor2;
        }
        DOMSource dOMSource = new DOMSource(node2);
        SessionContext sessionContext = new SessionContext();
        return sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
    }

    public static final Cursor getCursor(DocumentFragment documentFragment) {
        if (documentFragment == null) {
            return null;
        }
        DOMSource dOMSource = new DOMSource(documentFragment);
        SessionContext sessionContext = new SessionContext();
        return sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
    }

    public static final Cursor getCursor(NodeList nodeList) {
        if (nodeList == null) {
            return null;
        }
        if (nodeList instanceof Cursor) {
            Cursor cursor2 = ((Cursor)((Object)nodeList)).fork(false);
            cursor2.toPosition(1L);
            return cursor2;
        }
        int n2 = nodeList.getLength();
        Cursor cursor3 = null;
        if (n2 > 0) {
            DOMSource dOMSource = new DOMSource(nodeList.item(0));
            SessionContext sessionContext = new SessionContext();
            cursor3 = sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
            for (int i = 1; i < n2; ++i) {
                dOMSource = new DOMSource(nodeList.item(i));
                cursor3 = cursor3.sequenceConcat(sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE)), XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
            }
        }
        return cursor3;
    }

    public static final Cursor getCursor(NodeIterator nodeIterator) {
        if (nodeIterator == null) {
            return null;
        }
        Cursor cursor2 = null;
        Node node2 = nodeIterator.nextNode();
        DOMSource dOMSource = null;
        if (node2 != null) {
            dOMSource = new DOMSource(node2);
            SessionContext sessionContext = new SessionContext();
            cursor2 = sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE));
            node2 = nodeIterator.nextNode();
            while (node2 != null) {
                dOMSource = new DOMSource(node2);
                cursor2 = cursor2.sequenceConcat(sessionContext.document(dOMSource, new RequestInfo(XCIConstruction.FEATURES_FOR_PROTOTYPE)), XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_FOR_PROTOTYPE, false, false, true, true);
                node2 = nodeIterator.nextNode();
            }
        }
        return cursor2;
    }

    public static final Cursor getCursor(Object object2) {
        if (object2 == null) {
            return null;
        }
        SessionContext sessionContext = new SessionContext();
        CursorFactory cursorFactory = sessionContext.getSimpleDataFactory();
        return cursorFactory.sequence(object2);
    }

    private static QName qname_of_string(String string2) {
        QName qName;
        String string3 = "";
        String string4 = "";
        try {
            int n2 = string2.indexOf(":");
            if (n2 == -1) {
                string3 = "";
                string4 = string2;
            } else {
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1);
            }
            String string5 = (String)m_prefixes.get(string3);
            qName = new QName(string5, string4, string3);
        }
        catch (RuntimeException runtimeException) {
            if (!string3.equals("")) {
                throw runtimeException;
            }
            QName qName2 = new QName(string4);
            return null;
        }
        return qName;
    }

    public static XType resolve_TypeQNameF(char[] cArray) {
        QName qName = RuntimeLibrary.qname_of_string(new String(cArray));
        return new SchemaNamedXType(qName);
    }

    public static XType resolve_XNamedTypeQNameF(XSTypeDefinition xSTypeDefinition) {
        try {
            if (xSTypeDefinition != null) {
                Object object2;
                String string2 = xSTypeDefinition.getName();
                if (null == string2 && xSTypeDefinition instanceof TypeInfo) {
                    object2 = (TypeInfo)((Object)xSTypeDefinition);
                    string2 = object2.getTypeName();
                }
                object2 = RuntimeLibrary.qname_of_string(string2);
                return new SchemaNamedXType((QName)object2, (Object)xSTypeDefinition);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static char cursorToChar(Cursor cursor2) {
        if (cursor2 == null) {
            return '\u0000';
        }
        VolatileCData volatileCData = cursor2.itemTypedValue();
        if (cursor2.itemIsAtomic()) {
            XSTypeDefinition xSTypeDefinition = cursor2.itemXSType();
            if (xSTypeDefinition == TypeRegistry.XSDOUBLE || xSTypeDefinition == TypeRegistry.XSDECIMAL || xSTypeDefinition == TypeRegistry.XSINTEGER) {
                return (char)volatileCData.getDouble(1);
            }
            String string2 = volatileCData.isEmptySequence() ? "" : volatileCData.getString(1);
            return string2.charAt(0);
        }
        String string3 = volatileCData.isEmptySequence() ? "" : volatileCData.getString(1);
        try {
            return (char)Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return string3.charAt(0);
        }
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setPatternSeparator(';');
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setZeroDigit('0');
        DEC_NOTATION = new DecimalFormat("0.####################", decimalFormatSymbols);
        DOUBLE_FORMATER = new DecimalFormat("0.0#################E0", decimalFormatSymbols);
        EMPTY_NAMESPACE_TABLE = new int[0];
        m_prefixes = new HashMap();
        m_prefixes.put("xs", "http://www.w3.org/2001/XMLSchema");
        m_prefixes.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }
}

