/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.output.ResultDocumentResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class ResultDocumentManager {
    private final ResultDocumentResolver m_resultResolver;
    private final Result m_primary_result;
    private final ErrorHandler m_err_handler;
    private Map<String, Result> m_redirect_results;
    private Set<String> m_redirect_written;
    private Set<String> m_referenced_hrefs;

    ResultDocumentManager(ErrorHandler errorHandler, ResultDocumentResolver resultDocumentResolver, Result result2) {
        this.m_resultResolver = resultDocumentResolver;
        this.m_primary_result = result2;
        this.m_err_handler = errorHandler;
    }

    public void openRedirect(String string2, String string3, boolean bl) {
        Result result2 = this.getRedirectResult(string2, string3, bl);
        this.addRedirectResult(string3, result2);
    }

    public Result getRedirectResult(String string2, String string3, boolean bl) {
        this.checkURL(string3);
        Result result2 = this.m_resultResolver.getResultDocument(string2, string3, bl);
        this.checkResult(result2, string2, string3);
        return result2;
    }

    public Result lookupRedirectResult(String string2) {
        Result result2 = null;
        if (this.m_redirect_results != null) {
            result2 = this.m_redirect_results.get(string2);
        }
        return result2;
    }

    public void setRedirectWritten(String string2) {
        if (this.m_redirect_written == null) {
            this.m_redirect_written = new HashSet<String>();
        }
        this.m_redirect_written.add(string2);
    }

    public boolean isRedirectWritten(String string2) {
        if (this.m_redirect_written != null) {
            return this.m_redirect_written.contains(string2);
        }
        return false;
    }

    public void closeRedirect(String string2) {
        if (this.m_redirect_results != null) {
            this.m_redirect_results.remove(string2);
        }
        if (this.m_redirect_written != null) {
            this.m_redirect_written.remove(string2);
        }
    }

    private void addRedirectResult(String string2, Result result2) {
        if (this.m_redirect_results == null) {
            this.m_redirect_results = new HashMap<String, Result>();
        }
        this.m_redirect_results.put(string2, result2);
    }

    public Result getResultDocument(String string2, String string3, boolean bl) {
        if (!string3.equals("")) {
            this.checkURL(string3);
        }
        Result result2 = null;
        if ("".equals(string3) && this.m_primary_result != null) {
            result2 = this.m_primary_result;
        } else {
            result2 = this.m_resultResolver.getResultDocument(string2, string3);
            this.checkResult(result2, string2, string3);
        }
        if (!bl) {
            this.addReference(string3);
        }
        return result2;
    }

    public boolean hasPredefinedPrimaryResult() {
        return this.m_primary_result != null;
    }

    public boolean isReferenced(String string2) {
        if (this.m_referenced_hrefs != null) {
            return this.m_referenced_hrefs.contains(string2);
        }
        return false;
    }

    public boolean hadResultDocumentReferences() {
        return this.m_referenced_hrefs != null && this.m_referenced_hrefs.size() > 0;
    }

    public void addReference(String string2) {
        if (this.m_referenced_hrefs == null) {
            this.m_referenced_hrefs = new HashSet<String>();
        }
        this.m_referenced_hrefs.add(string2);
    }

    private void checkResult(Result result2, String string2, String string3) {
        SAXResult sAXResult;
        if (result2 != this.m_primary_result && result2 instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result2;
            if (streamResult.getOutputStream() == null && streamResult.getWriter() == null && (result2.getSystemId() == null || result2.getSystemId().length() == 0)) {
                String string4 = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTSTREAM_BAD", new Object[]{string3, string2});
                this.m_err_handler.report(3, string4, null, null, true);
            }
        } else if (result2 instanceof DOMResult) {
            boolean bl = false;
            DOMResult dOMResult = (DOMResult)result2;
            Node node2 = dOMResult.getNode();
            if (node2 == null) {
                bl = true;
            } else {
                short s = node2.getNodeType();
                switch (s) {
                    case 1: 
                    case 9: 
                    case 11: {
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
            }
            if (bl) {
                String string5 = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTDOM_BAD", new Object[]{string3, string2});
                this.m_err_handler.report(3, string5, null, null, true);
            }
        } else if (result2 instanceof SAXResult && (sAXResult = (SAXResult)result2).getHandler() == null) {
            String string6 = XMLMessages.createXMLMessage("ER_RES_DOC_RESULTSAX_BAD", new Object[]{string3, string2});
            this.m_err_handler.report(3, string6, null, null, true);
        }
    }

    private void checkURL(String string2) {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null && !ResultDocumentResolver.isCommonURL(string2)) {
            String string3 = XMLMessages.createXMLMessage("ER_RES_DOC_HREF_PROTOCOL_BAD", new Object[]{string2});
            this.m_err_handler.report(3, string3, null, null, true);
        }
    }
}

