/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class NumberFormatInt {
    private static final String DIGITS = "0123456789";
    private static final char CJK_IDEOGRAPH_FIRST = '\u4e00';
    private static final String KANJI_DIGITS = "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
    private static final char LATIN_CAPITAL_LETTER_A = 'A';
    private static final String ENGLISH_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char LATIN_SMALL_LETTER_A = 'a';
    private static final String ENGLISH_LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final char GREEK_CAPITAL_LETTER_ALPHA = '\u0391';
    private static final String GREEK_UPPER = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    private static final char GREEK_SMALL_LETTER_ALPHA = '\u03b1';
    private static final String GREEK_LOWER = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    private static final char CYRILLIC_CAPITAL_LETTER_A = '\u0410';
    private static final String RUSSIAN_UPPER = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    private static final char CYRILLIC_SMALL_LETTER_A = '\u0430';
    private static final String RUSSIAN_LOWER = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    private static final char HEBREW_LETTER_ALEF = '\u05d0';
    private static final String HEBREW = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    private static final char HIRAGANA_LETTER_A = '\u3042';
    private static final String HIRAGANA_A = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    private static final char KATAKANA_LETTER_A = '\u30a2';
    private static final String KATAKANA_A = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    private static final char HIRAGANA_LETTER_I = '\u3044';
    private static final String HIRAGANA_I = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    private static final char KATAKANA_LETTER_I = '\u30a4';
    private static final String KATAKANA_I = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    private static final String[] ROMAN_THOUSANDS = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static final String[] ROMAN_HUNDREDS = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static final String[] ROMAN_TENS = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static final String[] ROMAN_ONES = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static final Hashtable ordinalTable = new Hashtable();
    public static final String DEFAULT_FORMAT = "1";
    public static final String DEFAULT_LANG = "en-US";
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US", "");
    public static final String DEFAULT_LETTERVALUE = "alphabetic";
    public static final String DEFAULT_GROUPSEP = ",";
    public static final int DEFAULT_GROUPSIZE = 3;
    public static final String DEFAULT_ORDINAL = "no";
    private final NumberFormatFactoryRuleBased _factory;
    private final StringUtility _sUtil;
    private Locale[] m_Locales;
    private ArrayList m_LocaleNames;

    public static NumberFormatInt getInstance() {
        return new NumberFormatInt(NumberFormatFactoryRuleBased.getInstance());
    }

    public NumberFormatInt(NumberFormatFactoryRuleBased numberFormatFactoryRuleBased) {
        this._factory = numberFormatFactoryRuleBased;
        this._sUtil = numberFormatFactoryRuleBased != null ? new ICUStringUtility() : new StringUtility();
    }

    public final String formatValue(long l, String string2, int n2, String string3, String string4, String string5, String string6) {
        if (l == 0L && l < 0L) {
            return "" + -l;
        }
        if (string6.equals("yes")) {
            NumberFormatInt.initializeOrdinalHashtable();
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string2.charAt(0);
        switch (c) {
            case '0': 
            case '1': {
                stringBuffer.append(this.digitValue(l, DIGITS, string2, n2, string3, string5, string6));
                break;
            }
            case '\u4e00': {
                stringBuffer.append(this.digitValue(l, KANJI_DIGITS, string2, n2, string3, string5, string6));
                break;
            }
            case 'i': {
                stringBuffer.append(NumberFormatInt.romanValue(l));
                break;
            }
            case 'I': {
                stringBuffer.append(NumberFormatInt.romanValue(l).toUpperCase());
                break;
            }
            case 'N': 
            case 'W': 
            case 'n': 
            case 'w': {
                stringBuffer.append(this.spellValue(l, string2, n2, string3, string5, string6));
                break;
            }
            case 'A': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, ENGLISH_UPPER);
                break;
            }
            case 'a': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, ENGLISH_LOWER);
                break;
            }
            case '\u0391': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, GREEK_UPPER);
                break;
            }
            case '\u03b1': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, GREEK_LOWER);
                break;
            }
            case '\u0410': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, RUSSIAN_UPPER);
                break;
            }
            case '\u0430': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, RUSSIAN_LOWER);
                break;
            }
            case '\u05d0': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, HEBREW);
                break;
            }
            case '\u3042': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, HIRAGANA_A);
                break;
            }
            case '\u30a2': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, KATAKANA_A);
                break;
            }
            case '\u3044': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, HIRAGANA_I);
                break;
            }
            case '\u30a4': {
                NumberFormatInt.alphaValue(stringBuffer, l, 0, KATAKANA_I);
                break;
            }
            default: {
                if (string5 == null || string5.equals("en") || string5.startsWith("en_")) {
                    if ('A' <= c && c <= 'Z') {
                        int n3 = c - 65;
                        NumberFormatInt.alphaValue(stringBuffer, l, n3, ENGLISH_UPPER);
                        break;
                    }
                    if ('a' <= c && c <= 'z') {
                        int n4 = c - 97;
                        NumberFormatInt.alphaValue(stringBuffer, l, n4, ENGLISH_LOWER);
                        break;
                    }
                }
                stringBuffer.append(this.digitValue(l, DIGITS, DEFAULT_FORMAT, n2, string3, string5, string6));
            }
        }
        return stringBuffer.toString();
    }

    private final String spellValue(long l, String string2, int n2, String string3, String string4, String string5) {
        if (this._factory != null) {
            Locale locale = this.getLocale(string4);
            String string6 = ((ICUStringUtility)this._sUtil).spellNumber(l, string2, this._factory, locale, string5);
            if (string6 != null) {
                return string6;
            }
        } else {
            Locale locale = this.getLocale(string4);
            String string7 = this._sUtil.spellNumber(l, string2, this._factory, locale, string5);
            if (string7 != null) {
                return string7;
            }
        }
        return this.digitValue(l, DIGITS, DEFAULT_FORMAT, n2, string3, string4, string5);
    }

    private static final StringBuffer alphaValue(StringBuffer stringBuffer, long l, int n2, String string2) {
        if (l <= 0L) {
            return stringBuffer.append("" + l);
        }
        int n3 = string2.length() - n2;
        char c = string2.charAt(n2 + (int)((l - 1L) % (long)n3));
        if (l > (long)n3) {
            return NumberFormatInt.alphaValue(stringBuffer, (l - 1L) / (long)n3, n2, string2).append(c);
        }
        return stringBuffer.append("" + c);
    }

    private final String digitValue(long l, String string2, String string3, int n2, String string4, String string5, String string6) {
        int n3;
        Object object2;
        CharSequence charSequence;
        if (this._factory != null && string6 != null && string6.equals("yes") && (charSequence = ((ICUStringUtility)this._sUtil).ordinalNumber(l, this._factory, (Locale)(object2 = this.getLocale(string5)))) != null) {
            return charSequence;
        }
        object2 = new StringBuffer();
        charSequence = new StringBuffer();
        int n4 = string2.length();
        String string7 = "";
        for (long i = l; i > 0L; i /= (long)n4) {
            string7 = string2.charAt((int)(i % (long)n4)) + string7;
        }
        for (n3 = 0; n3 < string3.length() - string7.length(); ++n3) {
            ((StringBuffer)charSequence).append(string2.charAt(0));
        }
        ((StringBuffer)charSequence).append(string7);
        if (n2 > 0) {
            for (n3 = 0; n3 < ((StringBuffer)charSequence).length(); ++n3) {
                if (n3 != 0 && (((StringBuffer)charSequence).length() - n3) % n2 == 0) {
                    ((StringBuffer)object2).append(string4);
                }
                ((StringBuffer)object2).append(((StringBuffer)charSequence).charAt(n3));
            }
        } else {
            object2 = charSequence;
        }
        return ((StringBuffer)object2).toString();
    }

    private static String romanValue(long l) {
        if (l <= 0L || l > 9999L) {
            return "" + l;
        }
        return ROMAN_THOUSANDS[(int)l / 1000] + ROMAN_HUNDREDS[(int)l / 100 % 10] + ROMAN_TENS[(int)l / 10 % 10] + ROMAN_ONES[(int)l % 10];
    }

    private final Locale getLocale(String string2) {
        Locale locale;
        if (string2 == null || string2.length() == 0) {
            locale = DEFAULT_LOCALE;
        } else {
            if (this.m_Locales == null) {
                Locale[] localeArray = this._factory != null ? this._factory.getAvailableLocales() : NumberFormat.getAvailableLocales();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < localeArray.length; ++i) {
                    arrayList.add(localeArray[i].toString());
                }
                this.m_Locales = localeArray;
                this.m_LocaleNames = arrayList;
            }
            locale = LocaleUtility.IETFToValidLocale(string2, this.m_Locales, this.m_LocaleNames);
        }
        return locale;
    }

    private static String lowerCaseASingleWord(String string2, String string3, String string4) {
        if (string2.indexOf(string3) < 0) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = stringTokenizer.hasMoreTokens();
        while (bl) {
            String string5 = stringTokenizer.nextToken();
            if (string5.equals(string3)) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string5);
            }
            if (!(bl = stringTokenizer.hasMoreTokens())) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String applyPresentationModifier(String string2, String string3, Locale locale) {
        if (string2.equals("w") || string2.equals("n")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toLowerCase(locale, string3);
            }
            return this._sUtil.toLowerCase(locale, string3);
        }
        if (string2.equals("W") || string2.equals("N")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toUpperCase(locale, string3);
            }
            return this._sUtil.toUpperCase(locale, string3);
        }
        if (string2.equals("Ww") || string2.equals("Nn")) {
            if (this._factory != null) {
                return ((ICUStringUtility)this._sUtil).toTitleCase(locale, string3);
            }
            return this._sUtil.toTitleCase(locale, string3);
        }
        return null;
    }

    private static void initializeOrdinalHashtable() {
        ordinalTable.put("one", "first");
        ordinalTable.put("two", "second");
        ordinalTable.put("three", "third");
        ordinalTable.put("four", "fourth");
        ordinalTable.put("five", "fifth");
        ordinalTable.put("six", "sixth");
        ordinalTable.put("seven", "seventh");
        ordinalTable.put("eight", "eighth");
        ordinalTable.put("nine", "ninth");
        ordinalTable.put("ten", "tenth");
        ordinalTable.put("eleven", "eleventh");
        ordinalTable.put("twelve", "twelfth");
        ordinalTable.put("thirteen", "thirteenth");
        ordinalTable.put("fourteen", "fourteenth");
        ordinalTable.put("fifteen", "fifteenth");
        ordinalTable.put("sixteen", "sixteenth");
        ordinalTable.put("seventeen", "seventeenth");
        ordinalTable.put("eighteen", "eighteenth");
        ordinalTable.put("nineteen", "nineteenth");
        ordinalTable.put("twenty", "twentieth");
        ordinalTable.put("thirty", "thirtieth");
        ordinalTable.put("forty", "fortieth");
        ordinalTable.put("fifty", "fiftieth");
        ordinalTable.put("sixty", "sixtieth");
        ordinalTable.put("seventy", "seventieth");
        ordinalTable.put("eighty", "eightieth");
        ordinalTable.put("ninety", "ninetieth");
        ordinalTable.put("hundred", "hundredth");
        ordinalTable.put("thousand", "thousandth");
        ordinalTable.put("million", "millionth");
    }

    private static class StringUtility {
        private StringUtility() {
        }

        private String spellNumber(long l, String string2, NumberFormatFactoryRuleBased numberFormatFactoryRuleBased, Locale locale, String string3) {
            String string4 = new NumberSpeller().spellNumber((int)l);
            if (locale.equals(Locale.ENGLISH)) {
                string4 = string4.replace('-', ' ');
                if (string3.equals("yes")) {
                    int n2 = string4.lastIndexOf(" ");
                    if (n2 == -1) {
                        string4 = (String)ordinalTable.get(string4);
                    } else {
                        String string5 = (String)ordinalTable.get(string4.substring(n2 + 1));
                        string4 = string4.substring(0, n2 + 1) + string5;
                    }
                    if (string2.endsWith("o")) {
                        string2 = string2.substring(0, string2.indexOf("o"));
                    }
                }
            }
            if (string2.equals("w") || string2.equals("n")) {
                return this.toLowerCase(locale, string4);
            }
            if (string2.equals("W") || string2.equals("N")) {
                return this.toUpperCase(locale, string4);
            }
            if (string2.equals("Ww") || string2.equals("Nn")) {
                String string6 = this.toTitleCase(locale, string4);
                return NumberFormatInt.lowerCaseASingleWord(string6, "And", "and");
            }
            return null;
        }

        private String ordinalNumber(long l, NumberFormatFactoryRuleBased numberFormatFactoryRuleBased, Locale locale) {
            return null;
        }

        private String toUpperCase(Locale locale, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            return string2.toUpperCase(locale);
        }

        private String toLowerCase(Locale locale, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            return string2.toLowerCase(locale);
        }

        private String toTitleCase(Locale locale, String string2) {
            return this.toTitleCase(string2);
        }

        private final String toTitleCase(String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n2 = stringBuffer.length();
            char c = stringBuffer.charAt(0);
            if (Character.isLetter(c) && !Character.isTitleCase(c)) {
                stringBuffer.setCharAt(0, Character.toTitleCase(c));
            }
            char c2 = c;
            char c3 = ' ';
            for (int i = 1; i < n2; ++i) {
                c2 = stringBuffer.charAt(i);
                c3 = stringBuffer.charAt(i - 1);
                if (!Character.isWhitespace(c3) || !Character.isLetter(c2) || Character.isTitleCase(c2)) continue;
                stringBuffer.setCharAt(i, Character.toTitleCase(c2));
            }
            return stringBuffer.toString();
        }
    }

    private static class NumberSpeller {
        private final String[] singles = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        private final String[] tens = new String[]{"", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};

        private NumberSpeller() {
        }

        private String spellNumber(int n2) {
            String string2;
            if (n2 < 100) {
                string2 = this.getLessThanHundered(n2);
            } else if (n2 < 1000) {
                string2 = this.getLessThanThousand(n2);
            } else {
                string2 = this.singles[n2 / 1000] + " thousand";
                int n3 = n2 % 1000;
                if (n3 != 0) {
                    string2 = string2 + " " + this.getLessThanThousand(n3);
                }
            }
            return string2;
        }

        private String getLessThanHundered(int n2) {
            if (n2 < 20) {
                return this.singles[n2];
            }
            return this.tens[n2 / 10] + " " + this.singles[n2 % 10];
        }

        private String getLessThanThousand(int n2) {
            String string2 = this.singles[n2 / 100] + " hundred";
            int n3 = n2 % 100;
            if (n3 != 0) {
                string2 = string2 + " and " + this.getLessThanHundered(n3);
            }
            return string2;
        }
    }

    private static class ICUStringUtility
    extends StringUtility {
        private ICUStringUtility() {
        }

        private final String spellNumber(long l, String string2, NumberFormatFactoryRuleBased numberFormatFactoryRuleBased, Locale locale, String string3) {
            RuleBasedNumberFormat ruleBasedNumberFormat = numberFormatFactoryRuleBased.getFormatInstance(locale, 1);
            Long l2 = new Long(l);
            String string4 = l2.toString();
            try {
                string4 = ruleBasedNumberFormat.format((Object)l2);
            }
            catch (Throwable throwable) {
                return null;
            }
            if (string4.equals(l2.toString())) {
                return null;
            }
            if (locale.equals(Locale.ENGLISH)) {
                string4 = string4.replace('-', ' ');
                if (string3.equals("yes")) {
                    int n2 = string4.lastIndexOf(" ");
                    if (n2 == -1) {
                        string4 = (String)ordinalTable.get(string4);
                    } else {
                        String string5 = (String)ordinalTable.get(string4.substring(n2 + 1));
                        string4 = string4.substring(0, n2 + 1) + string5;
                    }
                    if (string2.endsWith("o")) {
                        string2 = string2.substring(0, string2.indexOf("o"));
                    }
                }
            }
            if (string2.equals("w") || string2.equals("n")) {
                return this.toLowerCase(locale, string4);
            }
            if (string2.equals("W") || string2.equals("N")) {
                return this.toUpperCase(locale, string4);
            }
            if (string2.equals("Ww") || string2.equals("Nn")) {
                return NumberFormatInt.lowerCaseASingleWord(this.toTitleCase(locale, string4), "And", "and");
            }
            return null;
        }

        private final String ordinalNumber(long l, NumberFormatFactoryRuleBased numberFormatFactoryRuleBased, Locale locale) {
            RuleBasedNumberFormat ruleBasedNumberFormat = numberFormatFactoryRuleBased.getFormatInstance(locale, 2);
            Long l2 = new Long(l);
            String string2 = l2.toString();
            try {
                string2 = ruleBasedNumberFormat.format((Object)l2);
                if (string2.indexOf(44) >= 0) {
                    int n2 = string2.length();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n2; ++i) {
                        char c = string2.charAt(i);
                        if (c == ',') continue;
                        stringBuffer.append(c);
                    }
                    string2 = stringBuffer.toString();
                }
            }
            catch (Throwable throwable) {
                return null;
            }
            if (string2.equals(l2.toString())) {
                return null;
            }
            return string2;
        }

        private final String toUpperCase(Locale locale, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            return UCharacter.toUpperCase((Locale)locale, (String)string2);
        }

        private final String toLowerCase(Locale locale, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            return UCharacter.toLowerCase((Locale)locale, (String)string2);
        }

        private final String toTitleCase(Locale locale, String string2) {
            if (string2 == null || string2.length() == 0) {
                return string2;
            }
            return UCharacter.toTitleCase((Locale)locale, (String)string2, null);
        }
    }
}

