/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.runtime;

import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatFactoryRuleBased;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.NumberFormatInt;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.v2.BasisLibrary2;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormatFunctionsLibrary {
    private static final String EMPTYSTRING = "";
    private static final String COMMA = ",";
    private static final String STAR = "*";
    private static final String DASH = "-";
    private static final String ZERO = "0";
    private boolean isTimeZoneSpecified = false;
    private boolean defaultCalendarFallBack = false;
    private boolean defaultLanguageFallBack = false;
    private static Map<Locale, GenericDateFormatSymbols> cachedSymbols = new ConcurrentHashMap<Locale, GenericDateFormatSymbols>();
    private final NumberFormatFactoryRuleBased s_ICUNumberFormatFactory = NumberFormatFactoryRuleBased.getInstance();
    private NumberFormatInt numberFormatInt = new NumberFormatInt(this.s_ICUNumberFormatFactory);

    public char[] formatDateTime(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]) - 1;
        int n4 = Integer.parseInt(stringArray[2]);
        int n5 = Integer.parseInt(stringArray[3]);
        int n6 = Integer.parseInt(stringArray[4]);
        int n7 = this.getSeconds(stringArray[5]);
        int n8 = this.getMillieconds(stringArray[5]);
        String string2 = stringArray[6];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string2, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(1, n2);
        genericCalendar.set(2, n3);
        genericCalendar.set(5, n4);
        genericCalendar.set(11, n5);
        genericCalendar.set(12, n6);
        genericCalendar.set(13, n7);
        genericCalendar.set(14, n8);
        StringBuffer stringBuffer = new StringBuffer();
        int n9 = cArray.length;
        block4: for (int i = 0; i < n9; ++i) {
            switch (cArray[i]) {
                case '[': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char c = cArray[++i];
                    if (c == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n9 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string3 = stringBuffer2.toString();
                    if (string3.length() <= 0) continue block4;
                    if (this.isPictureValid(string3)) {
                        stringBuffer.append(this.formatDateTimeVariableMarker(string3, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string3);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n9) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    private int getRawOffSetFromTimeZone(String string2) {
        int n2 = string2.indexOf("PT");
        int n3 = string2.indexOf("H");
        int n4 = string2.indexOf("M");
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n3 != -1 || n4 != -1) {
            if (n3 == -1) {
                n6 = Integer.parseInt(string2.substring(n2 + 2, n4));
            } else if (n4 == -1) {
                n5 = Integer.parseInt(string2.substring(n2 + 2, n3));
            } else {
                n5 = Integer.parseInt(string2.substring(n2 + 2, n3));
                n6 = Integer.parseInt(string2.substring(n3 + 1, n4));
            }
        }
        n7 = (n5 * 60 + n6) * 60 * 1000;
        if (string2.startsWith(DASH)) {
            n7 *= -1;
        }
        return n7;
    }

    private String getTimeFromOffset(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            return EMPTYSTRING;
        }
        if (n2 < 0) {
            stringBuffer.append(DASH);
            n2 *= -1;
        } else {
            stringBuffer.append("+");
        }
        int n3 = n2 / 60 / 1000;
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        if (n4 < 10) {
            stringBuffer.append(ZERO + String.valueOf(n4));
        } else {
            stringBuffer.append(String.valueOf(n4));
        }
        if (n5 < 10) {
            stringBuffer.append(":0" + String.valueOf(n5));
        } else {
            stringBuffer.append(":" + String.valueOf(n5));
        }
        return stringBuffer.toString();
    }

    private String applyPresentationModifier(String string2, String string3, NumberFormatInt numberFormatInt, Locale locale) {
        return numberFormatInt.applyPresentationModifier(string2, string3, locale);
    }

    private String formatYear(int n2, String string2, boolean bl, Locale locale) {
        String string3 = this.getModifier(string2, bl);
        String string4 = this.formatValueHelper(n2, string3, locale);
        if (bl) {
            string4 = this.adjustWidthForYear(string4, string2);
        }
        return string4;
    }

    private String formatMonth(int n2, String string2, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string3 = this.getModifier(string2, bl);
        int n3 = -1;
        int n4 = -1;
        if (bl && (n3 = this.getMinimumWidth(string2)) > (n4 = this.getMaximumWidth(string2))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (string3.startsWith("N") || string3.startsWith("n")) {
            String string4 = genericDateFormatSymbols.getMonths()[n2];
            int n5 = string4.length();
            if (bl && n4 != -1 && n5 > n4) {
                string4 = genericDateFormatSymbols.getShortMonths()[n2];
            }
            String string5 = this.applyPresentationModifier(string3, string4, this.numberFormatInt, locale);
            return string5;
        }
        String string6 = this.formatValueHelper(n2 + 1, string3, locale);
        if (bl) {
            string6 = this.adjustWidthForValue(string6, n3, n4);
        }
        return string6;
    }

    private String formatDateTimeVariableMarker(String string2, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string2);
        char c = string2.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'Y': {
                stringBuffer.append(this.formatYear(genericCalendar.get(1), string2, bl, locale));
                break;
            }
            case 'M': {
                stringBuffer.append(this.formatMonth(genericCalendar.get(2), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'D': {
                stringBuffer.append(this.formatValue(genericCalendar.get(5), string2, locale));
                break;
            }
            case 'd': {
                stringBuffer.append(this.formatValue(genericCalendar.get(6), string2, locale));
                break;
            }
            case 'F': {
                stringBuffer.append(this.formatDayOfWeek(genericCalendar.get(7), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'W': {
                stringBuffer.append(this.formatValue(genericCalendar.get(3), string2, locale));
                break;
            }
            case 'w': {
                stringBuffer.append(this.formatValue(genericCalendar.get(4), string2, locale));
                break;
            }
            case 'H': {
                stringBuffer.append(this.formatValue(genericCalendar.get(11), string2, locale));
                break;
            }
            case 'h': {
                int n2 = genericCalendar.get(10);
                if (n2 == 0) {
                    n2 = 12;
                }
                stringBuffer.append(this.formatValue(n2, string2, locale));
                break;
            }
            case 'P': {
                stringBuffer.append(this.formatAMPM(genericCalendar.get(9), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'm': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(12), string2, locale));
                break;
            }
            case 's': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(13), string2, locale));
                break;
            }
            case 'f': {
                stringBuffer.append(this.formatMillisecondValue(genericCalendar.get(14), string2, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String string3 = this.getTimeFromOffset(genericCalendar.get(15));
                String string4 = this.getModifier(string2, bl);
                if (string4.equals(EMPTYSTRING)) {
                    if (string3.equals(EMPTYSTRING)) {
                        string3 = "Z";
                    }
                } else if (string3.equals(EMPTYSTRING)) {
                    string3 = "GMT";
                }
                stringBuffer.append(string3);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private String formatDateVariableMarker(String string2, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string2);
        char c = string2.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'Y': {
                stringBuffer.append(this.formatYear(genericCalendar.get(1), string2, bl, locale));
                break;
            }
            case 'M': {
                stringBuffer.append(this.formatMonth(genericCalendar.get(2), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'D': {
                stringBuffer.append(this.formatValue(genericCalendar.get(5), string2, locale));
                break;
            }
            case 'd': {
                stringBuffer.append(this.formatValue(genericCalendar.get(6), string2, locale));
                break;
            }
            case 'F': {
                stringBuffer.append(this.formatDayOfWeek(genericCalendar.get(7), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'W': {
                stringBuffer.append(this.formatValue(genericCalendar.get(3), string2, locale));
                break;
            }
            case 'w': {
                stringBuffer.append(this.formatValue(genericCalendar.get(4), string2, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append(this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_DATE_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private String formatDayOfWeek(int n2, String string2, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string3 = this.getModifier(string2, bl);
        int n3 = -1;
        int n4 = -1;
        if (bl && (n3 = this.getMinimumWidth(string2)) > (n4 = this.getMaximumWidth(string2))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if (string3.startsWith("N") || string3.startsWith("n")) {
            String string4 = genericDateFormatSymbols.getWeekdays()[n2];
            int n5 = string4.length();
            if (bl && n4 != -1 && n5 > n4) {
                string4 = genericDateFormatSymbols.getShortWeekdays()[n2];
            }
            String string5 = this.applyPresentationModifier(string3, string4, this.numberFormatInt, locale);
            return string5;
        }
        String string6 = this.formatValueHelper(n2, string3, locale);
        if (bl) {
            string6 = this.adjustWidthForValue(string6, n3, n4);
        }
        return string6;
    }

    private String formatAMPM(int n2, String string2, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        String string3 = this.getModifier(string2, bl);
        if (string3.equals(EMPTYSTRING) && !bl) {
            string3 = "n";
        }
        String string4 = this.numberFormatInt.applyPresentationModifier(string3, genericDateFormatSymbols.getAmPmStrings()[n2], locale);
        return string4;
    }

    private String formatTimeValue(int n2, String string2, Locale locale) {
        boolean bl = this.isWidthSpecified(string2);
        String string3 = this.getModifier(string2, bl);
        if (string3.equals(EMPTYSTRING)) {
            string3 = "01";
        }
        String string4 = this.formatValueHelper(n2, string3, locale);
        if (bl) {
            string4 = this.adjustWidth(string4, string2);
        }
        return string4;
    }

    private String formatMillisecondValue(int n2, String string2, Locale locale) {
        String string3;
        boolean bl = this.isWidthSpecified(string2);
        String string4 = this.getModifier(string2, bl);
        if (bl) {
            int n3;
            int n4 = this.getMinimumWidth(string2);
            int n5 = this.getMaximumWidth(string2);
            if (string4.equals(EMPTYSTRING) || !this.containsLetter(string4)) {
                string4 = "001";
            }
            if ((n3 = (string3 = this.formatValueHelper(n2, string4, locale)).length()) > n5) {
                string3 = string3.substring(0, n5);
            } else if (n3 < n4 && !this.containsLetter(string3)) {
                StringBuffer stringBuffer = new StringBuffer();
                int n6 = n4 - n3;
                for (int i = 0; i < n6; ++i) {
                    stringBuffer.append('0');
                }
                string3 = string3 + stringBuffer.toString();
            }
        } else if (string4.equals(EMPTYSTRING)) {
            string3 = this.formatValueHelper(n2, "001", locale);
        } else if (!this.containsLetter(string4)) {
            string3 = this.formatValueHelper(n2, "001", locale);
            int n7 = string4.length();
            if (n7 > 3) {
                StringBuffer stringBuffer = new StringBuffer();
                int n8 = n7 - 3;
                for (int i = 0; i < n8; ++i) {
                    stringBuffer.append('0');
                }
                string3 = string3 + stringBuffer.toString();
            } else if (n7 < 3) {
                string3 = string3.substring(0, n7);
            }
        } else {
            string3 = this.formatValueHelper(n2, string4, locale);
        }
        return string3;
    }

    private String formatValue(int n2, String string2, Locale locale) {
        boolean bl = this.isWidthSpecified(string2);
        String string3 = this.getModifier(string2, bl);
        String string4 = this.formatValueHelper(n2, string3, locale);
        if (bl) {
            string4 = this.adjustWidth(string4, string2);
        }
        return string4;
    }

    private String formatValueHelper(int n2, String string2, Locale locale) {
        String string3 = string2.equals(EMPTYSTRING) ? String.valueOf(n2) : (string2.endsWith("o") ? this.numberFormatInt.formatValue(n2, string2, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), "yes") : this.numberFormatInt.formatValue(n2, string2, 1, EMPTYSTRING, EMPTYSTRING, locale.getLanguage(), EMPTYSTRING));
        return string3;
    }

    private String formatEras(int n2, String string2, boolean bl, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        return genericDateFormatSymbols.getEras()[n2];
    }

    public char[] formatDate(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]) - 1;
        int n4 = Integer.parseInt(stringArray[2]);
        String string2 = stringArray[3];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string2, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(1, n2);
        genericCalendar.set(2, n3);
        genericCalendar.set(5, n4);
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = cArray.length;
        block4: for (int i = 0; i < n5; ++i) {
            switch (cArray[i]) {
                case '[': {
                    char c;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if (++i == n5) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", "[");
                    }
                    if ((c = cArray[i]) == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n5 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string3 = stringBuffer2.toString();
                    if (string3.length() <= 0) continue block4;
                    if (this.isPictureValid(string3)) {
                        stringBuffer.append(this.formatDateVariableMarker(string3, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string3);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n5) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    public char[] formatTime(String[] stringArray, char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4) {
        Locale locale;
        int n2 = Integer.parseInt(stringArray[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = this.getSeconds(stringArray[2]);
        int n5 = this.getMillieconds(stringArray[2]);
        String string2 = stringArray[3];
        if (cArray2.length == 0) {
            locale = Locale.getDefault();
        } else if (!this.isLanguageSupported(String.valueOf(cArray2))) {
            this.defaultLanguageFallBack = true;
            locale = Locale.getDefault();
        } else {
            locale = new Locale(String.valueOf(cArray2), String.valueOf(cArray4));
        }
        GenericCalendar genericCalendar = this.getCalendar(String.valueOf(cArray3), string2, locale);
        GenericDateFormatSymbols genericDateFormatSymbols = this.getDateFormatSymbols(locale);
        genericCalendar.set(11, n2);
        genericCalendar.set(12, n3);
        genericCalendar.set(13, n4);
        genericCalendar.set(14, n5);
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = cArray.length;
        block4: for (int i = 0; i < n6; ++i) {
            switch (cArray[i]) {
                case '[': {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    char c = cArray[++i];
                    if (c == '[') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    while (i < n6 && (c = cArray[i]) != ']') {
                        if (!Character.isWhitespace(c)) {
                            stringBuffer2.append(cArray[i]);
                        }
                        ++i;
                    }
                    String string3 = stringBuffer2.toString();
                    if (string3.length() <= 0) continue block4;
                    if (this.isPictureValid(string3)) {
                        stringBuffer.append(this.formatTimeVariableMarker(string3, genericCalendar, genericDateFormatSymbols, locale));
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_PICTURE", string3);
                    continue block4;
                }
                case ']': {
                    char c;
                    if (++i == n6) {
                        BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    }
                    if ((c = cArray[i]) == ']') {
                        stringBuffer.append(c);
                        continue block4;
                    }
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_SQUARE_BRACKET_ERR", "]");
                    continue block4;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (this.defaultLanguageFallBack) {
            stringBuffer.insert(0, "[Language: " + locale.getLanguage() + "]");
        }
        if (this.defaultCalendarFallBack) {
            stringBuffer.insert(0, "[Calendar: AD]");
        }
        return stringBuffer.toString().toCharArray();
    }

    private String formatTimeVariableMarker(String string2, GenericCalendar genericCalendar, GenericDateFormatSymbols genericDateFormatSymbols, Locale locale) {
        boolean bl = this.isWidthSpecified(string2);
        char c = string2.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        switch (c) {
            case 'H': {
                stringBuffer.append(this.formatValue(genericCalendar.get(11), string2, locale));
                break;
            }
            case 'h': {
                int n2 = genericCalendar.get(10);
                if (n2 == 0) {
                    n2 = 12;
                }
                stringBuffer.append(this.formatValue(n2, string2, locale));
                break;
            }
            case 'P': {
                stringBuffer.append(this.formatAMPM(genericCalendar.get(9), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            case 'm': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(12), string2, locale));
                break;
            }
            case 's': {
                stringBuffer.append(this.formatTimeValue(genericCalendar.get(13), string2, locale));
                break;
            }
            case 'f': {
                stringBuffer.append(this.formatMillisecondValue(genericCalendar.get(14), string2, locale));
                break;
            }
            case 'Z': {
                if (!this.isTimeZoneSpecified) break;
                String string3 = this.getTimeFromOffset(genericCalendar.get(15));
                String string4 = this.getModifier(string2, bl);
                if (string4.equals(EMPTYSTRING)) {
                    if (string3.equals(EMPTYSTRING)) {
                        string3 = "Z";
                    }
                } else if (string3.equals(EMPTYSTRING)) {
                    string3 = "GMT";
                }
                stringBuffer.append(string3);
                break;
            }
            case 'z': {
                if (!this.isTimeZoneSpecified) break;
                stringBuffer.append("GMT" + this.getTimeFromOffset(genericCalendar.get(15)));
                break;
            }
            case 'C': {
                break;
            }
            case 'E': {
                stringBuffer.append(this.formatEras(genericCalendar.get(0), string2, bl, genericDateFormatSymbols, locale));
                break;
            }
            default: {
                BasisLibrary2.runTimeError("INVALID_TIME_SPECIFIER", String.valueOf(c));
            }
        }
        return stringBuffer.toString();
    }

    private boolean isWidthSpecified(String string2) {
        return string2.indexOf(COMMA) != -1;
    }

    private boolean isLanguageSupported(String string2) {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            if (!string2.equals(localeArray[i].getLanguage())) continue;
            return true;
        }
        return false;
    }

    private String adjustWidth(String string2, String string3) {
        String string4;
        int n2;
        int n3;
        int n4 = this.getMinimumWidth(string3);
        if (n4 > (n3 = this.getMaximumWidth(string3))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        if ((n2 = (string4 = String.valueOf(string2)).length()) < n4) {
            int n5 = n4 - n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n5; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string4);
            string4 = stringBuffer.toString();
        } else if (n2 > n3) {
            string4 = string4.substring(0, n3);
        }
        return string4;
    }

    private String adjustWidthForYear(String string2, String string3) {
        int n2;
        int n3 = this.getMinimumWidth(string3);
        if (n3 > (n2 = this.getMaximumWidth(string3))) {
            BasisLibrary2.runTimeError("INVALID_DATE_TIME_MAXIMUM_WIDTH");
        }
        return this.adjustWidthForValue(string2, n3, n2);
    }

    private String adjustWidthForValue(String string2, int n2, int n3) {
        String string3;
        int n4 = string2.length();
        if (n4 < n2) {
            if (Character.isDigit(string2.charAt(0))) {
                int n5 = n2 - n4;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n5; ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
                string3 = stringBuffer.toString();
            } else {
                int n6 = n2 - n4;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string2);
                string3 = stringBuffer.toString();
            }
        } else {
            string3 = n4 > n3 ? string2.substring(n4 - n3) : string2;
        }
        return string3;
    }

    private int getSeconds(String string2) {
        int n2 = string2.indexOf(".");
        if (n2 < 0) {
            return Integer.parseInt(string2);
        }
        return Integer.parseInt(string2.substring(0, n2));
    }

    private boolean hasOridnal(String string2) {
        if (string2.indexOf("o") == -1) {
            return false;
        }
        if (string2.endsWith("o")) {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case 'N': 
                    case 'W': 
                    case 'n': 
                    case 'w': {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean containsLetter(String string2) {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            if (Character.isDigit(string2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isPictureValid(String string2) {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ',' || c == '-' || c == '*') continue;
            return false;
        }
        return true;
    }

    private int getMillieconds(String string2) {
        int n2 = string2.indexOf(".");
        if (n2 < 0) {
            return 0;
        }
        return Integer.parseInt(string2.substring(n2 + 1));
    }

    private int getMinimumWidth(String string2) {
        String string3;
        int n2 = -1;
        int n3 = string2.indexOf(COMMA);
        int n4 = string2.indexOf(DASH);
        if (n3 != -1 && !(string3 = n4 == -1 ? string2.substring(n3 + 1) : string2.substring(n3 + 1, n4)).equals(EMPTYSTRING) && !string3.equals(STAR)) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", string3);
            }
        }
        return n2;
    }

    private int getMaximumWidth(String string2) {
        String string3 = EMPTYSTRING;
        int n2 = -1;
        int n3 = string2.indexOf(COMMA);
        int n4 = string2.indexOf(DASH);
        if (n3 != -1) {
            if (n4 != -1) {
                string3 = string2.substring(n4 + 1);
            }
            if (!string3.equals(EMPTYSTRING)) {
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    BasisLibrary2.runTimeError("INVALID_DATE_TIME_WIDTH_SPECIFIER", string3);
                }
            }
        }
        return n2;
    }

    private GenericCalendar getCalendar(String string2, String string3, Locale locale) {
        GenericCalendar genericCalendar = this.s_ICUNumberFormatFactory != null ? new GenericCalendarICUImpl(string2, string3, locale) : new GenericCalendarJavaImpl(string2, string3, locale);
        return genericCalendar;
    }

    private GenericDateFormatSymbols getDateFormatSymbols(Locale locale) {
        GenericDateFormatSymbols genericDateFormatSymbols = cachedSymbols.get(locale);
        if (genericDateFormatSymbols != null) {
            return genericDateFormatSymbols;
        }
        genericDateFormatSymbols = this.s_ICUNumberFormatFactory != null ? new DateFormatSymbolsICUImpl(locale) : new DateFormatSymbolsJavaImpl(locale);
        cachedSymbols.put(locale, genericDateFormatSymbols);
        return genericDateFormatSymbols;
    }

    private String getModifier(String string2, boolean bl) {
        String string3 = bl ? string2.substring(1, string2.indexOf(COMMA)) : (string2.length() > 1 ? string2.substring(1) : EMPTYSTRING);
        return string3;
    }

    private class GenericCalendarJavaImpl
    implements GenericCalendar {
        final GregorianCalendar m_cal;

        public GenericCalendarJavaImpl(String string2, String string3, Locale locale) {
            if (string2.equals(DateFormatFunctionsLibrary.EMPTYSTRING) || string2.equals("AD")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            } else if (string2.equals("ISO")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            } else {
                DateFormatFunctionsLibrary.this.defaultCalendarFallBack = true;
                GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            }
            if (!string3.equals(DateFormatFunctionsLibrary.EMPTYSTRING)) {
                DateFormatFunctionsLibrary.this.isTimeZoneSpecified = true;
                this.m_cal.getTimeZone().setRawOffset(DateFormatFunctionsLibrary.this.getRawOffSetFromTimeZone(string3));
            }
        }

        @Override
        public int get(int n2) {
            return this.m_cal.get(n2);
        }

        public Object getDisplayName(Locale locale) {
            return "hello";
        }

        @Override
        public void set(int n2, int n3) {
            this.m_cal.set(n2, n3);
        }

        @Override
        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private class GenericCalendarICUImpl
    implements GenericCalendar {
        final Calendar m_cal;

        public GenericCalendarICUImpl(String string2, String string3, Locale locale) {
            if (string2.equals(DateFormatFunctionsLibrary.EMPTYSTRING) || string2.equals("AD")) {
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            } else if (string2.equals("BE")) {
                this.m_cal = new BuddhistCalendar(locale);
            } else if (string2.equals("ISO")) {
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            } else {
                DateFormatFunctionsLibrary.this.defaultCalendarFallBack = true;
                com.ibm.icu.util.GregorianCalendar gregorianCalendar = new com.ibm.icu.util.GregorianCalendar(locale);
                gregorianCalendar.setMinimalDaysInFirstWeek(4);
                gregorianCalendar.setFirstDayOfWeek(2);
                this.m_cal = gregorianCalendar;
            }
            if (!string3.equals(DateFormatFunctionsLibrary.EMPTYSTRING)) {
                DateFormatFunctionsLibrary.this.isTimeZoneSpecified = true;
                this.m_cal.setTimeZone(TimeZone.getTimeZone((String)("GMT" + DateFormatFunctionsLibrary.this.getTimeFromOffset(DateFormatFunctionsLibrary.this.getRawOffSetFromTimeZone(string3)))));
            }
        }

        @Override
        public int get(int n2) {
            return this.m_cal.get(n2);
        }

        public Object getDisplayName(Locale locale) {
            return this.m_cal.getDisplayName(locale);
        }

        @Override
        public void set(int n2, int n3) {
            this.m_cal.set(n2, n3);
        }

        @Override
        public Object getTimeZone() {
            return this.m_cal.getTimeZone();
        }
    }

    private class DateFormatSymbolsJavaImpl
    implements GenericDateFormatSymbols {
        final DateFormatSymbols m_dfs;

        public DateFormatSymbolsJavaImpl(Locale locale) {
            this.m_dfs = new DateFormatSymbols(locale);
        }

        @Override
        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        @Override
        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        @Override
        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        @Override
        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        @Override
        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        @Override
        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private class DateFormatSymbolsICUImpl
    implements GenericDateFormatSymbols {
        final com.ibm.icu.text.DateFormatSymbols m_dfs;

        public DateFormatSymbolsICUImpl(Locale locale) {
            this.m_dfs = new com.ibm.icu.text.DateFormatSymbols(locale);
        }

        @Override
        public String[] getAmPmStrings() {
            return this.m_dfs.getAmPmStrings();
        }

        @Override
        public String[] getMonths() {
            return this.m_dfs.getMonths();
        }

        @Override
        public String[] getShortMonths() {
            return this.m_dfs.getShortMonths();
        }

        @Override
        public String[] getWeekdays() {
            return this.m_dfs.getWeekdays();
        }

        @Override
        public String[] getShortWeekdays() {
            return this.m_dfs.getShortWeekdays();
        }

        @Override
        public String[] getEras() {
            return this.m_dfs.getEras();
        }
    }

    private static interface GenericDateFormatSymbols {
        public String[] getMonths();

        public String[] getEras();

        public String[] getAmPmStrings();

        public String[] getShortMonths();

        public String[] getWeekdays();

        public String[] getShortWeekdays();
    }

    private static interface GenericCalendar {
        public int get(int var1);

        public void set(int var1, int var2);

        public Object getTimeZone();
    }
}

