/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XSLTTranslatorDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTTranslatorDriver.class);
    private static final String s_className = XSLTTranslatorDriver.class.getName();
    static final boolean s_abe = false;

    public static void main(String[] stringArray) {
        Object object2;
        if (stringArray.length == 0) {
            System.out.println("Usage: XSLTTranslatorDriver\n        [-out filename]\n        xslfile");
            return;
        }
        int n2 = 0;
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        OutputStream outputStream = System.out;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            if (((String)object2).equals("-dump")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n2;
                continue;
            }
            if (!((String)object2).equals("-out")) break;
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-out requires parameter");
                return;
            }
            try {
                outputStream = new FileOutputStream(stringArray[n2]);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not open output file " + stringArray[n2], exception);
                return;
            }
            ++n2;
        }
        try {
            if (stringArray.length - n2 != 1) {
                System.out.println("Expected xslfile parameter");
                return;
            }
            xSLTLinkerSettings.setVersion("2.0");
            object2 = new File(stringArray[n2]);
            URL uRL = ((File)object2).toURL();
            XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings.getVersion());
            Module module = xSLTCompiler.loadRuntimeLibrary();
            Module module2 = XSLTCompiler.compileStylesheetToModule(uRL, module, null, false, xSLTCompilerSettings);
            if (module2 == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(outputStream);
            module2.dump(printWriter);
            printWriter.close();
            module2.typeCheck();
            System.out.println("Done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

