/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.exec.XFactoryUtils;
import com.ibm.xltxe.rnm1.xtq.scontext.XStaticContext;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.serializer.SAX2DOM;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSLTDumpingParser
extends XSLTParser {
    private static final Logger s_logger = LoggerUtil.getLogger(XSLTDumpingParser.class);
    private static final String s_className = XSLTDumpingParser.class.getName();
    private SessionContext m_session;
    private int stylesheetCount;
    private SAX2DOM m_s2d;

    public XSLTDumpingParser(boolean bl, XStaticContext xStaticContext, SessionContext sessionContext) {
        super(bl, xStaticContext);
        this.m_session = sessionContext;
    }

    @Override
    public Expr parse(XMLReader xMLReader, InputSource inputSource, Expr expr) {
        String string2 = "xslt-dump-" + ++this.stylesheetCount;
        if (Program.TIMESTAMPED_DUMPS) {
            string2 = string2 + "." + System.currentTimeMillis();
        }
        string2 = string2 + ".xsl";
        SAX2DOM sAX2DOM = this.m_s2d;
        SAX2DOM sAX2DOM2 = null;
        try {
            this.m_s2d = sAX2DOM2 = new SAX2DOM();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            s_logger.logrb(Level.WARNING, s_className, "parse", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)parserConfigurationException);
        }
        Expr expr2 = super.parse(xMLReader, inputSource, expr);
        if (sAX2DOM2 != null) {
            this.m_s2d = sAX2DOM;
            Cursor cursor2 = XFactoryUtils.getDocument(new DOMSource(sAX2DOM2.getDOM()), this.m_session, false);
            File file = new File(string2);
            try {
                PrintStream printStream = new PrintStream(file);
                printStream.println("<!-- systemId: " + inputSource.getSystemId() + " -->");
                printStream.println();
                cursor2.copyToResult(new StreamResult(printStream), null, false, true);
                printStream.close();
                s_logger.logrb(Level.INFO, s_className, "parse", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{file.getCanonicalPath()});
                return expr2;
            }
            catch (IOException iOException) {
                s_logger.logrb(Level.WARNING, s_className, "parse", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)iOException);
            }
        }
        return expr2;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        this.m_s2d.characters(cArray, n2, n3);
        super.characters(cArray, n2, n3);
    }

    @Override
    public void endDocument() {
        this.m_s2d.endDocument();
        super.endDocument();
    }

    @Override
    public void endElement(String string2, String string3, String string4) {
        this.m_s2d.endElement(string2, string3, string4);
        super.endElement(string2, string3, string4);
    }

    @Override
    public void endPrefixMapping(String string2) {
        this.m_s2d.endPrefixMapping(string2);
        super.endPrefixMapping(string2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        this.m_s2d.ignorableWhitespace(cArray, n2, n3);
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void processingInstruction(String string2, String string3) {
        this.m_s2d.processingInstruction(string2, string3);
        super.processingInstruction(string2, string3);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_s2d.setDocumentLocator(locator);
        super.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String string2) {
        this.m_s2d.skippedEntity(string2);
        super.skippedEntity(string2);
    }

    @Override
    public void startDocument() {
        this.m_s2d.startDocument();
        super.startDocument();
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        this.m_s2d.startElement(string2, string3, string4, attributes2);
        super.startElement(string2, string3, string4, attributes2);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) {
        this.m_s2d.startPrefixMapping(string2, string3);
        super.startPrefixMapping(string2, string3);
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.m_s2d.comment(cArray, n2, n3);
        super.comment(cArray, n2, n3);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.m_s2d.endCDATA();
        super.endCDATA();
    }

    @Override
    public void endDTD() throws SAXException {
        this.m_s2d.endDTD();
        super.endDTD();
    }

    @Override
    public void endEntity(String string2) throws SAXException {
        this.m_s2d.endEntity(string2);
        super.endEntity(string2);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.m_s2d.startCDATA();
        super.startCDATA();
    }

    @Override
    public void startDTD(String string2, String string3, String string4) throws SAXException {
        this.m_s2d.startDTD(string2, string3, string4);
        super.startDTD(string2, string3, string4);
    }

    @Override
    public void startEntity(String string2) throws SAXException {
        this.m_s2d.startEntity(string2);
        super.startEntity(string2);
    }
}

