/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.OptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.AutomatonFunctionCallExtractionOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.DataFlowAnalyzer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.GetLastOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.SimpleUnflattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.SimpleUnflattenXDMSequenceOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StringEqualityOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XDMSequenceOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XLTXEDesugarer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTMinimalPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationOptimizer;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XSLTPartialEvaluationSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.xpath20.typesystem.XTypeStore;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.PolymorphicADTDesugarer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadParameterEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.LetLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.RepeatedExpressionOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.StaticStringTableOptimizer;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardOptimizationRegimen
extends OptimizationRegimen {
    private static final Logger s_logger = LoggerUtil.getLogger(StandardOptimizationRegimen.class);
    private static final String s_className = StandardOptimizationRegimen.class.getName();
    protected Program m_program;
    protected Module m_primaryModule;
    protected XSLTLinkerSettings m_linkerSettings;
    protected File m_dir;
    protected String m_className;
    protected Set m_entryPoints;
    private final boolean m_v2Regimen;
    private static final boolean JUSTTURNALLDUMPON = false;
    public static final String DUMP_OPTION = "dumpfil";
    public static final boolean sDumpSome = HiddenOptions.wasSpecified("dumpfil") && !HiddenOptions.optionValueIs("dumpfil", "off");
    public static final boolean sDumpAll = sDumpSome && HiddenOptions.wasSpecified("dumpfil.all");
    private XTypeStore m_typeStore = null;
    protected IdentifierConsolidator m_ic;

    public StandardOptimizationRegimen(String string2) {
        this.m_v2Regimen = "2.0".equals(string2);
    }

    protected void desugar() throws Exception {
        new XLTXEDesugarer(this.m_program).desugar();
    }

    protected void doPartialEvaluation() throws Exception {
        if (this.m_linkerSettings.isMinOptimizations()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Beginning minimal version of partial evaluation");
            }
            this.m_ic = new IdentifierConsolidator();
            XSLTPartialEvaluationSettings xSLTPartialEvaluationSettings = new XSLTPartialEvaluationSettings(this.m_linkerSettings.getCodeGenerationSettings());
            XSLTMinimalPartialEvaluationOptimizer xSLTMinimalPartialEvaluationOptimizer = new XSLTMinimalPartialEvaluationOptimizer(this.m_entryPoints, xSLTPartialEvaluationSettings);
            xSLTMinimalPartialEvaluationOptimizer.m_ic = this.m_ic;
            this.m_program.optimize(xSLTMinimalPartialEvaluationOptimizer);
            xSLTMinimalPartialEvaluationOptimizer = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Completed minimal version of partial evaluation");
            }
        } else {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Beginning partial evaluation");
            }
            this.m_ic = new IdentifierConsolidator();
            XSLTPartialEvaluationSettings xSLTPartialEvaluationSettings = new XSLTPartialEvaluationSettings(this.m_linkerSettings.getCodeGenerationSettings());
            XSLTPartialEvaluationOptimizer xSLTPartialEvaluationOptimizer = new XSLTPartialEvaluationOptimizer(this.m_entryPoints, xSLTPartialEvaluationSettings);
            xSLTPartialEvaluationOptimizer.m_ic = this.m_ic;
            this.m_program.optimize(xSLTPartialEvaluationOptimizer);
            xSLTPartialEvaluationOptimizer = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doPartialEvaluation", "Completed partial evaluation");
            }
        }
    }

    @Override
    public void doOptimizations(XSLTLinkerSettings xSLTLinkerSettings, Program program, Set set2, File file, String string2, Module module, SessionContext sessionContext) throws Exception {
        File file2 = file;
        this.m_linkerSettings = xSLTLinkerSettings;
        this.m_program = program;
        this.m_entryPoints = set2;
        this.m_dir = file;
        this.m_className = string2;
        this.m_primaryModule = module;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "doOptimizations", "Beginning optimizations");
        }
        if (DumpOption.INITIAL.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, DumpOption.INITIAL.getOption());
        }
        if (DumpOption.POLYMORPHIC_ADT.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.POLYMORPHIC_ADT.getOption());
        }
        this.desugar();
        if (DumpOption.POLYMORPHIC_ADT.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.POLYMORPHIC_ADT.getOption());
        }
        program.removeFunctionDerivativeInformation();
        if (this.m_v2Regimen) {
            new PolymorphicADTDesugarer(program).desugar();
            program.optimize(new StaticStringTableOptimizer());
            if (DumpOption.PARTIAL_EVAL.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.PARTIAL_EVAL.getOption());
            }
            this.m_ic = null;
            this.doPartialEvaluation();
            if (DumpOption.PARTIAL_EVAL.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.PARTIAL_EVAL.getOption());
            }
            if (DumpOption.AUTOMATON_FUNCTION.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.AUTOMATON_FUNCTION.getOption());
            }
            AutomatonFunctionCallExtractionOptimizer.doOptimization(program, set2, this.m_linkerSettings.getCodeGenerationSettings());
            if (DumpOption.AUTOMATON_FUNCTION.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.AUTOMATON_FUNCTION.getOption());
            }
            program.removeDeadFunctions();
            DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            if (DumpOption.DEAD_PARAMS.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.DEAD_PARAMS.getOption());
            }
            DeadParameterEliminatorOptimizer.eliminateDeadParameters(program);
            if (DumpOption.DEAD_PARAMS.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.DEAD_PARAMS.getOption());
            }
            if (DumpOption.DEAD_CODE.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.DEAD_CODE.getOption() + "-pass1");
            }
            program.removeDeadFunctions();
            program.removeFunctionDerivativeInformation();
            DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            if (DumpOption.DEAD_CODE.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.DEAD_CODE.getOption() + "-pass1");
            }
            if (DumpOption.STRING_EQUALITY.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.STRING_EQUALITY.getOption());
            }
            program.optimize(new StringEqualityOptimizer());
            if (DumpOption.STRING_EQUALITY.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.STRING_EQUALITY.getOption());
            }
            if (DumpOption.DEAD_CODE.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.DEAD_CODE.getOption() + "-pass2");
            }
            if (DumpOption.GET_LAST.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.GET_LAST.getOption());
            }
            program.optimize(new XDMSequenceOptimizer());
            if (DumpOption.GET_LAST.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.GET_LAST.getOption());
            }
            DeadLetEliminatorOptimizer.eliminateDeadLets(program);
            program.removeDeadFunctions();
            program.removeFunctionDerivativeInformation();
            if (DumpOption.DEAD_CODE.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.DEAD_CODE.getOption() + "-pass2");
            }
            program.optimize(new SimpleUnflattenXDMSequenceOptimizer());
            program.optimize(new SimpleUnflattenStreamOptimizer());
            boolean bl = false;
            if (bl) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-get-last-optimizer");
            }
            program.optimize(new GetLastOptimizer());
            if (bl) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-get-last-optimizer");
            }
            if (DumpOption.REPEATED_EXPRESSION.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.REPEATED_EXPRESSION.getOption());
            }
            RepeatedExpressionOptimizer repeatedExpressionOptimizer = new RepeatedExpressionOptimizer();
            repeatedExpressionOptimizer.prescan(program);
            program.optimize(repeatedExpressionOptimizer);
            program.typeCheckReduced();
            if (DumpOption.REPEATED_EXPRESSION.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.REPEATED_EXPRESSION.getOption());
            }
            if (DumpOption.GET_LAST.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.GET_LAST.getOption());
            }
            program.optimize(new GetLastOptimizer());
            if (DumpOption.GET_LAST.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.GET_LAST.getOption());
            }
            if (DumpOption.LETLET.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.LETLET.getOption());
            }
            program.optimize(new LetLetOptimizer());
            if (DumpOption.LETLET.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.LETLET.getOption());
            }
            if (DumpOption.DATAFLOW.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "pre-" + DumpOption.DATAFLOW.getOption());
            }
            DataFlowAnalyzer dataFlowAnalyzer = new DataFlowAnalyzer();
            Iterator<Function> iterator = program.exportedFunctionsIterator();
            while (iterator.hasNext()) {
                Function function2 = iterator.next();
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "doOptimizations", "InterProceduralAnalyzer processing " + function2.getName());
                }
                dataFlowAnalyzer.optimizeFunction(function2);
            }
            if (DumpOption.DATAFLOW.isEnabled()) {
                this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, "post-" + DumpOption.DATAFLOW.getOption());
            }
        }
        if (DumpOption.FINAL.isEnabled()) {
            this.dumpHelper(true, "Search.Leftmodule.Listitem", file2, DumpOption.FINAL.getOption());
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "doOptimizations", "Finished optimizations");
        }
        this.m_linkerSettings = null;
        this.m_program = null;
        this.m_entryPoints = null;
        this.m_dir = null;
        this.m_className = null;
        this.m_primaryModule = null;
    }

    public static void optimizeForSequences(Program program, boolean bl, File file) {
        if (DumpOption.XDMSEQUENCE_OPT.isEnabled()) {
            StandardOptimizationRegimen.dumpHelper2(bl, "Search.Leftmodule.Listitem", file, "pre-" + DumpOption.XDMSEQUENCE_OPT.getOption(), program);
        }
        XDMSequenceOptimizer.doOptimization(program);
        if (DumpOption.XDMSEQUENCE_OPT.isEnabled()) {
            StandardOptimizationRegimen.dumpHelper2(bl, "Search.Leftmodule.Listitem", file, "post-" + DumpOption.XDMSEQUENCE_OPT.getOption(), program);
        }
    }

    static void dumpHelper2(boolean bl, String string2, File file, String string3, Program program) {
        if (bl) {
            Program.dumpXylemFile((Module)program, file, "XSLTModule", string3);
        } else {
            Program.dumpXylemFunctions(program.getSimilarFunctions(string2), file, "XSLTModule", string3);
        }
    }

    protected void dumpHelper(boolean bl, String string2, File file, String string3) {
        if (bl) {
            Program.dumpXylemFile((Module)this.m_program, file, this.m_className, string3);
        } else {
            Program.dumpXylemFunctions(this.m_program.getSimilarFunctions(string2), file, this.m_className, string3);
        }
    }

    public static enum DumpOption {
        LISTING("listing", HiddenOptions.wasSpecified("dumpfil.listing")),
        INITIAL("initial"),
        PARTIAL_EVAL("partial-eval"),
        XDMSEQUENCE_OPT("xdmsequenceopt"),
        DEAD_CODE("deadcode"),
        AUTOMATON_FUNCTION("automatonfunction"),
        REPEATED_EXPRESSION("repeatedexpression"),
        LOOP_INVARIANT("loopinvariant"),
        STRING_EQUALITY("stringequality"),
        DEAD_PARAMS("deadparams"),
        POLYMORPHIC_ADT("polymorphicadtdesugarer"),
        GET_LAST("getlast"),
        DATAFLOW("dataflow"),
        FINAL("final"),
        LETLET("letlet");

        private final String m_option;
        private final boolean m_enabled;

        private DumpOption(String string3) {
            this.m_option = string3;
            this.m_enabled = sDumpAll || sDumpSome && HiddenOptions.wasSpecified("dumpfil." + string3);
        }

        private DumpOption(String string3, boolean bl) {
            this.m_option = string3;
            this.m_enabled = bl;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public String getOption() {
            return this.m_option;
        }
    }
}

