/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.Linker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandaloneXSLTCompilerLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(StandaloneXSLTCompilerLinker.class);
    private static final String s_className = StandaloneXSLTCompilerLinker.class.getName();

    public static void main(String[] stringArray) {
        Serializable serializable;
        if (stringArray.length == 0) {
            s_logger.logp(Level.INFO, s_className, "main", "Usage: StandaloneXSLTCompilerLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-classloaderproxy]\n        [-standardserializer]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        SessionContext sessionContext = new SessionContext();
        int n2 = 0;
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = Linker.parseOptions(xSLTLinkerSettings, stringArray, n2);
            if (n3 > 0) {
                n2 = n3 + 1;
                continue;
            }
            if (string2.equals("-split")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n2++]));
                continue;
            }
            if (string2.equals("-newsplit")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-newsplit missing parameter");
                    return;
                }
                try {
                    xSLTLinkerSettings.getCodeGenerationSettings().setPostReductionSplitLimit(Integer.parseInt(stringArray[n2]));
                }
                catch (NumberFormatException numberFormatException) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "invalid split limit: " + stringArray[n2]);
                    return;
                }
                ++n2;
                continue;
            }
            if (string2.equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n2;
                continue;
            }
            if (string2.equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n2;
                continue;
            }
            if (string2.equals("-classloaderproxy")) {
                xSLTLinkerSettings.setGenerateClassLoadingProxy(true);
                ++n2;
                continue;
            }
            if (string2.equals("-standardserializer")) {
                xSLTCompilerSettings.setStreamResultOnly(false);
                ++n2;
                continue;
            }
            if (string2.equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++n2;
                continue;
            }
            if (string2.equals("-generateFCGJava")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(3);
                ++n2;
                continue;
            }
            if (string2.equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n2;
                continue;
            }
            if (string2.equals("-xhtmlCompatability")) {
                xSLTCompilerSettings.setXHTMLCompatability(true);
                ++n2;
                continue;
            }
            if (!string2.equals("-command")) break;
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-command requires parameter");
                return;
            }
            try {
                String string3;
                serializable = new ArrayList();
                FileReader fileReader = new FileReader(stringArray[n2]);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).length() <= 0) continue;
                    ((ArrayList)serializable).add(string3);
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (IOException iOException) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + stringArray[n2], iOException);
                return;
            }
            stringArray = ((ArrayList)serializable).toArray(new String[0]);
            n2 = 0;
            break;
        }
        try {
            for (int i = 0; i < stringArray.length - n2; ++i) {
                String string4 = null;
                try {
                    serializable = new File(stringArray[i + n2]);
                    if (stringArray[(i += 2) + n2 - 1].equals("-classname")) {
                        string4 = stringArray[n2 + i];
                        if (i == stringArray.length) {
                            s_logger.logp(Level.SEVERE, s_className, "main", "-classname missing parameter");
                            throw new RuntimeException();
                        }
                    }
                    XSLTLinker.s_linker.compileStylesheet(((File)serializable).toURL(), string4, xSLTCompilerSettings, xSLTLinkerSettings, sessionContext);
                    continue;
                }
                catch (Throwable throwable) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "", throwable);
                }
            }
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", exception);
        }
    }
}

