/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SoftReferenceCache {
    private HashMap m_map = new HashMap();

    public synchronized void clear() {
        this.m_map.clear();
    }

    public synchronized void evict(String string2) {
        this.m_map.remove(string2);
    }

    public synchronized Object get(String string2) {
        SoftListNode softListNode = (SoftListNode)this.m_map.get(string2);
        if (softListNode == null) {
            return null;
        }
        this.m_map.put(string2, softListNode.unlink());
        return softListNode.get();
    }

    public synchronized int count(String string2) {
        int n2 = 0;
        SoftListNode softListNode = (SoftListNode)this.m_map.get(string2);
        while (softListNode != null) {
            softListNode = softListNode.m_next;
            ++n2;
        }
        return n2;
    }

    public synchronized Set getKeys() {
        return new HashSet(this.m_map.keySet());
    }

    public synchronized void cache(String string2, Object object2) {
        SoftListNode softListNode = new SoftListNode(object2);
        softListNode.link(this.m_map.put(string2, softListNode));
    }

    private class SoftListNode
    extends SoftReference {
        private SoftListNode m_prev;
        private SoftListNode m_next;

        SoftListNode(Object object2) {
            super(object2);
        }

        private void link(SoftListNode softListNode) {
            this.m_next = softListNode;
            if (softListNode != null) {
                this.m_next.m_prev = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            SoftReferenceCache softReferenceCache = SoftReferenceCache.this;
            synchronized (softReferenceCache) {
                this.unlink();
            }
            super.clear();
        }

        private SoftListNode unlink() {
            SoftListNode softListNode;
            if (this.m_prev != null) {
                this.m_prev.m_next = this.m_next;
            }
            if ((softListNode = this.m_next) != null) {
                this.m_next.m_prev = this.m_prev;
            }
            return softListNode;
        }
    }
}

