/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.translator.StaticError;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PrettyPrinter;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ZeroArgPrimopInstruction;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class ParamReferenceIdentifier
extends ZeroArgPrimopInstruction {
    private int m_paramIndex;

    public static void fixParamReferences(Module module) {
        module.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                if (instruction2 instanceof ParamReferenceIdentifier) {
                    ParamReferenceIdentifier paramReferenceIdentifier = (ParamReferenceIdentifier)instruction2;
                    if (paramReferenceIdentifier.m_paramIndex >= this.getCurrentFunction().m_parameters.length) {
                        throw new StaticError("ERR_SYSTEM", "oob " + paramReferenceIdentifier.m_paramIndex + "/" + this.getCurrentFunction().m_parameters.length + " in " + this.getCurrentFunction());
                    }
                    Object object2 = this.getCurrentFunction().m_parameters[paramReferenceIdentifier.m_paramIndex].getName();
                    instruction2 = new IdentifierInstruction(object2);
                    instruction2.setCachedType(paramReferenceIdentifier.getCachedType());
                    instruction2.setBindingEnvironment(paramReferenceIdentifier.getBindingEnvironment());
                }
                return instruction2;
            }
        });
    }

    public static void createParamReferences(Module module) {
        module.optimize(new Optimizer(){
            HashMap m_paramIndecies = new HashMap();

            @Override
            public void optimizeFunction(Function function2) {
                this.m_paramIndecies.clear();
                for (int i = 0; i < function2.m_parameters.length; ++i) {
                    this.m_paramIndecies.put(function2.m_parameters[i].getName(), new Integer(i));
                }
                super.optimizeFunction(function2);
            }

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                Object object2;
                Integer n2;
                if (instruction2 instanceof IdentifierInstruction && (n2 = (Integer)this.m_paramIndecies.get(object2 = ((IdentifierInstruction)instruction2).getVariable())) != null && instruction2.getBindingEnvironment().getVariableBinding(object2) == this.getCurrentFunction().m_parameters[n2]) {
                    ParamReferenceIdentifier paramReferenceIdentifier = new ParamReferenceIdentifier(n2, instruction2.getCachedType());
                    return paramReferenceIdentifier;
                }
                return instruction2;
            }
        });
    }

    ParamReferenceIdentifier(int n2, Type type2) {
        this.setCachedType(type2);
        this.m_paramIndex = n2;
    }

    public ParamReferenceIdentifier() {
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return this;
    }

    @Override
    public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        return this.getCachedType();
    }

    @Override
    public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return this.getCachedType();
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        super.write(writeObjectFileHelper);
        writeObjectFileHelper.writeInt(this.m_paramIndex);
        writeObjectFileHelper.writeType(this.getCachedType());
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        super.read(readObjectFileHelper, bindingEnvironment);
        this.m_paramIndex = readObjectFileHelper.readInt();
        this.setCachedType(readObjectFileHelper.readType());
    }

    @Override
    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (!(object2 instanceof ParamReferenceIdentifier)) {
            return false;
        }
        ParamReferenceIdentifier paramReferenceIdentifier = (ParamReferenceIdentifier)object2;
        return paramReferenceIdentifier.m_paramIndex == this.m_paramIndex;
    }

    @Override
    public void toString(PrettyPrinter prettyPrinter, int n2) {
        prettyPrinter.printFormOpen("PARAM", n2);
        prettyPrinter.print("" + this.m_paramIndex);
        prettyPrinter.printFormClose(n2);
    }
}

