/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReadObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OverlapDetectionXSLTLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTLinker.class);
    private static final String s_className = OverlapDetectionXSLTLinker.class.getName();

    public static void main(String[] stringArray) {
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        Object object5;
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        SessionContext sessionContext = new SessionContext();
        xSLTLinkerSettings.setOverlapDetection(true);
        if (stringArray.length == 0) {
            s_logger.logp(Level.INFO, s_className, "main", "Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            object5 = stringArray[n2];
            if (((String)object5).equals("-split")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n2++]));
                continue;
            }
            if (((String)object5).equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n2;
                continue;
            }
            if (((String)object5).equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n2;
                continue;
            }
            if (((String)object5).equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(4);
                ++n2;
                continue;
            }
            if (((String)object5).equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n2;
                continue;
            }
            if (!((String)object5).equals("-command")) break;
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "main", "-split requires parameter");
                return;
            }
            try {
                cloneable = new ArrayList();
                object4 = new FileReader(stringArray[n2]);
                object3 = new BufferedReader((Reader)object4);
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    if (((String)(object2 = ((String)object2).trim())).length() <= 0) continue;
                    ((ArrayList)cloneable).add(object2);
                }
                ((BufferedReader)object3).close();
                ((InputStreamReader)object4).close();
            }
            catch (IOException iOException) {
                s_logger.logp(Level.SEVERE, s_className, "main", "Could not read command file " + stringArray[n2], iOException);
                return;
            }
            stringArray = ((ArrayList)cloneable).toArray(stringArray);
            n2 = 0;
            break;
        }
        try {
            Object object6;
            Serializable serializable;
            object5 = new HashMap();
            cloneable = new HashMap();
            object4 = new ArrayList();
            object3 = new ArrayList();
            object2 = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length - n2; i += 2) {
                serializable = new File(stringArray[i + n2]);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "main", "Reading catalog for module " + serializable);
                }
                object6 = stringArray[i + n2 + 1];
                OverlapDetectionXSLTLinker.readIndividualModule(i / 2, (String)object6, serializable, (HashMap)object5, (HashMap)cloneable, (ArrayList)object4, (ArrayList)object3, (ArrayList)object2);
                arrayList.add((String)object6);
            }
            Module module = new Module((String)arrayList.get(0), null, new ModuleSignature(""));
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Detecting overlap");
            }
            OverlapDetectionXSLTLinker.detectOverlap(module, (HashMap)object5, cloneable, (ArrayList)object4, (ArrayList)object3, (ArrayList)object2, sessionContext);
            serializable = XSLTCompiler.loadRuntimeLibrary(false);
            module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", ((Module)serializable).m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(module);
            object6 = ((HashMap)cloneable).values().iterator();
            while (object6.hasNext()) {
                ((ModuleRecord)object6.next()).m_raf.close();
            }
            cloneable = null;
            object5 = null;
            ParamReferenceIdentifier.fixParamReferences(module);
            module.clearTypeInformation(true);
            module.removeFunctionDerivativeInformation();
            Program.dumpXylemFile(module, null, "master");
            XSLTCompiler.postASTProcessing(module, null, xSLTCompilerSettings.getPrereductionSplitLimit(), xSLTCompilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(module, (Module)serializable, arrayList.size(), arrayList, module.getName(), xSLTLinkerSettings, sessionContext);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", exception);
        }
    }

    public static void detectOverlap(Module module, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, SessionContext sessionContext) throws Exception {
        int n2;
        int[] nArray;
        Object[] objectArray;
        Object[] objectArray2;
        Object object2;
        Object object3;
        String[] stringArray;
        String[] stringArray2;
        Object object4;
        Object object52;
        byte[] byArray = new byte[0x100000];
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object52 : hashMap.keySet()) {
            object4 = ((FunctionSignature)object52).getFunctionName();
            int n3 = 0;
            while (hashSet.contains(object4)) {
                object4 = (String)object4 + "$" + ++n3;
            }
            hashMap3.put(object52, object4);
            hashSet.add(object4);
        }
        object52 = new ArrayList(hashMap.values());
        Collections.sort(object52, new Comparator(){

            public int compare(Object object2, Object object3) {
                ArrayList arrayList = (ArrayList)object2;
                ArrayList arrayList2 = (ArrayList)object3;
                int n2 = arrayList2.size() - arrayList.size();
                if (n2 != 0) {
                    return n2;
                }
                FunctionRecord functionRecord = (FunctionRecord)arrayList.get(0);
                FunctionRecord functionRecord2 = (FunctionRecord)arrayList2.get(0);
                return functionRecord.m_signature.getFunctionName().compareTo(functionRecord2.m_signature.getFunctionName());
            }
        });
        object4 = new ArrayList();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        Iterator iterator3 = arrayList3.iterator();
        Function function2 = null;
        Function function3 = null;
        Function function4 = null;
        Module module2 = new Module("", null);
        int[][] nArrayArray = new int[arrayList.size()][];
        int n4 = 0;
        while (iterator.hasNext()) {
            stringArray2 = (String[])iterator.next();
            stringArray = (String[])iterator2.next();
            object3 = (FunctionRecord)iterator3.next();
            function2 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)stringArray2, hashMap2, byArray);
            function3 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)stringArray, hashMap2, byArray);
            function4 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)object3, hashMap2, byArray);
            function2.typeCheckReduced(module2, new LinkedList());
            function3.typeCheckReduced(module2, new LinkedList());
            function4.typeCheckReduced(module2, new LinkedList());
            object2 = XSLTLinker.retrieveXDMStringArray(function2, sessionContext);
            objectArray2 = XSLTLinker.retrieveXDMStringArray(function3, sessionContext);
            objectArray = XSLTLinker.retrieveXDMIntArray(function4, sessionContext);
            nArrayArray[n4] = new int[((String[])object2).length];
            nArray = nArrayArray[n4];
            for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                nArray[n2] = -1;
                for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                    if (!XSLTLinker.areStringRefsEqual(((ArrayList)object4).get(i), (String)object2[n2]) || !XSLTLinker.areStringRefsEqual(arrayList4.get(i), (String)objectArray2[n2]) || !arrayList5.get(i).equals(new Integer(objectArray[n2]))) continue;
                    nArray[n2] = i;
                    break;
                }
                if (nArray[n2] != -1) continue;
                nArray[n2] = ((ArrayList)object4).size();
                ((ArrayList)object4).add(object2[n2]);
                arrayList4.add(objectArray2[n2]);
                arrayList5.add(new Integer(objectArray[n2]));
            }
            ++n4;
        }
        stringArray2 = new String[((ArrayList)object4).size()];
        ((ArrayList)object4).toArray(stringArray2);
        stringArray = new String[arrayList4.size()];
        arrayList4.toArray(stringArray);
        function2.setBody(XSLTLinker.makeStringArrayBody(stringArray2));
        function3.setBody(XSLTLinker.makeStringArrayBody(stringArray));
        function4.setBody(XSLTLinker.makeIntArrayBody(arrayList5));
        module.addFunction(function2);
        module.addFunction(function3);
        module.addFunction(function4);
        module.forceFunctionGeneration(function2);
        module.forceFunctionGeneration(function3);
        module.forceFunctionGeneration(function4);
        Iterator<Object> iterator4 = ((ArrayList)object52).iterator();
        block5: while (iterator4.hasNext()) {
            Object object6;
            Object object7;
            Object object8;
            object3 = (ArrayList)iterator4.next();
            object2 = ((ArrayList)object3).iterator();
            objectArray2 = new Instruction[((ArrayList)object3).size()];
            objectArray = new Function[((ArrayList)object3).size()];
            nArray = new int[((ArrayList)object3).size()];
            n2 = 0;
            while (object2.hasNext()) {
                object8 = (FunctionRecord)object2.next();
                Function function5 = null;
                function5 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)object8, hashMap2, byArray);
                if (function5.getName().equals("main")) {
                    function5.setName("main-functor");
                } else if (!(function5.getName().equals("setupOutput") || function5.getName().equals("whitespaceRules") || function5.getName().equals("setupCharacterMaps") || function5.getName().equals("get-ns-prefix-counter"))) {
                    if (((FunctionRecord)object8).m_exported) {
                        if (module.getFunction(function5.getName()) != null) continue block5;
                        module.addFunction(function5);
                        module.forceFunctionGeneration(function5);
                        continue block5;
                    }
                    function5.setName((String)hashMap3.get(((FunctionRecord)object8).m_signature));
                }
                object7 = (ModuleRecord)hashMap2.get(((FunctionRecord)object8).m_moduleName);
                nArray[n2] = object7.m_index;
                object6 = new XDMTypeUpdater((ModuleRecord)object7, hashMap3){
                    final /* synthetic */ ModuleRecord val$mr;
                    final /* synthetic */ HashMap val$unifiedFunctionNameMap;
                    {
                        this.val$mr = moduleRecord;
                        this.val$unifiedFunctionNameMap = hashMap;
                    }

                    @Override
                    protected Instruction optimizeStep2(Instruction instruction2) {
                        if (instruction2 instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                            FunctionSignature functionSignature = (FunctionSignature)this.val$mr.m_functionNames.get(functionCallInstruction.getFunction());
                            String string2 = (String)this.val$unifiedFunctionNameMap.get(functionSignature);
                            Instruction[] instructionArray = new Instruction[instruction2.getChildInstructionCount() + 1];
                            System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 1, functionCallInstruction.m_parameters.length);
                            instructionArray[0] = new IdentifierInstruction("__functorindex__");
                            functionCallInstruction.m_parameters = instructionArray;
                            functionCallInstruction.setFunction(string2);
                        }
                        return super.optimizeStep2(instruction2);
                    }
                };
                ((XDMTypeUpdater)object6).m_newIndices = nArrayArray[object7.m_index];
                ((Optimizer)object6).optimizeFunction(function5);
                objectArray[n2] = (int)function5;
                objectArray2[n2++] = function5.getBody();
            }
            object8 = objectArray[0];
            boolean bl = false;
            if (((Function)object8).getName().equals("build_key")) {
                bl = true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "detectOverlap", "Merging function " + ((Function)object8).getName() + " from " + ((ArrayList)object3).size() + " modules");
            }
            object7 = new Binding[((Function)object8).m_parameters.length + 1];
            System.arraycopy(((Function)object8).m_parameters, 0, object7, 1, ((Function)object8).m_parameters.length);
            object7[0] = new Binding((Object)"__functorindex__", IntType.s_intType);
            ((Function)object8).m_parameters = object7;
            object6 = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice((Instruction[])objectArray2, true, module, (Function)object8, nArray, hashMap2.size(), bl, null);
            ((Function)object8).setBody((Instruction)object6);
            module.addFunction((Function)object8);
        }
    }

    public static void readIndividualModule(int n2, String string2, File file, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws Exception {
        int n3;
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        ModuleRecord moduleRecord = new ModuleRecord();
        moduleRecord.m_baseOffset = dataInputStream.readInt() + 4;
        ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST));
        moduleRecord.m_functionNames = new HashMap();
        int n4 = readObjectFileHelper.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            FunctionRecord functionRecord = new FunctionRecord();
            functionRecord.m_offset = readObjectFileHelper.readInt();
            functionRecord.m_size = readObjectFileHelper.readInt();
            functionRecord.m_originalName = readObjectFileHelper.readString();
            functionRecord.m_exported = readObjectFileHelper.readBoolean();
            functionRecord.m_signature = new FunctionSignature();
            functionRecord.m_signature.read(readObjectFileHelper);
            functionRecord.m_moduleName = string2;
            ArrayList<FunctionRecord> arrayList4 = (ArrayList<FunctionRecord>)hashMap.get(functionRecord.m_signature);
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<FunctionRecord>();
                hashMap.put(functionRecord.m_signature, arrayList4);
            }
            arrayList4.add(functionRecord);
            moduleRecord.m_functionNames.put(functionRecord.m_originalName, functionRecord.m_signature);
            if (functionRecord.m_originalName.equals("xdm-names")) {
                arrayList.add(functionRecord);
                continue;
            }
            if (functionRecord.m_originalName.equals("xdm-types")) {
                arrayList3.add(functionRecord);
                continue;
            }
            if (!functionRecord.m_originalName.equals("xdm-uris")) continue;
            arrayList2.add(functionRecord);
        }
        n3 = objectInputStream.readInt();
        moduleRecord.m_instructionNames = new HashMap();
        for (int i = 0; i < n3; ++i) {
            moduleRecord.m_instructionNames.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
        fileInputStream.close();
        moduleRecord.m_raf = new RandomAccessFile(file, "r");
        moduleRecord.m_index = n2;
        hashMap2.put(string2, moduleRecord);
    }

    public static Function readFunction(FunctionRecord functionRecord, HashMap hashMap, byte[] byArray) throws Exception {
        final ModuleRecord moduleRecord = (ModuleRecord)hashMap.get(functionRecord.m_moduleName);
        if (byArray.length < functionRecord.m_size) {
            byArray = new byte[functionRecord.m_size];
        }
        moduleRecord.m_raf.seek(moduleRecord.m_baseOffset + functionRecord.m_offset);
        moduleRecord.m_raf.read(byArray, 0, functionRecord.m_size);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST)){

            @Override
            public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
                int n2 = this.readInt();
                Class clazz = (Class)moduleRecord.m_instructionNames.get(new Integer(n2));
                Instruction instruction2 = (Instruction)clazz.newInstance();
                instruction2.setCachedType(this.readType());
                instruction2.read(this, bindingEnvironment);
                return instruction2;
            }
        };
        Function function2 = new Function();
        function2.read(readObjectFileHelper);
        return function2;
    }

    static class ModuleRecord {
        HashMap m_instructionNames;
        HashMap m_functionNames;
        RandomAccessFile m_raf;
        int m_baseOffset;
        int m_index;

        ModuleRecord() {
        }
    }

    static class FunctionRecord {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        String m_moduleName;
        boolean m_exported;

        FunctionRecord() {
        }
    }
}

