/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.XTQProgram;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.WriteObjectFileHelper;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserSingleInputFile;
import com.ibm.xml.ras.LoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;

public class OverlapDetectionXSLTCompiler {
    private static final Logger s_logger = LoggerUtil.getLogger(OverlapDetectionXSLTCompiler.class);
    private static final String s_className = OverlapDetectionXSLTCompiler.class.getName();

    public static void main(String[] stringArray) {
        CLP cLP = new CLP();
        if (!cLP.parseCommandLine(stringArray)) {
            return;
        }
        try {
            Module module = XSLTCompiler.loadRuntimeLibrary(false);
            for (int i = 0; i < cLP.m_inputFiles.size(); ++i) {
                URL uRL = (URL)cLP.m_inputFiles.get(i);
                Module module2 = OverlapDetectionXSLTCompiler.compileIndividualModule(uRL, module, cLP.m_settings);
                module2.removeDeadFunctions();
                File file = (File)cLP.m_outputFiles.get(i);
                if (cLP.m_dumpXylem) {
                    File file2 = new File(file.getAbsolutePath() + ".xylem");
                    s_logger.logp(Level.INFO, s_className, "main", "Xylem dump being written to file " + file2);
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
                    module2.dump(printWriter);
                    printWriter.close();
                }
                ParamReferenceIdentifier.createParamReferences(module2);
                s_logger.logp(Level.INFO, s_className, "main", "Writing file " + file.getAbsolutePath());
                OverlapDetectionXSLTCompiler.writeIndividualModule(module2, file);
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "main", "Done");
            }
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "main", "", exception);
        }
    }

    public static Module compileIndividualModule(URL uRL, Module module, XSLTCompilerSettings xSLTCompilerSettings) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "compileIndividualModule", "Compiling stylesheet: " + uRL);
        }
        XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
        xSLTCompiler.setRuntimeLibrary(module);
        InputStream inputStream = uRL.openStream();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toString());
        XTQProgram xTQProgram = xSLTCompiler.buildAST(inputSource, uRL.toString());
        Module module2 = xSLTCompiler.translate(xTQProgram);
        module2.typeCheck(false);
        return module2;
    }

    public static void writeIndividualModule(Module module, File file) throws Exception {
        Object object2;
        WriteObjectFileHelper writeObjectFileHelper;
        ObjectOutputStream objectOutputStream;
        ArrayList<Function> arrayList = new ArrayList<Function>(module.getFunctions());
        Module.sortFunctionList(arrayList);
        Iterator<Object> iterator = arrayList.iterator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final HashMap hashMap = new HashMap();
        ArrayList<Record> arrayList2 = new ArrayList<Record>();
        while (iterator.hasNext()) {
            int n2 = byteArrayOutputStream.size();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            writeObjectFileHelper = new WriteObjectFileHelper(module, objectOutputStream){

                @Override
                public void writeInstructionTag(Instruction instruction2) throws IOException {
                    Integer n2 = (Integer)hashMap.get(instruction2.getClass());
                    if (n2 == null) {
                        n2 = new Integer(hashMap.size());
                        hashMap.put(instruction2.getClass(), n2);
                    }
                    this.writeInt(n2);
                    this.writeType(instruction2.getCachedType());
                }
            };
            Function object32 = iterator.next();
            object2 = new FunctionSignature(object32);
            boolean bl = module.m_signature.containsFunction(object32.getName());
            if (object32.isDerivative()) {
                ((FunctionSignature)object2).setFunctionName(object32.getOriginalFunction().getName());
            }
            object32.write(writeObjectFileHelper);
            objectOutputStream.close();
            int n3 = byteArrayOutputStream.size();
            Record record = new Record((FunctionSignature)object2, n2, n3 - n2, object32.getName(), bl);
            arrayList2.add(record);
        }
        byteArrayOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
        writeObjectFileHelper = new WriteObjectFileHelper(module, objectOutputStream);
        writeObjectFileHelper.writeInt(arrayList2.size());
        for (Record record : arrayList2) {
            writeObjectFileHelper.writeInt(record.m_offset);
            writeObjectFileHelper.writeInt(record.m_size);
            writeObjectFileHelper.writeString(record.m_originalName);
            writeObjectFileHelper.writeBoolean(record.m_exported);
            record.m_signature.write(writeObjectFileHelper);
        }
        objectOutputStream.writeInt(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            objectOutputStream.writeObject(entry.getValue());
            objectOutputStream.writeObject(entry.getKey());
        }
        objectOutputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object2 = new DataOutputStream(fileOutputStream);
        byte[] byArray = byteArrayOutputStream2.toByteArray();
        ((DataOutputStream)object2).writeInt(byArray.length);
        ((DataOutputStream)object2).flush();
        fileOutputStream.write(byArray);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        ((FilterOutputStream)object2).close();
    }

    static class Record {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        boolean m_exported;

        Record(FunctionSignature functionSignature, int n2, int n3, String string2, boolean bl) {
            this.m_signature = functionSignature;
            this.m_offset = n2;
            this.m_size = n3;
            this.m_originalName = string2;
            this.m_exported = bl;
        }
    }

    private static class CLP
    extends CommandLineParserSingleInputFile {
        ArrayList m_inputFiles = new ArrayList();
        ArrayList m_outputFiles = new ArrayList();
        XSLTCompilerSettings m_settings = new XSLTCompilerSettings();
        boolean m_dumpXylem = false;

        private CLP() {
        }

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: OverlapDetectionXSLTCompiler\n  [-help | -h | -?]          Prints this message\n  [-command commandfile]     Specifies a newline-delimited file with command line args\n  [-version | -showversion]  Prints the Xylem compiler version\n  [-xslt-version 1.0|2.0]    Specifies the version of XSLT to use\n  [-traceserialization]      Makes the translet insert diagnostic PIs into its output\n  [-dumpxylem]               Dumps out generated Xylem IL\n  [-traceimportsandincludes] Prints out the names/sizes of imported/included stylesheets\n  (input.xsl output.o)+      Compiles input.xsl into output.o\n");
                return -1;
            }
            if ("-command".equals(stringArray[n2])) {
                if (n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-command missing parameter");
                    return -1;
                }
                if (!this.handleCommandOption(stringArray[++n2])) {
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-xslt-version")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                this.m_settings.setVersion(stringArray[n2]);
                if (!stringArray[n2].equals("1.0") && !stringArray[n2].equals("2.0")) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "invalid version: " + stringArray[n2]);
                    return -1;
                }
                return n2;
            }
            if (stringArray[n2].equals("-version")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return -1;
            }
            if (stringArray[n2].equals("-showversion")) {
                System.out.println(RuntimeLibrary.verboseVersionWithCopyright());
                return n2;
            }
            if (stringArray[n2].equals("-dumpxylem")) {
                this.m_dumpXylem = true;
                return n2;
            }
            if (stringArray[n2].equals("-traceserialization")) {
                this.m_settings.setSerializationTraceEnabled(true);
                return n2;
            }
            if (stringArray[n2].equals("-traceimportsandincludes")) {
                this.m_settings.setTraceImportsAndIncludes(true);
                return n2;
            }
            if (n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "input filename " + stringArray[n2] + " missing corrsponding output filename");
                return -1;
            }
            this.m_inputFile = this.validateInputFilename(stringArray[n2], false);
            if (this.m_inputFile == null) {
                return -1;
            }
            this.m_inputFiles.add(this.m_inputFile);
            this.m_outputFiles.add(new File(stringArray[++n2]));
            return n2;
        }
    }
}

