/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XLTXEDesugarer;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.JavaC;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Linker
implements IXylemDriver {
    static final boolean SHOW_CPP_RESULT = false;
    private static final Logger s_logger = LoggerUtil.getLogger(Linker.class);
    private static final String s_className = Linker.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();
    public boolean m_isPerf;
    public boolean m_dumpXylem;
    public CodeGenerationSettings m_codeGenerationSettings = new CodeGenerationSettings();

    public static int parseOptions(XSLTLinkerSettings xSLTLinkerSettings, String[] stringArray, int n2) {
        if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
            System.out.println("\t[-outputdir dir]\n\t[-enabletracing]\n\t[-dumpxylem]\n\t[-dumpintermediatexylem]\n\t[-detectoverlap]\n\t[-classloaderproxy]");
            xSLTLinkerSettings.getCodeGenerationSettings().parseOption(stringArray, n2);
            return -1;
        }
        if ("-classLoaderProxy".equals(stringArray[n2])) {
            xSLTLinkerSettings.setGenerateClassLoadingProxy(true);
            return n2;
        }
        if ("-detectoverlap".equals(stringArray[n2])) {
            xSLTLinkerSettings.setOverlapDetection(true);
            return n2;
        }
        if ("-dumpintermediatexylem".equals(stringArray[n2])) {
            xSLTLinkerSettings.setDumpIntermediateXylem(true);
            return n2;
        }
        if ("-dumpxylem".equals(stringArray[n2])) {
            xSLTLinkerSettings.setDumpXylem(true);
            return n2;
        }
        if ("-enabletracing".equals(stringArray[n2])) {
            xSLTLinkerSettings.getCodeGenerationSettings().setFunctionCallTracing(true);
            return n2;
        }
        if ("-outputdir".equals(stringArray[n2])) {
            if (++n2 == stringArray.length) {
                s_logger.logp(Level.SEVERE, s_className, "parseOptions", "-outputdir missing parameter");
                return -1;
            }
            File file = new File(stringArray[n2]);
            xSLTLinkerSettings.setOutputDir(file);
            if (!file.exists() || !file.isDirectory()) {
                s_logger.logp(Level.SEVERE, s_className, "parseOptions", "specified output directory does not exist or is not a directory: " + file);
                return -1;
            }
            return n2;
        }
        return xSLTLinkerSettings.getCodeGenerationSettings().parseOption(stringArray, n2);
    }

    public static void main(String[] stringArray) {
        Linker linker;
        CLP cLP = new CLP();
        cLP.m_linker = linker = new Linker();
        SessionContext sessionContext = new SessionContext();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        linker.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        linker.m_dumpXylem = linker.m_codeGenerationSettings.m_dumpxylem;
        try {
            File file;
            if (cLP.m_files.size() > 1 || cLP.m_linkerSettings.isOverlapDetection()) {
                s_logger.logp(Level.SEVERE, s_className, "main", "multiple XSLT input files/-functor/-overlapdetection not yet supported");
                System.exit(-1);
            }
            if ((file = linker.linkFiles(cLP.m_files, cLP.m_classNames, null, 0, cLP, sessionContext)) != null && !linker.m_codeGenerationSettings.getJavaCSettings().isJavaCDisabled()) {
                JavaC.compile(file.getParentFile(), new String[]{file.getName()}, linker.m_outputDir, null, linker.m_codeGenerationSettings.getJavaCSettings());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File linkFiles(List list, List list2, Collection collection2, int n2, CLP cLP, SessionContext sessionContext) {
        Module module;
        LinkedList<Module> linkedList = new LinkedList<Module>();
        Iterator iterator = list.iterator();
        try {
            boolean bl;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "linkFiles", "Compiling, and obtaining signature for, runtime library");
            }
            module = (bl = cLP.m_version.equals("1.0")) ? XSLTCompiler.loadRuntimeLibrary(false) : XSLTCompiler.loadRuntimeLibrary(false);
            Program program = new Program();
            program.addModule(module);
            String string2 = module.getName();
            this.m_mss.registerModuleSignature(string2, program.getModuleSignature(string2));
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", exception);
            throw new Error();
        }
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "linkFiles", "linking " + uRL.getPath());
            }
            try {
                module = Module.loadCompiled(uRL, this.m_mss);
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "linkFiles", "", exception);
                throw new Error();
            }
        }
        return this.linkModules(linkedList, list2, collection2, n2, cLP, sessionContext);
    }

    public File linkModules(List list, List list2, Collection collection2, int n2, CLP cLP, SessionContext sessionContext) {
        try {
            boolean bl = cLP.m_version.equals("1.0");
            Module module = bl ? XSLTCompiler.loadRuntimeLibrary(false) : XSLTCompiler.loadRuntimeLibrary(false);
            Module module2 = (Module)list.get(0);
            String string2 = module2.getName();
            XSLTLinker.s_linker.compileProgram(module2, module, 1, string2 == null ? Collections.EMPTY_LIST : Collections.singletonList(string2), string2, cLP.m_linkerSettings, sessionContext);
            File file = new File(module2.getName());
            if (file == null || !file.exists()) {
                System.exit(-1);
            }
            return file;
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "linkModules", "linkModules failure\n", exception);
            System.exit(-1);
            return null;
        }
    }

    protected void desugar(Program program) {
        new XLTXEDesugarer(program).desugar();
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Linker m_linker;
        public String m_version = "1.0";
        public ArrayList m_classNames = new ArrayList();
        public XSLTLinkerSettings m_linkerSettings = new XSLTLinkerSettings(new XSLTCompilerSettings());

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (n2 == 0) {
                this.m_linkerSettings.setCodeGenSettings(this.m_linker.m_codeGenerationSettings);
            }
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: Linker\n\t[-classname name]");
                Linker.parseOptions(this.m_linkerSettings, stringArray, n2);
                System.out.println("\t[-version (1.0 | 2.0)\n");
                System.out.println("\t[-classname name-of-compiled-class]");
                super.parseOption(stringArray, n2);
                System.out.println("Input file should be *.cxo");
                return -1;
            }
            if (stringArray[n2].equals("-classname")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-classname missing parameter");
                    return -1;
                }
                this.m_classNames.add(stringArray[n2]);
                return n2;
            }
            if (stringArray[n2].equals("-version")) {
                if (++n2 == stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-version missing parameter");
                    return -1;
                }
                this.m_version = stringArray[n2];
                return n2;
            }
            if (stringArray[n2].equals("-javac")) {
                s_logger.logp(Level.INFO, s_className, "parseOption", "-javac is now default; use -disablejavac to suppress");
                return n2;
            }
            int n3 = this.m_linker.m_codeGenerationSettings.parseOption(stringArray, n2);
            if (n3 == -1) {
                return -1;
            }
            if (n3 != -2) {
                return n3;
            }
            return super.parseOption(stringArray, n2);
        }
    }
}

