/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.commandline.CommandLineParserMultipleInputFile;
import com.ibm.xltxe.rnm1.xylem.drivers.IXylemDriver;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Compiler
implements IXylemDriver {
    private static final Logger s_logger = LoggerUtil.getLogger(Compiler.class);
    private static final String s_className = Compiler.class.getName();
    public ModuleSignatureStore m_mss;
    public File m_outputDir = new File(".").getAbsoluteFile();

    public static void main(String[] stringArray) {
        CLP cLP = new CLP();
        Compiler compiler = cLP.m_compiler = new Compiler();
        if (!cLP.parseCommandLine(stringArray)) {
            System.exit(-1);
        }
        try {
            cLP.m_signatureSearchPath.addFirst(new File(".").toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        compiler.m_mss = new ModuleSignatureStore(cLP.m_signatureSearchPath);
        try {
            List list = compiler.compileFiles(cLP, null, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List compileFiles(CLP cLP, Collection collection2, boolean bl, boolean bl2) {
        LinkedList<Module> linkedList = new LinkedList<Module>();
        for (URL uRL : cLP.m_files) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileFiles", "compiling " + uRL.getPath());
            }
            try {
                Module module = this.handleFile(uRL, cLP, bl);
                if (!bl2) continue;
                linkedList.add(module);
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "compileFiles", "", exception);
                throw new Error();
            }
        }
        return bl2 ? linkedList : null;
    }

    protected Module handleFile(URL uRL, CLP cLP, boolean bl) {
        String string2;
        String string3 = uRL.toString();
        ModuleSignature moduleSignature = null;
        Module module = null;
        try {
            module = this.compile(uRL, cLP, moduleSignature, cLP.m_signatureSearchPath, this.m_mss);
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred during compilation of " + uRL, exception);
            System.exit(-1);
        }
        if (module.getName().equals("")) {
            string2 = uRL.getPath();
            string2 = string2.substring(string2.lastIndexOf("/") + 1);
            string2 = string2.substring(0, string2.lastIndexOf(".xylem"));
            module.setName(string2);
        }
        if (bl) {
            Object object2;
            string2 = module.getName() + ".cxo";
            try {
                object2 = new File(string2);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream((File)object2));
                Module.writeModule(objectOutputStream, module);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (Exception exception) {
                s_logger.logp(Level.SEVERE, s_className, "handleFile", "Error occurred writing of compiled module to " + string2, exception);
                System.exit(-1);
            }
            object2 = ModuleSignatureStore.makeFilename(module.getName()) + ".cxi";
            Compiler.writeOutSignature(module.m_signature, (String)object2);
        }
        return module;
    }

    public Module compile(URL uRL, CLP cLP, ModuleSignature moduleSignature, List list, ModuleSignatureStore moduleSignatureStore) throws Exception {
        try {
            boolean bl = cLP.m_version.equals("1.0");
            Module module = XSLTCompiler.loadRuntimeLibrary(false);
            XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
            xSLTCompilerSettings.setVersion(cLP.m_version);
            Module module2 = XSLTCompiler.compileStylesheetToModule(uRL, module, null, bl, xSLTCompilerSettings);
            return module2;
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "compile", "Error occurred compiling stylesheet " + uRL, exception);
            return null;
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static final void writeOutSignature(ModuleSignature moduleSignature, String string2, File file) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(file, string2)));
            moduleSignature.write(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "writeOutSignature", "Error occurred writing of compiled signature to " + string2, exception);
            System.exit(-1);
        }
    }

    public static class CLP
    extends CommandLineParserMultipleInputFile {
        public Compiler m_compiler;
        public String m_version = "1.0";

        @Override
        protected int parseOption(String[] stringArray, int n2) {
            if (stringArray[n2].equals("-help") || stringArray[n2].equals("-?") || stringArray[n2].equals("-h")) {
                System.out.println("Usage: Compiler\n\t[-[show]version]\n\t[-xslt-version 1.0|2.0]");
                super.parseOption(stringArray, n2);
                System.out.println("Input files should be be *.xylem or *.xylemi");
                System.out.println("\nRelease: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if ("-version".equals(stringArray[n2]) || "-showversion".equals(stringArray[n2])) {
                System.out.println("Release: Gustav-Mon-Jan-22-06:03:25-EST-2007");
                return -1;
            }
            if (stringArray[n2].equals("-xslt-version")) {
                int n3 = n2 + 1;
                if (n3 >= stringArray.length) {
                    s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version missing parameter");
                    return -1;
                }
                if (stringArray[n3].equals("1.0") || stringArray[n3].equals("2.0")) {
                    this.m_version = stringArray[n3];
                    return n3;
                }
                s_logger.logp(Level.SEVERE, s_className, "parseOption", "-xslt-version bad parameter: " + stringArray[n3]);
                return -1;
            }
            return super.parseOption(stringArray, n2);
        }
    }
}

