/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xslt.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.AutoFunctorizingXSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.TypeSpecializationDerivative;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ZeroArgPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AutoFunctorizingXSLTLinker {
    private static final Logger s_logger = LoggerUtil.getLogger(AutoFunctorizingXSLTLinker.class);
    private static final String s_className = AutoFunctorizingXSLTLinker.class.getName();
    private static final Instruction s_blankInstruction = LiteralInstruction.unitLiteral();

    public static final String compileStylesheetDetectOverlap(URL[] uRLArray, List list, XSLTCompilerSettings xSLTCompilerSettings, XSLTLinkerSettings xSLTLinkerSettings, SourceLoader sourceLoader, boolean bl, SessionContext sessionContext) {
        try {
            Cloneable cloneable;
            AbstractCollection abstractCollection;
            Object object2;
            ArrayList[] arrayListArray;
            Object object4;
            Module module = XSLTCompiler.loadRuntimeLibrary(false);
            Module[] moduleArray = new Module[uRLArray.length];
            Module[] moduleArray2 = new Module[uRLArray.length - 1];
            Module module2 = null;
            HashMap<ArrayList[], ArrayList[]> hashMap = new HashMap<ArrayList[], ArrayList[]>();
            HashMap hashMap2 = new HashMap();
            CodeCompressor codeCompressor = new CodeCompressor();
            for (int i = 0; i < moduleArray.length; ++i) {
                try {
                    moduleArray[i] = XSLTCompiler.compileStylesheetToModule(uRLArray[i], module, null, false, xSLTCompilerSettings, sourceLoader, bl);
                    moduleArray[i].typeCheck(false);
                    if (i > 0) {
                        AutoFunctorizingXSLTLinker.renameTypeSpecializedFunctions(moduleArray[i], moduleArray, hashMap2);
                        moduleArray[i].removeFunctionDerivativeInformation();
                        moduleArray[i].removeDeadFunctions();
                    } else {
                        AutoFunctorizingXSLTLinker.renameTypeSpecializedFunctions(moduleArray[i], moduleArray, hashMap2);
                        module2 = moduleArray[i];
                    }
                    moduleArray[i].optimize(codeCompressor);
                    if (xSLTLinkerSettings.isDumpXylem()) {
                        object4 = i < list.size() ? (String)list.get(i) : moduleArray[i].getName();
                        Program.dumpXylemFile(moduleArray[i], xSLTLinkerSettings.getOutputDir(), (String)object4, "autofunc" + i);
                    }
                }
                catch (Exception exception) {
                    s_logger.logp(Level.SEVERE, s_className, "compileStylesheetDetectOverlap", "", exception);
                }
                if (moduleArray[i] == null) {
                    return null;
                }
                if (i <= 0) continue;
                moduleArray2[i - 1] = moduleArray[i];
            }
            codeCompressor = null;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileStylesheetDetectOverlap", "Performing overlap detection");
            }
            XSLTLinker.consolidateXDMTables(moduleArray2, module2, sessionContext);
            module2.removeDeadFunctions();
            HashMap hashMap3 = new HashMap();
            object4 = new HashMap();
            for (int i = 0; i < moduleArray.length; ++i) {
                for (Function object32 : moduleArray[i].getFunctions()) {
                    if (object32.getName().equals("main")) {
                        object32.setName("main-functor");
                    } else if (!object32.getName().equals("setupOutput")) {
                        if (!object32.getName().equals("whitespaceRules")) {
                            if (!object32.getName().equals("setupCharacterMaps") && !object32.getName().equals("get-ns-prefix-counter") && moduleArray[i].getFunctionSignature(object32.getName()) != null) continue;
                        }
                    }
                    arrayListArray = AutoFunctorizingXSLTLinker.makeFunctionSignature(object32);
                    object2 = (ArrayList[])hashMap.get(arrayListArray);
                    if (object2 == null) {
                        abstractCollection = new ArrayList();
                        cloneable = new ArrayList();
                        object2 = new ArrayList[]{abstractCollection, cloneable};
                        hashMap.put(arrayListArray, (ArrayList[])object2);
                    } else {
                        abstractCollection = object2[0];
                        cloneable = object2[1];
                    }
                    ((ArrayList)abstractCollection).add((Function)object32);
                    ((ArrayList)cloneable).add(new Integer(i));
                    AutoFunctorizingXSLTLinker.scanForFunctionCalls(object32, hashMap3, (HashMap)object4, moduleArray[i]);
                    AutoFunctorizingXSLTLinker.augmentFunction(object32);
                }
            }
            object4 = null;
            Statistics statistics = new Statistics(moduleArray);
            int n2 = moduleArray.length;
            moduleArray = null;
            moduleArray2 = null;
            Iterator iterator = hashMap.keySet().iterator();
            abstractCollection = new HashSet();
            cloneable = new HashMap();
            while (iterator.hasNext()) {
                Object object3;
                object2 = (FunctionSignature)iterator.next();
                arrayListArray = (ArrayList[])hashMap.get(object2);
                ArrayList arrayList = arrayListArray[0];
                ArrayList arrayList2 = arrayListArray[1];
                Function function2 = (Function)arrayList.get(0);
                boolean bl2 = false;
                if (function2.getName().equals("build_key")) {
                    bl2 = true;
                }
                if (arrayList.size() > 1) {
                    Object object5;
                    Instruction[] instructionArray;
                    object3 = new int[arrayList.size()];
                    Iterator iterator2 = arrayList2.iterator();
                    int n3 = 0;
                    while (iterator2.hasNext()) {
                        instructionArray = (Instruction[])iterator2.next();
                        object3[n3++] = instructionArray.intValue();
                    }
                    instructionArray = new Instruction[arrayList.size()];
                    TypeEnvironment[] typeEnvironmentArray = new TypeEnvironment[arrayList.size()];
                    int n4 = 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (function2.getComment() != null) {
                        stringBuffer.append(function2.getComment());
                    }
                    stringBuffer.append('\n');
                    iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        object5 = (Function)iterator2.next();
                        stringBuffer.append("// ");
                        stringBuffer.append(";; merged from ");
                        stringBuffer.append(((Function)object5).getName());
                        stringBuffer.append(" in ");
                        stringBuffer.append(((Function)object5).getTypeEnvironment().getModule().getName());
                        stringBuffer.append('\n');
                        typeEnvironmentArray[n4] = ((Function)object5).getTypeEnvironment();
                        instructionArray[n4++] = ((Function)object5).getBody();
                    }
                    object5 = new int[1];
                    Instruction instruction2 = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(instructionArray, true, module2, function2, (int[])object3, n2, bl2, (int[])object5);
                    statistics.add((FunctionSignature)object2, (int[])object3, (int)object5[0]);
                    function2.setBody(instruction2);
                    function2.setComment(stringBuffer.toString());
                    iterator2 = arrayList.iterator();
                    iterator2.next();
                    while (iterator2.hasNext()) {
                        Function function3 = (Function)iterator2.next();
                        function3.setBody(null);
                        function3.m_bindingEnvironment = null;
                        function3.removeDerivativeInformation();
                    }
                    typeEnvironmentArray = null;
                    instructionArray = null;
                } else {
                    statistics.addUnique((FunctionSignature)object2, (Integer)arrayList2.get(0));
                }
                object3 = function2.getName();
                while (((HashSet)abstractCollection).contains(object3)) {
                    object3 = (String)object3 + "_$_";
                }
                ((HashSet)abstractCollection).add(object3);
                if (!((String)object3).equals(function2.getName())) {
                    ((HashMap)cloneable).put(object2, object3);
                    function2.setName((String)object3);
                }
                module2.addFunction(function2, false);
                iterator.remove();
            }
            statistics.summarize();
            abstractCollection = null;
            hashMap = null;
            Object var18_25 = null;
            AutoFunctorizingXSLTLinker.handleStandardExports(module2);
            AutoFunctorizingXSLTLinker.replaceFunctionCalls(module2, cloneable, hashMap3);
            cloneable = null;
            hashMap3 = null;
            module2.clearTypeInformation(true);
            module2.removeFunctionDerivativeInformation();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "compileStylesheetDetectOverlap", "Autofunctorization complete");
            }
            module2.optimize(new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction instruction2) {
                    if (instruction2 instanceof IdentifierReferenceInstruction) {
                        return ((IdentifierReferenceInstruction)instruction2).makeIdentifierInstruction();
                    }
                    return instruction2;
                }
            });
            XSLTCompiler.postASTProcessing(module2, null, xSLTCompilerSettings.getPrereductionSplitLimit(), xSLTCompilerSettings.isStreamResultOnly());
            XSLTLinker.s_linker.compileProgram(module2, module, uRLArray.length, list, module2.getName(), xSLTLinkerSettings, sessionContext);
            return module2.getName();
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "compileStylesheetDetectOverlap", "", exception);
            return null;
        }
    }

    public static String compileStylesheetDetectOverlap(URL[] uRLArray, List list, XSLTCompilerSettings xSLTCompilerSettings, XSLTLinkerSettings xSLTLinkerSettings, SessionContext sessionContext) {
        return AutoFunctorizingXSLTLinker.compileStylesheetDetectOverlap(uRLArray, list, xSLTCompilerSettings, xSLTLinkerSettings, null, false, sessionContext);
    }

    public static void handleStandardExports(Module module) {
        Function function2;
        Function function3 = module.getFunction("main-functor");
        Instruction[] instructionArray = new Instruction[function3.m_parameters.length];
        Binding[] bindingArray = new Binding[function3.m_parameters.length];
        for (int i = 0; i < function3.m_parameters.length; ++i) {
            instructionArray[i] = new IdentifierInstruction(function3.m_parameters[i].getName());
            bindingArray[i] = (Binding)function3.m_parameters[i].clone();
        }
        Function function4 = new Function("main", bindingArray, new FunctionCallInstruction("main-functor", instructionArray));
        module.addFunction(function4, false);
        module.forceFunctionGeneration(module.getFunction("main"));
        module.forceFunctionGeneration(module.getFunction("setupOutput"));
        module.forceFunctionGeneration(module.getFunction("whitespaceRules"));
        Function function5 = module.getFunction("setupCharacterMaps");
        if (function5 != null) {
            module.forceFunctionGeneration(module.getFunction("setupCharacterMaps"));
        }
        if ((function2 = module.getFunction("get-ns-prefix-counter")) != null) {
            module.forceFunctionGeneration(function2);
        }
    }

    public static void replaceFunctionCalls(Module module, final HashMap hashMap, final HashMap hashMap2) {
        module.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                FunctionCallInstruction functionCallInstruction;
                FunctionSignature functionSignature;
                if (instruction2 instanceof FunctionCallInstruction && (functionSignature = (FunctionSignature)hashMap2.get((functionCallInstruction = (FunctionCallInstruction)instruction2).getFunction())) != null) {
                    String string2 = (String)hashMap.get(functionSignature);
                    if (string2 != null) {
                        functionCallInstruction.setFunction(string2);
                    } else {
                        functionCallInstruction.setFunction(functionSignature.getFunctionName());
                    }
                }
                return super.optimizeStep(instruction2);
            }
        });
    }

    public static final void compileFunctorAppliedStylesheets(URL uRL, URL[] uRLArray, URL uRL2, XSLTCompilerSettings xSLTCompilerSettings, SourceLoader sourceLoader, boolean bl, SessionContext sessionContext) {
        try {
            XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
            if (null != sourceLoader) {
                xSLTCompiler.setSourceLoader(sourceLoader);
            }
            Module module = xSLTCompiler.loadRuntimeLibrary();
            ModuleSignature moduleSignature = AutoFunctorizingXSLTCompiler.parseSignatureFile(uRL2);
            Module[] moduleArray = new Module[uRLArray.length];
            for (int i = 0; i < uRLArray.length; ++i) {
                moduleArray[i] = XSLTCompiler.compileStylesheetToModule(uRLArray[i], module, moduleSignature, true, xSLTCompilerSettings, sourceLoader, bl);
                if (moduleArray[i] != null) continue;
                return;
            }
            Functor functor = AutoFunctorizingXSLTCompiler.compileToFunctor("functor", uRL, module, moduleSignature, sessionContext);
            XSLTLinker.s_linker.compileProgram(functor, moduleArray, module, xSLTCompiler.getLinkerSettings());
        }
        catch (Exception exception) {
            s_logger.logp(Level.SEVERE, s_className, "compileFunctorAppliedStylesheets", "", exception);
        }
    }

    public static void compileFunctorAppliedStylesheets(URL uRL, URL[] uRLArray, URL uRL2, XSLTCompilerSettings xSLTCompilerSettings, SessionContext sessionContext) {
        AutoFunctorizingXSLTLinker.compileFunctorAppliedStylesheets(uRL, uRLArray, uRL2, xSLTCompilerSettings, null, false, sessionContext);
    }

    protected static final FunctionSignature makeFunctionSignature(Function function2) {
        String string2 = function2.getName();
        Type type2 = function2.getReturnType();
        Binding[] bindingArray = function2.m_parameters;
        int n2 = 0;
        if (bindingArray.length > 0 && bindingArray[0].getName().equals("__functorindex__")) {
            n2 = 1;
        }
        Type[] typeArray = new Type[bindingArray.length - n2];
        Object[] objectArray = new Object[typeArray.length];
        for (int i = n2; i < bindingArray.length; ++i) {
            typeArray[i - n2] = bindingArray[i].getBindingType();
            objectArray[i - n2] = "x" + (i - n2);
        }
        return new FunctionSignature(string2, objectArray, typeArray, type2);
    }

    protected static final void scanForFunctionCalls(Function function2, final HashMap hashMap, final HashMap hashMap2, final Module module) {
        new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                if (instruction2 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                    FunctionSignature functionSignature = AutoFunctorizingXSLTLinker.makeFunctionSignature(module.getFunction(functionCallInstruction.getFunction()));
                    String string2 = (String)hashMap2.get(functionSignature);
                    if (string2 == null) {
                        string2 = Integer.toString(hashMap.size());
                        hashMap.put(string2, functionSignature);
                        hashMap2.put(functionSignature, string2);
                    }
                    functionCallInstruction.setFunction(string2);
                }
                return instruction2;
            }
        }.optimizeFunction(function2);
    }

    protected static final Instruction foldTogetherStreams(Instruction[] instructionArray, int[] nArray, int n2, boolean bl) {
        int n3;
        int n4 = -1;
        int n5 = -1;
        boolean bl2 = true;
        boolean bl3 = true;
        String string2 = null;
        for (int i = 0; i < instructionArray.length; ++i) {
            if (!(instructionArray[i] instanceof StreamInstruction)) {
                return null;
            }
            StreamInstruction streamInstruction = (StreamInstruction)instructionArray[i];
            if (n4 == -1 || streamInstruction.getChildInstructionCount() < n4) {
                n4 = instructionArray[i].getChildInstructionCount();
            }
            if (n5 == -1 || streamInstruction.getChildInstructionCount() > n5) {
                n5 = instructionArray[i].getChildInstructionCount();
            }
            if (!streamInstruction.isString()) {
                bl2 = false;
                continue;
            }
            if (!bl2) continue;
            if (string2 == null) {
                string2 = streamInstruction.getStringContent();
                continue;
            }
            if (string2.equals(streamInstruction.getStringContent())) continue;
            bl3 = false;
        }
        if (bl2) {
            if (bl3) {
                return instructionArray[0];
            }
            return null;
        }
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        block1: for (int i = 0; i < n4; ++i) {
            boolean bl4 = true;
            n3 = 1;
            Instruction[] instructionArray2 = new Instruction[instructionArray.length];
            for (int j = 0; j < instructionArray.length; ++j) {
                instructionArray2[j] = instructionArray[j].getChildInstruction(i);
                if (instructionArray2[j].getCachedType() instanceof StreamType) {
                    n3 = 0;
                } else {
                    bl4 = false;
                }
                if (!bl4 && n3 == 0) break block1;
            }
            Instruction instruction2 = AutoFunctorizingXSLTLinker.foldTogether(instructionArray2, nArray, n2, bl);
            if (instruction2 == null) break;
            arrayList.add(instruction2);
        }
        Type type2 = ((StreamType)((StreamInstruction)instructionArray[0]).getCachedType()).getElementType();
        if (arrayList.size() < n5) {
            ArrayList[] arrayListArray = new ArrayList[instructionArray.length];
            for (n3 = 0; n3 < instructionArray.length; ++n3) {
                arrayListArray[n3] = new ArrayList();
            }
            for (n3 = arrayList.size(); n3 < n5; ++n3) {
                for (int i = 0; i < instructionArray.length; ++i) {
                    if (n3 >= instructionArray[i].getChildInstructionCount()) continue;
                    arrayListArray[i].add(instructionArray[i].getChildInstruction(n3));
                }
            }
            Instruction[] instructionArray3 = new Instruction[instructionArray.length];
            for (int i = 0; i < instructionArray.length; ++i) {
                StreamInstruction streamInstruction = new StreamInstruction(type2, arrayListArray[i]);
                instructionArray3[i] = streamInstruction;
            }
            Instruction instruction3 = AutoFunctorizingXSLTLinker.foldTogether(instructionArray3, false, nArray, n2, bl);
            arrayList.add(instruction3 == null ? AutoFunctorizingXSLTLinker.makeChoice(instructionArray3, nArray, n2) : instruction3);
        }
        StreamInstruction streamInstruction = new StreamInstruction(type2, arrayList);
        return streamInstruction;
    }

    protected static final Instruction areCompatible(Instruction[] instructionArray) {
        int n2 = -1;
        Instruction instruction2 = null;
        for (int i = 0; i < instructionArray.length; ++i) {
            if (n2 == -1) {
                n2 = instructionArray[i].getChildInstructionCount();
            } else if (n2 != instructionArray[i].getChildInstructionCount()) {
                return null;
            }
            if (i > 0) {
                for (int j = 0; j < n2; ++j) {
                    Instruction instruction3;
                    Type type2;
                    Type type3 = instructionArray[0].getChildInstruction(j).getCachedType();
                    if (type3 == null) {
                        type3 = IntType.s_intType;
                    }
                    if ((type2 = (instruction3 = instructionArray[i].getChildInstruction(j)).getCachedType()) == null) {
                        type2 = IntType.s_intType;
                    }
                    if (type3.equals(type2)) continue;
                    return null;
                }
            }
            Instruction instruction4 = instructionArray[i].cloneShallow();
            for (int j = 0; j < n2; ++j) {
                instruction4.setChildInstruction(j, s_blankInstruction);
            }
            instruction4.clearTypeInformation();
            if (instruction2 == null) {
                instruction2 = instruction4;
                continue;
            }
            if (!instruction2.getClass().equals(instruction4.getClass())) {
                return null;
            }
            if (!(instruction2 instanceof LetInstruction ? !((LetInstruction)instruction4).getVariable().equals(((LetInstruction)instruction2).getVariable()) : !instruction2.equals(instruction4))) continue;
            return null;
        }
        return instruction2;
    }

    public static final Instruction foldTogetherOrMakeChoice(Instruction[] instructionArray, boolean bl, Module module, Function function2, int[] nArray, int n2, boolean bl2, int[] nArray2) {
        Instruction instruction2;
        Instruction instruction3 = instruction2 = bl2 ? null : AutoFunctorizingXSLTLinker.foldTogether(instructionArray, nArray, n2, bl2);
        if (instruction2 == null) {
            if (nArray2 != null) {
                nArray2[0] = 0;
            }
            instruction2 = AutoFunctorizingXSLTLinker.makeChoice(instructionArray, nArray, n2);
            if (bl2 || bl) {
                MatchInstruction matchInstruction = (MatchInstruction)instruction2;
                MatchInstruction.Match[] matchArray = matchInstruction.getMatches();
                for (int i = 0; i < matchArray.length; ++i) {
                    Function function3 = new Function(function2.generateNewFixupName(), (Binding[])function2.m_parameters.clone(), matchArray[i].getHandler());
                    module.addFunction(function3);
                    Instruction[] instructionArray2 = new Instruction[function2.m_parameters.length];
                    for (int j = 0; j < instructionArray2.length; ++j) {
                        instructionArray2[j] = new IdentifierInstruction(function2.m_parameters[j].getName());
                    }
                    matchArray[i].setHandler(new FunctionCallInstruction(function3.getName(), instructionArray2));
                }
            }
        } else if (nArray2 != null) {
            nArray2[0] = 1;
        }
        return instruction2;
    }

    protected static final Instruction foldTogether(Instruction[] instructionArray, int[] nArray, int n2, boolean bl) {
        return AutoFunctorizingXSLTLinker.foldTogether(instructionArray, true, nArray, n2, bl);
    }

    protected static final Instruction foldTogether(Instruction[] instructionArray, boolean bl, int[] nArray, int n2, boolean bl2) {
        if (bl && instructionArray[0] instanceof StreamInstruction) {
            return AutoFunctorizingXSLTLinker.foldTogetherStreams(instructionArray, nArray, n2, bl2);
        }
        Instruction instruction2 = AutoFunctorizingXSLTLinker.areCompatible(instructionArray);
        if (instruction2 != null) {
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                Instruction[] instructionArray2 = new Instruction[instructionArray.length];
                for (int j = 0; j < instructionArray.length; ++j) {
                    instructionArray2[j] = instructionArray[j].getChildInstruction(i);
                }
                instruction2.setChildInstruction(i, AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice(instructionArray2, false, null, null, nArray, n2, bl2, null));
            }
            return instruction2;
        }
        return null;
    }

    protected static final boolean areEquivalent(Instruction[] instructionArray) {
        Instruction instruction2 = AutoFunctorizingXSLTLinker.areCompatible(instructionArray);
        if (instruction2 != null) {
            for (int i = 0; i < instruction2.getChildInstructionCount(); ++i) {
                Instruction[] instructionArray2 = new Instruction[instructionArray.length];
                for (int j = 0; j < instructionArray.length; ++j) {
                    instructionArray2[j] = instructionArray[j].getChildInstruction(i);
                }
                if (AutoFunctorizingXSLTLinker.areEquivalent(instructionArray2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static final Instruction makeChoice(Instruction[] instructionArray, int[] nArray, int n2) {
        Object object2;
        Iterator iterator;
        Iterator iterator2;
        Object[] objectArray;
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block0: for (int i = 0; i < instructionArray.length; ++i) {
            Object object3;
            objectArray = new Integer(i);
            iterator2 = arrayList.iterator();
            iterator = arrayList2.iterator();
            while (iterator2.hasNext()) {
                object3 = (Instruction)iterator2.next();
                object2 = (ArrayList)iterator.next();
                if (!AutoFunctorizingXSLTLinker.areEquivalent(new Instruction[]{instructionArray[i], object3})) continue;
                ((ArrayList)object2).add(objectArray);
                continue block0;
            }
            arrayList.add(instructionArray[i]);
            object3 = new ArrayList();
            ((ArrayList)object3).add(objectArray);
            arrayList2.add(object3);
        }
        MatchInstruction.Match[] matchArray = new MatchInstruction.Match[arrayList.size()];
        objectArray = new Instruction[n2];
        Arrays.fill(objectArray, LiteralInstruction.integerLiteral(-1));
        iterator2 = arrayList.iterator();
        iterator = arrayList2.iterator();
        int n3 = 0;
        while (iterator2.hasNext()) {
            object2 = (Instruction)iterator2.next();
            ArrayList arrayList3 = (ArrayList)iterator.next();
            Iterator iterator3 = arrayList3.iterator();
            while (iterator3.hasNext()) {
                objectArray[nArray[((Integer)iterator3.next()).intValue()]] = LiteralInstruction.integerLiteral(n3);
            }
            matchArray[n3] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(n3), (Instruction)object2);
            ++n3;
        }
        return new MatchInstruction((Instruction)new StreamElementInstruction(new StreamInstruction((Type)IntType.s_intType, (Instruction[])objectArray), new IdentifierInstruction("__functorindex__")), matchArray, null);
    }

    protected static final void augmentFunction(Function function2) {
        new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                if (instruction2 instanceof FunctionCallInstruction) {
                    FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction2;
                    Instruction[] instructionArray = new Instruction[instruction2.getChildInstructionCount() + 1];
                    System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 1, functionCallInstruction.m_parameters.length);
                    instructionArray[0] = new IdentifierInstruction("__functorindex__");
                    functionCallInstruction.m_parameters = instructionArray;
                }
                return super.optimizeStep(instruction2);
            }
        }.optimizeFunction(function2);
        Binding[] bindingArray = new Binding[function2.m_parameters.length + 1];
        System.arraycopy(function2.m_parameters, 0, bindingArray, 1, function2.m_parameters.length);
        bindingArray[0] = new Binding((Object)"__functorindex__", IntType.s_intType);
        function2.m_parameters = bindingArray;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "augmentFunction", function2.getName() + " has " + function2.m_parameters.length + " parameters");
        }
    }

    protected static final void renameTypeSpecializedFunctions(Module module, Module[] moduleArray, HashMap hashMap) {
        final HashMap<String, String> hashMap2 = new HashMap<String, String>();
        module.removeDeadFunctions();
        for (Function function2 : new ArrayList<Function>(module.getFunctions())) {
            Function function3;
            Object object2 = function2.getDerivationKey();
            if (object2 == null || !(object2 instanceof TypeSpecializationDerivative)) continue;
            Function function4 = function2.getOriginalFunction();
            Object var8_8 = null;
            HashMap<Object, Function> hashMap3 = (HashMap<Object, Function>)hashMap.get(function4.getName());
            if (hashMap3 == null) {
                hashMap3 = new HashMap<Object, Function>();
                hashMap.put(function4.getName(), hashMap3);
            }
            if ((function3 = (Function)hashMap3.get(object2)) == null) {
                function3 = function2;
                hashMap3.put(object2, function3);
            }
            hashMap2.put(function2.getName(), function3.getName());
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "renameTypeSpecializedFunctions", "renamed " + function2.getName() + " to " + function3.getName());
            }
            module.renameFunction(function2, function3.getName());
            if (function2 == function3) continue;
            AutoFunctorizingXSLTLinker.renameMismatchedParams(function2, function3.m_parameters);
        }
        module.optimize(new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction instruction2) {
                FunctionCallInstruction functionCallInstruction;
                String string2;
                if (instruction2 instanceof FunctionCallInstruction && (string2 = (String)hashMap2.get((functionCallInstruction = (FunctionCallInstruction)instruction2).getFunction())) != null) {
                    functionCallInstruction.setFunction(string2);
                }
                return super.optimizeStep(instruction2);
            }
        });
    }

    public static void renameMismatchedParams(Function function2, Binding[] bindingArray) {
        final HashMap<Object, Binding> hashMap = new HashMap<Object, Binding>();
        for (int i = 0; i < function2.m_parameters.length; ++i) {
            if (function2.m_parameters[i].getName().equals(bindingArray[i].getName())) continue;
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "renameMismatchedParams", "renaming " + function2.m_parameters[i] + " to " + bindingArray[i].getName());
            }
            hashMap.put(function2.m_parameters[i].getName(), function2.m_parameters[i]);
            function2.m_parameters[i].setName(bindingArray[i].getName());
        }
        if (hashMap.size() > 0) {
            new Optimizer(){

                @Override
                protected Instruction optimizeStep(Instruction instruction2) {
                    Object object2;
                    Binding binding;
                    if (instruction2 instanceof IdentifierInstruction && (binding = (Binding)hashMap.get(object2 = ((IdentifierInstruction)instruction2).getVariable())) != null && instruction2.getBindingEnvironment().getVariableBinding(object2) == binding) {
                        IdentifierInstruction identifierInstruction = new IdentifierInstruction(binding.getName());
                        identifierInstruction.setCachedType(binding.getBindingType());
                        identifierInstruction.setBindingEnvironment(instruction2.getBindingEnvironment());
                        return identifierInstruction;
                    }
                    return instruction2;
                }
            }.optimizeFunction(function2);
        }
    }

    public static class Statistics {
        String[] m_modules;
        int m_total = 0;
        final HashMap m_counts = new HashMap();
        final HashMap m_goodCounts = new HashMap();
        final List[] m_uniqueFunctions;

        public Statistics(Module[] moduleArray) {
            this.m_modules = new String[moduleArray.length];
            this.m_uniqueFunctions = new List[moduleArray.length];
            for (int i = 0; i < moduleArray.length; ++i) {
                this.m_modules[i] = moduleArray[i].getName();
                this.m_uniqueFunctions[i] = new LinkedList();
            }
        }

        public Statistics(String[] stringArray) {
            this.m_modules = new String[stringArray.length];
            this.m_uniqueFunctions = new List[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_modules[i] = stringArray[i];
                this.m_uniqueFunctions[i] = new LinkedList();
            }
        }

        private void incr(Object object2, HashMap hashMap) {
            Integer n2 = (Integer)hashMap.get(object2);
            n2 = n2 == null ? new Integer(1) : new Integer(n2 + 1);
            hashMap.put(object2, n2);
        }

        public void addUnique(FunctionSignature functionSignature, int n2) {
            this.incr(this.m_modules[n2], this.m_counts);
            ++this.m_total;
        }

        public void add(FunctionSignature functionSignature, int[] nArray, int n2) {
            ++this.m_total;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(this.m_modules[nArray[i]]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append(',');
            }
            String string2 = stringBuffer.toString();
            this.incr(string2, this.m_counts);
            if (n2 > 0) {
                this.incr(string2, this.m_goodCounts);
            }
        }

        public void summarize() {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "=== Overlap Detection SUMMARY ===");
            }
            ArrayList arrayList = new ArrayList(this.m_counts.keySet());
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object2, Object object3) {
                    object2 = Statistics.this.m_counts.get(object2);
                    object3 = Statistics.this.m_counts.get(object3);
                    if (object2 == null && object3 == null) {
                        return 0;
                    }
                    if (object2 == null) {
                        return -1;
                    }
                    if (object3 == null) {
                        return 1;
                    }
                    return ((Integer)object2).compareTo((Integer)object3);
                }
            });
            Collections.reverse(arrayList);
            Iterator iterator = arrayList.iterator();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "" + this.m_total + " total signatures");
            }
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Integer n2 = (Integer)this.m_counts.get(e);
                Integer n3 = (Integer)this.m_goodCounts.get(e);
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "summarize", n2 + " functions common to " + e);
                }
                if (n3 == null || !LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                s_logger.logp(Level.FINER, s_className, "summarize", " of which " + n3 + " could be merged");
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "summarize", "=================================");
            }
        }
    }

    public static class CodeCompressor
    extends PostOrderOptimizer {
        protected HashMap m_identifierMap = new HashMap();

        @Override
        public void optimizeFunction(Function function2) {
            if (function2.hasBeenTypeChecked() && !function2.getTypeEnvironment().getModule().m_signature.containsFunction(function2.getName())) {
                super.optimizeFunction(function2);
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction instruction2) {
            StreamInstruction streamInstruction;
            TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
            if (instruction2 instanceof CoerceInstruction) {
                Type type2;
                CoerceInstruction coerceInstruction = (CoerceInstruction)instruction2;
                Instruction instruction3 = coerceInstruction.getOperand();
                Type type3 = coerceInstruction.getType().resolveType(typeEnvironment);
                if (type3.equals(type2 = instruction3.getCachedType().resolveType(typeEnvironment))) {
                    return instruction3;
                }
            } else if (instruction2 instanceof AssertTypeInstruction) {
                AssertTypeInstruction assertTypeInstruction = (AssertTypeInstruction)instruction2;
                Instruction instruction4 = assertTypeInstruction.getOperand();
                if (assertTypeInstruction.getType().equals(instruction4.getCachedType().resolveType(typeEnvironment))) {
                    return instruction4;
                }
            } else if (instruction2 instanceof IdentifierInstruction) {
                IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction2;
                Type type4 = identifierInstruction.getCachedType();
                Type type5 = type4.resolveType(typeEnvironment);
                if (type5 != null) {
                    NameTypePair nameTypePair = new NameTypePair(identifierInstruction.getVariable(), type5);
                    IdentifierReferenceInstruction identifierReferenceInstruction = (IdentifierReferenceInstruction)this.m_identifierMap.get(nameTypePair);
                    if (identifierReferenceInstruction == null) {
                        identifierReferenceInstruction = new IdentifierReferenceInstruction(nameTypePair.m_name, nameTypePair.m_type);
                        this.m_identifierMap.put(nameTypePair, identifierReferenceInstruction);
                    }
                    return identifierReferenceInstruction;
                }
            } else if (instruction2 instanceof StreamInstruction && !(streamInstruction = (StreamInstruction)instruction2).isStoredAsString() && streamInstruction.getChildInstructionCount() == 1 && streamInstruction.getChildInstruction(0).getCachedType().resolveType(typeEnvironment).equals(streamInstruction.getCachedType().resolveType(typeEnvironment))) {
                return streamInstruction.getChildInstruction(0);
            }
            return super.optimizeStep(instruction2);
        }

        public static final class NameTypePair {
            public Object m_name;
            public Type m_type;

            public NameTypePair(Object object2, Type type2) {
                this.m_name = object2;
                this.m_type = type2;
                if (this.m_type == null) {
                    throw new IllegalArgumentException();
                }
            }

            public int hashCode() {
                return this.m_name.hashCode() + this.m_type.hashCode();
            }

            public boolean equals(Object object2) {
                if (!(object2 instanceof NameTypePair)) {
                    return false;
                }
                NameTypePair nameTypePair = (NameTypePair)object2;
                return nameTypePair.m_name.equals(this.m_name) && nameTypePair.m_type.equals(this.m_type);
            }
        }
    }

    public static final class IdentifierReferenceInstruction
    extends ZeroArgPrimopInstruction {
        protected Type m_type;
        protected Object m_name;

        protected IdentifierReferenceInstruction(Object object2, Type type2) {
            this.setCachedType(type2);
            this.m_name = object2;
            this.m_type = type2;
        }

        @Override
        public String innerToString() {
            return "identifier-ref@" + this.m_type.prettyPrint() + " " + this.m_name;
        }

        public IdentifierInstruction makeIdentifierInstruction() {
            return new IdentifierInstruction(this.m_name);
        }

        @Override
        public Instruction cloneWithoutTypeInformation() {
            return this;
        }

        @Override
        public Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object2) {
            return object2 != null && object2 instanceof IdentifierReferenceInstruction && ((IdentifierReferenceInstruction)object2).m_name.equals(this.m_name);
        }
    }
}

