/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.drivers.StarletLoader;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIPreparer;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiledExecutable;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathCompiler;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathInterpretedExecutable;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StackFrameAnalyzer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XCompilationParameters;
import com.ibm.xml.xci.NodeTest;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.StaticContext;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;

public class XPathPreparer
extends AbstractSPIPreparer {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathPreparer.class);
    private static final String s_className = XPathPreparer.class.getName();
    public static final String OPTION_JAVASOURCEDESTDIRS;
    public static final String JAVADESTDIR_OPTION = "javeDestDir";
    public static final boolean JAVASOURCEDESTDIRSPECIFIED;

    public XPathPreparer(SessionContext sessionContext) {
        super(sessionContext);
    }

    @Override
    public boolean compile(Source source, File file, StaticContext staticContext, String string2, int n2) {
        String string3 = this.getStringFromSource(source);
        if (string3 != null) {
            return this.compile(string3, file, staticContext, string2, n2, source);
        }
        return false;
    }

    @Override
    public boolean compile(String string2, File file, StaticContext staticContext, String string3, int n2) {
        return this.compile(string2, file, staticContext, string3, n2, null);
    }

    private boolean compile(String string2, File file, StaticContext staticContext, String string3, int n2, Source source) {
        if (string2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "compile", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "COMPILE_XPATH", new Object[]{Version.getVersion(), string2});
        }
        ErrorHandler errorHandler = this.getErrorHandler(staticContext);
        XTQStaticContext xTQStaticContext = this.getXTQStaticContext(staticContext, source);
        try {
            XPathCompiler xPathCompiler = this.createParserAndCompiler(source, xTQStaticContext, errorHandler);
            xPathCompiler.setClassName(this.getClassName(string3));
            xPathCompiler.setDestDirectory(file.getAbsolutePath());
            xPathCompiler.setOutputType(1);
            xPathCompiler.setGenerateBCEL(!xTQStaticContext.getJavaSourceFeature());
            xPathCompiler.setInterpreted(false);
            xPathCompiler.setSplitLimit(0);
            xPathCompiler.setEmitAutoSplitWarning(false);
            if (staticContext.getPackageName() != null) {
                xPathCompiler.setPackageName(staticContext.getPackageName());
            }
            return xPathCompiler.compile(string2, null, this.getSessionContext());
        }
        catch (HandledRuntimeException handledRuntimeException) {
            if (handledRuntimeException.getRuntimeException() != null) {
                throw handledRuntimeException.getRuntimeException();
            }
        }
        catch (Exception exception) {
            XPathPreparer.reportException(staticContext, exception);
        }
        return false;
    }

    @Override
    public Executable load(String string2) throws ClassNotFoundException {
        String string3 = this.getClassName(string2);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XPATH", new Object[]{string3});
        }
        Class clazz = StarletLoader.loadStarlet(string3, null);
        return new XPathCompiledExecutable(clazz, this.m_session);
    }

    @Override
    public Executable load(XCompilationParameters xCompilationParameters) throws ClassNotFoundException {
        String string2 = this.getQualifiedClassName(xCompilationParameters);
        if (s_logger.isLoggable(Level.CONFIG)) {
            s_logger.logrb(Level.CONFIG, s_className, "load", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "LOAD_XPATH", new Object[]{string2});
        }
        Class clazz = StarletLoader.loadStarlet(string2, xCompilationParameters.getClassLoader());
        return new XPathCompiledExecutable(clazz, this.m_session);
    }

    public static void directJavaSourceToDirectory(XPathCompiler xPathCompiler) {
        if (JAVASOURCEDESTDIRSPECIFIED) {
            File file = new File(OPTION_JAVASOURCEDESTDIRS);
            file.mkdir();
            xPathCompiler.setDestDirectory(OPTION_JAVASOURCEDESTDIRS);
        }
    }

    @Override
    public Executable prepare(String string2, StaticContext staticContext, int n2) {
        return this.prepare(string2, staticContext, n2, null);
    }

    private Executable prepare(String string2, StaticContext staticContext, int n2, Source source) {
        Object object2;
        if (string2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ERR_NULL_EXPRESSION", null));
        }
        ErrorHandler errorHandler = this.getErrorHandler(staticContext);
        XTQStaticContext xTQStaticContext = this.getXTQStaticContext(staticContext, source);
        boolean bl = xTQStaticContext.getCompileFeature();
        if (s_logger.isLoggable(Level.CONFIG)) {
            object2 = bl ? "PREPARE_XPATH_COMPILER" : "PREPARE_XPATH_INTERPRETER";
            s_logger.logrb(Level.CONFIG, s_className, "prepare", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", (String)object2, new Object[]{Version.getVersion(), string2});
        }
        try {
            object2 = this.createParserAndCompiler(source, xTQStaticContext, errorHandler);
            String string3 = this.getClassName(null);
            ((XStarCompiler)object2).setClassName(string3);
            ((XStarCompiler)object2).setInterpreted(false);
            if (bl) {
                Class<?> clazz;
                if (xTQStaticContext.getJavaSourceFeature()) {
                    XPathPreparer.directJavaSourceToDirectory((XPathCompiler)object2);
                    ((XStarCompiler)object2).setGenerateBCEL(false);
                    ((XStarCompiler)object2).setInterpreted(false);
                    ((XPathCompiler)object2).compile(string2, null, this.getSessionContext());
                    Class clazz2 = StarletLoader.loadStarlet(string3, null);
                    return new XPathCompiledExecutable(clazz2, this.m_session);
                }
                ((XStarCompiler)object2).setGenerateBCEL(true);
                ((XStarCompiler)object2).setInterpreted(false);
                ((XStarCompiler)object2).setSplitLimit(0);
                ((XStarCompiler)object2).setEmitAutoSplitWarning(false);
                if (xTQStaticContext.getGenClassesFeature()) {
                    ((XStarCompiler)object2).setOutputType(3);
                } else if (DUMP_BYTECODE) {
                    this.enableBytecodeDump((XStarCompiler)object2);
                } else {
                    ((XStarCompiler)object2).setOutputType(2);
                }
                ((XPathCompiler)object2).compile(string2, null, this.getSessionContext());
                byte[][] byArray = ((XStarCompiler)object2).getBytecodes();
                if (byArray == null) {
                    ErrorMsg errorMsg = new ErrorMsg("NO_TRANSLET_CLASS_ERR");
                    throw new NullPointerException(errorMsg.toString());
                }
                StarletLoader.ByteCodeArraysClassLoader byteCodeArraysClassLoader = StarletLoader.getByteCodeArraysClassLoader(byArray, ((XStarCompiler)object2).getNames());
                try {
                    clazz = byteCodeArraysClassLoader.loadClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    return null;
                }
                return new XPathCompiledExecutable(clazz, this.m_session);
            }
            ((XStarCompiler)object2).setInterpreted(true);
            ((XPathCompiler)object2).compile(string2, null, this.getSessionContext());
            ModuleSignature moduleSignature = new ModuleSignature("");
            Program program = new Program(moduleSignature);
            program.addModule(((XStarCompiler)object2).getStarletModule());
            if (!((XStarCompiler)object2).useMixedMode()) {
                program.addModule(((XPathCompiler)object2).getRuntimeLibrary());
            }
            XPathPreparer.prepareForStackFrames((XPathCompiler)object2);
            int n3 = staticContext.getIntegerMathMode();
            return new XPathInterpretedExecutable(program, ((XStarCompiler)object2).getFILLibrary(), n3 == 2, n3 == 3, this.m_session);
        }
        catch (HandledRuntimeException handledRuntimeException) {
            if (handledRuntimeException.getRuntimeException() != null) {
                throw handledRuntimeException.getRuntimeException();
            }
        }
        catch (Exception exception) {
            XPathPreparer.reportException(staticContext, exception);
        }
        return null;
    }

    public static void prepareForStackFrames(XPathCompiler xPathCompiler) {
        Module module = xPathCompiler.getStarletModule();
        StackFrameAnalyzer stackFrameAnalyzer = new StackFrameAnalyzer();
        Iterator<Function> iterator = module.exportedFunctionsIterator();
        while (iterator.hasNext()) {
            Function function2 = iterator.next();
            stackFrameAnalyzer.optimizeFunction(function2);
        }
    }

    @Override
    public Executable prepare(Source source, StaticContext staticContext, int n2) {
        String string2 = this.getStringFromSource(source);
        if (string2 != null) {
            return this.prepare(string2, staticContext, n2, source);
        }
        return null;
    }

    @Override
    public Executable prepare(Axis axis, NodeTest nodeTest, StaticContext staticContext, int n2) {
        return null;
    }

    protected XPathCompiler createParserAndCompiler(Source source, XTQStaticContext xTQStaticContext, ErrorHandler errorHandler) {
        XSLTParser xSLTParser = new XSLTParser(true, xTQStaticContext);
        XPathCompiler xPathCompiler = new XPathCompiler("2.0", xSLTParser);
        CodeGenerationSettings codeGenerationSettings = xPathCompiler.getLinkerSettings().getCodeGenerationSettings();
        int n2 = xTQStaticContext.getIntegerMathMode();
        codeGenerationSettings.setArbitraryPrecision(n2 == 2);
        codeGenerationSettings.setOverflowDetection(n2 == 3);
        xSLTParser.getExpressionFactory().setLanguage("XPath2");
        xPathCompiler.setErrorHandler(errorHandler);
        return xPathCompiler;
    }

    private String getClassName(String string2) {
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "XPathModule";
    }

    static {
        String string2 = HiddenOptions.getStringValue(JAVADESTDIR_OPTION);
        if (string2 != null) {
            OPTION_JAVASOURCEDESTDIRS = string2;
            JAVASOURCEDESTDIRSPECIFIED = true;
        } else {
            OPTION_JAVASOURCEDESTDIRS = ".";
            JAVASOURCEDESTDIRSPECIFIED = false;
        }
    }
}

