/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.xtq.Version;
import com.ibm.xltxe.rnm1.xtq.exec.AbstractSPIExecutable;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.runtime.Recyclable;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.AbstractPathlet;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.InterpretedPathlet;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.type.TypeRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class XPathExecutable
extends AbstractSPIExecutable {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathExecutable.class);
    private static final String s_className = XPathExecutable.class.getName();
    private AbstractPathlet m_cachedPathlet;
    private HashMap<String, Object> m_properties;

    public XPathExecutable(SessionContext sessionContext) {
        super(sessionContext);
    }

    @Override
    public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        if (cursor3 == null) {
            throw new IllegalArgumentException("Cursor result must not be null!");
        }
        Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        if (cursor4 != null) {
            cursor3.addCopy(area, cursor4);
            cursor4.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
        assert (null != dynamicContext);
        AbstractPathlet abstractPathlet = null;
        try {
            abstractPathlet = this.getPathlet(dynamicContext);
            Cursor cursor3 = this.execute(cursor2, dynamicContext, abstractPathlet, profile, cursorArray);
            return cursor3;
        }
        catch (HandledRuntimeException handledRuntimeException) {
            if (handledRuntimeException.getRuntimeException() != null) {
                throw handledRuntimeException.getRuntimeException();
            }
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", null), null);
        }
        catch (Exception exception) {
            this.reportError(dynamicContext, exception);
        }
        finally {
            if (abstractPathlet instanceof Recyclable) {
                ((Recyclable)((Object)abstractPathlet)).recycle();
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.m_properties == null) {
            Map<String, String> map2;
            this.m_properties = new HashMap();
            Map<String, String> map3 = this.getFunctionMap();
            if (map3 != null) {
                this.m_properties.put("http://www.ibm.com/xmlns/prod/xcij/function-map", map3);
            }
            if ((map2 = this.getVariableMap()) != null) {
                this.m_properties.put("http://www.ibm.com/xmlns/prod/xcij/variable-map", map2);
            }
        }
        return this.m_properties;
    }

    private Cursor execute(Cursor cursor2, DynamicContext dynamicContext, AbstractPathlet abstractPathlet, Cursor.Profile profile, Cursor[] cursorArray) throws Exception {
        if (s_logger.isLoggable(Level.CONFIG)) {
            boolean bl = abstractPathlet instanceof InterpretedPathlet;
            if (bl) {
                s_logger.logrb(Level.CONFIG, s_className, "execute", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "EXECUTE_XPATH_INTERPRETER", new Object[]{Version.getVersion()});
            } else {
                s_logger.logrb(Level.CONFIG, s_className, "execute", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "EXECUTE_XPATH_COMPILER", new Object[]{abstractPathlet.getClass().getName(), Version.getVersion()});
            }
        }
        if (DUMP_INPUT) {
            this.dumpInput(cursor2);
        }
        Cursor cursor3 = (Cursor)abstractPathlet.evaluate(cursor2, (int)(cursor2 == null ? 0L : cursor2.contextPosition()), (int)(cursor2 == null ? 0L : cursor2.contextSize()), dynamicContext);
        return cursor3;
    }

    private AbstractPathlet getPathlet(DynamicContext dynamicContext) throws Exception {
        AbstractPathlet abstractPathlet = this.createPathlet(this.m_session, this.m_session.getTypeRegistry());
        abstractPathlet.postInitialization();
        abstractPathlet.setErrorHandler(this.getErrorHandler(dynamicContext));
        return abstractPathlet;
    }

    abstract AbstractPathlet createPathlet(SessionContext var1, TypeRegistry var2) throws Exception;

    private AbstractPathlet getCachedPathlet() {
        if (this.m_cachedPathlet == null) {
            try {
                this.m_cachedPathlet = this.createPathlet(this.m_session, this.m_session.getTypeRegistry());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_cachedPathlet;
    }

    private Map<String, String> getFunctionMap() {
        AbstractPathlet abstractPathlet = this.getCachedPathlet();
        if (abstractPathlet != null) {
            return abstractPathlet.getFunctionMap();
        }
        return null;
    }

    private Map<String, String> getVariableMap() {
        AbstractPathlet abstractPathlet = this.getCachedPathlet();
        if (abstractPathlet != null) {
            return abstractPathlet.getVariableMap();
        }
        return null;
    }
}

