/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xpath.drivers;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandlerProvider;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarCompiler;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.exec.XTQStaticContext;
import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xml.types.TypeFactory;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathLinker;
import com.ibm.xltxe.rnm1.xtq.xpath.ext.subexp.SubExpCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.cmdline.utils.PrettyXylemListing;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.StandardOptimizationRegimen;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.FunctionOperatorTable;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.NamespaceHelper;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.PolymorphicFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.SimpleFunctionDeclaration;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XPath2SubExpTranslator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XPath2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xltxe.rnm1.xtq.xslt.typechecker.v2.XPath2TypeChecker;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.instructions.GetAxisCursorInstruction;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.types.XDMItemType;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.DynamicVariableBuilder;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.Axis;
import com.ibm.xml.xci.type.TypeRegistry;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

public class XPathCompiler
extends XStarCompiler
implements ErrorHandlerProvider {
    private static final Logger s_logger = LoggerUtil.getLogger(XPathCompiler.class);
    private static final String s_className = XPathCompiler.class.getName();
    public static final String XPATH_MAIN = "__xpath_main__";
    public static final String XPATH_FUNCTION = "__xpath_function__";
    public static final String XPATH_MODULE = "XPathModule";
    protected XSLTParser _parser;
    private int _nextGType = 14;
    private ArrayList<String> _namesIndex;
    private Hashtable<String, Integer> _elements;
    private Hashtable<String, Integer> _attributes;
    private Hashtable<String, Integer> _namespaceDecls;
    private int _nextNSType;
    private ArrayList<String> _namespaceIndex;
    private Hashtable<String, Integer> _namespaces;
    private int _stepPatternSerial = 1;
    private boolean _staticTyping = false;
    private String _xpathVersion = "2.0";
    private boolean _hasIdCall = false;
    private boolean _callsNodeset = false;
    private static final int SIMPLE = 0;
    private static final int POLYMORPHIC = 1;
    private static final int OPERATOR = 2;
    private static final int XTQHP = 3;
    private static final int BUILT_IN = 4;
    protected FunctionOperatorTable funcTable = FunctionOperatorTable.getInstance();
    private final String[] OPERATOR_NAMES = new String[]{"add", "subtract", "multiply", "div", "idiv", "mod", "eq", "ne", "gt", "lt", "ge", "le", "unary-minus", "unary-plus", "g_eq", "g_ne", "g_gt", "g_lt", "g_ge", "g_le", "is", "<<", ">>", "union", "intersect", "except"};
    private final Hashtable<FunctionKey, FunctionDeclaration> _functions = new Hashtable();
    private final PolymorphicFunctionDeclaration[] _operators = new PolymorphicFunctionDeclaration[26];
    protected Module _rtlibModule;
    protected ModuleSignature _rtlibSignature;
    private TypeFactory _typeFactory = null;
    private TypeRegistry _typeRegistry = null;
    private boolean _inGlobal = false;

    public XPathCompiler(String string2, XSLTParser xSLTParser) {
        super(string2);
        this._xpathVersion = string2;
        this._parser = xSLTParser;
        this.initCompiler(TypeRegistry.newTypeRegistry());
    }

    protected void initCompiler(TypeRegistry typeRegistry) {
        this._parser.init();
        this.initFunctionAndOperatorDeclarations();
        this._nextGType = 14;
        this._namesIndex = new ArrayList(128);
        this._elements = new Hashtable();
        this._attributes = new Hashtable();
        this._namespaceDecls = new Hashtable();
        this._namespaces = new Hashtable();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex = new ArrayList(32);
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
        this.setTypeRegistry(typeRegistry);
    }

    @Override
    public void reset() {
        super.reset();
        this._parser.reset();
        this._nextGType = 14;
        this._namesIndex.clear();
        this._elements.clear();
        this._attributes.clear();
        this._namespaceDecls.clear();
        this._namespaces.clear();
        this._namespaces.put("", new Integer(this._nextNSType));
        this._namespaceIndex.clear();
        this._stepPatternSerial = 1;
        this._hasIdCall = false;
        this._callsNodeset = false;
    }

    public int registerAttribute(QName qName) {
        Integer n2 = this._attributes.get(qName.toString());
        if (n2 == null) {
            n2 = new Integer(this._nextGType++);
            this._attributes.put(qName.toString(), n2);
            String string2 = qName.getNamespaceURI();
            String string3 = "@" + qName.getLocalPart();
            if (string2 != null && !string2.equals("")) {
                this._namesIndex.add(string2 + ":" + string3);
            } else {
                this._namesIndex.add(string3);
            }
            if (qName.getLocalPart().equals("*")) {
                this.registerNamespace(qName.getNamespaceURI());
            }
        }
        return n2;
    }

    public Hashtable<String, Integer> getAttributes() {
        return this._attributes;
    }

    public int registerElement(QName qName) {
        Integer n2 = this._elements.get(qName.toString());
        if (n2 == null) {
            n2 = new Integer(this._nextGType++);
            this._elements.put(qName.toString(), n2);
            String string2 = qName.getNamespaceURI();
            String string3 = qName.getLocalPart();
            if (string2 != null && !string2.equals("")) {
                this._namesIndex.add(string2 + ":" + string3);
            } else {
                this._namesIndex.add(string3);
            }
        }
        if (qName.getLocalPart().equals("*")) {
            this.registerNamespace(qName.getNamespaceURI());
        }
        return n2;
    }

    public int registerNamespaceDecl(QName qName) {
        Integer n2 = this._namespaceDecls.get(qName.toString());
        if (n2 == null) {
            n2 = new Integer(this._nextGType++);
            this._namespaceDecls.put(qName.toString(), n2);
            String string2 = qName.getNamespaceURI();
            String string3 = "%" + qName.getLocalPart();
            if (string2 != null && !string2.equals("")) {
                this._namesIndex.add(string2 + ":" + string3);
            } else {
                this._namesIndex.add(string3);
            }
            if (qName.getLocalPart().equals("*")) {
                this.registerNamespace(qName.getNamespaceURI());
            }
        }
        return n2;
    }

    public int registerNamespace(String string2) {
        Integer n2 = this._namespaces.get(string2);
        if (n2 == null) {
            n2 = new Integer(this._nextNSType++);
            this._namespaces.put(string2, n2);
            this._namespaceIndex.add(string2);
        }
        return n2;
    }

    public List<String> getNamesIndex() {
        return this._namesIndex;
    }

    public List<String> getNamespaceIndex() {
        return this._namespaceIndex;
    }

    private void initFunctionAndOperatorDeclarations() {
        boolean bl = this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when");
        if (bl) {
            this.initSimpleFunctionDeclarations(true);
        } else {
            this.initSimpleFunctionDeclarations(false);
            this.initXtqhpFunctionDeclarations();
            this.initBuiltInExtensionFunctionDeclarations();
        }
        this.initPolymorphicFunctionDeclarations();
        this.initOperatorDeclarations();
    }

    private void initSimpleFunctionDeclarations(boolean bl) {
        int n2 = this.funcTable.getSimpleFunctionLength();
        if (bl) {
            n2 -= 22;
        }
        for (int i = 0; i < n2; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 0);
            int n3 = this.funcTable.getSimpleFunctionDeclLength(i) - 3;
            FunctionKey functionKey = new FunctionKey(new QName("http://www.w3.org/2005/xpath-functions", this.funcTable.getSimpleFunctionName(i), "fn"), n3);
            this._functions.put(functionKey, simpleFunctionDeclaration);
        }
    }

    private void initPolymorphicFunctionDeclarations() {
        int n2 = this.funcTable.getPolymorphicFunctionLength();
        for (int i = 0; i < n2; ++i) {
            int n3;
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 1);
            String string2 = this.funcTable.getPolymorphicFunctionName(i);
            FunctionKey functionKey = new FunctionKey(new QName("http://www.w3.org/2005/xpath-functions", string2, "fn"), n3 = this.funcTable.getPolymorphicFunctionDeclLength(i) - 4);
            FunctionDeclaration functionDeclaration = this._functions.get(functionKey);
            if (functionDeclaration == null) {
                PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = new PolymorphicFunctionDeclaration(string2, n3, simpleFunctionDeclaration);
                this._functions.put(functionKey, polymorphicFunctionDeclaration);
                continue;
            }
            if (!(functionDeclaration instanceof PolymorphicFunctionDeclaration)) continue;
            ((PolymorphicFunctionDeclaration)functionDeclaration).addDeclarationEntry(simpleFunctionDeclaration);
        }
    }

    private void initXtqhpFunctionDeclarations() {
        int n2 = this.funcTable.getXtqhpFunctionLength();
        for (int i = 0; i < n2; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 3);
            int n3 = this.funcTable.getXtqhpFunctionDeclLength(i) - 3;
            FunctionKey functionKey = new FunctionKey(new QName("http://xtqhp", this.funcTable.getXtqhpFunctionName(i)), n3);
            this._functions.put(functionKey, simpleFunctionDeclaration);
        }
    }

    private void initBuiltInExtensionFunctionDeclarations() {
        int n2 = this.funcTable.getBuiltInExtensionFunctionLength();
        for (int i = 0; i < n2; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, 0, 4);
            int n3 = this.funcTable.getBuiltInExtensionFunctionDeclLength(i) - 4;
            FunctionKey functionKey = new FunctionKey(new QName(this.funcTable.getBuiltInExtensionFunctionNamespace(i), this.funcTable.getBuiltInExtensionFunctionName(i)), n3);
            this._functions.put(functionKey, simpleFunctionDeclaration);
        }
    }

    private void initOperatorDeclaration(int n2) {
        int n3 = this.funcTable.getOperatorItemLength(n2);
        String string2 = this.OPERATOR_NAMES[n2];
        int n4 = 0;
        if (n3 > 0) {
            n4 = this.funcTable.getOperatorDeclLength(n2, 0) - 4;
        }
        PolymorphicFunctionDeclaration polymorphicFunctionDeclaration = new PolymorphicFunctionDeclaration(string2, n4);
        for (int i = 0; i < n3; ++i) {
            SimpleFunctionDeclaration simpleFunctionDeclaration = this.createFunctionDeclaration(i, n2, 2);
            polymorphicFunctionDeclaration.addDeclarationEntry(simpleFunctionDeclaration);
        }
        this._operators[n2] = polymorphicFunctionDeclaration;
    }

    private void initOperatorDeclarations() {
        int n2 = this.funcTable.getOperatorLength();
        for (int i = 0; i < n2; ++i) {
            this.initOperatorDeclaration(i);
        }
    }

    private SimpleFunctionDeclaration createFunctionDeclaration(int n2, int n3, int n4) {
        String string2;
        XSequenceType xSequenceType;
        int n5;
        XSequenceType[] xSequenceTypeArray;
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            xSequenceTypeArray = null;
                            if (n4 != 1) break block7;
                            String string3 = this.funcTable.getPolymorphicFunctionName(n2);
                            int n6 = this.funcTable.getPolymorphicFunctionDeclLength(n2) - 4;
                            n5 = this.funcTable.getPolymorphicFunctionFlag(n2);
                            xSequenceType = this.funcTable.getPolymorphicFunctionReturnType(n2);
                            string2 = this.funcTable.getPolymorphicFunctionName_Real(n2);
                            if (string2 == null) {
                                string2 = string3;
                            }
                            if (n6 <= 0) break block8;
                            xSequenceTypeArray = new XSequenceType[n6];
                            int n7 = 4;
                            for (int i = 0; i < n6; ++i) {
                                xSequenceTypeArray[i] = this.funcTable.getPolymorphicFunctionArgType(n2, n7 + i);
                            }
                            break block8;
                        }
                        if (n4 != 2) break block9;
                        String string4 = this.funcTable.getOperatorName(n3, n2);
                        int n8 = this.funcTable.getOperatorDeclLength(n3, n2) - 4;
                        n5 = this.funcTable.getOperatorFlag(n3, n2);
                        xSequenceType = this.funcTable.getOperatorReturnType(n3, n2);
                        string2 = string4;
                        if (n8 <= 0) break block8;
                        xSequenceTypeArray = new XSequenceType[n8];
                        int n9 = 4;
                        for (int i = 0; i < n8; ++i) {
                            xSequenceTypeArray[i] = this.funcTable.getOperatorArgType(n3, n2, n9 + i);
                        }
                        break block8;
                    }
                    if (n4 != 0) break block10;
                    String string5 = this.funcTable.getSimpleFunctionName(n2);
                    int n10 = this.funcTable.getSimpleFunctionDeclLength(n2) - 3;
                    n5 = this.funcTable.getSimpleFunctionFlag(n2);
                    xSequenceType = this.funcTable.getSimpleFunctionReturnType(n2);
                    string2 = string5;
                    if (n10 <= 0) break block8;
                    xSequenceTypeArray = new XSequenceType[n10];
                    int n11 = 3;
                    for (int i = 0; i < n10; ++i) {
                        xSequenceTypeArray[i] = this.funcTable.getSimpleFunctionArgType(n2, n11 + i);
                    }
                    break block8;
                }
                if (n4 != 4) break block11;
                String string6 = this.funcTable.getBuiltInExtensionFunctionName(n2);
                int n12 = this.funcTable.getBuiltInExtensionFunctionDeclLength(n2) - 4;
                n5 = this.funcTable.getBuiltInExtensionFunctionFlag(n2);
                xSequenceType = this.funcTable.getBuiltInExtensionFunctionReturnType(n2);
                string2 = string6;
                if (n12 <= 0) break block8;
                xSequenceTypeArray = new XSequenceType[n12];
                int n13 = 4;
                for (int i = 0; i < n12; ++i) {
                    xSequenceTypeArray[i] = this.funcTable.getBuiltInExtensionFunctionArgType(n2, n13 + i);
                }
                break block8;
            }
            String string7 = this.funcTable.getXtqhpFunctionName(n2);
            int n14 = this.funcTable.getXtqhpFunctionDeclLength(n2) - 3;
            n5 = this.funcTable.getXtqhpFunctionFlag(n2);
            xSequenceType = this.funcTable.getXtqhpFunctionReturnType(n2);
            string2 = string7;
            if (n14 > 0) {
                xSequenceTypeArray = new XSequenceType[n14];
                int n15 = 3;
                for (int i = 0; i < n14; ++i) {
                    xSequenceTypeArray[i] = this.funcTable.getXtqhpFunctionArgType(n2, n15 + i);
                }
            }
        }
        return new SimpleFunctionDeclaration(string2, xSequenceType, xSequenceTypeArray, n5);
    }

    public FunctionDeclaration getFunctionDeclarationFromSignature(QName qName, int n2) {
        return this._functions.get(new FunctionKey(qName, n2));
    }

    public PolymorphicFunctionDeclaration getOperatorDeclaration(int n2) {
        return this._operators[n2];
    }

    public String getXPathVersion() {
        return this._xpathVersion;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void setStaticTyping(boolean bl) {
        this._staticTyping = bl;
    }

    public boolean isStaticTyping() {
        return this._staticTyping;
    }

    public void setHasIdCall(boolean bl) {
        this._hasIdCall = bl;
    }

    public boolean hasIdCall() {
        return this._hasIdCall;
    }

    @Override
    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this._parser.setDebug(bl);
    }

    public void setCallsNodeset(boolean bl) {
        this._callsNodeset = bl;
    }

    public boolean callsNodeset() {
        return this._callsNodeset;
    }

    public void setInGlobal(boolean bl) {
        this._inGlobal = bl;
    }

    public boolean isInGlobal() {
        return this._inGlobal;
    }

    public int nextStepPatternSerial() {
        return this._stepPatternSerial++;
    }

    @Override
    public Module getRuntimeLibrary() {
        return this._rtlibModule;
    }

    public ModuleSignature getRuntimeLibrarySignature() {
        if (this._rtlibModule != null) {
            return this._rtlibModule.m_signature;
        }
        return this._rtlibSignature;
    }

    @Override
    public void setRuntimeLibrary(Module module) {
        this._rtlibModule = module;
    }

    public void setRuntimeSignature(ModuleSignature moduleSignature) {
        this._rtlibSignature = moduleSignature;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        this._parser.setErrorHandler(errorHandler);
    }

    public SourceLocation createSourceLocation(Expr expr) {
        return null;
    }

    public void setSecureProcessing(boolean bl) {
        this._parser.setSecureProcessing(bl);
    }

    public XTQStaticContext getStaticContext() {
        return (XTQStaticContext)this._parser.getStaticContext();
    }

    public TypeFactory getTypeFactory() {
        if (this._typeFactory == null) {
            XTQStaticContext xTQStaticContext = this.getStaticContext();
            this._typeFactory = new TypeFactory(xTQStaticContext.getInScopeSchemaModel(xTQStaticContext.getTypeRegistry()));
            this._typeRegistry = null;
        }
        return this._typeFactory;
    }

    protected void setTypeRegistry(TypeRegistry typeRegistry) {
        this._typeRegistry = typeRegistry;
    }

    public boolean compile(String string2, SubExpCompiler subExpCompiler, SessionContext sessionContext) {
        try {
            this.setRuntimeLibrary(this.loadRuntimeLibrary());
            Expr expr = this.buildAST(string2);
            this.setStarletModule(this._xpathVersion.equals("2.0") ? this.translate(expr, subExpCompiler) : this.translate10(expr));
            if (StandardOptimizationRegimen.DumpOption.LISTING.isEnabled()) {
                Module module = this.getStarletModule();
                if (!this.useMixedMode()) {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module, this.getRuntimeLibrary()});
                } else {
                    PrettyXylemListing.MakeListing(module.getName(), new Module[]{module});
                }
            }
            if (this.getDoPostASTProcessing()) {
                // empty if block
            }
            if (!this.isInterpreted()) {
                this.getStarletModule().reduce();
                this.linkAndCodeGen(this.getRuntimeLibrary(), this.getStarletModule(), sessionContext);
            }
        }
        catch (WrappedRuntimeException wrappedRuntimeException) {
            this._parser.reportError(2, new ErrorMsg(wrappedRuntimeException), (Throwable)wrappedRuntimeException.getException());
        }
        catch (HandledRuntimeException handledRuntimeException) {
            throw handledRuntimeException;
        }
        catch (Exception exception) {
            this._parser.reportError(2, new ErrorMsg(exception));
        }
        catch (Error error2) {
            error2.printStackTrace();
            this._parser.reportError(2, new ErrorMsg(error2));
        }
        return !this._parser.errorsFound();
    }

    public Expr buildAST(String string2) throws Exception {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Started building AST");
        }
        Expr expr = this._parser.parseExpression(string2);
        String string3 = this._parser.getStaticContext().getBaseURI();
        if (string3 != null) {
            expr.setBaseURI(SystemIDResolver.getAbsoluteURI(string3));
        } else {
            expr.setBaseURI(System.getProperty("user.dir") + File.separator);
        }
        if (!this._xpathVersion.equals("2.0")) {
            throw new RuntimeException("[XPathCompiler] v1 deprecated");
        }
        new XPath2TypeChecker(this).visitExpression(expr);
        if (this._parser.errorsFound()) {
            throw new XPathExpressionException(XMLMessages.createXMLMessage("ERR_FAIL_COMPILE_EXP", string2));
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "buildAST", "Finished building AST");
        }
        return expr;
    }

    public Module translate(Expr expr, SubExpCompiler subExpCompiler) throws Exception {
        Instruction instruction2;
        Object object2;
        Object[] objectArray;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Started translating AST to FIL");
        }
        Module module = new Module(Util.baseName(this.getClassName()), null, new ModuleSignature(""));
        module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt2", this.getRuntimeLibrarySignature(), "xslt2"));
        XPath2Translator xPath2Translator = subExpCompiler != null ? new XPath2SubExpTranslator(subExpCompiler, this) : new XPath2Translator(this);
        xPath2Translator.setStylesheetModlue(module);
        LetChainBuilder letChainBuilder = LetChainBuilder.newInstance(this.isInterpreted());
        DynamicVariableBuilder dynamicVariableBuilder = DynamicVariableBuilder.newDVB();
        Instruction instruction3 = xPath2Translator.compileNode(dynamicVariableBuilder, letChainBuilder, expr);
        Instruction instruction4 = letChainBuilder.packageUp(instruction3);
        Binding[] bindingArray = new Binding[]{new Binding((Object)"__current__", new XDMItemType()), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType), new Binding((Object)"__othercontextinfo__", new NamedType("XSLT20ContextInfo"))};
        Function function2 = new Function(XPATH_FUNCTION, bindingArray, instruction4);
        module.addFunction(function2);
        letChainBuilder = letChainBuilder.newInstance();
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        arrayList.add(new IdentifierInstruction("__rootcursor__"));
        arrayList.add(new IdentifierInstruction("__contextposition__"));
        arrayList.add(new IdentifierInstruction("__contextlast__"));
        arrayList.add(letChainBuilder.bind(new NamespaceHelper().callGetStaticNamespaceTablesFunction()));
        if (this.getStaticContext().getFeature("http://www.ibm.com/xmlns/prod/xltxe-j/use-when")) {
            objectArray = this.getStaticContext().getCurrentDateTime();
            object2 = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object2[i] = LiteralInstruction.integerLiteral(objectArray[i]);
            }
            arrayList.add(letChainBuilder.bind(new StreamInstruction((Type)IntType.s_intType, (Instruction[])object2)));
            instruction2 = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, letChainBuilder, "constructContextInfoUseWhen", arrayList);
        } else {
            instruction2 = TranslatorUtilities.makeRuntimeLibraryFunctionCall((XStarCompiler)this, letChainBuilder, "constructContextInfo", arrayList);
        }
        objectArray = new Instruction[]{new IdentifierInstruction("__rootcursor__"), new IdentifierInstruction("__contextposition__"), new IdentifierInstruction("__contextlast__"), instruction2};
        object2 = letChainBuilder.bind(new FunctionCallInstruction(XPATH_FUNCTION, (Instruction[])objectArray));
        instruction4 = letChainBuilder.packageUp((Instruction)object2);
        Binding[] bindingArray2 = new Binding[]{new Binding((Object)"__rootcursor__", new XDMItemType()), new Binding((Object)"__contextposition__", IntType.s_intType), new Binding((Object)"__contextlast__", IntType.s_intType)};
        function2 = new Function(XPATH_MAIN, bindingArray2, instruction4);
        module.addFunction(function2);
        this.addPredefinedFunctions(module);
        this.addXDMFunctions(module);
        XSLT2Translator.generateSchemaModel(module, this.getStaticContext(), true);
        module.addFunction(xPath2Translator.createGetInScopeNamespaceTablesFunction());
        Function[] functionArray = xPath2Translator.translateStaticContext();
        for (int i = 0; i < functionArray.length; ++i) {
            module.addFunction(functionArray[i]);
        }
        module.exportAllSymbols();
        module.typeCheck(false);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "translate", "Finished translating AST to FIL");
        }
        if (StandardOptimizationRegimen.sDumpSome) {
            Program.dumpXylemFile(module, this.m_linkerSettings.getOutputDir(), module.getName());
        }
        return module;
    }

    private Module translate10(Expr expr) throws Exception {
        Module module = new Module(Util.baseName(this.getClassName()), null, new ModuleSignature(""));
        module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", this.getRuntimeLibrary().m_signature, "xslt1"));
        throw new RuntimeException("XPath Translator v1 deprecated");
    }

    public void addPredefinedFunctions(Module module) {
        Function function2 = new Function("empty-cursor", new Binding[]{new Binding((Object)"__root__", new XDMItemType())}, new GetAxisCursorInstruction(Axis.PARENT, new IdentifierInstruction("__root__")));
        function2.setMemoizeResult(true);
        module.addFunction(function2);
    }

    public void addXDMFunctions(Module module) {
        Function function2 = new Function("xdm-node-counter-fields", new Binding[0], XSLTLinker.makeStringArrayBody(new String[0]));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
        function2 = new Function("xdm-names", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
        function2 = new Function("xdm-uris", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
        function2 = new Function("xdm-types", new Binding[0], new StreamInstruction(IntType.s_intType));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
        function2 = new Function("xdm-namespaces", new Binding[0], new StreamInstruction(JavaObjectType.s_javaStringType));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
        String string2 = null;
        function2 = new Function("xdm-encoding", new Binding[]{}, string2 == null ? LiteralInstruction.nullLiteral(JavaObjectType.s_javaStringType) : new LetInstruction("x", StreamInstruction.charStreamLiteral(string2), new CharStreamToJavaStringInstruction(new IdentifierInstruction("x"))));
        module.addFunction(function2);
        module.forceFunctionGeneration(function2);
    }

    @Override
    public XStarLinker getLinker() {
        return XPathLinker.s_linker;
    }

    public void dumpFunctionKeys(PrintStream printStream) {
        Enumeration<FunctionKey> enumeration = this._functions.keys();
        while (enumeration.hasMoreElements()) {
            FunctionKey functionKey = enumeration.nextElement();
            printStream.print(functionKey.getFunctionName());
            printStream.print("(");
            printStream.print(functionKey.getArity());
            printStream.println(" arguments)");
        }
    }

    final class FunctionKey {
        private final QName functionName;
        private final int arity;

        FunctionKey(QName qName, int n2) {
            this.functionName = qName;
            this.arity = n2;
        }

        public int hashCode() {
            return this.functionName.hashCode() + this.arity;
        }

        public boolean equals(Object object2) {
            FunctionKey functionKey = (FunctionKey)object2;
            return this.functionName.equals(functionKey.getFunctionName()) && this.arity == functionKey.getArity();
        }

        public QName getFunctionName() {
            return this.functionName;
        }

        public int getArity() {
            return this.arity;
        }
    }
}

