/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorBasedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.StringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.UnimplementedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.RuleBasedCollator;

public class XCollatorJavaCollatorProxy
implements XCollator {
    private Collator fWrappedCollator;
    private Collator fSecondaryStrengthCollator;
    private static final String EMPTY_STRING = "";
    private StringSearcher fSearcher;
    private XCollator.CaseOrder fCaseOrder;

    public XCollatorJavaCollatorProxy(Collator collator2, XCollator.CaseOrder caseOrder) {
        Collator collator3 = null;
        if (caseOrder != XCollator.CaseOrder.DEFAULT && collator2.getStrength() == 2) {
            collator3 = (Collator)collator2.clone();
            collator3.setStrength(1);
            this.fSecondaryStrengthCollator = collator3;
        }
        this.fWrappedCollator = collator2;
        this.fCaseOrder = caseOrder;
        this.fSearcher = collator2 instanceof RuleBasedCollator ? new CollatorBasedStringSearcher((RuleBasedCollator)collator2, (RuleBasedCollator)collator3) : new UnimplementedStringSearcher();
    }

    @Override
    public int compare(String string2, String string3) {
        int n2 = this.fWrappedCollator.compare(string2, string3);
        switch (this.fCaseOrder) {
            case UPPER_FIRST: 
            case LOWER_FIRST: {
                n2 = this.filterComparisonWithCaseOrder(string2, string3, n2);
                break;
            }
        }
        return n2;
    }

    private int filterComparisonWithCaseOrder(String string2, String string3, int n2) {
        return this.fSearcher.filterComparisonWithCaseOrder(string2, string3, this.fCaseOrder, n2);
    }

    @Override
    public int compareCollationKeys(Object object2, Object object3) {
        CollationKey collationKey = (CollationKey)object2;
        CollationKey collationKey2 = (CollationKey)object3;
        int n2 = collationKey.compareTo(collationKey2);
        switch (this.fCaseOrder) {
            case UPPER_FIRST: 
            case LOWER_FIRST: {
                n2 = this.filterComparisonWithCaseOrder(collationKey.getSourceString(), collationKey2.getSourceString(), n2);
                break;
            }
        }
        return n2;
    }

    @Override
    public boolean contains(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return false;
        }
        return this.firstOccurance(string2, string3) != null;
    }

    @Override
    public boolean endsWith(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return true;
        }
        Range range = this.lastOccurance(string2, string3);
        return range != null && range.m_endOffset == string2.length();
    }

    @Override
    public Object getCollationKey(String string2) {
        return this.fWrappedCollator.getCollationKey(string2);
    }

    @Override
    public boolean startsWith(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return false;
        }
        Range range = this.firstOccurance(string2, string3);
        return range != null && range.m_startOffset == 0;
    }

    Range firstOccurance(String string2, String string3) {
        return this.fSearcher.firstOccurance(string2, string3);
    }

    Range lastOccurance(String string2, String string3) {
        return this.fSearcher.lastOccurance(string2, string3);
    }

    @Override
    public String substringAfter(String string2, String string3) {
        Range range;
        String string4 = string3.equals(EMPTY_STRING) ? string2 : (string2.equals(EMPTY_STRING) ? EMPTY_STRING : ((range = this.firstOccurance(string2, string3)) == null ? EMPTY_STRING : string2.substring(range.m_endOffset)));
        return string4;
    }

    @Override
    public String substringBefore(String string2, String string3) {
        Range range;
        String string4 = string3.equals(EMPTY_STRING) ? EMPTY_STRING : (string2.equals(EMPTY_STRING) ? EMPTY_STRING : ((range = this.firstOccurance(string2, string3)) == null ? EMPTY_STRING : string2.substring(0, range.m_startOffset)));
        return string4;
    }
}

