/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public final class LocaleUtility {
    private static final char IETF_SEPARATOR = '-';
    private static final char LOCALE_SEPARATOR = '_';
    private static final String EMPTY_STRING = "";
    private static final Hashtable<String, Locale> sLocales = new Hashtable();

    private static final String IETFToLocaleLang(String string2) {
        return string2 != null ? string2.replace('-', '_') : null;
    }

    public static final Locale getLocaleForLang(String string2) {
        String string3 = LocaleUtility.IETFToLocaleLang(string2);
        Locale locale = sLocales.get(string3);
        if (locale == null) {
            String[] stringArray = LocaleUtility.splitLangName(string3, '-');
            locale = stringArray[1].equals(EMPTY_STRING) ? new Locale(stringArray[0]) : (stringArray[2].equals(EMPTY_STRING) ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0], stringArray[1], stringArray[2]));
            sLocales.put(string3, locale);
        }
        return locale;
    }

    public static final Locale IETFToValidLocale(String string2, Locale[] localeArray, ArrayList arrayList) {
        if (localeArray == null) {
            return null;
        }
        if (string2 == null) {
            return Locale.getDefault();
        }
        if (!LocaleUtility.isIETFLangValid(string2)) {
            return Locale.getDefault();
        }
        String string3 = LocaleUtility.IETFToLocaleLang(string2);
        Locale locale = LocaleUtility.stringToLocale(string3, localeArray, arrayList);
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    static final Locale stringToLocale(String string2, Locale[] localeArray, ArrayList arrayList) {
        if (localeArray == null) {
            return null;
        }
        String string3 = string2;
        int n2 = -1;
        n2 = arrayList.indexOf(string3);
        if (n2 > -1) {
            return localeArray[n2];
        }
        String[] stringArray = LocaleUtility.splitLangName(string3, '_');
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        if (string6.length() != 0 && (n2 = arrayList.indexOf(string3 = string5.length() != 0 ? string4 + '_' + string5 : string4)) > -1) {
            return localeArray[n2];
        }
        if (string5.length() != 0 && (n2 = arrayList.indexOf(string3 = string6.length() != 0 ? string4 + '_' + string6 : string4)) > -1) {
            return localeArray[n2];
        }
        string3 = string4;
        n2 = arrayList.indexOf(string3);
        if (n2 > -1) {
            return localeArray[n2];
        }
        return null;
    }

    static boolean isIETFLangValid(String string2) {
        int n2 = string2.length();
        if (n2 == 0) {
            return false;
        }
        if (string2.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (!Character.isWhitespace(string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String[] splitLangName(String string2, char c) {
        String string3 = EMPTY_STRING;
        String string4 = EMPTY_STRING;
        String string5 = EMPTY_STRING;
        int n2 = string2.indexOf(c);
        if (n2 < 0) {
            string3 = string2;
        } else {
            int n3;
            string3 = string2.substring(0, n2);
            if ((n3 = string2.indexOf(c, ++n2)) < 0) {
                string4 = string2.substring(n2);
            } else {
                string4 = string2.substring(n2, n3);
                string5 = string2.substring(n3 + 1);
            }
        }
        string3 = string3.length() == 2 ? string3.toLowerCase() : EMPTY_STRING;
        string4 = string4.length() == 2 ? string4.toUpperCase() : EMPTY_STRING;
        string5 = string5.length() > 0 && (string3.length() == 2 || string4.length() == 2) ? string5.toUpperCase() : EMPTY_STRING;
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    static int compareLangCountryVariant(String string2, String string3) {
        int n2;
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            n2 = 4;
        } else {
            String string4;
            String string5;
            String string6;
            String string7;
            String[] stringArray;
            String string8;
            string2 = LocaleUtility.IETFToLocaleLang(string2);
            string3 = LocaleUtility.IETFToLocaleLang(string3);
            String[] stringArray2 = LocaleUtility.splitLangName(string2, '_');
            String string9 = stringArray2[0];
            n2 = !string9.equals(string8 = (stringArray = LocaleUtility.splitLangName(string3, '_'))[0]) ? 3 : (!(string7 = stringArray2[1]).equals(string6 = stringArray[1]) ? 2 : (!(string5 = stringArray2[2]).equals(string4 = stringArray[2]) ? 1 : 0));
        }
        return n2;
    }

    static {
        Locale[] localeArray = Locale.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            sLocales.put(localeArray[i].toString(), localeArray[i]);
        }
    }
}

