/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorBasedStringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorFactory;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Locale;

final class JavaCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final CollatorBasedStringSearcher m_search;
    private final JavaCollator m_helperTertiaryCanonical;
    private final JavaCollator m_helperSecondary;
    private static final boolean old_code = false;

    JavaCollator(CollatorDeclarationImpl collatorDeclarationImpl) {
        super(collatorDeclarationImpl, LocaleUtility.IETFToValidLocale(collatorDeclarationImpl.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        ruleBasedCollator = this.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules());
        JavaCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new CollatorBasedStringSearcher(ruleBasedCollator, null);
        this.setStrength(collatorDeclarationImpl.getStrengthType());
        this.m_helperTertiaryCanonical = this.getHelperTertiaryCanonical(this.m_declaration, this.m_locale);
        this.m_helperSecondary = this.getHelperSecondary(this.m_declaration, this.m_locale);
    }

    private JavaCollator(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        super(collatorDeclarationImpl, locale);
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.m_locale);
        ruleBasedCollator = this.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules());
        JavaCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new CollatorBasedStringSearcher(ruleBasedCollator, null);
        this.setStrength(collatorDeclarationImpl.getStrengthType());
        this.m_helperSecondary = null;
        this.m_helperTertiaryCanonical = null;
    }

    @Override
    public Object getCollationKey(String string2) {
        return this.m_collator.getCollationKey(string2);
    }

    private final int defaultCaseCompare(Object object2, Object object3) {
        int n2 = 0;
        n2 = object2 instanceof CollationKey && object3 instanceof CollationKey ? ((CollationKey)object2).compareTo((CollationKey)object3) : this.m_collator.compare((String)object2, (String)object3);
        return JavaCollator.formatCompareReturn(n2);
    }

    @Override
    public int compareCollationKeys(Object object2, Object object3) {
        ParamCaseOrder paramCaseOrder = this.m_declaration.getCaseOrderType();
        int n2 = this.m_collator.getStrength();
        if (paramCaseOrder == ParamCaseOrder.NOT_SPECIFIED) {
            return this.defaultCaseCompare(object2, object3);
        }
        String string2 = null;
        String string3 = null;
        if (object2 instanceof CollationKey && object3 instanceof CollationKey) {
            string2 = ((CollationKey)object2).getSourceString();
            string3 = ((CollationKey)object3).getSourceString();
        } else {
            string2 = (String)object2;
            string3 = (String)object3;
        }
        int n3 = 0;
        n3 = n2 == 0 || n2 == 1 ? this.defaultCaseCompare(object2, object3) : this.m_helperSecondary.defaultCaseCompare(string2, string3);
        if (n3 != 0) {
            return n3;
        }
        n3 = this.getCaseDiff(string2, string3);
        if (n3 != 0) {
            return n3;
        }
        return this.defaultCaseCompare(object2, object3);
    }

    @Override
    public int compare(String string2, String string3) {
        return this.compareCollationKeys(string2, string3);
    }

    private final int getCaseDiff(String string2, String string3) {
        ParamCaseOrder[] paramCaseOrderArray = this.m_helperTertiaryCanonical.m_search.getFirstCaseDiff(string2, string3, this.m_locale);
        if (paramCaseOrderArray != null) {
            if (this.m_declaration.getCaseOrderType() == ParamCaseOrder.UPPER_FIRST) {
                if (paramCaseOrderArray[0] == ParamCaseOrder.UPPER_FIRST) {
                    return -1;
                }
                return 1;
            }
            if (paramCaseOrderArray[0] == ParamCaseOrder.LOWER_FIRST) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    private final RuleBasedCollator setRules(RuleBasedCollator ruleBasedCollator, String string2) {
        if (string2 != null && 0 < string2.length()) {
            String string3 = ruleBasedCollator.getRules();
            try {
                ruleBasedCollator = new RuleBasedCollator(string3 + string2);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ruleBasedCollator;
    }

    private static void setDecomposition(RuleBasedCollator ruleBasedCollator, ParamDecomposition paramDecomposition) {
        if (paramDecomposition != ParamDecomposition.NOT_SPECIFIED) {
            int n2 = paramDecomposition == ParamDecomposition.NO ? 0 : (paramDecomposition == ParamDecomposition.CANONICAL ? 1 : (paramDecomposition == ParamDecomposition.FULL ? 2 : 0));
            ruleBasedCollator.setDecomposition(n2);
        }
    }

    private void setStrength(ParamStrength paramStrength) {
        if (paramStrength != null) {
            int n2 = paramStrength == ParamStrength.PRIMARY ? 0 : (paramStrength == ParamStrength.SECONDARY ? 1 : (paramStrength == ParamStrength.TERTIARY ? 2 : (paramStrength == ParamStrength.IDENTICAL ? 3 : 2)));
            this.setStrength(n2);
        }
    }

    private void setStrength(int n2) {
        this.m_collator.setStrength(n2);
        this.m_search.resetMaskStrength();
    }

    private JavaCollator getHelperTertiaryCanonical(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        JavaCollator javaCollator;
        if (collatorDeclarationImpl.getStrengthType() == ParamStrength.TERTIARY && collatorDeclarationImpl.getDecompositionType() == ParamDecomposition.CANONICAL) {
            javaCollator = this;
        } else {
            CollatorDeclarationImpl collatorDeclarationImpl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(collatorDeclarationImpl.getName() + "/?strength=tertiary?decomposition=primary", collatorDeclarationImpl.getLanguage(), ParamDecomposition.CANONICAL.getValue(), ParamStrength.TERTIARY.getValue(), collatorDeclarationImpl.getRules(), collatorDeclarationImpl.getCaseOrderType().getValue(), this.getClass().getName());
            javaCollator = new JavaCollator(collatorDeclarationImpl2, locale);
        }
        return javaCollator;
    }

    private JavaCollator getHelperSecondary(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        JavaCollator javaCollator;
        ParamStrength paramStrength = collatorDeclarationImpl.getStrengthType();
        if (paramStrength == ParamStrength.PRIMARY || paramStrength == ParamStrength.SECONDARY) {
            javaCollator = this;
        } else {
            CollatorDeclarationImpl collatorDeclarationImpl2 = (CollatorDeclarationImpl)CollatorFactory.getCollatorDeclaration(collatorDeclarationImpl.getName() + "/?strength=primary", collatorDeclarationImpl.getLanguage(), collatorDeclarationImpl.getDecompositionType().getValue(), ParamStrength.SECONDARY.getValue(), collatorDeclarationImpl.getRules(), collatorDeclarationImpl.getCaseOrderType().getValue(), this.getClass().getName());
            javaCollator = new JavaCollator(collatorDeclarationImpl2, locale);
        }
        return javaCollator;
    }

    @Override
    Range[] allOccurances(String string2, String string3) {
        return this.m_search.allOccurances(string2, string3);
    }

    @Override
    Range firstOccurance(String string2, String string3) {
        return this.m_search.firstOccurance(string2, string3);
    }

    @Override
    Range lastOccurance(String string2, String string3) {
        return this.m_search.lastOccurance(string2, string3);
    }

    static Locale getLocaleSupported(String string2) {
        Locale locale = LocaleUtility.IETFToValidLocale(string2, s_Locales, s_LocaleNames);
        return locale;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

