/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SearchIterator;
import com.ibm.icu.text.StringSearch;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorImplBase;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.LocaleUtility;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Messages;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamDecomposition;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamStrength;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

final class ICUCollator
extends CollatorImplBase {
    private static final Locale[] s_Locales = RuleBasedCollator.getAvailableLocales();
    private static final ArrayList s_LocaleNames = new ArrayList();
    private final RuleBasedCollator m_collator;
    private final SearchIterator m_search;

    ICUCollator(CollatorDeclarationImpl collatorDeclarationImpl) {
        super(collatorDeclarationImpl, LocaleUtility.IETFToValidLocale(collatorDeclarationImpl.getLanguage(), s_Locales, s_LocaleNames));
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)Collator.getInstance((Locale)this.m_locale);
        ICUCollator.setDecomposition(ruleBasedCollator, collatorDeclarationImpl.getDecompositionType());
        ICUCollator.setStrength(ruleBasedCollator, collatorDeclarationImpl.getStrengthType());
        ruleBasedCollator = ICUCollator.setRules(ruleBasedCollator, collatorDeclarationImpl.getRules(), this.m_messages);
        ICUCollator.setCaseOrder(ruleBasedCollator, collatorDeclarationImpl.getCaseOrderType());
        this.m_collator = ruleBasedCollator;
        this.m_search = new StringSearch("pat", (CharacterIterator)new StringCharacterIterator("t"), this.m_collator);
    }

    @Override
    public Object getCollationKey(String string2) {
        return this.m_collator.getCollationKey(string2);
    }

    @Override
    public int compareCollationKeys(Object object2, Object object3) {
        int n2 = 0;
        n2 = object2 instanceof CollationKey && object3 instanceof CollationKey ? ((CollationKey)object2).compareTo((CollationKey)object3) : this.m_collator.compare((String)object2, (String)object3);
        return ICUCollator.formatCompareReturn(n2);
    }

    @Override
    public int compare(String string2, String string3) {
        int n2 = this.m_collator.compare(string2, string3);
        return n2;
    }

    private static final RuleBasedCollator setRules(RuleBasedCollator ruleBasedCollator, String string2, Stack stack) {
        if (string2 != null) {
            String string3 = ruleBasedCollator.getRules();
            try {
                ruleBasedCollator = new RuleBasedCollator(string3 + string2);
            }
            catch (Exception exception) {
                String string4 = Messages.createMessage("INVALID_ATTR_VALUE_IGNORED", new Object[]{"rules", string2});
                Messages.Message message = new Messages.Message(string4, 3);
                stack.push(message);
            }
        }
        return ruleBasedCollator;
    }

    private static void setDecomposition(RuleBasedCollator ruleBasedCollator, ParamDecomposition paramDecomposition) {
        if (paramDecomposition != null) {
            int n2 = paramDecomposition == ParamDecomposition.NO ? 16 : (paramDecomposition == ParamDecomposition.CANONICAL ? 17 : (paramDecomposition == ParamDecomposition.FULL ? 17 : 17));
            ruleBasedCollator.setDecomposition(n2);
        }
    }

    private static void setStrength(RuleBasedCollator ruleBasedCollator, ParamStrength paramStrength) {
        if (paramStrength != null) {
            int n2 = -1;
            if (paramStrength == ParamStrength.PRIMARY) {
                n2 = 0;
            } else if (paramStrength == ParamStrength.SECONDARY) {
                n2 = 1;
            } else if (paramStrength == ParamStrength.TERTIARY) {
                n2 = 2;
            } else if (paramStrength == ParamStrength.IDENTICAL) {
                n2 = 15;
            }
            ruleBasedCollator.setStrength(n2);
        }
    }

    private static void setCaseOrder(RuleBasedCollator ruleBasedCollator, ParamCaseOrder paramCaseOrder) {
        if (paramCaseOrder == null) {
            return;
        }
        if (paramCaseOrder == ParamCaseOrder.UPPER_FIRST) {
            ruleBasedCollator.setUpperCaseFirst(true);
        } else if (paramCaseOrder == ParamCaseOrder.LOWER_FIRST) {
            ruleBasedCollator.setLowerCaseFirst(true);
        }
    }

    @Override
    Range[] allOccurances(String string2, String string3) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        ((StringSearch)this.m_search).setPattern(string3);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        Vector<Range> vector = null;
        int n2 = -1;
        int n3 = this.m_search.first();
        while (n3 != -1) {
            n2 = this.m_search.getMatchLength();
            if (n2 > 0) {
                if (vector == null) {
                    vector = new Vector<Range>();
                }
                vector.add(new Range(n3, n3 + n2));
            }
            n3 = this.m_search.next();
        }
        Range[] rangeArray = vector == null ? null : ICUCollator.convertFromVector(vector);
        return rangeArray;
    }

    @Override
    Range firstOccurance(String string2, String string3) {
        Range range = null;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        ((StringSearch)this.m_search).setPattern(string3);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        int n2 = -1;
        int n3 = this.m_search.first();
        while (n3 != -1) {
            n2 = this.m_search.getMatchLength();
            if (n2 > 0) {
                range = new Range(n3, n3 + n2);
                break;
            }
            n3 = this.m_search.next();
        }
        return range;
    }

    @Override
    Range lastOccurance(String string2, String string3) {
        Range range = null;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        ((StringSearch)this.m_search).setPattern(string3);
        this.m_search.setTarget((CharacterIterator)stringCharacterIterator);
        this.m_search.setOverlapping(true);
        int n2 = -1;
        int n3 = this.m_search.first();
        while (n3 != -1) {
            n2 = this.m_search.getMatchLength();
            if (n2 > 0) {
                range = new Range(n3, n3 + n2);
            }
            n3 = this.m_search.next();
        }
        return range;
    }

    static Locale getLocaleSupported(String string2) {
        Locale locale = LocaleUtility.stringToLocale(string2, s_Locales, s_LocaleNames);
        return locale;
    }

    static {
        for (int i = 0; i < s_Locales.length; ++i) {
            s_LocaleNames.add(s_Locales[i].toString());
        }
    }
}

