/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclaration;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.CollatorDeclarationImpl;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

abstract class CollatorImplBase
implements XCollator {
    private static final String EMPTY_STRING = "";
    final CollatorDeclarationImpl m_declaration;
    final Locale m_locale;
    final Stack m_messages = new Stack();

    CollatorImplBase(CollatorDeclarationImpl collatorDeclarationImpl, Locale locale) {
        this.m_declaration = collatorDeclarationImpl;
        this.m_locale = locale;
    }

    public CollatorDeclaration getDeclaration() {
        return this.m_declaration;
    }

    private final Stack getMessages() {
        return this.m_messages;
    }

    abstract Range[] allOccurances(String var1, String var2);

    abstract Range firstOccurance(String var1, String var2);

    abstract Range lastOccurance(String var1, String var2);

    @Override
    public boolean contains(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return false;
        }
        return this.firstOccurance(string2, string3) != null;
    }

    @Override
    public boolean startsWith(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return false;
        }
        Range range = this.firstOccurance(string2, string3);
        return range != null && range.m_startOffset == 0;
    }

    @Override
    public boolean endsWith(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return true;
        }
        if (string2.equals(EMPTY_STRING)) {
            return false;
        }
        Range range = this.lastOccurance(string2, string3);
        return range != null && range.m_endOffset == string2.length();
    }

    @Override
    public String substringBefore(String string2, String string3) {
        if (string3.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        if (string2.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        Range range = this.firstOccurance(string2, string3);
        if (range == null) {
            return EMPTY_STRING;
        }
        return string2.substring(0, range.m_startOffset);
    }

    @Override
    public String substringAfter(String string2, String string3) {
        Range range;
        String string4 = string3.equals(EMPTY_STRING) ? string2 : (string2.equals(EMPTY_STRING) ? EMPTY_STRING : ((range = this.lastOccurance(string2, string3)) == null ? EMPTY_STRING : string2.substring(range.m_endOffset)));
        return string4;
    }

    static final int formatCompareReturn(int n2) {
        n2 = n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
        return n2;
    }

    static Range[] convertFromVector(Vector vector) {
        int n2 = vector.size();
        Range[] rangeArray = new Range[n2];
        for (int i = 0; i < n2; ++i) {
            rangeArray[i] = (Range)vector.elementAt(i);
        }
        return rangeArray;
    }
}

