/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.xcollator;

import com.ibm.xltxe.rnm1.xtq.xml.xcollator.ParamCaseOrder;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.Range;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.StringSearcher;
import com.ibm.xltxe.rnm1.xtq.xml.xcollator.XCollator;
import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Vector;

final class CollatorBasedStringSearcher
extends StringSearcher {
    private static final boolean DEBUG = false;
    private final RuleBasedCollator m_collator;
    private final RuleBasedCollator m_secondaryStrengthCollator;
    private int m_mask;

    CollatorBasedStringSearcher(RuleBasedCollator ruleBasedCollator, RuleBasedCollator ruleBasedCollator2) {
        this.m_collator = ruleBasedCollator;
        this.m_secondaryStrengthCollator = ruleBasedCollator2;
        this.resetMaskStrength();
    }

    void resetMaskStrength() {
        this.m_mask = CollatorBasedStringSearcher.getMask(this.m_collator.getStrength());
    }

    final Range[] allOccurances(String string2, String string3) {
        Range[] rangeArray;
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string2);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string3);
        Vector<Range> vector = null;
        for (int i = 0; i < string2.length(); ++i) {
            collationElementIterator.setOffset(i);
            collationElementIterator2.reset();
            Range range = this.match(collationElementIterator, collationElementIterator2);
            if (range == null) continue;
            if (vector == null) {
                vector = new Vector<Range>();
            }
            vector.add(range);
        }
        if (vector == null) {
            rangeArray = null;
        } else {
            rangeArray = new Range[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                rangeArray[i] = (Range)vector.elementAt(i);
            }
        }
        return rangeArray;
    }

    private final Range match(CollationElementIterator collationElementIterator, CollationElementIterator collationElementIterator2) {
        int n2;
        int n3;
        int n4;
        block7: {
            n4 = collationElementIterator.getOffset();
            n3 = -1;
            int n5 = this.getElement(-1);
            int n6 = 0;
            n2 = 0;
            boolean bl = true;
            boolean bl2 = true;
            while (true) {
                if (bl) {
                    n6 = this.getElement(collationElementIterator2.next());
                }
                if (bl2) {
                    n3 = collationElementIterator.getOffset();
                    n2 = this.getElement(collationElementIterator.next());
                }
                bl = true;
                bl2 = true;
                if (n6 == n5) break block7;
                if (n2 == 0) {
                    bl = false;
                    continue;
                }
                if (n6 == 0) {
                    bl2 = false;
                    continue;
                }
                if (n2 != n6) break;
            }
            return null;
        }
        while (n2 == 0) {
            n3 = collationElementIterator.getOffset();
            n2 = this.getElement(collationElementIterator.next());
        }
        if (n3 > n4) {
            return new Range(n4, n3);
        }
        return null;
    }

    final ParamCaseOrder[] getFirstCaseDiff(String string2, String string3, Locale locale) {
        ParamCaseOrder[] paramCaseOrderArray;
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string2);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string3);
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = this.getElement(-1);
        int n7 = 0;
        int n8 = 0;
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            String string4;
            if (bl) {
                n4 = collationElementIterator2.getOffset();
                n7 = this.getElement(collationElementIterator2.next());
                n5 = collationElementIterator2.getOffset();
            }
            if (bl2) {
                n2 = collationElementIterator.getOffset();
                n8 = this.getElement(collationElementIterator.next());
                n3 = collationElementIterator.getOffset();
            }
            bl = true;
            bl2 = true;
            if (n7 == n6 || n8 == n6) {
                return null;
            }
            if (n8 == 0) {
                bl = false;
                continue;
            }
            if (n7 == 0) {
                bl2 = false;
                continue;
            }
            if (n8 == n7 || n4 >= n5 || n2 >= n3) continue;
            String string5 = string2.substring(n2, n3);
            String string6 = string3.substring(n4, n5);
            String string7 = string5.toUpperCase(locale);
            if (this.m_collator.compare(string7, string4 = string6.toUpperCase(locale)) != 0) continue;
            paramCaseOrderArray = new ParamCaseOrder[]{ParamCaseOrder.UNKNOWN, ParamCaseOrder.UNKNOWN};
            if (this.m_collator.compare(string5, string7) == 0) {
                paramCaseOrderArray[0] = ParamCaseOrder.UPPER_FIRST;
            } else if (this.m_collator.compare(string5, string5.toLowerCase(locale)) == 0) {
                paramCaseOrderArray[0] = ParamCaseOrder.LOWER_FIRST;
            }
            if (this.m_collator.compare(string6, string4) == 0) {
                paramCaseOrderArray[1] = ParamCaseOrder.UPPER_FIRST;
            } else if (this.m_collator.compare(string6, string6.toLowerCase(locale)) == 0) {
                paramCaseOrderArray[1] = ParamCaseOrder.LOWER_FIRST;
            }
            if (paramCaseOrderArray[0] == ParamCaseOrder.UPPER_FIRST && paramCaseOrderArray[1] == ParamCaseOrder.LOWER_FIRST || paramCaseOrderArray[0] == ParamCaseOrder.LOWER_FIRST && paramCaseOrderArray[1] == ParamCaseOrder.UPPER_FIRST) break;
        }
        return paramCaseOrderArray;
    }

    private static final int getMask(int n2) {
        switch (n2) {
            case 0: {
                return -65536;
            }
            case 1: {
                return -256;
            }
        }
        return -1;
    }

    private final int getElement(int n2) {
        return n2 & this.m_mask;
    }

    @Override
    public Range firstOccurance(String string2, String string3) {
        Range range = null;
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string2);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string3);
        for (int i = 0; i < string2.length(); ++i) {
            collationElementIterator.setOffset(i);
            collationElementIterator2.reset();
            Range range2 = this.match(collationElementIterator, collationElementIterator2);
            if (range2 == null) continue;
            range = range2;
            break;
        }
        return range;
    }

    @Override
    public Range lastOccurance(String string2, String string3) {
        Range range = null;
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string2);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string3);
        for (int i = 0; i < string2.length(); ++i) {
            collationElementIterator.setOffset(i);
            collationElementIterator2.reset();
            Range range2 = this.match(collationElementIterator, collationElementIterator2);
            if (range2 == null) continue;
            range = range2;
        }
        return range;
    }

    @Override
    public int filterComparisonWithCaseOrder(String string2, String string3, XCollator.CaseOrder caseOrder, int n2) {
        int n3;
        if (this.m_secondaryStrengthCollator != null && (n3 = this.m_secondaryStrengthCollator.compare(string2, string3)) != 0) {
            return n2;
        }
        CollationElementIterator collationElementIterator = this.m_collator.getCollationElementIterator(string2);
        CollationElementIterator collationElementIterator2 = this.m_collator.getCollationElementIterator(string3);
        int n4 = collationElementIterator.getOffset();
        int n5 = collationElementIterator2.getOffset();
        int n6 = 0;
        boolean bl = false;
        while (!bl && n6 == 0) {
            int n7;
            int n8 = collationElementIterator.next();
            int n9 = collationElementIterator2.next();
            boolean bl2 = n8 == -1;
            boolean bl3 = n9 == -1;
            boolean bl4 = bl = bl2 || bl3;
            if (bl) break;
            int n10 = bl2 ? string2.length() : collationElementIterator.getOffset();
            int n11 = n7 = bl3 ? string3.length() : collationElementIterator2.getOffset();
            if (n8 != n9) {
                int n12;
                int n13;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                for (n13 = n4; n13 < n10; ++n13) {
                    if (bl5 && bl7) continue;
                    n12 = string2.codePointAt(n13);
                    if (!bl5 && Character.isUpperCase(n12)) {
                        bl5 = true;
                    }
                    if (bl7 || !Character.isLowerCase(n12)) continue;
                    bl7 = true;
                }
                for (n13 = n5; n13 < n7; ++n13) {
                    if (bl6 && bl8) continue;
                    n12 = string3.codePointAt(n13);
                    if (!bl6 && Character.isUpperCase(n12)) {
                        bl6 = true;
                    }
                    if (bl8 || !Character.isLowerCase(n12)) continue;
                    bl8 = true;
                }
                switch (caseOrder) {
                    case LOWER_FIRST: {
                        if (bl5 && !bl6 && bl8) {
                            n6 = 1;
                            break;
                        }
                        if (bl5 || !bl7 || !bl6) break;
                        n6 = -1;
                        break;
                    }
                    case UPPER_FIRST: {
                        if (bl5 && !bl6 && bl8) {
                            n6 = -1;
                            break;
                        }
                        if (bl5 || !bl7 || !bl6) break;
                        n6 = 1;
                    }
                }
            }
            n4 = n10;
            n5 = n7;
        }
        return n6 != 0 ? n6 : n2;
    }
}

