/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.unicode.normalize;

import com.ibm.icu.text.Normalizer;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;

public final class XNormalizer {
    public static final String DEFAULT_FORM = "NFC";
    public static final String EMPTY_STRING = "";

    public static final String normalizeUnicode(String string2) {
        return string2.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(string2, XNormalizer.getNormalizerMode(DEFAULT_FORM));
    }

    public static final String normalizeUnicode(String string2, String string3) {
        return string2.equals(EMPTY_STRING) ? EMPTY_STRING : XNormalizer.normalizeUnicode(string2, XNormalizer.getNormalizerMode(string3));
    }

    public static synchronized boolean alreadyNormalizedUnicode(String string2) {
        return Normalizer.quickCheck((String)string2, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM)).equals(Normalizer.YES);
    }

    public static synchronized int normalizeUnicode(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5) {
        int n6 = Normalizer.normalize((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0);
        return n6;
    }

    public static synchronized boolean alreadyNormalizedUnicode(char[] cArray, int n2, int n3) {
        return Normalizer.quickCheck((char[])cArray, (int)n2, (int)n3, (Normalizer.Mode)XNormalizer.getNormalizerMode(DEFAULT_FORM), (int)0).equals(Normalizer.YES);
    }

    private static final synchronized String normalizeUnicode(String string2, Normalizer.Mode mode) {
        if (Normalizer.quickCheck((String)string2, (Normalizer.Mode)mode).equals(Normalizer.YES)) {
            return string2;
        }
        return Normalizer.normalize((String)string2, (Normalizer.Mode)mode);
    }

    private static final Normalizer.Mode getNormalizerMode(String string2) {
        String string3 = string2.trim().toUpperCase();
        try {
            if (string3.equals(DEFAULT_FORM)) {
                return Normalizer.NFC;
            }
            if (string3.equals("NFD")) {
                return Normalizer.NFD;
            }
            if (string3.equals("NFKC")) {
                return Normalizer.NFKC;
            }
            if (string3.equals("NFKD")) {
                return Normalizer.NFKD;
            }
            if (string3.equals("FCD")) {
                return Normalizer.FCD;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new NoClassDefFoundError(XMLMessages.createXMLMessage("ER_NEEDS_ICU", new Object[]{"normalizeUnicode"}));
        }
        throw new RuntimeException(XMLMessages.createXMLMessage("ER_UNSUPPORTED_NORMALIZATION_FORM", new Object[]{string2}));
    }
}

