/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.BaseConstants;

public abstract class OccurrenceIndicator
implements BaseConstants {
    public static final OccurrenceIndicator ZERO_OR_MORE = new ZeroOrMore();
    public static final OccurrenceIndicator ONE_OR_MORE = new OneOrMore();
    public static final OccurrenceIndicator ZERO_OR_ONE = new ZeroOrOne();
    public static final OccurrenceIndicator TWO_OR_MORE = new TwoOrMore();
    public static final OccurrenceIndicator ONE = new One();

    protected OccurrenceIndicator() {
    }

    public abstract boolean canBeEmpty();

    public abstract int matches(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator sum(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator choice(OccurrenceIndicator var1);

    public abstract OccurrenceIndicator product(OccurrenceIndicator var1);

    public static class TwoOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "2+";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == this || occurrenceIndicator == ZERO_OR_MORE || occurrenceIndicator == ONE_OR_MORE) {
                return 1;
            }
            return 0;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator occurrenceIndicator) {
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ONE || occurrenceIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (occurrenceIndicator == TWO_OR_MORE) {
                return TWO_OR_MORE;
            }
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }
    }

    public static class One
    extends OccurrenceIndicator {
        public String toString() {
            return "";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator occurrenceIndicator) {
            return occurrenceIndicator != TWO_OR_MORE ? 1 : 0;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == TWO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return occurrenceIndicator;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator occurrenceIndicator) {
            return occurrenceIndicator;
        }
    }

    public static class ZeroOrOne
    extends OccurrenceIndicator {
        public String toString() {
            return "?";
        }

        @Override
        public boolean canBeEmpty() {
            return true;
        }

        @Override
        public int matches(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == this || occurrenceIndicator == ZERO_OR_MORE) {
                return 1;
            }
            if (occurrenceIndicator == TWO_OR_MORE) {
                return 0;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ONE || occurrenceIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ONE || occurrenceIndicator == ZERO_OR_ONE) {
                return ZERO_OR_ONE;
            }
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ONE || occurrenceIndicator == ZERO_OR_ONE) {
                return ZERO_OR_ONE;
            }
            return ZERO_OR_MORE;
        }
    }

    public static class OneOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "+";
        }

        @Override
        public boolean canBeEmpty() {
            return false;
        }

        @Override
        public int matches(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == this || occurrenceIndicator == ZERO_OR_MORE) {
                return 1;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ONE_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return ONE_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            if (occurrenceIndicator == TWO_OR_MORE) {
                return TWO_OR_MORE;
            }
            return ONE_OR_MORE;
        }
    }

    public static class ZeroOrMore
    extends OccurrenceIndicator {
        public String toString() {
            return "*";
        }

        @Override
        public boolean canBeEmpty() {
            return true;
        }

        @Override
        public int matches(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == this) {
                return 1;
            }
            return 2;
        }

        @Override
        public OccurrenceIndicator sum(OccurrenceIndicator occurrenceIndicator) {
            if (occurrenceIndicator == ONE || occurrenceIndicator == ONE_OR_MORE) {
                return ONE_OR_MORE;
            }
            if (occurrenceIndicator == ZERO_OR_ONE || occurrenceIndicator == ZERO_OR_MORE) {
                return ZERO_OR_MORE;
            }
            return TWO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator choice(OccurrenceIndicator occurrenceIndicator) {
            return ZERO_OR_MORE;
        }

        @Override
        public OccurrenceIndicator product(OccurrenceIndicator occurrenceIndicator) {
            return ZERO_OR_MORE;
        }
    }
}

