/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xml.types;

import com.ibm.xltxe.rnm1.xtq.xml.types.AnyAtomicType;
import com.ibm.xltxe.rnm1.xtq.xml.types.IDerivableType;
import com.ibm.xltxe.rnm1.xtq.xml.types.ItemType;
import com.ibm.xltxe.rnm1.xtq.xml.types.NodeType;
import com.ibm.xltxe.rnm1.xtq.xml.types.Type;
import com.ibm.xltxe.rnm1.xtq.xml.types.UntypedAny;
import com.ibm.xltxe.rnm1.xtq.xml.types.XSequenceType;
import javax.xml.namespace.QName;

public class ElementType
extends NodeType {
    private Type m_elementType;
    private QName m_elementName;
    private QName[] m_subGroupNames;
    private boolean m_nillable;
    private boolean m_isDeclaration;

    public ElementType() {
        this(null, null, false);
    }

    public ElementType(QName qName, Type type2) {
        this(qName, type2, false);
    }

    public ElementType(QName qName, Type type2, boolean bl) {
        this.m_elementName = qName;
        this.m_elementType = type2;
        this.m_nillable = bl;
    }

    public ElementType(QName qName, QName[] qNameArray, Type type2, boolean bl) {
        this.m_elementName = qName;
        this.m_elementType = type2;
        this.m_subGroupNames = qNameArray;
        this.m_nillable = bl;
        this.m_isDeclaration = true;
    }

    public boolean isNillable() {
        return this.m_nillable;
    }

    public boolean isDeclaration() {
        return this.m_isDeclaration;
    }

    public QName getElementName() {
        return this.m_elementName;
    }

    public Type getElementType() {
        return this.m_elementType;
    }

    @Override
    public Type getAtomizedType() {
        if (this.m_elementType instanceof AnyAtomicType) {
            return this.m_elementType;
        }
        if (this.m_elementType == UNTYPEDANY) {
            return UNTYPEDATOMIC;
        }
        return UNTYPEDATOMIC;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("element(");
        if (this.m_elementName != null) {
            stringBuffer.append(this.m_elementName.toString());
        } else {
            stringBuffer.append('*');
        }
        stringBuffer.append(", ");
        if (this.m_elementType != null) {
            stringBuffer.append(this.m_elementType.toString());
        } else {
            stringBuffer.append('*');
        }
        if (this.m_nillable) {
            stringBuffer.append(", nillable");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object2) {
        if (object2 instanceof ElementType) {
            ElementType elementType = (ElementType)object2;
            return this.elementNameEquals(elementType) && this.elementTypeEquals(elementType) && this.m_nillable == elementType.isNillable();
        }
        return false;
    }

    private boolean elementNameEquals(ElementType elementType) {
        if (this.m_elementName != null) {
            return this.m_elementName.equals(elementType.getElementName());
        }
        return elementType.getElementName() == null;
    }

    private boolean elementTypeEquals(ElementType elementType) {
        if (this.m_elementType != null) {
            return this.m_elementType.equals(elementType.getElementType());
        }
        return elementType.getElementType() == null;
    }

    @Override
    public int getId() {
        return 53;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int typeMatches(XSequenceType xSequenceType, int n2) {
        ItemType itemType = xSequenceType.getBaseType();
        if (itemType == Type.NODE) return 1;
        if (itemType == Type.ITEM) {
            return 1;
        }
        if (!(itemType instanceof ElementType)) return 0;
        ElementType elementType = (ElementType)itemType;
        QName qName = elementType.getElementName();
        Type type2 = elementType.getElementType();
        QName[] qNameArray = elementType.getSubGroupNames();
        boolean bl = true;
        if (qName != null && !(bl = qName.equals(this.m_elementName)) && qNameArray != null && this.m_elementName != null) {
            for (int i = 0; i < qNameArray.length && !(bl = qNameArray[i].equals(this.m_elementName)); ++i) {
            }
        }
        if (bl) {
            if (type2 == null) return 1;
            if (!(this.m_elementType instanceof IDerivableType)) return 2;
            if (((IDerivableType)((Object)this.m_elementType)).isDerivedFrom((IDerivableType)((Object)type2))) {
                return 1;
            }
            if (!(this.m_elementType instanceof UntypedAny)) return 0;
            return 2;
        }
        if (this.m_elementName != null) return 0;
        return 2;
    }

    public QName[] getSubGroupNames() {
        return this.m_subGroupNames;
    }
}

