/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.utils;

import com.ibm.xltxe.rnm1.xtq.xci.dtm.utils.ExtendedType;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;

public class ExpandedNameTable {
    static final String IBM_COPYRIGHT = "Licensed Materials - Property of IBM\n\nXML Cursor Interface for Java (XCI-J)\u00a9 Copyright IBM Corp. 2004, 2008. All Rights Reserved.\n\nUS Government Users Restricted Rights - Use, duplication or disclosure \nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final short NTYPES = 14;
    private ExtendedType[] m_extendedTypes;
    private static int m_initialSize = 128;
    private int m_nextType;
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int TEXT = 3;
    public static final int CDATA_SECTION = 4;
    public static final int ENTITY_REFERENCE = 5;
    public static final int ENTITY = 6;
    public static final int PROCESSING_INSTRUCTION = 7;
    public static final int COMMENT = 8;
    public static final int DOCUMENT = 9;
    public static final int DOCUMENT_TYPE = 10;
    public static final int DOCUMENT_FRAGMENT = 11;
    public static final int NOTATION = 12;
    public static final int NAMESPACE = 13;
    private static ExtendedType[] m_defaultExtendedTypes;
    private static float m_loadFactor;
    private static int m_initialCapacity;
    private int m_capacity = m_initialCapacity;
    private int m_threshold = (int)((float)this.m_capacity * m_loadFactor);
    private HashEntry[] m_table = new HashEntry[this.m_capacity];

    public ExpandedNameTable() {
        this.initExtendedTypes();
    }

    private void initExtendedTypes() {
        this.m_extendedTypes = new ExtendedType[m_initialSize];
        for (int i = 0; i < 14; ++i) {
            this.m_extendedTypes[i] = m_defaultExtendedTypes[i];
            this.m_table[i] = new HashEntry(m_defaultExtendedTypes[i], i, i, null);
        }
        this.m_nextType = 14;
    }

    public int getExpandedTypeID(String string2, String string3, int n2, boolean bl) {
        Object object2;
        int n3;
        int n4;
        if (null == string2) {
            string2 = "";
        }
        if (null == string3) {
            string3 = "";
        }
        if ((n4 = (n3 = n2 + string2.hashCode() + string3.hashCode()) % this.m_capacity) < 0) {
            n4 = -n4;
        }
        Object object3 = this.m_table[n4];
        while (object3 != null) {
            object2 = ((HashEntry)object3).key;
            if (((HashEntry)object3).hash == n3 && object2.getNodeType() == n2 && object2.getLocalName().equals(string3) && object2.getNamespace().equals(string2)) {
                return ((HashEntry)object3).value;
            }
            object3 = ((HashEntry)object3).next;
        }
        if (bl) {
            return -1;
        }
        if (this.m_nextType > this.m_threshold) {
            this.rehash();
            n4 = n3 % this.m_capacity;
            if (n4 < 0) {
                n4 = -n4;
            }
        }
        object3 = new ExtendedType(n2, string2, string3, n3);
        if (this.m_extendedTypes.length == this.m_nextType) {
            object2 = new ExtendedType[this.m_extendedTypes.length * 2];
            System.arraycopy(this.m_extendedTypes, 0, object2, 0, this.m_extendedTypes.length);
            this.m_extendedTypes = object2;
        }
        this.m_extendedTypes[this.m_nextType] = object3;
        this.m_table[n4] = object2 = new HashEntry((ExtendedType)object3, this.m_nextType, n3, this.m_table[n4]);
        return this.m_nextType++;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.m_extendedTypes.length; ++i) {
            if (this.m_extendedTypes[i] == null) continue;
            stringBuilder.append(this.m_extendedTypes[i].toString()).append(",");
        }
        return stringBuilder.append(']').toString();
    }

    private void rehash() {
        int n2;
        int n3 = this.m_capacity;
        HashEntry[] hashEntryArray = this.m_table;
        this.m_capacity = n2 = 2 * n3 + 1;
        this.m_threshold = (int)((float)n2 * m_loadFactor);
        this.m_table = new HashEntry[n2];
        for (int i = n3 - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                HashEntry hashEntry2 = hashEntry;
                hashEntry = hashEntry.next;
                int n4 = hashEntry2.hash % n2;
                if (n4 < 0) {
                    n4 = -n4;
                }
                hashEntry2.next = this.m_table[n4];
                this.m_table[n4] = hashEntry2;
            }
        }
    }

    public int getExpandedTypeID(int n2) {
        return n2;
    }

    public String getLocalName(int n2) {
        return this.m_extendedTypes[n2].getLocalName();
    }

    public final int getLocalNameID(int n2) {
        if (this.m_extendedTypes[n2].getLocalName().equals("")) {
            return 0;
        }
        return n2;
    }

    public String getNamespace(int n2) {
        String string2 = this.m_extendedTypes[n2].getNamespace();
        return string2.equals("") ? null : string2;
    }

    public String getNamespace2(int n2) {
        String string2 = this.m_extendedTypes[n2].getNamespace();
        return string2;
    }

    public final int getNamespaceID(int n2) {
        if (this.m_extendedTypes[n2].getNamespace().equals("")) {
            return 0;
        }
        return n2;
    }

    public final short getType(int n2) {
        return (short)this.m_extendedTypes[n2].getNodeType();
    }

    public boolean setItemPSVI(int n2, XSTypeDefinition xSTypeDefinition) {
        ExtendedType extendedType = this.m_extendedTypes[n2];
        XSTypeDefinition xSTypeDefinition2 = extendedType.getXSTypeDefinition();
        if (xSTypeDefinition2 == null) {
            extendedType.setXSTypeDefinition(xSTypeDefinition);
            return true;
        }
        return xSTypeDefinition2.equals(xSTypeDefinition);
    }

    public XSTypeDefinition getSchemaType(int n2) {
        ExtendedType extendedType = this.m_extendedTypes[n2];
        XSTypeDefinition xSTypeDefinition = extendedType.getXSTypeDefinition();
        return xSTypeDefinition;
    }

    public int getSize() {
        return this.m_nextType;
    }

    public ExtendedType[] getExtendedTypes() {
        return this.m_extendedTypes;
    }

    public boolean assertTypeMappings(String[] stringArray, String[] stringArray2, int[] nArray) {
        int n2 = stringArray.length;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                String string2 = i < stringArray2.length ? stringArray2[i] : "";
                int n3 = this.getExpandedTypeID(string2, stringArray[i], nArray[i], false);
                if (n3 == i + 14) continue;
                return false;
            }
        }
        return true;
    }

    static {
        m_loadFactor = 0.75f;
        m_initialCapacity = 203;
        m_defaultExtendedTypes = new ExtendedType[14];
        for (int i = 0; i < 14; ++i) {
            ExpandedNameTable.m_defaultExtendedTypes[i] = new ExtendedType(i, "", "");
        }
    }

    private static final class HashEntry {
        ExtendedType key;
        int value;
        int hash;
        HashEntry next;

        protected HashEntry(ExtendedType extendedType, int n2, int n3, HashEntry hashEntry) {
            this.key = extendedType;
            this.value = n2;
            this.hash = n3;
            this.next = hashEntry;
        }
    }
}

