/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.ref;

public class IntVectorLazy {
    private int m_blocksize;
    private int[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;
    private boolean _isLazy = false;
    private boolean _isForwardOrderedAndUnique;

    public IntVectorLazy() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new int[this.m_blocksize];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public IntVectorLazy(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new int[n2];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public IntVectorLazy(int n2, int n3) {
        this.m_blocksize = n3;
        this.m_mapSize = n2;
        this.m_map = new int[n2];
        this._isForwardOrderedAndUnique = true;
        this._isLazy = false;
    }

    public IntVectorLazy(IntVectorLazy intVectorLazy) {
        this.m_map = new int[intVectorLazy.m_mapSize];
        this.m_mapSize = intVectorLazy.m_mapSize;
        this.m_firstFree = intVectorLazy.m_firstFree;
        this.m_blocksize = intVectorLazy.m_blocksize;
        System.arraycopy(intVectorLazy.m_map, 0, this.m_map, 0, this.m_firstFree);
        this._isLazy = intVectorLazy._isLazy;
        this._isForwardOrderedAndUnique = intVectorLazy._isForwardOrderedAndUnique;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int n2) {
        this.m_firstFree = n2;
    }

    public final void addElement(int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (this._isForwardOrderedAndUnique && this.m_firstFree > 0 && this.m_map[this.m_firstFree - 1] >= n2) {
            this._isForwardOrderedAndUnique = false;
        }
        this.m_map[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final void insertElementAt(int n2, int n3) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n3 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n3, this.m_map, n3 + 1, this.m_firstFree - n3);
            if (this.m_map[n3 + 1] <= n2) {
                this._isForwardOrderedAndUnique = false;
            }
        }
        if (this._isForwardOrderedAndUnique && n3 > 0 && this.m_map[n3 - 1] >= n2) {
            this._isForwardOrderedAndUnique = false;
        }
        this.m_map[n3] = n2;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = Integer.MIN_VALUE;
        }
        this.m_firstFree = 0;
        this._isForwardOrderedAndUnique = true;
    }

    public final boolean removeElement(int n2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n2) continue;
            if (i + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
            } else {
                this.m_map[i] = Integer.MIN_VALUE;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n2) {
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2, this.m_firstFree);
        } else {
            this.m_map[n2] = Integer.MIN_VALUE;
        }
        --this.m_firstFree;
    }

    public final void reverseElements() {
        int n2 = this.m_firstFree;
        int n3 = n2 - 1;
        int n4 = n2 >> 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.m_map[n3];
            this.m_map[n3] = this.m_map[n5];
            this.m_map[n5] = n6;
            ++n5;
            --n3;
        }
    }

    public final void setElementAt(int n2, int n3) {
        this.m_map[n3] = n2;
    }

    public final int elementAt(int n2) {
        return this.m_map[n2];
    }

    public final boolean contains(int n2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n2) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(int n2, int n3) {
        for (int i = n3; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n2) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int n2) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n2) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int n2) {
        for (int i = this.m_firstFree - 1; i >= 0; --i) {
            if (this.m_map[i] != n2) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public Object clone() throws CloneNotSupportedException {
        return new IntVectorLazy(this);
    }

    public boolean isForwardOrderedAndUnique() {
        return this._isForwardOrderedAndUnique;
    }

    public void setForwardOrderedAndUnique(boolean bl) {
        this._isForwardOrderedAndUnique = bl;
    }

    public boolean isLazy() {
        return this._isLazy;
    }

    public void setLazy(boolean bl) {
        this._isLazy = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.elementAt(i));
        }
        return stringBuffer.toString();
    }

    public final void sortAndEliminateDups() {
        this.quicksort(this.m_map, 0, this.size() - 1);
        int n2 = this.eleiminateDupsFromSorted(this.m_map);
        this.m_firstFree -= n2;
        this.setForwardOrderedAndUnique(true);
    }

    private int eleiminateDupsFromSorted(int[] nArray) {
        int n2 = 0;
        for (int i = 1; i < this.size(); ++i) {
            if (nArray[i - 1] == nArray[i]) {
                ++n2;
            }
            if (n2 <= 0) continue;
            nArray[i - n2] = nArray[i];
        }
        return n2;
    }

    public void quicksort(int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n4 >= n5) {
            return;
        }
        if (n4 == n5 - 1) {
            if (nArray[n4] > nArray[n5]) {
                int n6 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = n6;
            }
            return;
        }
        int n7 = nArray[(n4 + n5) / 2];
        nArray[(n4 + n5) / 2] = nArray[n5];
        nArray[n5] = n7;
        while (n4 < n5) {
            while (nArray[n4] <= n7 && n4 < n5) {
                ++n4;
            }
            while (n7 <= nArray[n5] && n4 < n5) {
                --n5;
            }
            if (n4 >= n5) continue;
            int n8 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = n8;
        }
        nArray[n3] = nArray[n5];
        nArray[n5] = n7;
        this.quicksort(nArray, n2, n4 - 1);
        this.quicksort(nArray, n5 + 1, n3);
    }
}

