/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.xci.dtm.ref;

import com.ibm.xltxe.rnm1.xtq.xci.dtm.DTMException;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.CoroutineManager;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.ref.IncrementalSAXSource;
import com.ibm.xltxe.rnm1.xtq.xci.dtm.utils.ThreadControllerWrapper;
import com.ibm.xltxe.rnm1.xtq.xci.res.XMLMessages;
import java.io.IOException;
import java.io.Serializable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class IncrementalSAXSource_Filter
implements IncrementalSAXSource,
ContentHandler,
DTDHandler,
LexicalHandler,
ErrorHandler,
Runnable {
    boolean DEBUG = false;
    private CoroutineManager fCoroutineManager = null;
    private int fControllerCoroutineID = -1;
    private int fSourceCoroutineID = -1;
    private ContentHandler clientContentHandler = null;
    private LexicalHandler clientLexicalHandler = null;
    private DTDHandler clientDTDHandler = null;
    private ErrorHandler clientErrorHandler = null;
    private int eventcounter;
    private int frequency = 5;
    private boolean fNoMoreEvents = false;
    private XMLReader fXMLReader = null;
    private InputSource fXMLReaderInputSource = null;

    public IncrementalSAXSource_Filter() {
        this.init(new CoroutineManager(), -1, -1);
    }

    public IncrementalSAXSource_Filter(CoroutineManager coroutineManager, int n2) {
        this.init(coroutineManager, n2, -1);
    }

    public static IncrementalSAXSource createIncrementalSAXSource(CoroutineManager coroutineManager, int n2) {
        return new IncrementalSAXSource_Filter(coroutineManager, n2);
    }

    public void init(CoroutineManager coroutineManager, int n2, int n3) {
        if (coroutineManager == null) {
            coroutineManager = new CoroutineManager();
        }
        this.fCoroutineManager = coroutineManager;
        this.fControllerCoroutineID = coroutineManager.co_joinCoroutineSet(n2);
        this.fSourceCoroutineID = coroutineManager.co_joinCoroutineSet(n3);
        if (this.fControllerCoroutineID == -1 || this.fSourceCoroutineID == -1) {
            String string2 = "IncrmentalSAXSource_Filter.init() was called, but ";
            string2 = this.fControllerCoroutineID == -1 ? string2 + "controllerCoroutineID of " + n2 + " failed on co.co_joinCoroutineSet()" : string2 + "fSourceCoroutineID of " + this.fSourceCoroutineID + " failed on co.co_joinCoroutineSet()";
            throw new DTMException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string2}));
        }
        this.fNoMoreEvents = false;
        this.eventcounter = this.frequency;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.fXMLReader = xMLReader;
        xMLReader.setContentHandler(this);
        xMLReader.setDTDHandler(this);
        xMLReader.setErrorHandler(this);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.clientContentHandler = contentHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        this.clientDTDHandler = dTDHandler;
    }

    @Override
    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.clientLexicalHandler = lexicalHandler;
    }

    public void setErrHandler(ErrorHandler errorHandler) {
        this.clientErrorHandler = errorHandler;
    }

    public void setReturnFrequency(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.frequency = this.eventcounter = n2;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.characters(cArray, n2, n3);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endDocument();
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endElement(string2, string3, string4);
        }
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.endPrefixMapping(string2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.ignorableWhitespace(cArray, n2, n3);
        }
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.processingInstruction(string2, string3);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (--this.eventcounter <= 0) {
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.skippedEntity(string2);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.co_entry_pause();
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startDocument();
        }
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startElement(string2, string3, string4, attributes2);
        }
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
        if (this.clientContentHandler != null) {
            this.clientContentHandler.startPrefixMapping(string2, string3);
        }
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.comment(cArray, n2, n3);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endCDATA();
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endDTD();
        }
    }

    @Override
    public void endEntity(String string2) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.endEntity(string2);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startCDATA();
        }
    }

    @Override
    public void startDTD(String string2, String string3, String string4) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startDTD(string2, string3, string4);
        }
    }

    @Override
    public void startEntity(String string2) throws SAXException {
        if (null != this.clientLexicalHandler) {
            this.clientLexicalHandler.startEntity(string2);
        }
    }

    @Override
    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        if (null != this.clientDTDHandler) {
            this.clientDTDHandler.notationDecl(string2, string3, string4);
        }
    }

    @Override
    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        if (null != this.clientDTDHandler) {
            this.clientDTDHandler.unparsedEntityDecl(string2, string3, string4, string5);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
        this.eventcounter = 0;
        this.co_yield(false);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (null != this.clientErrorHandler) {
            this.clientErrorHandler.error(sAXParseException);
        }
    }

    public int getSourceCoroutineID() {
        return this.fSourceCoroutineID;
    }

    public int getControllerCoroutineID() {
        return this.fControllerCoroutineID;
    }

    public CoroutineManager getCoroutineManager() {
        return this.fCoroutineManager;
    }

    protected void count_and_yield(boolean bl) throws SAXException {
        if (!bl) {
            this.eventcounter = 0;
        }
        if (--this.eventcounter <= 0) {
            this.co_yield(true);
            this.eventcounter = this.frequency;
        }
    }

    private void co_entry_pause() throws SAXException {
        if (this.fCoroutineManager == null) {
            this.init(null, -1, -1);
        }
        try {
            Object object2 = this.fCoroutineManager.co_entry_pause(this.fSourceCoroutineID);
            if (object2 == Boolean.FALSE) {
                this.co_yield(false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.DEBUG) {
                noSuchMethodException.printStackTrace();
            }
            throw new SAXException(noSuchMethodException);
        }
    }

    private void co_yield(boolean bl) throws SAXException {
        if (this.fNoMoreEvents) {
            return;
        }
        try {
            Object object2 = Boolean.FALSE;
            if (bl) {
                object2 = this.fCoroutineManager.co_resume(Boolean.TRUE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
            if (object2 == Boolean.FALSE) {
                this.fNoMoreEvents = true;
                if (this.fXMLReader != null) {
                    throw new StopException();
                }
                this.fCoroutineManager.co_exit_to(Boolean.FALSE, this.fSourceCoroutineID, this.fControllerCoroutineID);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
            throw new SAXException(noSuchMethodException);
        }
    }

    @Override
    public void startParse(InputSource inputSource) throws SAXException {
        if (this.fNoMoreEvents) {
            String string2 = "IncrementalSAXSource_Filter.startParse() called, but there are no events to parse.";
            throw new SAXException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string2}));
        }
        if (this.fXMLReader == null) {
            String string3 = "IncrementalSAXSource_Filter.startParse() called, but the XMLReader is null";
            throw new SAXException(XMLMessages.createXMLMessage("SYSTEM_ERROR", new Object[]{string3}));
        }
        this.fXMLReaderInputSource = inputSource;
        ThreadControllerWrapper.runThread(this, -1);
    }

    @Override
    public void run() {
        if (this.fXMLReader == null) {
            return;
        }
        if (this.DEBUG) {
            System.out.println("IncrementalSAXSource_Filter parse thread launched");
        }
        Serializable serializable = Boolean.FALSE;
        try {
            this.fXMLReader.parse(this.fXMLReaderInputSource);
        }
        catch (IOException iOException) {
            serializable = iOException;
        }
        catch (StopException stopException) {
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof StopException) {
                if (this.DEBUG) {
                    System.out.println("Active IncrementalSAXSource_Filter normal stop exception");
                }
            }
            if (this.DEBUG) {
                System.out.println("Active IncrementalSAXSource_Filter UNEXPECTED SAX exception: " + exception);
                exception.printStackTrace();
            }
            serializable = sAXException;
        }
        this.fXMLReader = null;
        try {
            this.fNoMoreEvents = true;
            this.fCoroutineManager.co_exit_to(serializable, this.fSourceCoroutineID, this.fControllerCoroutineID);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace(System.err);
            this.fCoroutineManager.co_exit(this.fSourceCoroutineID);
        }
    }

    @Override
    public Object deliverMoreNodes(boolean bl) {
        if (this.fNoMoreEvents) {
            return Boolean.FALSE;
        }
        try {
            Object object2 = this.fCoroutineManager.co_resume(bl ? Boolean.TRUE : Boolean.FALSE, this.fControllerCoroutineID, this.fSourceCoroutineID);
            if (object2 == Boolean.FALSE) {
                this.fCoroutineManager.co_exit(this.fControllerCoroutineID);
            }
            return object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return noSuchMethodException;
        }
    }

    class StopException
    extends RuntimeException {
        private static final long serialVersionUID = 2263978686197558602L;

        StopException() {
        }
    }
}

