/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.utils;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.SimpleNode;
import com.ibm.xltxe.rnm1.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTBaseMsg;
import com.ibm.xltxe.rnm1.xtq.ast.res.ASTMsg;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SourceLocation;
import java.util.Vector;

public class Reporter {
    private boolean _debug = true;
    private boolean _reportImmediately = true;
    private ErrorHandler _errorHandler;
    private boolean _dieOnError = false;
    private Vector _errors = new Vector();
    private Vector _warnings = new Vector();
    private boolean _hasErrors = false;

    public void reset() {
        this._errors.removeAllElements();
        this._warnings.removeAllElements();
        this._hasErrors = false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public boolean errorsFound() {
        return this._hasErrors || this._errors.size() > 0;
    }

    public void printErrors() {
        int n2 = this._errors.size();
        if (n2 > 0) {
            System.err.println(new ASTMsg("ERR_SYSTEM", "Compiler errors."));
            for (int i = 0; i < n2; ++i) {
                System.err.println("  " + this._errors.elementAt(i));
            }
            this._errors.clear();
        }
    }

    public void printWarnings() {
        int n2 = this._warnings.size();
        if (n2 > 0) {
            System.err.println(new ASTMsg("COMPILER_WARNING_KEY"));
            for (int i = 0; i < n2; ++i) {
                System.err.println("  " + this._warnings.elementAt(i));
            }
            this._warnings.clear();
        }
    }

    public void _assert(String string2) {
        ASTMsg aSTMsg = new ASTMsg(new RuntimeException(string2));
        this.report(0, aSTMsg);
    }

    public void _assert(boolean bl) {
        if (!bl) {
            Throwable throwable = new Throwable("Programmers Assertion Failed!");
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(boolean bl, Throwable throwable) {
        if (!bl) {
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(boolean bl, SimpleNode simpleNode) {
        if (!bl) {
            Throwable throwable = new Throwable("\nProblem with: " + simpleNode.getClass().getName() + "! \nLine #" + simpleNode.getLineNumber() + " type: " + XPathTreeConstants.jjtNodeName[simpleNode.getId()]);
            ASTMsg aSTMsg = new ASTMsg(throwable);
            this.report(0, aSTMsg);
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public void _assert(Throwable throwable) {
        ASTMsg aSTMsg = new ASTMsg(throwable);
        this.report(0, aSTMsg);
    }

    public void assertNotImplemented(Throwable throwable) {
        ASTMsg aSTMsg = new ASTMsg(throwable);
        this.report(0, aSTMsg);
    }

    public void report(int n2, ASTBaseMsg aSTBaseMsg) {
        this.report(n2, aSTBaseMsg, null);
    }

    private void reportErrorHandler(int n2, String string2, SourceLocation sourceLocation, Throwable throwable) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this._errorHandler.report(3, string2, sourceLocation, throwable, true);
                this._hasErrors = true;
                break;
            }
            case 3: {
                this._errorHandler.report(2, string2, sourceLocation, throwable, false);
                this._hasErrors = true;
                break;
            }
            case 4: {
                this._errorHandler.report(1, string2, sourceLocation, throwable, false);
                break;
            }
            case 5: {
                this._errorHandler.report(2, string2, sourceLocation, throwable, false);
            }
        }
    }

    private void reportImmediately(int n2, RuntimeException runtimeException) {
        if (this.isDieOnError() && n2 != 4 || n2 == 2) {
            if (this._errors.size() > 1) {
                this.printErrors();
            }
            if (this._warnings.size() > 1) {
                this.printWarnings();
            }
            throw runtimeException;
        }
        if (this.isDebug() && n2 != 4) {
            if (this._errors.size() > 1) {
                this.printErrors();
            }
            if (this._warnings.size() > 1) {
                this.printWarnings();
            }
            runtimeException.printStackTrace();
        } else {
            if (this._errors.size() > 0) {
                this.printErrors();
            }
            if (this._warnings.size() > 0) {
                this.printWarnings();
            }
        }
    }

    public void report(int n2, ASTBaseMsg aSTBaseMsg, Throwable throwable) {
        if (this._errorHandler != null) {
            String string2 = aSTBaseMsg.getFormattedMessage();
            SourceLocation sourceLocation = aSTBaseMsg.getSourceLocation();
            this.reportErrorHandler(n2, string2, sourceLocation, throwable);
            return;
        }
        switch (n2) {
            case 0: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 1: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 2: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 3: {
                this._errors.addElement(aSTBaseMsg);
                break;
            }
            case 4: {
                this._warnings.addElement(aSTBaseMsg);
            }
        }
        if (this.isReportImmediately()) {
            RuntimeException runtimeException = new RuntimeException(aSTBaseMsg.toString());
            this.reportImmediately(n2, runtimeException);
        }
    }

    public void report(int n2, String string2, Throwable throwable) {
        if (this._errorHandler != null) {
            this.reportErrorHandler(n2, string2, null, throwable);
            return;
        }
        if (this.isReportImmediately()) {
            if (throwable instanceof RuntimeException) {
                this.reportImmediately(n2, (RuntimeException)throwable);
            } else {
                this.reportImmediately(n2, new RuntimeException(throwable));
            }
        }
    }

    public Vector getErrors() {
        return this._errors;
    }

    public Vector getWarnings() {
        return this._warnings;
    }

    public boolean isReportImmediately() {
        return this._reportImmediately;
    }

    public void setReportImmediately(boolean bl) {
        this._reportImmediately = bl;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public boolean isDieOnError() {
        return this._dieOnError;
    }

    public void setDieOnError(boolean bl) {
        this._dieOnError = bl;
    }
}

