/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.scontext;

import com.ibm.xltxe.rnm1.xtq.ast.nodes.Expr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class MergedCharacterMapsManager {
    private static final int FULLYKNOWN = 1;
    private static final int NOT_PROCESSED = 2;
    public static final int CIRCULAR_REFERENCE = 3;
    private static final int NOT_FULLYKNOWN = 4;
    private Hashtable m_mapName2CharMap;
    ArrayList m_referencedMapping;
    ArrayList m_nodeThatReferences;

    public String[] getCharacterMapNames() {
        String[] stringArray;
        if (this.m_mapName2CharMap == null) {
            stringArray = new String[]{};
        } else {
            Enumeration enumeration = this.m_mapName2CharMap.keys();
            stringArray = new String[this.m_mapName2CharMap.size()];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
        }
        return stringArray;
    }

    private void putCharacterMap(String string2, CharacterMapRecord characterMapRecord) {
        this.m_mapName2CharMap.put(string2, characterMapRecord);
    }

    public CharacterMapRecord findCharMap(String string2) {
        CharacterMapRecord characterMapRecord = null;
        if (this.m_mapName2CharMap != null && string2 != null) {
            characterMapRecord = (CharacterMapRecord)this.m_mapName2CharMap.get(string2);
        }
        return characterMapRecord;
    }

    public CharacterMapRecord getCharMap(String string2, Expr.ImportPrecedence importPrecedence) {
        CharacterMapRecord characterMapRecord;
        if (this.m_mapName2CharMap == null) {
            this.m_mapName2CharMap = new Hashtable();
        }
        if ((characterMapRecord = this.findCharMap(string2)) == null) {
            characterMapRecord = new CharacterMapRecord(string2, importPrecedence);
            this.putCharacterMap(string2, characterMapRecord);
        } else if (importPrecedence.hasHigherPrecedenceThan(characterMapRecord.m_impPrecedence)) {
            characterMapRecord = new CharacterMapRecord(string2, importPrecedence);
            this.putCharacterMap(string2, characterMapRecord);
        }
        return characterMapRecord;
    }

    public void setCharacterMapping(String string2, int n2, String string3) {
        CharacterMapRecord characterMapRecord = this.findCharMap(string2);
        if (characterMapRecord == null) {
            characterMapRecord = this.getCharMap(string2, Expr.ImportPrecedence.getLowestPrecedence());
        }
        characterMapRecord.setMapping(n2, string3);
    }

    public void setDependancy(String string2, String string3) {
        CharacterMapRecord characterMapRecord = this.findCharMap(string2);
        characterMapRecord.setDependancy(string3);
    }

    public void process() {
        CharacterMapRecord characterMapRecord;
        String string2;
        int n2;
        String[] stringArray = this.getCharacterMapNames();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string2 = stringArray[n2];
            characterMapRecord = this.findCharMap(string2);
            characterMapRecord.reset();
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string2 = stringArray[n2];
            characterMapRecord = this.findCharMap(string2);
            characterMapRecord.process(null);
        }
    }

    public int getStatus(String string2) {
        CharacterMapRecord characterMapRecord = this.findCharMap(string2);
        int n2 = characterMapRecord.getStatus();
        return n2;
    }

    public CharacterMapRecord[] getCircularList(String string2) {
        CharacterMapRecord characterMapRecord = this.findCharMap(string2);
        CharacterMapRecord[] characterMapRecordArray = characterMapRecord.m_circularList;
        return characterMapRecordArray;
    }

    public void characterMapIsReferenced(String string2, Object object2) {
        if (this.m_referencedMapping == null) {
            this.m_referencedMapping = new ArrayList();
            this.m_nodeThatReferences = new ArrayList();
        }
        this.m_referencedMapping.add(string2);
        this.m_nodeThatReferences.add(object2);
    }

    public String[] getReferences() {
        String[] stringArray = this.m_referencedMapping != null ? this.m_referencedMapping.toArray(new String[0]) : new String[]{};
        return stringArray;
    }

    public Object[] getReferencingNodes() {
        Object[] objectArray = this.m_nodeThatReferences != null ? this.m_nodeThatReferences.toArray() : new String[]{};
        return objectArray;
    }

    public class CharacterMapRecord {
        Object m_expr;
        private int m_status2 = 2;
        private String[] m_use_character_maps;
        private final Hashtable m_rawMappings = new Hashtable();
        private final Hashtable m_mergedIntegerToOutputCharacterRecord = new Hashtable();
        private final String m_mapName;
        private CharacterMapRecord[] m_circularList = null;
        private final Expr.ImportPrecedence m_impPrecedence;
        private boolean m_isDuplicate;
        private boolean m_isReferencedByOutputorResultDocument;
        private String m_lexicalQName;

        public void markDuplicate() {
            this.m_isDuplicate = true;
        }

        public boolean isDuplicate() {
            return this.m_isDuplicate;
        }

        public void mightBeUsedByOutputOrResultDocument() {
            this.m_isReferencedByOutputorResultDocument = true;
        }

        public boolean isReferenced() {
            return this.m_isReferencedByOutputorResultDocument;
        }

        private void setCircularList(CharacterMapRecord[] characterMapRecordArray) {
            this.m_circularList = characterMapRecordArray;
        }

        private CharacterMapRecord[] getCircularList() {
            return this.m_circularList;
        }

        public int getStatus() {
            return this.m_status2;
        }

        private void setStatus(int n2) {
            this.m_status2 = n2;
        }

        private CharacterMapRecord(String string2, Expr.ImportPrecedence importPrecedence) {
            this.m_mapName = string2;
            this.m_impPrecedence = importPrecedence;
        }

        private void setMapping(int n2, String string2) {
            Integer n3 = new Integer(n2);
            OutputCharacterRecord outputCharacterRecord = new OutputCharacterRecord(n2, string2);
            this.putRawCharacterMap(n3, outputCharacterRecord);
            this.putMergedCharacterMap(n3, outputCharacterRecord);
        }

        private void setDependancy(String string2) {
            if (this.m_use_character_maps == null) {
                this.m_use_character_maps = new String[1];
                this.m_use_character_maps[0] = string2;
            } else {
                int n2 = this.m_use_character_maps.length;
                String[] stringArray = new String[n2 + 1];
                System.arraycopy(this.m_use_character_maps, 0, stringArray, 0, n2);
                stringArray[n2] = string2;
                this.m_use_character_maps = stringArray;
            }
        }

        private void reset() {
            this.m_mergedIntegerToOutputCharacterRecord.clear();
            this.setCircularList(null);
            this.setStatus(2);
            if (this.m_use_character_maps != null) {
                boolean bl = true;
                while (bl) {
                    bl = false;
                    for (int i = 0; i < this.m_use_character_maps.length - 1; ++i) {
                        String string2 = this.m_use_character_maps[i];
                        String string3 = this.m_use_character_maps[i + 1];
                        CharacterMapRecord characterMapRecord = MergedCharacterMapsManager.this.findCharMap(string2);
                        CharacterMapRecord characterMapRecord2 = MergedCharacterMapsManager.this.findCharMap(string3);
                        if (!characterMapRecord.getImportPrecedence().hasHigherPrecedenceThan(characterMapRecord2.getImportPrecedence())) continue;
                        this.m_use_character_maps[i] = string3;
                        this.m_use_character_maps[i + 1] = string2;
                        bl = true;
                    }
                }
            }
        }

        public OutputCharacterRecord[] getRawOutputCharacterRecords() {
            Enumeration enumeration = this.m_rawMappings.keys();
            int n2 = this.m_rawMappings.size();
            OutputCharacterRecord[] outputCharacterRecordArray = new OutputCharacterRecord[n2];
            for (int i = 0; i < outputCharacterRecordArray.length; ++i) {
                Object k = enumeration.nextElement();
                outputCharacterRecordArray[i] = (OutputCharacterRecord)this.m_rawMappings.get(k);
            }
            return outputCharacterRecordArray;
        }

        private void putRawCharacterMap(Integer n2, OutputCharacterRecord outputCharacterRecord) {
            this.m_rawMappings.put(n2, outputCharacterRecord);
        }

        public Expr.ImportPrecedence getImportPrecedence() {
            return this.m_impPrecedence;
        }

        public String getLocalName() {
            int n2 = this.m_mapName.indexOf(125);
            String string2 = 0 < n2 ? this.m_mapName.substring(n2 + 1) : this.m_mapName;
            return string2;
        }

        public String getURI() {
            int n2 = this.m_mapName.indexOf(123);
            int n3 = this.m_mapName.indexOf(125);
            String string2 = 0 <= n2 && n2 < n3 ? this.m_mapName.substring(n2 + 1, n3) : "";
            return string2;
        }

        public OutputCharacterRecord[] getMergedOutputCharacterRecords() {
            Enumeration enumeration = this.m_mergedIntegerToOutputCharacterRecord.keys();
            int n2 = this.m_mergedIntegerToOutputCharacterRecord.size();
            OutputCharacterRecord[] outputCharacterRecordArray = new OutputCharacterRecord[n2];
            for (int i = 0; i < outputCharacterRecordArray.length; ++i) {
                Object k = enumeration.nextElement();
                outputCharacterRecordArray[i] = (OutputCharacterRecord)this.m_mergedIntegerToOutputCharacterRecord.get(k);
            }
            return outputCharacterRecordArray;
        }

        private void putMergedCharacterMap(Integer n2, OutputCharacterRecord outputCharacterRecord) {
            this.m_mergedIntegerToOutputCharacterRecord.put(n2, outputCharacterRecord);
        }

        private void process(CharacterMapRecord[] characterMapRecordArray) {
            int n2;
            CharacterMapRecord characterMapRecord;
            String string2;
            int n3;
            int n4;
            if (this.getStatus() != 2) {
                return;
            }
            CharacterMapRecord characterMapRecord2 = MergedCharacterMapsManager.this.findCharMap(this.m_mapName);
            characterMapRecordArray = this.appendToList(characterMapRecordArray, characterMapRecord2);
            for (n4 = characterMapRecordArray.length - 2; 0 <= n4; --n4) {
                if (characterMapRecordArray[n4] != characterMapRecord2) continue;
                int n5 = characterMapRecordArray.length - n4;
                CharacterMapRecord[] characterMapRecordArray2 = new CharacterMapRecord[n5];
                System.arraycopy(characterMapRecordArray, n4, characterMapRecordArray2, 0, n5);
                this.setCircularList(characterMapRecordArray2);
                this.setStatus(3);
                return;
            }
            n4 = 1;
            if (this.m_use_character_maps != null) {
                for (n3 = 0; n3 < this.m_use_character_maps.length; ++n3) {
                    string2 = this.m_use_character_maps[n3];
                    characterMapRecord = MergedCharacterMapsManager.this.findCharMap(string2);
                    if (characterMapRecord != null) {
                        characterMapRecord.process(characterMapRecordArray);
                        int n6 = characterMapRecord.getStatus();
                        switch (n6) {
                            case 1: {
                                break;
                            }
                            case 3: {
                                n4 = 0;
                                CharacterMapRecord[] characterMapRecordArray3 = characterMapRecord.getCircularList();
                                for (n2 = 0; n2 < characterMapRecordArray3.length; ++n2) {
                                    if (characterMapRecordArray3[n2] != characterMapRecord2) continue;
                                    int n7 = n2 + 1;
                                    CharacterMapRecord[] characterMapRecordArray4 = new CharacterMapRecord[1 + n7];
                                    characterMapRecordArray4[0] = characterMapRecord2;
                                    System.arraycopy(characterMapRecordArray3, 0, characterMapRecordArray4, 1, n7);
                                    this.setCircularList(characterMapRecordArray4);
                                    this.setStatus(3);
                                    return;
                                }
                            }
                            default: {
                                n4 = 0;
                                break;
                            }
                        }
                        continue;
                    }
                    n4 = 0;
                }
            }
            if (n4 == 0) {
                this.setStatus(4);
                return;
            }
            if (this.m_use_character_maps != null) {
                for (n3 = 0; n3 < this.m_use_character_maps.length; ++n3) {
                    string2 = this.m_use_character_maps[n3];
                    characterMapRecord = MergedCharacterMapsManager.this.findCharMap(string2);
                    OutputCharacterRecord[] outputCharacterRecordArray = characterMapRecord.getMergedOutputCharacterRecords();
                    for (int i = 0; i < outputCharacterRecordArray.length; ++i) {
                        n2 = outputCharacterRecordArray[i].m_inputChar;
                        Integer n8 = new Integer(n2);
                        this.m_mergedIntegerToOutputCharacterRecord.put(n8, outputCharacterRecordArray[i]);
                    }
                }
            }
            OutputCharacterRecord[] outputCharacterRecordArray = this.getRawOutputCharacterRecords();
            for (int i = 0; i < outputCharacterRecordArray.length; ++i) {
                int n9 = outputCharacterRecordArray[i].m_inputChar;
                Integer n10 = new Integer(n9);
                this.m_mergedIntegerToOutputCharacterRecord.put(n10, outputCharacterRecordArray[i]);
            }
            this.setStatus(1);
        }

        private CharacterMapRecord[] appendToList(CharacterMapRecord[] characterMapRecordArray, CharacterMapRecord characterMapRecord) {
            if (characterMapRecordArray == null) {
                characterMapRecordArray = new CharacterMapRecord[]{characterMapRecord};
            } else {
                int n2 = characterMapRecordArray.length;
                CharacterMapRecord[] characterMapRecordArray2 = new CharacterMapRecord[n2 + 1];
                System.arraycopy(characterMapRecordArray, 0, characterMapRecordArray2, 0, n2);
                characterMapRecordArray2[n2] = characterMapRecord;
                characterMapRecordArray = characterMapRecordArray2;
            }
            return characterMapRecordArray;
        }

        public void setExpr(Object object2) {
            this.m_expr = object2;
        }

        public Object getExpr() {
            return this.m_expr;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<xsl:character-map name='").append(this.m_mapName);
            stringBuffer.append("' ");
            if (this.m_use_character_maps != null) {
                stringBuffer.append("use-character-maps='");
                for (int i = 0; i < this.m_use_character_maps.length; ++i) {
                    stringBuffer.append(this.m_use_character_maps[i]).append(' ');
                }
                stringBuffer.append("'");
            }
            stringBuffer.append(" />");
            if (this.m_isDuplicate) {
                stringBuffer.append("*** DUP ***");
            }
            switch (this.getStatus()) {
                case 1: {
                    stringBuffer.append(" FULLKNOWN");
                    break;
                }
                case 2: {
                    stringBuffer.append(" NOT_PROCESSED");
                    break;
                }
                case 3: {
                    stringBuffer.append(" CIRCULAR_REFERENCE");
                }
            }
            return stringBuffer.toString();
        }

        public void setLexicalQName(String string2) {
            this.m_lexicalQName = string2;
        }

        public String getLexicalQName() {
            return this.m_lexicalQName;
        }
    }

    public static class OutputCharacterRecord {
        public final int m_inputChar;
        public final String m_outputString;

        private OutputCharacterRecord() {
            this.m_inputChar = 0;
            this.m_outputString = null;
        }

        private OutputCharacterRecord(int n2, String string2) {
            this.m_inputChar = n2;
            this.m_outputString = string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<xsl:output-character character='");
            stringBuffer.append((char)this.m_inputChar).append("' (integer " + this.m_inputChar);
            stringBuffer.append(")  string='").append(this.m_outputString).append("' />");
            return stringBuffer.toString();
        }
    }
}

