/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.exec.DelegatingErrorHandler;
import com.ibm.xltxe.rnm1.xtq.exec.XDynamicContextImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XFactoryImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XFactoryUtils;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xml.xapi.XDynamicContext;
import com.ibm.xml.xapi.XExecutable;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.ErrorHandler;
import com.ibm.xml.xci.exec.Executable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;

public class XExecutableImpl
implements XExecutable {
    private XFactoryImpl m_factory;
    private Executable m_spiExecutable;
    private boolean m_isValidating;

    public XExecutableImpl(XFactoryImpl xFactoryImpl, Executable executable, boolean bl) {
        this.m_factory = xFactoryImpl;
        this.m_spiExecutable = executable;
        this.m_isValidating = bl;
    }

    @Override
    public XSequenceCursor execute(XItemView xItemView) {
        return this.execute(xItemView, null);
    }

    @Override
    public XSequenceCursor execute(XItemView xItemView, XDynamicContext xDynamicContext) {
        Cursor cursor2 = XFactoryUtils.getCursor(xItemView, true);
        XSequenceCursor xSequenceCursor = this.execute(cursor2, xDynamicContext);
        if (cursor2 != null && cursor2 != xSequenceCursor) {
            cursor2.release();
        }
        return xSequenceCursor;
    }

    @Override
    public XSequenceCursor execute(Source source) {
        return this.execute(source, null);
    }

    @Override
    public XSequenceCursor execute(Source source, XDynamicContext xDynamicContext) {
        Cursor cursor2 = XFactoryUtils.getDocument(source, this.getSessionContext(xDynamicContext), this.isValidating(), this.getErrorHandler(xDynamicContext));
        XSequenceCursor xSequenceCursor = this.execute(cursor2, xDynamicContext);
        if (cursor2 != null && cursor2 != xSequenceCursor) {
            cursor2.release();
        }
        return xSequenceCursor;
    }

    @Override
    public XSequenceCursor execute() {
        return this.execute((XItemView)null);
    }

    @Override
    public XSequenceCursor execute(XDynamicContext xDynamicContext) {
        return this.execute((XItemView)null, xDynamicContext);
    }

    protected XSequenceCursor execute(Cursor cursor2, XDynamicContext xDynamicContext) {
        this.initializeBindings(xDynamicContext);
        DynamicContext dynamicContext = this.getSPIDynamicContext(xDynamicContext);
        Cursor cursor3 = this.m_spiExecutable.execute(cursor2, dynamicContext, XFactoryUtils.XLTXE_PROFILE, null);
        return XFactoryUtils.getSequenceCursor(cursor3, false);
    }

    @Override
    public List<XItemView> executeToList(Source source, XDynamicContext xDynamicContext) {
        return this.getList(this.execute(source, xDynamicContext));
    }

    @Override
    public List<XItemView> executeToList(Source source) {
        return this.getList(this.execute(source));
    }

    @Override
    public List<XItemView> executeToList(XItemView xItemView, XDynamicContext xDynamicContext) {
        return this.getList(this.execute(xItemView, xDynamicContext));
    }

    @Override
    public List<XItemView> executeToList(XItemView xItemView) {
        return this.getList(this.execute(xItemView));
    }

    @Override
    public List<XItemView> executeToList() {
        return this.getList(this.execute((XItemView)null));
    }

    @Override
    public List<XItemView> executeToList(XDynamicContext xDynamicContext) {
        return this.getList(this.execute((XItemView)null, xDynamicContext));
    }

    protected DynamicContext getSPIDynamicContext(XDynamicContext xDynamicContext) {
        DynamicContext dynamicContext;
        if (xDynamicContext == null) {
            dynamicContext = new BasicMutableDynamicContext(this.m_factory.getSessionContext());
            XMessageHandler xMessageHandler = this.m_factory.getMessageHandler();
            if (xMessageHandler != null) {
                dynamicContext.setErrorHandler(new DelegatingErrorHandler(xMessageHandler));
            }
            dynamicContext.setValidating(this.isValidating());
        } else {
            dynamicContext = ((XDynamicContextImpl)xDynamicContext).getSPIDynamicContext();
        }
        return dynamicContext;
    }

    protected SessionContext getSessionContext(XDynamicContext xDynamicContext) {
        if (xDynamicContext != null) {
            return ((XDynamicContextImpl)xDynamicContext).getSessionContext();
        }
        return this.m_factory.getSessionContext();
    }

    protected Executable getSPIExecutable() {
        return this.m_spiExecutable;
    }

    protected boolean isValidating() {
        return this.m_isValidating;
    }

    protected ErrorHandler getErrorHandler(XDynamicContext xDynamicContext) {
        ErrorHandler errorHandler = null;
        if (xDynamicContext != null) {
            errorHandler = ((XDynamicContextImpl)xDynamicContext).getSPIDynamicContext().getErrorHandler();
        }
        return errorHandler;
    }

    private List<XItemView> getList(XSequenceCursor xSequenceCursor) {
        if (xSequenceCursor == null) {
            return Collections.EMPTY_LIST;
        }
        return xSequenceCursor.exportAsList();
    }

    protected void initializeBindings(XDynamicContext xDynamicContext) {
        try {
            if (xDynamicContext instanceof XDynamicContextImpl) {
                Map<String, Object> map2 = this.m_spiExecutable.getProperties();
                XDynamicContextImpl xDynamicContextImpl = (XDynamicContextImpl)xDynamicContext;
                Map map3 = (Map)(map2 == null ? null : map2.get("http://www.ibm.com/xmlns/prod/xcij/function-map"));
                Map map4 = (Map)(map2 == null ? null : map2.get("http://www.ibm.com/xmlns/prod/xcij/variable-map"));
                xDynamicContextImpl.setupBindings(map3, map4);
            }
        }
        catch (Exception exception) {
            this.reportError(xDynamicContext, exception);
        }
    }

    protected void reportError(XDynamicContext xDynamicContext, Exception exception) {
        if (this.getErrorHandler(xDynamicContext) == null) {
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_XSLT_EXECUTION_TERMINATED", null), exception);
        }
        this.getErrorHandler(xDynamicContext).report(-1, XMessageHandler.MsgType.FATAL_ERROR, exception, null, true);
        throw new XProcessException(XMLMessages.createXMLMessage("ER_API_XSLT_EXECUTION_TERMINATED", null), null);
    }
}

