/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.exec.DelegatingErrorHandler;
import com.ibm.xltxe.rnm1.xtq.exec.DelegatingSourceURIResolver;
import com.ibm.xltxe.rnm1.xtq.exec.XFactoryUtils;
import com.ibm.xltxe.rnm1.xtq.exec.XTypeUtils;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xml.xapi.XCollectionResolver;
import com.ibm.xml.xapi.XDynamicContext;
import com.ibm.xml.xapi.XItemView;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xapi.XResultResolver;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xapi.XSourceResolver;
import com.ibm.xml.xapi.XTypeConstants;
import com.ibm.xml.xapi.XUnparsedTextResolver;
import com.ibm.xml.xci.CData;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.bytes.Bytes;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.type.TypeRegistry;
import com.ibm.xml.xml4j.api.s1.xs.XSSimpleTypeDefinition;
import com.ibm.xml.xml4j.api.s1.xs.XSTypeDefinition;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.Collator;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public final class XDynamicContextImpl
implements XDynamicContext {
    private BasicMutableDynamicContext m_context;
    private final SessionContext m_sessionContext;
    private CursorFactory m_cursorFactory;
    private XMessageHandler m_errorHandler;
    private HashMap<QName, Object> m_variableBindings;
    private HashMap<String, ExternalFunction> m_functionBindings;

    public XDynamicContextImpl(SessionContext sessionContext, boolean bl) {
        this.m_context = new BasicMutableDynamicContext(sessionContext);
        this.m_sessionContext = sessionContext;
        this.m_context.setValidating(bl);
    }

    @Override
    public void bind(QName qName, boolean bl) {
        this.bindVariable(qName, new Boolean(bl));
    }

    @Override
    public void bindSequence(QName qName, boolean[] blArray) {
        this.bindVariable(qName, blArray);
    }

    @Override
    public void bind(QName qName, byte by2) {
        this.bindVariable(qName, new Byte(by2));
    }

    @Override
    public void bindSequence(QName qName, byte[] byArray) {
        this.bindVariable(qName, byArray);
    }

    @Override
    public void bind(QName qName, byte[] byArray) {
        this.bindVariable(qName, byArray);
    }

    @Override
    public void bindSequence(QName qName, byte[][] byArray) {
        this.bindVariable(qName, byArray);
    }

    @Override
    public void bind(QName qName, XMLGregorianCalendar xMLGregorianCalendar) {
        this.bindVariable(qName, xMLGregorianCalendar);
    }

    @Override
    public void bindSequence(QName qName, XMLGregorianCalendar[] xMLGregorianCalendarArray) {
        this.bindVariable(qName, xMLGregorianCalendarArray);
    }

    @Override
    public void bind(QName qName, BigDecimal bigDecimal) {
        this.bindVariable(qName, bigDecimal);
    }

    @Override
    public void bindSequence(QName qName, BigDecimal[] bigDecimalArray) {
        this.bindVariable(qName, bigDecimalArray);
    }

    @Override
    public void bind(QName qName, BigInteger bigInteger) {
        this.bindVariable(qName, bigInteger);
    }

    @Override
    public void bindSequence(QName qName, BigInteger[] bigIntegerArray) {
        this.bindVariable(qName, bigIntegerArray);
    }

    @Override
    public void bind(QName qName, double d) {
        this.bindVariable(qName, new Double(d));
    }

    @Override
    public void bindSequence(QName qName, double[] dArray) {
        this.bindVariable(qName, dArray);
    }

    @Override
    public void bind(QName qName, Duration duration2) {
        this.bindVariable(qName, duration2);
    }

    @Override
    public void bindSequence(QName qName, Duration[] durationArray) {
        this.bindVariable(qName, durationArray);
    }

    @Override
    public void bind(QName qName, float f2) {
        this.bindVariable(qName, new Float(f2));
    }

    @Override
    public void bindSequence(QName qName, float[] fArray) {
        this.bindVariable(qName, fArray);
    }

    @Override
    public void bindFunction(QName qName, Method method) {
        this.checkFunctionName(qName);
        this.checkMethod(method);
        ExternalFunction externalFunction = new ExternalFunction(qName, method);
        this.bindFunction(qName, externalFunction);
    }

    @Override
    public void bindFunction(QName qName, Method method, Object object2) {
        this.checkFunctionName(qName);
        this.checkMethod(method);
        if (object2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_INSTANCE_OBJECT", null));
        }
        ExternalFunction externalFunction = new ExternalFunction(qName, method, object2);
        this.bindFunction(qName, externalFunction);
    }

    @Override
    public void bind(QName qName, int n2) {
        this.bindVariable(qName, new Integer(n2));
    }

    @Override
    public void bindSequence(QName qName, int[] nArray) {
        this.bindVariable(qName, nArray);
    }

    @Override
    public void bind(QName qName, XItemView xItemView) {
        this.checkVariableName(qName);
        this.checkVariableValue(xItemView);
        this.m_context.bindVariable(qName, XFactoryUtils.getCursor(xItemView, true));
    }

    @Override
    public void bind(QName qName, long l) {
        this.bindVariable(qName, new Long(l));
    }

    @Override
    public void bindSequence(QName qName, long[] lArray) {
        this.bindVariable(qName, lArray);
    }

    @Override
    public void bind(QName qName, Node node2) {
        this.checkVariableName(qName);
        this.checkVariableValue(node2);
        if (node2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_BIND_NULL_NODE", null));
        }
        this.bind(qName, new DOMSource(node2));
    }

    @Override
    public void bind(QName qName, QName qName2) {
        this.bindVariable(qName, qName2);
    }

    @Override
    public void bindSequence(QName qName, QName[] qNameArray) {
        this.bindVariable(qName, qNameArray);
    }

    @Override
    public void bindSequence(QName qName, XSequenceCursor xSequenceCursor) {
        this.checkVariableName(qName);
        Cursor cursor2 = null;
        if (xSequenceCursor != null) {
            cursor2 = XFactoryUtils.getCursor(xSequenceCursor, true);
        }
        this.m_context.bindVariable(qName, cursor2);
    }

    @Override
    public void bind(QName qName, short s) {
        this.bindVariable(qName, new Short(s));
    }

    @Override
    public void bindSequence(QName qName, short[] sArray) {
        this.bindVariable(qName, sArray);
    }

    @Override
    public void bind(QName qName, Source source) {
        this.checkVariableName(qName);
        this.checkVariableValue(source);
        Cursor cursor2 = XFactoryUtils.getDocument(source, this.getSessionContext(), this.getValidating(), this.m_context.getErrorHandler());
        this.m_context.bindVariable(qName, cursor2);
    }

    @Override
    public void bind(QName qName, String string2) {
        this.bindVariable(qName, string2);
    }

    @Override
    public void bindSequence(QName qName, String[] stringArray) {
        this.bindVariable(qName, stringArray);
    }

    @Override
    public void bind(QName qName, Object object2) {
        this.bindVariable(qName, object2);
    }

    public void setupBindings(Map<String, String> map2, Map<String, String> map3) {
        QName qName;
        String string2;
        Object object2;
        Object object3;
        if (this.m_functionBindings != null) {
            for (Map.Entry<Object, Object> entry : this.m_functionBindings.entrySet()) {
                object3 = (String)entry.getKey();
                object2 = (ExternalFunction)entry.getValue();
                string2 = null;
                if (map2 != null) {
                    string2 = map2.get(object3);
                }
                qName = string2 != null ? QName.valueOf(string2) : XTypeConstants.UNTYPEDATOMIC_QNAME;
                ((ExternalFunction)object2).setType(qName);
                this.m_context.bindFunction(((ExternalFunction)object2).getName(), ((ExternalFunction)object2).getArity(), (Executable)object2);
            }
        }
        if (this.m_variableBindings != null) {
            for (Map.Entry<Object, Object> entry : this.m_variableBindings.entrySet()) {
                object3 = (QName)entry.getKey();
                object2 = entry.getValue();
                string2 = null;
                if (map3 != null) {
                    string2 = map3.get(((QName)object3).toString());
                }
                qName = null;
                if (string2 != null) {
                    qName = QName.valueOf(string2);
                }
                Cursor cursor2 = this.getCursor(object2, qName);
                this.m_context.bindVariable((QName)object3, cursor2);
            }
        }
    }

    private Cursor getCursor(Object object2, QName qName) {
        if (object2 instanceof XSequenceCursor) {
            return XFactoryUtils.getCursor((XSequenceCursor)object2, true);
        }
        if (object2 instanceof XItemView) {
            return XFactoryUtils.getCursor((XItemView)object2, true);
        }
        if (object2 instanceof String) {
            return this.getCursorFactory().sequence((CharSequence)((String)object2), this.getSimpleTypeDefinition(qName, TypeRegistry.XSSTRING), false);
        }
        if (object2 instanceof Boolean) {
            return this.getCursorFactory().sequence((Boolean)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSBOOLEAN), false);
        }
        if (object2 instanceof Byte) {
            return this.getCursorFactory().sequence((Byte)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSBYTE), false);
        }
        if (object2 instanceof Short) {
            return this.getCursorFactory().sequence((Short)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSSHORT), false);
        }
        if (object2 instanceof Integer) {
            return this.getCursorFactory().sequence((Integer)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSINT), false);
        }
        if (object2 instanceof Long) {
            return this.getCursorFactory().sequence((Long)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSLONG), false);
        }
        if (object2 instanceof Float) {
            return this.getCursorFactory().sequence(((Float)object2).floatValue(), this.getSimpleTypeDefinition(qName, TypeRegistry.XSFLOAT), false);
        }
        if (object2 instanceof Double) {
            return this.getCursorFactory().sequence((Double)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDOUBLE), false);
        }
        if (object2 instanceof BigDecimal) {
            return this.getCursorFactory().sequence((BigDecimal)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDECIMAL), false);
        }
        if (object2 instanceof BigInteger) {
            return this.getCursorFactory().sequence((BigInteger)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSINTEGER), false);
        }
        if (object2 instanceof QName) {
            return this.getCursorFactory().sequence((QName)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSQNAME), false);
        }
        if (object2 instanceof XMLGregorianCalendar) {
            return this.getCursorFactory().sequence((XMLGregorianCalendar)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME), false);
        }
        if (object2 instanceof Duration) {
            return this.getCursorFactory().sequence((Duration)object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION), false);
        }
        if (object2 instanceof Node) {
            return XFactoryUtils.getCursor((Node)object2, this.getSessionContext(), this.getValidating());
        }
        if (object2 instanceof NodeList) {
            return XFactoryUtils.getCursor((NodeList)object2, this.getSessionContext(), this.getValidating());
        }
        if (object2 instanceof NodeIterator) {
            return XFactoryUtils.getCursor((NodeIterator)object2, this.getSessionContext(), this.getValidating());
        }
        if (object2 instanceof Source) {
            return XFactoryUtils.getDocument((Source)object2, this.getSessionContext(), this.getValidating(), this.m_context.getErrorHandler());
        }
        if (object2.getClass().isArray()) {
            Class<?> clazz = object2.getClass().getComponentType();
            if (clazz.equals(Boolean.TYPE)) {
                return this.getCursorFactory().sequence((boolean[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSBOOLEAN), false);
            }
            if (clazz.equals(Byte.TYPE)) {
                return this.getCursorFactory().sequence((byte[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSBYTE), false);
            }
            if (clazz.equals(Short.TYPE)) {
                return this.getCursorFactory().sequence((short[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSSHORT), false);
            }
            if (clazz.equals(Integer.TYPE)) {
                return this.getCursorFactory().sequence((int[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSINT), false);
            }
            if (clazz.equals(Long.TYPE)) {
                return this.getCursorFactory().sequence((long[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSLONG), false);
            }
            if (clazz.equals(Float.TYPE)) {
                return this.getCursorFactory().sequence((float[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSFLOAT), false);
            }
            if (clazz.equals(Double.TYPE)) {
                return this.getCursorFactory().sequence((double[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDOUBLE), false);
            }
            if (clazz.equals(String.class)) {
                return this.getCursorFactory().sequence((String[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSSTRING), false);
            }
            if (clazz.equals(BigDecimal.class)) {
                return this.getCursorFactory().sequence((BigDecimal[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDECIMAL), false);
            }
            if (clazz.equals(BigInteger.class)) {
                return this.getCursorFactory().sequence((BigInteger[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSINTEGER), false);
            }
            if (clazz.equals(QName.class)) {
                return this.getCursorFactory().sequence((QName[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSQNAME), false);
            }
            if (clazz.equals(XMLGregorianCalendar.class)) {
                return this.getCursorFactory().sequence((XMLGregorianCalendar[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDATETIME), false);
            }
            if (clazz.equals(Duration.class)) {
                return this.getCursorFactory().sequence((Duration[])object2, this.getSimpleTypeDefinition(qName, TypeRegistry.XSDURATION), false);
            }
            if (clazz.isArray()) {
                if ((clazz = clazz.getComponentType()).equals(Byte.TYPE)) {
                    byte[][] byArray = (byte[][])object2;
                    if (byArray.length == 0) {
                        return null;
                    }
                    XSSimpleTypeDefinition xSSimpleTypeDefinition = this.getSimpleTypeDefinition(qName, TypeRegistry.XSHEXBINARY);
                    Cursor cursor2 = this.getCursorFactory().sequence(byArray[0], xSSimpleTypeDefinition, false);
                    for (int i = 1; i < byArray.length; ++i) {
                        Cursor cursor3 = this.getCursorFactory().sequence(byArray[i], xSSimpleTypeDefinition, false);
                        cursor2 = cursor2.sequenceConcat(cursor3, cursor2.profile(), cursor2.futureProfile(), false, false, true, false);
                    }
                    return cursor2;
                }
                return this.getCursorFactory().sequence(object2);
            }
            return this.getCursorFactory().sequence(object2);
        }
        return this.getCursorFactory().sequence(object2);
    }

    @Override
    public XMessageHandler getMessageHandler() {
        return this.m_errorHandler;
    }

    @Override
    public boolean getFeature(String string2) {
        if (string2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_FEATURE_NAME", null));
        }
        return this.m_context.getFeature(string2);
    }

    @Override
    public Duration getImplicitTimeZone() {
        try {
            return this.m_context.getImplicitTimeZone().getDuration(1);
        }
        catch (ParseException parseException) {
            throw new XProcessException(parseException.getMessage(), parseException);
        }
    }

    @Override
    public String getBaseOutputURI() {
        return this.m_context.getBaseOutputURI();
    }

    @Override
    public XResultResolver getResultResolver() {
        return this.m_context.getResultResolver();
    }

    @Override
    public XSourceResolver getSourceResolver() {
        URIResolver uRIResolver = this.m_context.getSourceURIResolver();
        if (uRIResolver instanceof DelegatingSourceURIResolver) {
            return ((DelegatingSourceURIResolver)uRIResolver).getSourceResolver();
        }
        return null;
    }

    @Override
    public QName getXSLTInitialMode() {
        return this.m_context.getXSLTInitialMode();
    }

    @Override
    public QName getXSLTInitialTemplate() {
        return this.m_context.getXSLTInitialTemplate();
    }

    @Override
    public void setXSLTInitialMode(QName qName) {
        this.m_context.setXSLTInitialMode(qName);
    }

    @Override
    public void setXSLTInitialTemplate(QName qName) {
        this.m_context.setXSLTInitialTemplate(qName);
    }

    @Override
    public void removeFunctionBinding(QName qName, int n2) {
        this.checkFunctionName(qName);
        this.checkArity(n2);
        if (this.m_functionBindings != null) {
            this.m_functionBindings.remove(this.getFunctionKey(qName, n2));
            this.m_context.removeFunction(qName, n2);
        }
    }

    @Override
    public void removeBinding(QName qName) {
        this.checkVariableName(qName);
        if (this.m_variableBindings != null) {
            this.m_variableBindings.remove(qName);
            this.m_context.removeVariableBinding(qName);
        }
    }

    @Override
    public void bindCollation(String string2, Locale locale) {
        if (locale == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_COLLATOR", null));
        }
        this.bindCollation(string2, Collator.getInstance(locale));
    }

    @Override
    public void bindCollation(String string2, Collator collator2) {
        this.checkCollationURI(string2);
        if (collator2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_COLLATOR", null));
        }
        this.m_context.bindCollation(string2, collator2);
    }

    @Override
    public Collator getCollation(String string2) {
        this.checkCollationURI(string2);
        return this.m_context.getCollation(string2);
    }

    @Override
    public void removeCollationBinding(String string2) {
        this.checkCollationURI(string2);
        this.m_context.removeCollation(string2);
    }

    @Override
    public void setMessageHandler(XMessageHandler xMessageHandler) {
        this.m_errorHandler = xMessageHandler;
        DelegatingErrorHandler delegatingErrorHandler = null;
        if (xMessageHandler != null) {
            delegatingErrorHandler = new DelegatingErrorHandler(xMessageHandler);
        }
        this.m_context.setErrorHandler(delegatingErrorHandler);
    }

    @Override
    public void setFeature(String string2, boolean bl) {
        if (string2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_FEATURE_NAME", null));
        }
        this.m_context.setFeature(string2, bl);
    }

    @Override
    public void setImplicitTimeZone(Duration duration2) {
        CData cData = null;
        if (duration2 != null) {
            cData = this.getCursorFactory().data(duration2, TypeRegistry.XSDAYTIMEDURATION, false);
        }
        this.m_context.setImplicitTimeZone(cData);
    }

    @Override
    public void setBaseOutputURI(String string2) {
        this.m_context.setBaseOutputURI(string2);
    }

    @Override
    public void setResultResolver(XResultResolver xResultResolver) {
        this.m_context.setResultResolver(xResultResolver);
    }

    @Override
    public void setSourceResolver(XSourceResolver xSourceResolver) {
        if (xSourceResolver == null) {
            this.m_context.setSourceURIResolver(null);
        } else {
            this.m_context.setSourceURIResolver(new DelegatingSourceURIResolver(xSourceResolver));
        }
    }

    @Override
    public XCollectionResolver getCollectionResolver() {
        return this.m_context.getCollectionResolver();
    }

    @Override
    public void setCollectionResolver(XCollectionResolver xCollectionResolver) {
        this.m_context.setCollectionResolver(xCollectionResolver);
    }

    public DynamicContext getSPIDynamicContext() {
        return this.m_context;
    }

    public SessionContext getSessionContext() {
        return this.m_sessionContext;
    }

    public TypeRegistry getTypeRegistry() {
        return this.m_sessionContext.getTypeRegistry();
    }

    public boolean getValidating() {
        return this.m_context.getValidating();
    }

    @Override
    public XUnparsedTextResolver getUnparsedTextResolver() {
        return this.m_context.getUnparsedTextResolver();
    }

    @Override
    public void setUnparsedTextResolver(XUnparsedTextResolver xUnparsedTextResolver) {
        this.m_context.setUnparsedTextResolver(xUnparsedTextResolver);
    }

    private CursorFactory getCursorFactory() {
        if (this.m_cursorFactory == null) {
            this.m_cursorFactory = this.getSessionContext().getSimpleDataFactory();
        }
        return this.m_cursorFactory;
    }

    private void checkVariableName(QName qName) {
        if (qName == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_VARIABLE_NAME", null));
        }
    }

    private void checkVariableValue(Object object2) {
        if (object2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_VARIABLE_VALUE", null));
        }
    }

    private void checkFunctionName(QName qName) {
        if (qName == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_FUNCTION_NAME", null));
        }
    }

    private void checkMethod(Method method) {
        if (method == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_METHOD", null));
        }
    }

    private void checkType(QName qName) {
        if (qName == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_TYPE", null));
        }
    }

    private void checkArity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_NEGATIVE_ARITY", Integer.toString(n2)));
        }
    }

    private void checkCollationURI(String string2) {
        boolean bl;
        Serializable serializable;
        IllegalArgumentException illegalArgumentException = null;
        if (string2 == null) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_API_NULL_URI", null));
        }
        if ("http://www.w3.org/2005/xpath-functions/collation/codepoint".equals(string2)) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_UCP_URI_BINDING", null));
        }
        try {
            serializable = URI.create(string2);
            bl = ((URI)serializable).isAbsolute();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
            bl = false;
        }
        if (!bl) {
            serializable = new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_NOT_ABSOLUTE_COLLATION_URI", string2));
            if (illegalArgumentException != null) {
                ((Throwable)serializable).initCause(illegalArgumentException);
            }
            throw serializable;
        }
    }

    private XSSimpleTypeDefinition getSimpleTypeDefinition(QName qName, XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        if (qName == null) {
            return xSSimpleTypeDefinition;
        }
        return this.getSimpleTypeDefinition(qName);
    }

    private XSSimpleTypeDefinition getSimpleTypeDefinition(QName qName) {
        this.checkType(qName);
        XSSimpleTypeDefinition xSSimpleTypeDefinition = XTypeUtils.getSimpleTypeForName(qName, this.getTypeRegistry());
        if (xSSimpleTypeDefinition != null) {
            return xSSimpleTypeDefinition;
        }
        throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_API_NOT_SIMPLE_ATOMIC", qName));
    }

    private void bindFunction(QName qName, ExternalFunction externalFunction) {
        if (this.m_functionBindings == null) {
            this.m_functionBindings = new HashMap();
        }
        String string2 = this.getFunctionKey(qName, externalFunction.getArity());
        this.m_functionBindings.put(string2, externalFunction);
    }

    private String getFunctionKey(QName qName, int n2) {
        return qName.toString() + ":" + n2;
    }

    private void bindVariable(QName qName, Object object2) {
        this.checkVariableName(qName);
        this.checkVariableValue(object2);
        if (this.m_variableBindings == null) {
            this.m_variableBindings = new HashMap();
        }
        this.m_variableBindings.put(qName, object2);
    }

    private class ExternalFunction
    implements Executable {
        QName m_name;
        Method m_method;
        QName m_type;
        Object m_instanceObject;

        public ExternalFunction(QName qName, Method method) {
            this.m_name = qName;
            this.m_method = method;
        }

        public ExternalFunction(QName qName, Method method, Object object2) {
            this.m_name = qName;
            this.m_method = method;
            this.m_instanceObject = object2;
        }

        public void setType(QName qName) {
            this.m_type = qName;
        }

        public QName getName() {
            return this.m_name;
        }

        public int getArity() {
            return this.m_method.getParameterTypes().length;
        }

        @Override
        public Cursor execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            try {
                int n2 = 0;
                Object object2 = null;
                if (!Modifier.isStatic(this.m_method.getModifiers())) {
                    if (this.m_instanceObject != null) {
                        object2 = this.m_instanceObject;
                    } else {
                        throw new XProcessException(XMLMessages.createXMLMessage("ER_EXT_FUNC_NO_INSTANCE_OBJECT", new Object[]{this.m_method.getName(), this.m_method.getParameterTypes().length}), null);
                    }
                }
                Object[] objectArray = this.getJavaArgs(cursorArray, n2);
                Object object3 = this.m_method.invoke(object2, objectArray);
                return this.getResult(object3);
            }
            catch (XProcessException xProcessException) {
                throw xProcessException;
            }
            catch (Exception exception) {
                throw new XProcessException(exception.getMessage(), exception);
            }
        }

        @Override
        public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
            Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            cursor3.copyToResult(result2, null, false, true);
        }

        private Object[] getJavaArgs(Cursor[] cursorArray, int n2) throws Exception {
            Class<?>[] classArray = this.m_method.getParameterTypes();
            if (cursorArray.length != classArray.length) {
                throw new XProcessException(XMLMessages.createXMLMessage("ER_EXT_FUNC_WRONG_NUMBER_ARGS", new Object[]{this.m_method.getName(), Integer.toString(classArray.length), Integer.toString(cursorArray.length)}), null);
            }
            Object[] objectArray = new Object[cursorArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz = classArray[i];
                Cursor cursor2 = cursorArray[i + n2];
                if (clazz.equals(Node.class)) {
                    objectArray[i] = XFactoryUtils.getNode(cursor2);
                    continue;
                }
                if (clazz.equals(XItemView.class)) {
                    objectArray[i] = XFactoryUtils.getSequenceCursor(cursor2, false).getSingletonItem();
                    continue;
                }
                if (clazz.equals(XSequenceCursor.class)) {
                    objectArray[i] = XFactoryUtils.getSequenceCursor(cursor2, true);
                    continue;
                }
                if (clazz.equals(NodeList.class)) {
                    objectArray[i] = XFactoryUtils.getNodeList(cursor2);
                    continue;
                }
                if (clazz.equals(NodeIterator.class)) {
                    objectArray[i] = XFactoryUtils.getNodeIterator(cursor2);
                    continue;
                }
                if (clazz.isArray()) {
                    XSTypeDefinition xSTypeDefinition;
                    Class<?> clazz2 = clazz.getComponentType();
                    if (clazz2.equals(Byte.TYPE)) {
                        xSTypeDefinition = cursor2.itemXSType();
                        if (xSTypeDefinition.derivedFromType(TypeRegistry.XSBASE64BINARY, (short)3)) {
                            objectArray[i] = this.getByteArray(cursor2.itemTypedValue().getBase64Binary(1));
                            continue;
                        }
                        if (xSTypeDefinition.derivedFromType(TypeRegistry.XSHEXBINARY, (short)3)) {
                            objectArray[i] = this.getByteArray(cursor2.itemTypedValue().getHexBinary(1));
                            continue;
                        }
                        objectArray[i] = this.getSequenceArgument(cursor2, clazz2);
                        continue;
                    }
                    if (clazz2.isArray()) {
                        if (clazz2.getComponentType().equals(Byte.TYPE)) {
                            int n3;
                            byte[][] byArrayArray;
                            xSTypeDefinition = cursor2.itemXSType();
                            if (xSTypeDefinition.derivedFromType(TypeRegistry.XSBASE64BINARY, (short)3)) {
                                cursor2 = cursor2.fork(false);
                                byArrayArray = new byte[(int)cursor2.contextSize()][];
                                n3 = 0;
                                do {
                                    byArrayArray[n3] = this.getByteArray(cursor2.itemTypedValue().getBase64Binary(1));
                                } while (++n3 < byArrayArray.length && cursor2.toNext());
                                objectArray[i] = byArrayArray;
                                cursor2.release();
                                continue;
                            }
                            if (xSTypeDefinition.derivedFromType(TypeRegistry.XSHEXBINARY, (short)3)) {
                                cursor2 = cursor2.fork(false);
                                byArrayArray = new byte[(int)cursor2.contextSize()][];
                                n3 = 0;
                                do {
                                    byArrayArray[n3] = this.getByteArray(cursor2.itemTypedValue().getHexBinary(1));
                                } while (++n3 < byArrayArray.length && cursor2.toNext());
                                objectArray[i] = byArrayArray;
                                cursor2.release();
                                continue;
                            }
                            objectArray[i] = this.getSequenceArgument(cursor2, clazz2);
                            continue;
                        }
                        objectArray[i] = this.getSequenceArgument(cursor2, clazz2);
                        continue;
                    }
                    objectArray[i] = this.getSequenceArgument(cursor2, clazz2);
                    continue;
                }
                objectArray[i] = this.getAtomicArgument(cursor2.itemTypedValue(), clazz);
            }
            return objectArray;
        }

        private byte[] getByteArray(Bytes bytes2) {
            byte[] byArray = new byte[(int)bytes2.byteLength()];
            bytes2.writeBytesTo(0, byArray, 0, false);
            return byArray;
        }

        private Object getAtomicArgument(VolatileCData volatileCData, Class clazz) {
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
                return new Boolean(volatileCData.getBoolean(1));
            }
            if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
                return new Byte(volatileCData.getByte(1));
            }
            if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                return new Short(volatileCData.getShort(1));
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                return new Integer(volatileCData.getInt(1));
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                return new Long(volatileCData.getLong(1));
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                return new Float(volatileCData.getFloat(1));
            }
            if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                return new Double(volatileCData.getDouble(1));
            }
            if (clazz.equals(String.class)) {
                return volatileCData.getString(1);
            }
            if (clazz.equals(BigDecimal.class)) {
                return volatileCData.getBigDecimal(1);
            }
            if (clazz.equals(BigInteger.class)) {
                return volatileCData.getBigInteger(1);
            }
            if (clazz.equals(QName.class)) {
                return volatileCData.getQName(1, null);
            }
            if (clazz.equals(XMLGregorianCalendar.class)) {
                try {
                    return volatileCData.getXMLGregorianCalendar(1);
                }
                catch (ParseException parseException) {
                    throw new XProcessException(parseException.getMessage(), parseException);
                }
            }
            if (clazz.equals(Duration.class)) {
                try {
                    return volatileCData.getDuration(1);
                }
                catch (ParseException parseException) {
                    throw new XProcessException(parseException.getMessage(), parseException);
                }
            }
            return volatileCData.getObject(1);
        }

        private Object getSequenceArgument(Cursor cursor2, Class clazz) {
            Object[] objectArray;
            cursor2 = cursor2.fork(false);
            if (clazz.equals(Boolean.TYPE)) {
                boolean[] blArray = new boolean[(int)cursor2.contextSize()];
                int n2 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    blArray[n2] = volatileCData.getBoolean(1);
                } while (++n2 < blArray.length && cursor2.toNext());
                objectArray = blArray;
            } else if (clazz.equals(Boolean.class)) {
                Boolean[] booleanArray = new Boolean[(int)cursor2.contextSize()];
                int n3 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    booleanArray[n3] = new Boolean(volatileCData.getBoolean(1));
                } while (++n3 < booleanArray.length && cursor2.toNext());
                objectArray = booleanArray;
            } else if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
                byte[] byArray = new byte[(int)cursor2.contextSize()];
                int n4 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    byArray[n4] = volatileCData.getByte(1);
                } while (++n4 < byArray.length && cursor2.toNext());
                objectArray = byArray;
            } else if (clazz.equals(Byte.class)) {
                Byte[] byteArray = new Byte[(int)cursor2.contextSize()];
                int n5 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    byteArray[n5] = new Byte(volatileCData.getByte(1));
                } while (++n5 < byteArray.length && cursor2.toNext());
                objectArray = byteArray;
            } else if (clazz.equals(Short.TYPE)) {
                short[] sArray = new short[(int)cursor2.contextSize()];
                int n6 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    sArray[n6] = volatileCData.getShort(1);
                } while (++n6 < sArray.length && cursor2.toNext());
                objectArray = sArray;
            } else if (clazz.equals(Short.class)) {
                Short[] shortArray = new Short[(int)cursor2.contextSize()];
                int n7 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    shortArray[n7] = new Short(volatileCData.getShort(1));
                } while (++n7 < shortArray.length && cursor2.toNext());
                objectArray = shortArray;
            } else if (clazz.equals(Integer.TYPE)) {
                int[] nArray = new int[(int)cursor2.contextSize()];
                int n8 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    nArray[n8] = volatileCData.getInt(1);
                } while (++n8 < nArray.length && cursor2.toNext());
                objectArray = nArray;
            } else if (clazz.equals(Integer.class)) {
                Integer[] integerArray = new Integer[(int)cursor2.contextSize()];
                int n9 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    integerArray[n9] = new Integer(volatileCData.getInt(1));
                } while (++n9 < integerArray.length && cursor2.toNext());
                objectArray = integerArray;
            } else if (clazz.equals(Long.TYPE)) {
                long[] lArray = new long[(int)cursor2.contextSize()];
                int n10 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    lArray[n10] = volatileCData.getLong(1);
                } while (++n10 < lArray.length && cursor2.toNext());
                objectArray = lArray;
            } else if (clazz.equals(Long.class)) {
                Long[] longArray = new Long[(int)cursor2.contextSize()];
                int n11 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    longArray[n11] = new Long(volatileCData.getLong(1));
                } while (++n11 < longArray.length && cursor2.toNext());
                objectArray = longArray;
            } else if (clazz.equals(Float.TYPE)) {
                float[] fArray = new float[(int)cursor2.contextSize()];
                int n12 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    fArray[n12] = volatileCData.getFloat(1);
                } while (++n12 < fArray.length && cursor2.toNext());
                objectArray = fArray;
            } else if (clazz.equals(Float.class)) {
                Float[] floatArray = new Float[(int)cursor2.contextSize()];
                int n13 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    floatArray[n13] = new Float(volatileCData.getFloat(1));
                } while (++n13 < floatArray.length && cursor2.toNext());
                objectArray = floatArray;
            } else if (clazz.equals(Double.TYPE)) {
                double[] dArray = new double[(int)cursor2.contextSize()];
                int n14 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    dArray[n14] = volatileCData.getDouble(1);
                } while (++n14 < dArray.length && cursor2.toNext());
                objectArray = dArray;
            } else if (clazz.equals(Double.class)) {
                Double[] doubleArray = new Double[(int)cursor2.contextSize()];
                int n15 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    doubleArray[n15] = new Double(volatileCData.getDouble(1));
                } while (++n15 < doubleArray.length && cursor2.toNext());
                objectArray = doubleArray;
            } else if (clazz.equals(String.class)) {
                String[] stringArray = new String[(int)cursor2.contextSize()];
                int n16 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    stringArray[n16] = volatileCData.getString(1);
                } while (++n16 < stringArray.length && cursor2.toNext());
                objectArray = stringArray;
            } else if (clazz.equals(BigDecimal.class)) {
                BigDecimal[] bigDecimalArray = new BigDecimal[(int)cursor2.contextSize()];
                int n17 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    bigDecimalArray[n17] = volatileCData.getBigDecimal(1);
                } while (++n17 < bigDecimalArray.length && cursor2.toNext());
                objectArray = bigDecimalArray;
            } else if (clazz.equals(BigInteger.class)) {
                BigInteger[] bigIntegerArray = new BigInteger[(int)cursor2.contextSize()];
                int n18 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    bigIntegerArray[n18] = volatileCData.getBigInteger(1);
                } while (++n18 < bigIntegerArray.length && cursor2.toNext());
                objectArray = bigIntegerArray;
            } else if (clazz.equals(QName.class)) {
                QName[] qNameArray = new QName[(int)cursor2.contextSize()];
                int n19 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    qNameArray[n19] = volatileCData.getQName(1, null);
                } while (++n19 < qNameArray.length && cursor2.toNext());
                objectArray = qNameArray;
            } else if (clazz.equals(XMLGregorianCalendar.class)) {
                try {
                    XMLGregorianCalendar[] xMLGregorianCalendarArray = new XMLGregorianCalendar[(int)cursor2.contextSize()];
                    int n20 = 0;
                    do {
                        VolatileCData volatileCData = cursor2.itemTypedValue();
                        xMLGregorianCalendarArray[n20] = volatileCData.getXMLGregorianCalendar(1);
                    } while (++n20 < xMLGregorianCalendarArray.length && cursor2.toNext());
                    objectArray = xMLGregorianCalendarArray;
                }
                catch (ParseException parseException) {
                    throw new XProcessException(parseException.getMessage(), parseException);
                }
            } else if (clazz.equals(Duration.class)) {
                try {
                    Duration[] durationArray = new Duration[(int)cursor2.contextSize()];
                    int n21 = 0;
                    do {
                        VolatileCData volatileCData = cursor2.itemTypedValue();
                        durationArray[n21] = volatileCData.getDuration(1);
                    } while (++n21 < durationArray.length && cursor2.toNext());
                    objectArray = durationArray;
                }
                catch (ParseException parseException) {
                    throw new XProcessException(parseException.getMessage(), parseException);
                }
            } else if (clazz.equals(Node.class)) {
                Node[] nodeArray = new Node[(int)cursor2.contextSize()];
                int n22 = 0;
                do {
                    nodeArray[n22] = XFactoryUtils.getNode(cursor2);
                } while (++n22 < nodeArray.length && cursor2.toNext());
                objectArray = nodeArray;
            } else {
                Object[] objectArray2 = (Object[])Array.newInstance(clazz, (int)cursor2.contextSize());
                int n23 = 0;
                do {
                    VolatileCData volatileCData = cursor2.itemTypedValue();
                    objectArray2[n23] = volatileCData.getObject(1);
                } while (++n23 < objectArray2.length && cursor2.toNext());
                objectArray = objectArray2;
            }
            cursor2.release();
            return objectArray;
        }

        private Cursor getResult(Object object2) {
            if (object2 == null) {
                return null;
            }
            Class<?> clazz = this.m_method.getReturnType();
            if (clazz.equals(Node.class)) {
                return XFactoryUtils.getCursor((Node)object2, XDynamicContextImpl.this.getSessionContext(), XDynamicContextImpl.this.getValidating());
            }
            if (clazz.equals(NodeList.class)) {
                return XFactoryUtils.getCursor((Node)object2, XDynamicContextImpl.this.getSessionContext(), XDynamicContextImpl.this.getValidating());
            }
            if (clazz.equals(NodeIterator.class)) {
                return XFactoryUtils.getCursor((NodeIterator)object2, XDynamicContextImpl.this.getSessionContext(), XDynamicContextImpl.this.getValidating());
            }
            if (clazz.equals(XItemView.class)) {
                return XFactoryUtils.getCursor((XItemView)object2, true);
            }
            if (clazz.equals(XSequenceCursor.class)) {
                return XFactoryUtils.getCursor((XSequenceCursor)object2, true);
            }
            return XDynamicContextImpl.this.getCursor(object2, this.m_type);
        }

        @Override
        public void execute(Cursor cursor2, Cursor.Area area, Cursor cursor3, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray) {
            if (cursor3 == null) {
                throw new XProcessException(XMLMessages.createXMLMessage("ER_INTERNAL_ERROR", "Cursor result must not be null!"), null);
            }
            Cursor cursor4 = this.execute(cursor2, dynamicContext, profile, cursorArray);
            if (cursor4 != null) {
                cursor3.addCopy(area, cursor4);
                cursor4.release();
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            return null;
        }
    }
}

