/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XSourceResolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;

final class DelegatingSourceURIResolver
implements URIResolver {
    private static final Logger s_logger = LoggerUtil.getLogger(DelegatingSourceURIResolver.class);
    private static final String s_className = DelegatingSourceURIResolver.class.getName();
    XSourceResolver m_resolver;

    public DelegatingSourceURIResolver(XSourceResolver xSourceResolver) {
        this.m_resolver = xSourceResolver;
    }

    @Override
    public Source resolve(String string2, String string3) throws TransformerException {
        try {
            Source source = this.m_resolver.getSource(string2, string3);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "resolve", "User-supplied XSourceResolver " + this.m_resolver + " used to resolve (" + string2 + ", " + string3 + ") returned Source " + source + (source != null ? " with systemId '" + source.getSystemId() + "'" : ""));
            }
            return source;
        }
        catch (Exception exception) {
            throw new TransformerException(exception);
        }
    }

    public XSourceResolver getSourceResolver() {
        return this.m_resolver;
    }
}

