/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XSchemaResolver;
import com.ibm.xml.xci.type.SchemaResolver;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;

public class DelegatingSchemaResolver
implements SchemaResolver {
    private static final Logger s_logger = LoggerUtil.getLogger(DelegatingSchemaResolver.class);
    private static final String s_className = DelegatingSchemaResolver.class.getName();
    XSchemaResolver m_resolver = null;

    public DelegatingSchemaResolver(XSchemaResolver xSchemaResolver) {
        this.m_resolver = xSchemaResolver;
    }

    public XSchemaResolver getSchemaResolver() {
        return this.m_resolver;
    }

    @Override
    public List<? extends Source> resolve(SchemaResolver.SchemaIdentifier schemaIdentifier) {
        List<String> list = schemaIdentifier.getLocations();
        String string2 = schemaIdentifier.getBaseURI();
        String string3 = schemaIdentifier.getNamespace();
        List<? extends Source> list2 = this.m_resolver.getSchema(string3, list, string2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Source source : list2) {
                stringBuilder.append(source);
                if (source != null) {
                    stringBuilder.append(" with systemId '");
                    stringBuilder.append(source.getSystemId());
                    stringBuilder.append('\'');
                }
                stringBuilder.append('\n');
            }
            s_logger.logp(Level.FINER, s_className, "resolve", "User-supplied XSchemaResolver " + this.m_resolver.toString() + " used to resolve (" + schemaIdentifier.toString() + ") returned the following Sources:\n" + stringBuilder.toString());
        }
        return list2;
    }
}

