/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XSequenceCursor;
import com.ibm.xml.xci.exec.SourceLocation;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DelegatingErrorHandler
implements com.ibm.xml.xci.exec.ErrorHandler,
DOMErrorHandler,
ErrorHandler {
    private XMessageHandler m_userEH;

    public DelegatingErrorHandler(XMessageHandler xMessageHandler) {
        this.m_userEH = xMessageHandler;
    }

    @Override
    public void report(int n2, XMessageHandler.MsgType msgType, String string2, SourceLocation sourceLocation, boolean bl) {
        this.m_userEH.report(msgType, string2, sourceLocation, null, null);
    }

    @Override
    public void report(int n2, XMessageHandler.MsgType msgType, Throwable throwable, SourceLocation sourceLocation, boolean bl) {
        this.m_userEH.report(msgType, throwable.getMessage(), sourceLocation, throwable, null);
    }

    public void report(int n2, XMessageHandler.MsgType msgType, String string2, SourceLocation sourceLocation, boolean bl, XSequenceCursor xSequenceCursor) {
        this.m_userEH.report(msgType, string2, sourceLocation, null, xSequenceCursor);
    }

    public void report(int n2, XMessageHandler.MsgType msgType, Throwable throwable, SourceLocation sourceLocation, boolean bl, XSequenceCursor xSequenceCursor) {
        this.m_userEH.report(msgType, throwable.getMessage(), sourceLocation, null, xSequenceCursor);
    }

    @Override
    public boolean handleError(DOMError dOMError) {
        XMessageHandler.MsgType msgType = this.severityToLevel(dOMError.getSeverity());
        String string2 = dOMError.getMessage();
        Object object2 = dOMError.getRelatedException();
        Throwable throwable = object2 instanceof Throwable ? (Throwable)object2 : null;
        SourceLocation sourceLocation = this.convertDOMLocation(dOMError.getLocation());
        this.m_userEH.report(msgType, string2, sourceLocation, throwable, null);
        return true;
    }

    private XMessageHandler.MsgType severityToLevel(short s) {
        switch (s) {
            case 1: {
                return XMessageHandler.MsgType.WARNING;
            }
            case 2: {
                return XMessageHandler.MsgType.ERROR;
            }
        }
        return XMessageHandler.MsgType.FATAL_ERROR;
    }

    private SourceLocation convertDOMLocation(DOMLocator dOMLocator) {
        if (dOMLocator == null) {
            return null;
        }
        return new SourceLocation(dOMLocator.getUri(), null, dOMLocator.getLineNumber(), dOMLocator.getColumnNumber(), -1, -1);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.ERROR, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, null);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.FATAL_ERROR, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, null);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.m_userEH.report(XMessageHandler.MsgType.WARNING, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, null);
    }

    private SourceLocation convertSAXLocation(SAXParseException sAXParseException) {
        return new SourceLocation(sAXParseException.getSystemId(), sAXParseException.getPublicId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), -1, -1);
    }
}

