/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.runtime.HandledRuntimeException;
import com.ibm.xltxe.rnm1.xtq.xslt.res.ErrorMsg;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xci.exec.SourceLocation;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements com.ibm.xml.xci.exec.ErrorHandler,
DOMErrorHandler,
ErrorHandler {
    private String m_unknown = null;

    private void report(XMessageHandler.MsgType msgType, String string2, SourceLocation sourceLocation, Throwable throwable, boolean bl) {
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (sourceLocation != null) {
            string4 = sourceLocation.getSystemId();
            if (string4 == null || string4.length() == 0) {
                string4 = this.getUnknownString();
            }
            string3 = sourceLocation.getStartLine() == -1 ? this.getUnknownString() : String.valueOf(sourceLocation.getStartLine());
            String string5 = sourceLocation.getStartColumn() == -1 ? this.getUnknownString() : String.valueOf(sourceLocation.getStartColumn());
            ErrorMsg errorMsg = new ErrorMsg("SOURCE_LOCATION_MSG", new Object[]{string4, string3, string5});
            stringBuffer.append(errorMsg.getFormattedMessage());
        }
        string4 = stringBuffer.toString();
        switch (msgType) {
            case INFO: {
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(new ErrorMsg("INFO_PLUS_WRAPPED_MSG", (Object)string4, (Object)throwable.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("INFO_MSG", string4));
                break;
            }
            case WARNING: {
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(new ErrorMsg("WARNING_PLUS_WRAPPED_MSG", (Object)string4, (Object)throwable.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("WARNING_MSG", string4));
                break;
            }
            case ERROR: {
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(new ErrorMsg("ERROR_PLUS_WRAPPED_MSG", (Object)string4, (Object)throwable.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("ERROR_MSG", string4));
                break;
            }
            case FATAL_ERROR: {
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)string4, (Object)throwable.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", string4));
                break;
            }
            case TRACE: {
                System.err.println(new ErrorMsg("TRACE_MSG", string4));
                break;
            }
            default: {
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(new ErrorMsg("FATAL_ERR_PLUS_WRAPPED_MSG", (Object)string4, (Object)throwable.getMessage()));
                    break;
                }
                System.err.println(new ErrorMsg("FATAL_ERR_MSG", string4));
            }
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
        if (bl) {
            string3 = string2;
            throw new HandledRuntimeException(string3);
        }
    }

    @Override
    public void report(int n2, XMessageHandler.MsgType msgType, String string2, SourceLocation sourceLocation, boolean bl) {
        this.report(msgType, string2, sourceLocation, null, bl);
    }

    @Override
    public void report(int n2, XMessageHandler.MsgType msgType, Throwable throwable, SourceLocation sourceLocation, boolean bl) {
        this.report(msgType, throwable.getMessage(), sourceLocation, throwable, bl);
    }

    @Override
    public boolean handleError(DOMError dOMError) {
        XMessageHandler.MsgType msgType = this.severityToLevel(dOMError.getSeverity());
        String string2 = dOMError.getMessage();
        Object object2 = dOMError.getRelatedException();
        Throwable throwable = object2 instanceof Throwable ? (Throwable)object2 : null;
        SourceLocation sourceLocation = this.convertDOMLocation(dOMError.getLocation());
        this.report(msgType, string2, sourceLocation, throwable, false);
        return true;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.report(XMessageHandler.MsgType.ERROR, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, false);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.report(XMessageHandler.MsgType.FATAL_ERROR, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, true);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.report(XMessageHandler.MsgType.WARNING, sAXParseException.getLocalizedMessage(), this.convertSAXLocation(sAXParseException), sAXParseException, false);
    }

    private XMessageHandler.MsgType severityToLevel(short s) {
        switch (s) {
            case 1: {
                return XMessageHandler.MsgType.WARNING;
            }
            case 2: {
                return XMessageHandler.MsgType.ERROR;
            }
        }
        return XMessageHandler.MsgType.FATAL_ERROR;
    }

    private SourceLocation convertDOMLocation(DOMLocator dOMLocator) {
        if (dOMLocator == null) {
            return null;
        }
        return new SourceLocation(dOMLocator.getUri(), null, dOMLocator.getLineNumber(), dOMLocator.getColumnNumber(), -1, -1);
    }

    private SourceLocation convertSAXLocation(SAXParseException sAXParseException) {
        return new SourceLocation(sAXParseException.getSystemId(), sAXParseException.getPublicId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), -1, -1);
    }

    private String getUnknownString() {
        if (this.m_unknown == null) {
            this.m_unknown = new ErrorMsg("UNKNOWN_MSG").getFormattedMessage();
        }
        return this.m_unknown;
    }
}

