/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.exec;

import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.exec.SPIErrorHandlerImpl;
import com.ibm.xltxe.rnm1.xtq.exec.XDynamicContextImpl;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.runtime.DefaultErrorHandler;
import com.ibm.xltxe.rnm1.xtq.xml.res.XMLMessages;
import com.ibm.xltxe.rnm1.xtq.xpath.runtime.ApplyTemplatesDispatchIDTable;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xapi.XMessageHandler;
import com.ibm.xml.xapi.XProcessException;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public abstract class AbstractSPIExecutable
implements Executable {
    private static final Logger s_logger = LoggerUtil.getLogger(AbstractSPIExecutable.class);
    private static final String s_className = AbstractSPIExecutable.class.getName();
    public static final boolean DUMP_INPUT = HiddenOptions.wasSpecified("dumpinput");
    protected SessionContext m_session;
    private ErrorHandler m_defaultErrorHandler;

    public AbstractSPIExecutable() {
    }

    public AbstractSPIExecutable(SessionContext sessionContext) {
        this.m_session = sessionContext;
    }

    @Override
    public void execute(Cursor cursor2, DynamicContext dynamicContext, Cursor.Profile profile, Cursor[] cursorArray, Result result2) {
        Cursor cursor3 = this.execute(cursor2, dynamicContext, profile, cursorArray);
        cursor3.copyToResult(result2, null, false, true);
    }

    public void loadSchema(XDynamicContextImpl xDynamicContextImpl) {
    }

    @Override
    public abstract void execute(Cursor var1, Cursor.Area var2, Cursor var3, DynamicContext var4, Cursor.Profile var5, Cursor[] var6);

    protected void initializeApplyTemplatesDispatchIDTable(AbstractStarlet abstractStarlet) {
        ApplyTemplatesDispatchIDTable applyTemplatesDispatchIDTable = new ApplyTemplatesDispatchIDTable();
        boolean bl = applyTemplatesDispatchIDTable.assertTypeMappings(abstractStarlet.getNamesArray(), abstractStarlet.getUrisArray(), abstractStarlet.getTypesArray());
        if (!bl) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Failed pre-asserting XPath Expanded Types into Document Manager."));
        }
        abstractStarlet.setApplyTemplatesDispatchIDTable(applyTemplatesDispatchIDTable);
    }

    protected ErrorHandler getErrorHandler(DynamicContext dynamicContext) {
        ErrorHandler errorHandler = null;
        if (dynamicContext.getErrorHandler() != null) {
            int n2 = -1;
            errorHandler = new SPIErrorHandlerImpl(dynamicContext.getErrorHandler(), n2);
        } else {
            errorHandler = this.getDefaultErrorHandler();
        }
        return errorHandler;
    }

    protected void reportError(DynamicContext dynamicContext, Exception exception) {
        if (dynamicContext.getErrorHandler() == null) {
            throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", null), exception);
        }
        dynamicContext.getErrorHandler().report(-1, XMessageHandler.MsgType.FATAL_ERROR, exception, null, true);
        throw new XProcessException(XMLMessages.createXMLMessage("ER_API_EXECUTION_TERMINATED", null), null);
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    protected void dumpInput(Cursor cursor2) {
        String string2 = "input-dump";
        if (Program.TIMESTAMPED_DUMPS) {
            string2 = string2 + "." + System.currentTimeMillis();
        }
        string2 = string2 + ".xml";
        File file = new File(string2);
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println("<!-- systemId: " + (cursor2 != null && cursor2.itemDocumentInfo() != null ? cursor2.itemDocumentInfo().getURI() : null) + " -->");
            printStream.println();
            if (cursor2 != null) {
                cursor2 = cursor2.fork(false);
                cursor2.copyToResult(new StreamResult(printStream), null, false, true);
            }
            printStream.close();
            s_logger.logrb(Level.INFO, s_className, "dumpInput", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{file.getCanonicalPath()});
        }
        catch (IOException iOException) {
            s_logger.logrb(Level.WARNING, s_className, "dumpInput", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_SYSTEM_EXCEPTION", (Throwable)iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ErrorHandler getDefaultErrorHandler() {
        if (this.m_defaultErrorHandler == null) {
            this.m_defaultErrorHandler = new DefaultErrorHandler();
        }
        return this.m_defaultErrorHandler;
    }
}

