/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.fcg.impl.HiddenOptions;
import com.ibm.xltxe.rnm1.xtq.bcel.classfile.JavaClass;
import com.ibm.xltxe.rnm1.xtq.common.utils.ErrorHandler;
import com.ibm.xltxe.rnm1.xtq.common.utils.SystemIDResolver;
import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xtq.drivers.XStarLinker;
import com.ibm.xltxe.rnm1.xtq.runtime.AbstractStarlet;
import com.ibm.xltxe.rnm1.xtq.xpath.drivers.XPathPreparer;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.DriverConstants;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xltxe.rnm1.xtq.xslt.drivers.XylemRuntimePreCompiler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.FormHandler;
import com.ibm.xltxe.rnm1.xtq.xslt.xylem.parser.TypeHandler;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.codegen.CodeGenerationSettings;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.ClassCollector;
import com.ibm.xltxe.rnm1.xylem.codegen.bcel.Resource;
import com.ibm.xltxe.rnm1.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xci.SessionContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XStarCompiler {
    public static final int FILE_OUTPUT = 1;
    public static final int BYTEARRAY_OUTPUT = 2;
    public static final int JAR_OUTPUT = 4;
    public static final int JAVA_SOURCE = 8;
    public static final int DEBUG_MSG = 16;
    public static final int BYTEARRAY_AND_FILE_OUTPUT = 3;
    public static final int BYTEARRAY_AND_JAR_OUTPUT = 6;
    public static final int BYTEARRAY_AND_JAR_DEBUG_OUTPUT = 22;
    public static final int JAVA_SOURCE_AND_FILE_OUTPUT = 9;
    private static final Logger s_logger = LoggerUtil.getLogger(XStarCompiler.class);
    private static final String s_className = XStarCompiler.class.getName();
    protected Module m_runtimeLibrary = null;
    private static Object s_cachedRuntimeLock = new Object();
    private static int s_cachedReductionHelperCount;
    private static SoftReference<Module> s_cachedCompilerRuntime;
    private static SoftReference<ModuleSignature> s_cachedRuntimeSignature;
    protected boolean m_debug = false;
    protected String m_jarFileName = null;
    protected String m_className = null;
    protected File m_destDir = null;
    protected String m_packageName = null;
    protected boolean m_trace = false;
    protected XSLTCompilerSettings m_compiSettings = null;
    protected XSLTLinkerSettings m_linkerSettings = null;
    protected Vector<JavaClass> m_classes = new Vector();
    protected Vector<Resource> m_resources = new Vector();
    protected byte[][] m_bytecodes;
    protected String[] m_cnames;
    protected int m_outputType = 2;
    protected boolean m_generateBCEL = false;
    protected ModuleSignature m_moduleSignature = null;
    private Module m_starletModule = null;
    public static final String MIXEDMODE_OPTION = "mixedmode";
    public static final boolean MIXEDMODE;
    private boolean m_mixedMode;
    private String m_filLibraryName;
    private Class<? extends AbstractStarlet> m_filLibrary;

    public XStarCompiler(String string2) {
        this.m_compiSettings = new XSLTCompilerSettings();
        this.m_compiSettings.setVersion(string2);
        this.m_linkerSettings = new XSLTLinkerSettings(this.m_compiSettings);
    }

    public void setStreamResultOnly(boolean bl) {
        this.m_compiSettings.setStreamResultOnly(bl);
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        codeGenerationSettings.setOrderSafeSplit(!bl);
    }

    public boolean isStreamResultOnly() {
        return this.m_compiSettings.isStreamResultOnly();
    }

    public void reset() {
        this.m_classes.removeAllElements();
        this.m_resources.removeAllElements();
        this.m_bytecodes = null;
    }

    public byte[][] getBytecodes() {
        if (this.m_bytecodes == null) {
            int n2 = this.m_classes.size();
            byte[][] byArrayArray = new byte[n2][];
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                JavaClass javaClass = this.m_classes.get(i);
                byArrayArray[i] = javaClass.getBytes();
                stringArray[i] = javaClass.getClassName();
            }
            this.m_bytecodes = byArrayArray;
            this.m_cnames = stringArray;
            this.m_classes.removeAllElements();
        }
        return this.m_bytecodes;
    }

    public String[] getNames() {
        return this.m_cnames;
    }

    public void setClassName(String string2) {
        String string3 = Util.baseName(string2);
        String string4 = Util.noExtName(string3);
        String string5 = Util.toJavaName(string4);
        this.m_className = this.m_packageName == null ? string5 : this.m_packageName + '.' + string5;
    }

    public String getClassName() {
        return this.m_className;
    }

    private String classFileName(String string2) {
        return string2.replace('.', File.separatorChar) + ".class";
    }

    public void setOutputType(int n2) {
        this.m_outputType = n2;
    }

    private File getOutputFile(String string2) {
        if (this.m_destDir != null) {
            return new File(this.m_destDir, this.classFileName(string2));
        }
        return new File(this.classFileName(string2));
    }

    public boolean setDestDirectory(String string2) {
        File file = new File(string2);
        if (file.exists() || file.mkdirs()) {
            this.m_destDir = file;
            this.m_linkerSettings.setOutputDir(this.m_destDir);
            return true;
        }
        this.m_destDir = null;
        return false;
    }

    public void setPackageName(String string2) {
        this.m_packageName = string2;
        if (this.m_className != null) {
            this.setClassName(this.m_className);
        }
    }

    public void setJarFileName(String string2) {
        this.m_jarFileName = string2.endsWith(".jar") ? string2 : string2 + ".jar";
    }

    public String getJarFileName() {
        return this.m_jarFileName;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public boolean debug() {
        return this.m_debug;
    }

    public void setTrace(boolean bl) {
        this.m_trace = bl;
    }

    public boolean trace() {
        return this.m_trace;
    }

    public boolean getGenerateBCEL() {
        return this.m_generateBCEL;
    }

    public void setGenerateBCEL(boolean bl) {
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        this.m_generateBCEL = bl;
        if (bl) {
            codeGenerationSettings.setTargetLanguage(4);
        } else {
            codeGenerationSettings.setTargetLanguage(3);
        }
    }

    public int getSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public void setSplitLimit(int n2) {
        this.m_compiSettings.setPrereductionSplitLimit(n2);
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        codeGenerationSettings.setBCELAutoSplitFunctions(n2 == 0);
    }

    public void setEmitAutoSplitWarning(boolean bl) {
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        codeGenerationSettings.setEmitAutoSplitWarning(bl);
    }

    public ClassCollector getByteCodeClassCollecter() {
        ChainedClassCollector chainedClassCollector = null;
        if ((this.m_outputType & 2) != 0) {
            chainedClassCollector = new CachingClassCollector(chainedClassCollector);
        }
        if ((this.m_outputType & 1) != 0) {
            chainedClassCollector = new WritingClassCollector(chainedClassCollector);
        }
        return chainedClassCollector;
    }

    public void outputToJar(boolean bl) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Enumeration<Resource> enumeration;
        Manifest manifest = new Manifest();
        Attributes attributes2 = manifest.getMainAttributes();
        attributes2.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map2 = manifest.getEntries();
        Enumeration<JavaClass> enumeration2 = this.m_classes.elements();
        String string2 = new Date().toString();
        Attributes.Name name2 = new Attributes.Name("Date");
        while (enumeration2.hasMoreElements()) {
            enumeration = enumeration2.nextElement();
            object5 = ((JavaClass)((Object)enumeration)).getClassName().replace('.', '/');
            object4 = new Attributes();
            ((Attributes)object4).put(name2, string2);
            map2.put((String)object5 + ".class", (Attributes)object4);
        }
        enumeration = this.m_resources.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (Resource)enumeration.nextElement();
            object4 = new Attributes();
            ((Attributes)object4).put(name2, string2);
            map2.put(object5.getName(), (Attributes)object4);
        }
        boolean bl2 = SystemIDResolver.isAbsolutePath(this.m_jarFileName);
        object4 = null;
        object4 = bl2 ? new File(this.m_jarFileName) : new File(this.m_destDir, this.m_jarFileName);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream((File)object4), manifest);
        enumeration2 = this.m_classes.elements();
        while (enumeration2.hasMoreElements()) {
            object3 = enumeration2.nextElement();
            object2 = ((JavaClass)object3).getClassName().replace('.', '/');
            jarOutputStream.putNextEntry(new JarEntry((String)object2 + ".class"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ((JavaClass)object3).dump(byteArrayOutputStream);
            byteArrayOutputStream.writeTo(jarOutputStream);
        }
        enumeration = this.m_resources.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            jarOutputStream.putNextEntry(new JarEntry(object3.getName()));
            object2 = new ByteArrayOutputStream(2048);
            object3.dump((OutputStream)object2);
            ((ByteArrayOutputStream)object2).writeTo(jarOutputStream);
        }
        jarOutputStream.close();
        if (bl) {
            s_logger.logrb(Level.INFO, s_className, "outputToJar", "com.ibm.xltxe.rnm1.xylem.res.XylemMessages", "DUMPED_INFO_LOCATION", new Object[]{((File)object4).getCanonicalPath()});
        }
    }

    private ModuleSignature readModuleSignature() throws Exception {
        InputStream inputStream = XylemRuntimePreCompiler.getPrecompiledRuntimeSignature();
        if (inputStream == null) {
            return null;
        }
        List<URL> list = Collections.emptyList();
        ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(list);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        ModuleSignature moduleSignature = new ModuleSignature();
        moduleSignature.read(objectInputStream, moduleSignatureStore);
        inputStream.close();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "readModuleSignature", "Successfully read serialized FIL runtime library module signature");
        }
        return moduleSignature;
    }

    private static Module readModule() throws Exception {
        InputStream inputStream = XylemRuntimePreCompiler.getPrecompiledRuntime();
        InputStream inputStream2 = XylemRuntimePreCompiler.getPrecompiledRuntimeSignature();
        if (inputStream == null || inputStream2 == null) {
            return null;
        }
        List<URL> list = Collections.emptyList();
        ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(list);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream2);
        ModuleSignature moduleSignature = new ModuleSignature();
        moduleSignature.read(objectInputStream, moduleSignatureStore);
        inputStream2.close();
        moduleSignatureStore.registerModuleSignature("xslt2", moduleSignature);
        objectInputStream = new ObjectInputStream(inputStream);
        Module module = Module.readModule(objectInputStream, moduleSignatureStore);
        inputStream.close();
        module.typeCheckReduced();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "readModule", "Successfully read serialized FIL runtime library module");
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature loadRuntimeSignature() throws Exception {
        Object object2 = s_cachedRuntimeLock;
        synchronized (object2) {
            ModuleSignature moduleSignature;
            ModuleSignature moduleSignature2 = moduleSignature = s_cachedRuntimeSignature == null ? null : s_cachedRuntimeSignature.get();
            if (moduleSignature == null) {
                moduleSignature = this.newRuntimeLibrarySignatureInstance();
                s_cachedRuntimeSignature = new SoftReference<ModuleSignature>(moduleSignature);
            } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "loadRuntimeSignature", "Using cached FIL runtime library module signature");
            }
            return moduleSignature;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module loadRuntimeLibrary() throws Exception {
        Object object2 = s_cachedRuntimeLock;
        synchronized (object2) {
            Module module;
            Module module2 = module = s_cachedCompilerRuntime == null ? null : s_cachedCompilerRuntime.get();
            if (module == null) {
                module = this.newRuntimeLibraryInstance();
                s_cachedReductionHelperCount = ReductionHelper.getIntermediateIdentifierCount();
                s_cachedCompilerRuntime = new SoftReference<Module>(module);
            } else if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "loadRuntimeLibrary", "Using cached FIL runtime library module");
            }
            ReductionHelper.resetIntermediateIdentifierCounter(s_cachedReductionHelperCount);
            if (this.isInterpreted()) {
                return module;
            }
            return module.cloneModule();
        }
    }

    private Module newRuntimeLibraryInstance() throws Exception {
        Module module = XStarCompiler.readModule();
        if (module == null) {
            return XStarCompiler.parseRuntimeLibrary();
        }
        return module;
    }

    private ModuleSignature newRuntimeLibrarySignatureInstance() throws Exception {
        ModuleSignature moduleSignature = this.readModuleSignature();
        if (moduleSignature == null) {
            moduleSignature = XStarCompiler.parseRuntimeLibrarySignature();
        }
        return moduleSignature;
    }

    public void linkAndCodeGen(Module module, Module module2, SessionContext sessionContext) throws Exception {
        this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(this.getByteCodeClassCollecter());
        this.getLinker().compileProgram(module2, module, 1, Collections.EMPTY_LIST, this.m_className, this.m_linkerSettings, sessionContext);
        if ((this.m_outputType & 4) != 0) {
            this.outputToJar((this.m_outputType & 0x10) != 0);
        }
    }

    public XStarLinker getLinker() {
        return XStarLinker.s_linker;
    }

    public static Module parseRuntimeLibrary() throws Exception {
        ClassLoaderSourceResolver classLoaderSourceResolver = new ClassLoaderSourceResolver();
        Parser parser = new Parser(classLoaderSourceResolver, classLoaderSourceResolver.resolve(null, "com/ibm/xltxe/rnm1/xtq/xslt/runtime/v2/MainLib2.xylem"));
        new TypeHandler().registerTypes(parser);
        new FormHandler().registerForms(parser);
        Module module = parser.parseModuleFragment();
        module.setName("xslt2");
        module.exportAllSymbols();
        module.typeCheck();
        module.exportAllSymbols();
        module.reduce();
        if (LoggerUtil.isFineLoggable(s_logger)) {
            s_logger.logp(Level.FINE, s_className, "parseRuntimeLibrary", "Successfully parsed FIL runtime library");
        }
        return module;
    }

    private static ModuleSignature parseRuntimeLibrarySignature() throws Exception {
        return XStarCompiler.parseRuntimeLibrary().m_signature;
    }

    public Module getRuntimeLibrary() {
        return this.m_runtimeLibrary;
    }

    public void setRuntimeLibrary(Module module) {
        this.m_runtimeLibrary = module;
    }

    public void cleanRuntimeLibrary() {
        this.setRuntimeLibrary(null);
    }

    public ModuleSignature getModuleSignature() {
        return this.m_moduleSignature;
    }

    public void setModuleSignature(ModuleSignature moduleSignature) {
        this.m_moduleSignature = moduleSignature;
    }

    public int getPrereductionSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public boolean isSerializationTraceEnabled() {
        return this.m_compiSettings.isSerializationTraceEnabled();
    }

    public void setTraceImportsAndIncludes(boolean bl) {
        this.m_compiSettings.setTraceImportsAndIncludes(bl);
    }

    public void setDoPostASTProcessing(boolean bl) {
        this.m_compiSettings.setDoPostASTProcessing(bl);
    }

    public boolean getDoPostASTProcessing() {
        return this.m_compiSettings.isDoPostASTProcessing();
    }

    public boolean isInterpreted() {
        return this.m_compiSettings.isInterpreted();
    }

    public boolean useMixedMode() {
        return this.m_mixedMode;
    }

    public Class<? extends AbstractStarlet> getFILLibrary() {
        return this.m_filLibrary;
    }

    public String getFILLibraryName() {
        return this.m_filLibraryName;
    }

    public void setInterpreted(boolean bl) {
        this.m_compiSettings.setInterpreted(bl);
        if (bl && MIXEDMODE) {
            CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
            this.m_mixedMode = true;
            this.m_filLibraryName = codeGenerationSettings.getArbitraryPrecision() ? DriverConstants.RUNTIME_ARBITRARY_PRECISION_QUALIFIED_CLASS_NAME : (codeGenerationSettings.getOverflowDetection() ? DriverConstants.RUNTIME_OVERFLOW_DETECTION_QUALIFIED_CLASS_NAME : DriverConstants.RUNTIME_QUALIFIED_CLASS_NAME);
            try {
                this.m_filLibrary = Class.forName(this.m_filLibraryName).asSubclass(AbstractStarlet.class);
                if (LoggerUtil.isFineLoggable(s_logger)) {
                    s_logger.logp(Level.FINE, s_className, "setInterpreted", "Using mixed-mode interpreter: " + this.m_filLibraryName);
                }
            }
            catch (Exception exception) {
                s_logger.logrb(Level.WARNING, s_className, "setInterpreted", "com.ibm.xltxe.rnm1.xtq.xslt.runtime.res.RuntimeMessages", "ERR_PRECOMPILED_RUNTIME_NOT_FOUND");
                this.m_mixedMode = false;
            }
        }
    }

    public XSLTCompilerSettings getCompilerSettings() {
        return this.m_compiSettings;
    }

    public static Module loadRuntimeLibrary(boolean bl) throws Exception {
        XStarCompiler xStarCompiler = new XStarCompiler("2.0");
        xStarCompiler.setInterpreted(bl);
        return xStarCompiler.loadRuntimeLibrary();
    }

    public Module getStarletModule() {
        return this.m_starletModule;
    }

    public void setStarletModule(Module module) {
        this.m_starletModule = module;
    }

    public void cleanStarletModule() {
        this.setStarletModule(null);
    }

    public XSLTLinkerSettings getLinkerSettings() {
        return this.m_linkerSettings;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_linkerSettings.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_linkerSettings.setErrorHandler(errorHandler);
    }

    protected void dumpModule(Module module) {
        try {
            File file = new File(XPathPreparer.OPTION_JAVASOURCEDESTDIRS, module.getName() + ".xylem");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            module.dump(printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        s_cachedCompilerRuntime = null;
        s_cachedRuntimeSignature = null;
        MIXEDMODE = !HiddenOptions.optionValueIs(MIXEDMODE_OPTION, "off");
    }

    private class WritingClassCollector
    extends ChainedClassCollector {
        public WritingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        @Override
        public void handleGeneratedClass(JavaClass javaClass) {
            try {
                javaClass.dump(XStarCompiler.this.getOutputFile(javaClass.getClassName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            try {
                resource.dump(new FileOutputStream(new File(XStarCompiler.this.m_destDir, resource.getName())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        @Override
        public void handleGeneratedClass(JavaClass javaClass) {
            XStarCompiler.this.m_classes.add(javaClass);
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            XStarCompiler.this.m_resources.add(resource);
        }
    }

    private abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector classCollector) {
            this.m_nextCollector = classCollector;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        @Override
        public final void acceptGeneratedClass(JavaClass javaClass) {
            this.handleGeneratedClass(javaClass);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(javaClass);
            }
        }

        @Override
        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }
}

