/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xtq.drivers;

import com.ibm.xltxe.rnm1.xtq.drivers.ObjectFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class EnvironmentCheck {
    public static final String ERROR = "ERROR.";
    public static final String WARNING = "WARNING.";
    public static final String ERROR_FOUND = "At least one error was found!";
    public static final String VERSION = "version.";
    public static final String FOUNDCLASSES = "foundclasses.";
    public static final String CLASS_PRESENT = "present-unknown-version";
    public static final String CLASS_NOTPRESENT = "not-present";
    public String[] jarNames = new String[]{"xml.jar"};
    public Hashtable versionTable = new Hashtable();
    public Hashtable relatedJarsTable = new Hashtable();
    protected PrintWriter outWriter = new PrintWriter(System.out, true);

    public EnvironmentCheck() {
        this.versionTable.put("xlxpCompiler", "com.ibm.xml.xlxp.compiler.Version");
        this.versionTable.put("xlxpScanner", "com.ibm.xml.xlxp.internal.s1.scan.Version");
        this.versionTable.put("xlxpVM", "com.ibm.xml.xlxp.internal.s1.runtime.Version");
        this.versionTable.put("xmlapis", "org.apache.xmlcommons.Version");
        this.versionTable.put("xlxpXCIAdapter", "com.ibm.xml.xci.adapters.xlxp2.Version");
        this.versionTable.put("resolver", "org.apache.xml.resolver.Version");
        this.versionTable.put("xerces", "com.ibm.xml.xml4j.internal.s1.impl.Version");
        this.versionTable.put("serializer", "com.ibm.xltxe.rnm1.xml.serializer.Version");
        this.versionTable.put("XLTXE2", "com.ibm.xltxe.rnm1.xtq.Version");
        this.versionTable.put("XLTXE1", "org.apache.xalan.Version");
        this.versionTable.put("xci", "com.ibm.xml.xci.Version");
        this.versionTable.put("fcg", "com.ibm.xltxe.rnm1.fcg.Version");
        this.relatedJarsTable.put("bcel", "com.ibm.xltxe.rnm1.xtq.bcel.generic.InstructionList");
        this.relatedJarsTable.put("icu", "com.ibm.icu.text.Normalizer");
    }

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-out".equalsIgnoreCase(stringArray[i])) continue;
            if (++i < stringArray.length) {
                try {
                    printWriter = new PrintWriter(new FileWriter(stringArray[i], true));
                }
                catch (Exception exception) {
                    System.err.println("# WARNING: -out " + stringArray[i] + " threw " + exception.toString());
                }
                continue;
            }
            System.err.println("# WARNING: -out argument should have a filename, output sent to console");
        }
        EnvironmentCheck environmentCheck = new EnvironmentCheck();
        environmentCheck.checkEnvironment(printWriter);
    }

    public boolean checkEnvironment(PrintWriter printWriter) {
        Hashtable hashtable;
        boolean bl;
        if (null != printWriter) {
            this.outWriter = printWriter;
        }
        if (bl = this.writeEnvironmentReport(hashtable = this.getEnvironmentHash())) {
            this.logMsg("# WARNING: Potential problems found in your environment!");
            this.logMsg("#    Check any 'ERROR' items above against the Xalan FAQs");
            this.logMsg("#    to correct potential problems with your classes/jars");
            this.logMsg("#    http://xml.apache.org/xalan-j/faq.html");
            if (null != this.outWriter) {
                this.outWriter.flush();
            }
            return false;
        }
        this.logMsg("# Your environment seems to be OK.");
        if (null != this.outWriter) {
            this.outWriter.flush();
        }
        return true;
    }

    public Hashtable getEnvironmentHash() {
        Hashtable hashtable = new Hashtable();
        this.checkAntVersion(hashtable);
        this.checkDOMVersion(hashtable);
        this.checkSAXVersion(hashtable);
        this.checkSystemProperties(hashtable);
        this.checkVersionUtilities(hashtable, this.versionTable);
        this.checkOtherRelatedJars(hashtable);
        return hashtable;
    }

    protected boolean writeEnvironmentReport(Hashtable hashtable) {
        if (null == hashtable) {
            this.logMsg("# ERROR: writeEnvironmentReport called with null Hashtable");
            return false;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        StringBuffer stringBuffer6 = new StringBuffer();
        StringBuffer stringBuffer7 = new StringBuffer();
        StringBuffer stringBuffer8 = new StringBuffer();
        StringBuffer stringBuffer9 = new StringBuffer();
        StringBuffer stringBuffer10 = new StringBuffer();
        this.logMsg("#---- BEGIN writeEnvironmentReport(Revision: 1.44): Useful stuff found: ----");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string2 = (String)k;
            try {
                if (string2.startsWith(FOUNDCLASSES)) {
                    Vector vector = (Vector)hashtable.get(string2);
                    bl |= this.logFoundJars(vector, string2);
                    continue;
                }
                if (string2.startsWith(ERROR)) {
                    bl = true;
                }
                if (string2.startsWith("version.DOM")) {
                    stringBuffer3.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.ant")) {
                    stringBuffer2.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.SAX")) {
                    stringBuffer4.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.xlxp")) {
                    stringBuffer5.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.xerces")) {
                    stringBuffer6.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.xmlapis")) {
                    stringBuffer7.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version.XLTXE")) {
                    stringBuffer8.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("version")) {
                    stringBuffer10.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                if (string2.startsWith("other")) {
                    stringBuffer9.append(string2 + "=" + hashtable.get(string2) + "\n");
                    continue;
                }
                this.logMsg(string2 + "=" + hashtable.get(string2));
            }
            catch (Exception exception) {
                this.logMsg("Reading-" + k + "= threw: " + exception.toString());
            }
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(stringBuffer4.toString());
        stringBuffer.append(stringBuffer5.toString());
        stringBuffer.append(stringBuffer6.toString());
        stringBuffer.append(stringBuffer7.toString());
        stringBuffer.append(stringBuffer8.toString());
        stringBuffer.append(stringBuffer10.toString());
        this.logMsg("#----- Start reporting Version utilities -----");
        this.logMsg(stringBuffer.toString());
        this.logMsg("#----- End reporting Version utilities -----");
        this.logMsg("#----- Start reporting Other related Jars -----");
        this.logMsg(stringBuffer9.toString());
        this.logMsg("#----- END reporting Other related Jars -----");
        this.logMsg("#----- END writeEnvironmentReport: Useful properties found: -----");
        return bl;
    }

    protected boolean logFoundJars(Vector vector, String string2) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl = false;
        this.logMsg("#---- BEGIN Listing XML-related jars in: " + string2 + " ----");
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                String string3 = (String)k;
                try {
                    if (string3.startsWith(ERROR)) {
                        bl = true;
                    }
                    this.logMsg(string3 + "=" + hashtable.get(string3));
                }
                catch (Exception exception) {
                    bl = true;
                    this.logMsg("Reading-" + k + "= threw: " + exception.toString());
                }
            }
        }
        this.logMsg("#----- END Listing XML-related jars in: " + string2 + " -----");
        return bl;
    }

    public void appendEnvironmentReport(Node node2, Document document2, Hashtable hashtable) {
        if (null == node2 || null == document2) {
            return;
        }
        try {
            Element element2 = document2.createElement("EnvironmentCheck");
            element2.setAttribute("version", "Revision: 1.44");
            node2.appendChild(element2);
            if (null == hashtable) {
                Element element3 = document2.createElement("status");
                element3.setAttribute("result", "ERROR");
                element3.appendChild(document2.createTextNode("appendEnvironmentReport called with null Hashtable!"));
                element2.appendChild(element3);
                return;
            }
            boolean bl = false;
            Element element4 = document2.createElement("environment");
            element2.appendChild(element4);
            Object object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                Object k = object2.nextElement();
                String string2 = (String)k;
                try {
                    Object object3;
                    if (string2.startsWith(FOUNDCLASSES)) {
                        object3 = (Vector)hashtable.get(string2);
                        bl |= this.appendFoundJars(element4, document2, (Vector)object3, string2);
                        continue;
                    }
                    if (string2.startsWith(ERROR)) {
                        bl = true;
                    }
                    object3 = document2.createElement("item");
                    object3.setAttribute("key", string2);
                    object3.appendChild(document2.createTextNode((String)hashtable.get(string2)));
                    element4.appendChild((Node)object3);
                }
                catch (Exception exception) {
                    bl = true;
                    Element element5 = document2.createElement("item");
                    element5.setAttribute("key", string2);
                    element5.appendChild(document2.createTextNode("ERROR. Reading " + k + " threw: " + exception.toString()));
                    element4.appendChild(element5);
                }
            }
            object2 = document2.createElement("status");
            object2.setAttribute("result", bl ? "ERROR" : "OK");
            element2.appendChild((Node)object2);
        }
        catch (Exception exception) {
            System.err.println("appendEnvironmentReport threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    protected boolean appendFoundJars(Node node2, Document document2, Vector vector, String string2) {
        if (null == vector || vector.size() < 1) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Element element2;
                Object k = enumeration.nextElement();
                try {
                    String string3 = (String)k;
                    if (string3.startsWith(ERROR)) {
                        bl = true;
                    }
                    element2 = document2.createElement("foundJar");
                    element2.setAttribute("name", string3.substring(0, string3.indexOf("-")));
                    element2.setAttribute("desc", string3.substring(string3.indexOf("-") + 1));
                    element2.appendChild(document2.createTextNode((String)hashtable.get(string3)));
                    node2.appendChild(element2);
                }
                catch (Exception exception) {
                    bl = true;
                    element2 = document2.createElement("foundJar");
                    element2.appendChild(document2.createTextNode("ERROR. Reading " + k + " threw: " + exception.toString()));
                    node2.appendChild(element2);
                }
            }
        }
        return bl;
    }

    protected void checkSystemProperties(Hashtable hashtable) {
        String string2;
        if (null == hashtable) {
            hashtable = new Hashtable<String, Object>();
        }
        try {
            string2 = System.getProperty("java.version");
            hashtable.put("java.version", string2);
        }
        catch (SecurityException securityException) {
            hashtable.put("java.version", "WARNING: SecurityException thrown accessing system version properties");
        }
        try {
            String string3;
            string2 = System.getProperty("java.class.path");
            hashtable.put("java.class.path", string2);
            Vector vector = this.checkPathForJars(string2, this.jarNames);
            if (null != vector) {
                hashtable.put("foundclasses.java.class.path", vector);
            }
            if (null != (string3 = System.getProperty("sun.boot.class.path"))) {
                hashtable.put("sun.boot.class.path", string3);
                vector = this.checkPathForJars(string3, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.sun.boot.class.path", vector);
                }
            }
            if (null != (string3 = System.getProperty("java.ext.dirs"))) {
                hashtable.put("java.ext.dirs", string3);
                vector = this.checkPathForJars(string3, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.java.ext.dirs", vector);
                }
            }
            if (null != (string3 = System.getProperty("java.endorsed.dirs"))) {
                hashtable.put("java.endorsed.dirs", string3);
                vector = this.checkPathForJars(string3, this.jarNames);
                if (null != vector) {
                    hashtable.put("foundclasses.java.endorsed.dirs", vector);
                }
            }
        }
        catch (SecurityException securityException) {
            hashtable.put("java.class.path", "WARNING: SecurityException thrown accessing system classpath properties");
        }
    }

    protected Vector checkPathForJars(String string2, String[] stringArray) {
        if (null == string2 || null == stringArray || 0 == string2.length() || 0 == stringArray.length) {
            return null;
        }
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            for (int i = 0; i < stringArray.length; ++i) {
                Hashtable<String, String> hashtable;
                if (string3.indexOf(stringArray[i]) <= -1) continue;
                File file = new File(string3);
                if (file.exists()) {
                    try {
                        hashtable = new Hashtable(2);
                        hashtable.put(stringArray[i] + "-path", file.getAbsolutePath());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                hashtable = new Hashtable<String, String>(2);
                hashtable.put(stringArray[i] + "-path", "WARNING. Classpath entry: " + string3 + " does not exist");
                hashtable.put(stringArray[i] + "-apparent.version", CLASS_NOTPRESENT);
                vector.addElement(hashtable);
            }
        }
        return vector;
    }

    protected void checkVersionUtilities(Hashtable hashtable, Hashtable hashtable2) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        int n2 = hashtable2.size();
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable2.get(string2);
            String string4 = "";
            try {
                CodeSource codeSource;
                Class clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
                Class[] classArray = new Class[]{};
                Method method = clazz.getMethod("getVersion", classArray);
                String string5 = (String)method.invoke(null, new Object[0]);
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                    string4 = codeSource.getLocation().getPath();
                }
                if (string4.length() > 0) {
                    hashtable.put(VERSION + string2, string5 + " is loaded from " + string4);
                    continue;
                }
                hashtable.put(VERSION + string2, string5);
            }
            catch (Exception exception) {
                hashtable.put(VERSION + string2, CLASS_NOTPRESENT);
            }
        }
    }

    protected void checkOtherRelatedJars(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        int n2 = this.relatedJarsTable.size();
        Enumeration enumeration = this.relatedJarsTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.relatedJarsTable.get(string2);
            try {
                Class clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
                String string4 = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
                hashtable.put("other." + string2, string2 + " is loaded from " + string4);
            }
            catch (Exception exception) {
                hashtable.put("other." + string2, CLASS_NOTPRESENT);
            }
        }
    }

    protected void checkAntVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            Class[] classArray = new Class[]{};
            Class clazz = ObjectFactory.findProviderClass("org.apache.tools.ant.Main", ObjectFactory.findClassLoader(), true);
            Method method = clazz.getMethod("getAntVersion", classArray);
            Object object2 = method.invoke(null, new Object[0]);
            hashtable.put("version.ant", (String)object2);
        }
        catch (Exception exception) {
            hashtable.put("version.ant", CLASS_NOTPRESENT);
        }
    }

    protected void checkDOMVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{String.class, String.class};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.w3c.dom.Document", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("createElementNS", classArray);
            hashtable.put("version.DOM", "2.0");
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.DOM", "ERROR attempting to load DOM level 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
        }
    }

    protected void checkSAXVersion(Hashtable hashtable) {
        if (null == hashtable) {
            hashtable = new Hashtable<String, String>();
        }
        Class[] classArray = new Class[]{String.class};
        Class[] classArray2 = new Class[]{Attributes.class};
        try {
            Class clazz = ObjectFactory.findProviderClass("org.xml.sax.helpers.AttributesImpl", ObjectFactory.findClassLoader(), true);
            clazz.getMethod("setAttributes", classArray2);
            hashtable.put("version.SAX", "2.0");
        }
        catch (Exception exception) {
            hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
            hashtable.put(ERROR, ERROR_FOUND);
            try {
                Class clazz = ObjectFactory.findProviderClass("org.xml.sax.XMLReader", ObjectFactory.findClassLoader(), true);
                clazz.getMethod("parse", classArray);
                hashtable.put("version.SAX-backlevel", "2.0beta2-or-earlier");
            }
            catch (Exception exception2) {
                hashtable.put("ERROR.version.SAX", "ERROR attempting to load SAX version 2 class: " + exception.toString());
                hashtable.put(ERROR, ERROR_FOUND);
                try {
                    Class clazz = ObjectFactory.findProviderClass("org.xml.sax.Parser", ObjectFactory.findClassLoader(), true);
                    Method method = clazz.getMethod("parse", classArray);
                    hashtable.put("version.SAX-backlevel", "1.0");
                }
                catch (Exception exception3) {
                    hashtable.put("ERROR.version.SAX-backlevel", "ERROR attempting to load SAX version 1 class: " + exception3.toString());
                }
            }
        }
    }

    protected void logMsg(String string2) {
        this.outWriter.println(string2);
    }
}

